// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the RagFile.
type RagFile_RagFileType int32

const (
	// RagFile type is unspecified.
	RagFile_RAG_FILE_TYPE_UNSPECIFIED RagFile_RagFileType = 0
	// RagFile type is TXT.
	RagFile_RAG_FILE_TYPE_TXT RagFile_RagFileType = 1
	// RagFile type is PDF.
	RagFile_RAG_FILE_TYPE_PDF RagFile_RagFileType = 2
)

// Enum value maps for RagFile_RagFileType.
var (
	RagFile_RagFileType_name = map[int32]string{
		0: "RAG_FILE_TYPE_UNSPECIFIED",
		1: "RAG_FILE_TYPE_TXT",
		2: "RAG_FILE_TYPE_PDF",
	}
	RagFile_RagFileType_value = map[string]int32{
		"RAG_FILE_TYPE_UNSPECIFIED": 0,
		"RAG_FILE_TYPE_TXT":         1,
		"RAG_FILE_TYPE_PDF":         2,
	}
)

func (x RagFile_RagFileType) Enum() *RagFile_RagFileType {
	p := new(RagFile_RagFileType)
	*p = x
	return p
}

func (x RagFile_RagFileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RagFile_RagFileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes[0].Descriptor()
}

func (RagFile_RagFileType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes[0]
}

func (x RagFile_RagFileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RagFile_RagFileType.Descriptor instead.
func (RagFile_RagFileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{2, 0}
}

// Config for the embedding model to use for RAG.
type RagEmbeddingModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The model config to use.
	//
	// Types that are assignable to ModelConfig:
	//
	//	*RagEmbeddingModelConfig_VertexPredictionEndpoint_
	ModelConfig isRagEmbeddingModelConfig_ModelConfig `protobuf_oneof:"model_config"`
}

func (x *RagEmbeddingModelConfig) Reset() {
	*x = RagEmbeddingModelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RagEmbeddingModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagEmbeddingModelConfig) ProtoMessage() {}

func (x *RagEmbeddingModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagEmbeddingModelConfig.ProtoReflect.Descriptor instead.
func (*RagEmbeddingModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{0}
}

func (m *RagEmbeddingModelConfig) GetModelConfig() isRagEmbeddingModelConfig_ModelConfig {
	if m != nil {
		return m.ModelConfig
	}
	return nil
}

func (x *RagEmbeddingModelConfig) GetVertexPredictionEndpoint() *RagEmbeddingModelConfig_VertexPredictionEndpoint {
	if x, ok := x.GetModelConfig().(*RagEmbeddingModelConfig_VertexPredictionEndpoint_); ok {
		return x.VertexPredictionEndpoint
	}
	return nil
}

type isRagEmbeddingModelConfig_ModelConfig interface {
	isRagEmbeddingModelConfig_ModelConfig()
}

type RagEmbeddingModelConfig_VertexPredictionEndpoint_ struct {
	// The Vertex AI Prediction Endpoint that either refers to a publisher model
	// or an endpoint that is hosting a 1P fine-tuned text embedding model.
	// Endpoints hosting non-1P fine-tuned text embedding models are
	// currently not supported.
	VertexPredictionEndpoint *RagEmbeddingModelConfig_VertexPredictionEndpoint `protobuf:"bytes,1,opt,name=vertex_prediction_endpoint,json=vertexPredictionEndpoint,proto3,oneof"`
}

func (*RagEmbeddingModelConfig_VertexPredictionEndpoint_) isRagEmbeddingModelConfig_ModelConfig() {}

// A RagCorpus is a RagFile container and a project can have multiple
// RagCorpora.
type RagCorpus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the RagCorpus.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the RagCorpus.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the RagCorpus.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Immutable. The embedding model config of the RagCorpus.
	RagEmbeddingModelConfig *RagEmbeddingModelConfig `protobuf:"bytes,6,opt,name=rag_embedding_model_config,json=ragEmbeddingModelConfig,proto3" json:"rag_embedding_model_config,omitempty"`
	// Output only. Timestamp when this RagCorpus was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this RagCorpus was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *RagCorpus) Reset() {
	*x = RagCorpus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RagCorpus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagCorpus) ProtoMessage() {}

func (x *RagCorpus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagCorpus.ProtoReflect.Descriptor instead.
func (*RagCorpus) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1}
}

func (x *RagCorpus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RagCorpus) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RagCorpus) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RagCorpus) GetRagEmbeddingModelConfig() *RagEmbeddingModelConfig {
	if x != nil {
		return x.RagEmbeddingModelConfig
	}
	return nil
}

func (x *RagCorpus) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *RagCorpus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A RagFile contains user data for chunking, embedding and indexing.
type RagFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The origin location of the RagFile if it is imported from Google Cloud
	// Storage or Google Drive.
	//
	// Types that are assignable to RagFileSource:
	//
	//	*RagFile_GcsSource
	//	*RagFile_GoogleDriveSource
	//	*RagFile_DirectUploadSource
	RagFileSource isRagFile_RagFileSource `protobuf_oneof:"rag_file_source"`
	// Output only. The resource name of the RagFile.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the RagFile.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the RagFile.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The size of the RagFile in bytes.
	SizeBytes int64 `protobuf:"varint,4,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. The type of the RagFile.
	RagFileType RagFile_RagFileType `protobuf:"varint,5,opt,name=rag_file_type,json=ragFileType,proto3,enum=google.cloud.aiplatform.v1beta1.RagFile_RagFileType" json:"rag_file_type,omitempty"`
	// Output only. Timestamp when this RagFile was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this RagFile was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *RagFile) Reset() {
	*x = RagFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RagFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFile) ProtoMessage() {}

func (x *RagFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFile.ProtoReflect.Descriptor instead.
func (*RagFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{2}
}

func (m *RagFile) GetRagFileSource() isRagFile_RagFileSource {
	if m != nil {
		return m.RagFileSource
	}
	return nil
}

func (x *RagFile) GetGcsSource() *GcsSource {
	if x, ok := x.GetRagFileSource().(*RagFile_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *RagFile) GetGoogleDriveSource() *GoogleDriveSource {
	if x, ok := x.GetRagFileSource().(*RagFile_GoogleDriveSource); ok {
		return x.GoogleDriveSource
	}
	return nil
}

func (x *RagFile) GetDirectUploadSource() *DirectUploadSource {
	if x, ok := x.GetRagFileSource().(*RagFile_DirectUploadSource); ok {
		return x.DirectUploadSource
	}
	return nil
}

func (x *RagFile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RagFile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RagFile) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RagFile) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

func (x *RagFile) GetRagFileType() RagFile_RagFileType {
	if x != nil {
		return x.RagFileType
	}
	return RagFile_RAG_FILE_TYPE_UNSPECIFIED
}

func (x *RagFile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *RagFile) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isRagFile_RagFileSource interface {
	isRagFile_RagFileSource()
}

type RagFile_GcsSource struct {
	// Output only. Google Cloud Storage location of the RagFile.
	// It does not support wildcards in the Cloud Storage uri for now.
	GcsSource *GcsSource `protobuf:"bytes,8,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type RagFile_GoogleDriveSource struct {
	// Output only. Google Drive location. Supports importing individual files
	// as well as Google Drive folders.
	GoogleDriveSource *GoogleDriveSource `protobuf:"bytes,9,opt,name=google_drive_source,json=googleDriveSource,proto3,oneof"`
}

type RagFile_DirectUploadSource struct {
	// Output only. The RagFile is encapsulated and uploaded in the
	// UploadRagFile request.
	DirectUploadSource *DirectUploadSource `protobuf:"bytes,10,opt,name=direct_upload_source,json=directUploadSource,proto3,oneof"`
}

func (*RagFile_GcsSource) isRagFile_RagFileSource() {}

func (*RagFile_GoogleDriveSource) isRagFile_RagFileSource() {}

func (*RagFile_DirectUploadSource) isRagFile_RagFileSource() {}

// Specifies the size and overlap of chunks for RagFiles.
type RagFileChunkingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The size of the chunks.
	ChunkSize int32 `protobuf:"varint,1,opt,name=chunk_size,json=chunkSize,proto3" json:"chunk_size,omitempty"`
	// The overlap between chunks.
	ChunkOverlap int32 `protobuf:"varint,2,opt,name=chunk_overlap,json=chunkOverlap,proto3" json:"chunk_overlap,omitempty"`
}

func (x *RagFileChunkingConfig) Reset() {
	*x = RagFileChunkingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RagFileChunkingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileChunkingConfig) ProtoMessage() {}

func (x *RagFileChunkingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileChunkingConfig.ProtoReflect.Descriptor instead.
func (*RagFileChunkingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{3}
}

func (x *RagFileChunkingConfig) GetChunkSize() int32 {
	if x != nil {
		return x.ChunkSize
	}
	return 0
}

func (x *RagFileChunkingConfig) GetChunkOverlap() int32 {
	if x != nil {
		return x.ChunkOverlap
	}
	return 0
}

// Config for uploading RagFile.
type UploadRagFileConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the size and overlap of chunks after uploading RagFile.
	RagFileChunkingConfig *RagFileChunkingConfig `protobuf:"bytes,1,opt,name=rag_file_chunking_config,json=ragFileChunkingConfig,proto3" json:"rag_file_chunking_config,omitempty"`
}

func (x *UploadRagFileConfig) Reset() {
	*x = UploadRagFileConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadRagFileConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRagFileConfig) ProtoMessage() {}

func (x *UploadRagFileConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRagFileConfig.ProtoReflect.Descriptor instead.
func (*UploadRagFileConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{4}
}

func (x *UploadRagFileConfig) GetRagFileChunkingConfig() *RagFileChunkingConfig {
	if x != nil {
		return x.RagFileChunkingConfig
	}
	return nil
}

// Config for importing RagFiles.
type ImportRagFilesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ImportSource:
	//
	//	*ImportRagFilesConfig_GcsSource
	//	*ImportRagFilesConfig_GoogleDriveSource
	ImportSource isImportRagFilesConfig_ImportSource `protobuf_oneof:"import_source"`
	// Specifies the size and overlap of chunks after importing RagFiles.
	RagFileChunkingConfig *RagFileChunkingConfig `protobuf:"bytes,4,opt,name=rag_file_chunking_config,json=ragFileChunkingConfig,proto3" json:"rag_file_chunking_config,omitempty"`
	// Optional. The max number of queries per minute that this job is allowed to
	// make to the embedding model specified on the corpus. This value is specific
	// to this job and not shared across other import jobs. Consult the Quotas
	// page on the project to set an appropriate value here.
	// If unspecified, a default value of 1,000 QPM would be used.
	MaxEmbeddingRequestsPerMin int32 `protobuf:"varint,5,opt,name=max_embedding_requests_per_min,json=maxEmbeddingRequestsPerMin,proto3" json:"max_embedding_requests_per_min,omitempty"`
}

func (x *ImportRagFilesConfig) Reset() {
	*x = ImportRagFilesConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportRagFilesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportRagFilesConfig) ProtoMessage() {}

func (x *ImportRagFilesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportRagFilesConfig.ProtoReflect.Descriptor instead.
func (*ImportRagFilesConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{5}
}

func (m *ImportRagFilesConfig) GetImportSource() isImportRagFilesConfig_ImportSource {
	if m != nil {
		return m.ImportSource
	}
	return nil
}

func (x *ImportRagFilesConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetImportSource().(*ImportRagFilesConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportRagFilesConfig) GetGoogleDriveSource() *GoogleDriveSource {
	if x, ok := x.GetImportSource().(*ImportRagFilesConfig_GoogleDriveSource); ok {
		return x.GoogleDriveSource
	}
	return nil
}

func (x *ImportRagFilesConfig) GetRagFileChunkingConfig() *RagFileChunkingConfig {
	if x != nil {
		return x.RagFileChunkingConfig
	}
	return nil
}

func (x *ImportRagFilesConfig) GetMaxEmbeddingRequestsPerMin() int32 {
	if x != nil {
		return x.MaxEmbeddingRequestsPerMin
	}
	return 0
}

type isImportRagFilesConfig_ImportSource interface {
	isImportRagFilesConfig_ImportSource()
}

type ImportRagFilesConfig_GcsSource struct {
	// Google Cloud Storage location. Supports importing individual files as
	// well as entire Google Cloud Storage directories. Sample formats:
	// - `gs://bucket_name/my_directory/object_name/my_file.txt`
	// - `gs://bucket_name/my_directory`
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ImportRagFilesConfig_GoogleDriveSource struct {
	// Google Drive location. Supports importing individual files as
	// well as Google Drive folders.
	GoogleDriveSource *GoogleDriveSource `protobuf:"bytes,3,opt,name=google_drive_source,json=googleDriveSource,proto3,oneof"`
}

func (*ImportRagFilesConfig_GcsSource) isImportRagFilesConfig_ImportSource() {}

func (*ImportRagFilesConfig_GoogleDriveSource) isImportRagFilesConfig_ImportSource() {}

// Config representing a model hosted on Vertex Prediction Endpoint.
type RagEmbeddingModelConfig_VertexPredictionEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The endpoint resource name.
	// Format:
	// `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
	// or
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. The resource name of the model that is deployed on the
	// endpoint. Present only when the endpoint is not a publisher model.
	// Pattern:
	// `projects/{project}/locations/{location}/models/{model}`
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	// Output only. Version ID of the model that is deployed on the endpoint.
	// Present only when the endpoint is not a publisher model.
	ModelVersionId string `protobuf:"bytes,3,opt,name=model_version_id,json=modelVersionId,proto3" json:"model_version_id,omitempty"`
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) Reset() {
	*x = RagEmbeddingModelConfig_VertexPredictionEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagEmbeddingModelConfig_VertexPredictionEndpoint) ProtoMessage() {}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagEmbeddingModelConfig_VertexPredictionEndpoint.ProtoReflect.Descriptor instead.
func (*RagEmbeddingModelConfig_VertexPredictionEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{0, 0}
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) GetModelVersionId() string {
	if x != nil {
		return x.ModelVersionId
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x90, 0x03, 0x0a, 0x17, 0x52, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x91, 0x01, 0x0a, 0x1a,
	0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x18, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x1a,
	0xd0, 0x01, 0x0a, 0x18, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0xf9, 0x03, 0x0a, 0x09, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x1a, 0x72, 0x61, 0x67, 0x5f,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x17,
	0x72, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x80, 0x01, 0xea, 0x41,
	0x7d, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x72, 0x61, 0x67, 0x5f,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2a, 0x0a, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x32, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0xa4,
	0x07, 0x0a, 0x07, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x67, 0x63,
	0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x69, 0x0a, 0x13,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x6c, 0x0a, 0x14, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x12, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x5d, 0x0a, 0x0d, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x5a, 0x0a, 0x0b, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x41, 0x47, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x41, 0x47, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x54, 0x58, 0x54, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x41, 0x47,
	0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x44, 0x46, 0x10, 0x02,
	0x3a, 0x8f, 0x01, 0xea, 0x41, 0x8b, 0x01, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b,
	0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x7d, 0x2a,
	0x08, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x32, 0x07, 0x72, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x5b, 0x0a, 0x15, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x4f, 0x76, 0x65, 0x72, 0x6c,
	0x61, 0x70, 0x22, 0x86, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x18, 0x72, 0x61,
	0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x94, 0x03, 0x0a, 0x14,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x64, 0x0a, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x48, 0x00, 0x52, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x6f, 0x0a, 0x18, 0x72, 0x61, 0x67, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x15, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x1e, 0x6d, 0x61, 0x78, 0x5f,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x6d, 0x61, 0x78, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x4d, 0x69,
	0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x42, 0xe9, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x12, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x52, 0x61, 0x67, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_goTypes = []interface{}{
	(RagFile_RagFileType)(0),                                 // 0: google.cloud.aiplatform.v1beta1.RagFile.RagFileType
	(*RagEmbeddingModelConfig)(nil),                          // 1: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig
	(*RagCorpus)(nil),                                        // 2: google.cloud.aiplatform.v1beta1.RagCorpus
	(*RagFile)(nil),                                          // 3: google.cloud.aiplatform.v1beta1.RagFile
	(*RagFileChunkingConfig)(nil),                            // 4: google.cloud.aiplatform.v1beta1.RagFileChunkingConfig
	(*UploadRagFileConfig)(nil),                              // 5: google.cloud.aiplatform.v1beta1.UploadRagFileConfig
	(*ImportRagFilesConfig)(nil),                             // 6: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig
	(*RagEmbeddingModelConfig_VertexPredictionEndpoint)(nil), // 7: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.VertexPredictionEndpoint
	(*timestamppb.Timestamp)(nil),                            // 8: google.protobuf.Timestamp
	(*GcsSource)(nil),                                        // 9: google.cloud.aiplatform.v1beta1.GcsSource
	(*GoogleDriveSource)(nil),                                // 10: google.cloud.aiplatform.v1beta1.GoogleDriveSource
	(*DirectUploadSource)(nil),                               // 11: google.cloud.aiplatform.v1beta1.DirectUploadSource
}
var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_depIdxs = []int32{
	7,  // 0: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.vertex_prediction_endpoint:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.VertexPredictionEndpoint
	1,  // 1: google.cloud.aiplatform.v1beta1.RagCorpus.rag_embedding_model_config:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig
	8,  // 2: google.cloud.aiplatform.v1beta1.RagCorpus.create_time:type_name -> google.protobuf.Timestamp
	8,  // 3: google.cloud.aiplatform.v1beta1.RagCorpus.update_time:type_name -> google.protobuf.Timestamp
	9,  // 4: google.cloud.aiplatform.v1beta1.RagFile.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	10, // 5: google.cloud.aiplatform.v1beta1.RagFile.google_drive_source:type_name -> google.cloud.aiplatform.v1beta1.GoogleDriveSource
	11, // 6: google.cloud.aiplatform.v1beta1.RagFile.direct_upload_source:type_name -> google.cloud.aiplatform.v1beta1.DirectUploadSource
	0,  // 7: google.cloud.aiplatform.v1beta1.RagFile.rag_file_type:type_name -> google.cloud.aiplatform.v1beta1.RagFile.RagFileType
	8,  // 8: google.cloud.aiplatform.v1beta1.RagFile.create_time:type_name -> google.protobuf.Timestamp
	8,  // 9: google.cloud.aiplatform.v1beta1.RagFile.update_time:type_name -> google.protobuf.Timestamp
	4,  // 10: google.cloud.aiplatform.v1beta1.UploadRagFileConfig.rag_file_chunking_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileChunkingConfig
	9,  // 11: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	10, // 12: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.google_drive_source:type_name -> google.cloud.aiplatform.v1beta1.GoogleDriveSource
	4,  // 13: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_chunking_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileChunkingConfig
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_init() }
func file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_io_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RagEmbeddingModelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RagCorpus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RagFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RagFileChunkingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadRagFileConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportRagFilesConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RagEmbeddingModelConfig_VertexPredictionEndpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*RagEmbeddingModelConfig_VertexPredictionEndpoint_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*RagFile_GcsSource)(nil),
		(*RagFile_GoogleDriveSource)(nil),
		(*RagFile_DirectUploadSource)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ImportRagFilesConfig_GcsSource)(nil),
		(*ImportRagFilesConfig_GoogleDriveSource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto = out.File
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_depIdxs = nil
}
