/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the CustomDataStreamingPostBody type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CustomDataStreamingPostBody{}

// CustomDataStreamingPostBody struct for CustomDataStreamingPostBody
type CustomDataStreamingPostBody struct {
	Name *string `json:"name,omitempty"`
	// Options:  * `http` - Edge Applications (default)  * `waf` - WAF Events  * `cells_console` - Edge Functions  * `rtm_activity` - Activity History   
	DataSource NullableString `json:"data_source,omitempty"`
	// Note:  * Add all variables and values that will be used to stream according to the data source you choose to use.    * All data streaming [variables can be found on the reference documentation](https://www.azion.com/en/documentation/products/data-streaming/#selecting-data-sources).   
	TemplateModel *string `json:"template_model,omitempty"`
	Active NullableBool `json:"active,omitempty"`
}

// NewCustomDataStreamingPostBody instantiates a new CustomDataStreamingPostBody object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCustomDataStreamingPostBody() *CustomDataStreamingPostBody {
	this := CustomDataStreamingPostBody{}
	var active bool = true
	this.Active = *NewNullableBool(&active)
	return &this
}

// NewCustomDataStreamingPostBodyWithDefaults instantiates a new CustomDataStreamingPostBody object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCustomDataStreamingPostBodyWithDefaults() *CustomDataStreamingPostBody {
	this := CustomDataStreamingPostBody{}
	var active bool = true
	this.Active = *NewNullableBool(&active)
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *CustomDataStreamingPostBody) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CustomDataStreamingPostBody) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *CustomDataStreamingPostBody) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *CustomDataStreamingPostBody) SetName(v string) {
	o.Name = &v
}

// GetDataSource returns the DataSource field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *CustomDataStreamingPostBody) GetDataSource() string {
	if o == nil || IsNil(o.DataSource.Get()) {
		var ret string
		return ret
	}
	return *o.DataSource.Get()
}

// GetDataSourceOk returns a tuple with the DataSource field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CustomDataStreamingPostBody) GetDataSourceOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.DataSource.Get(), o.DataSource.IsSet()
}

// HasDataSource returns a boolean if a field has been set.
func (o *CustomDataStreamingPostBody) HasDataSource() bool {
	if o != nil && o.DataSource.IsSet() {
		return true
	}

	return false
}

// SetDataSource gets a reference to the given NullableString and assigns it to the DataSource field.
func (o *CustomDataStreamingPostBody) SetDataSource(v string) {
	o.DataSource.Set(&v)
}
// SetDataSourceNil sets the value for DataSource to be an explicit nil
func (o *CustomDataStreamingPostBody) SetDataSourceNil() {
	o.DataSource.Set(nil)
}

// UnsetDataSource ensures that no value is present for DataSource, not even an explicit nil
func (o *CustomDataStreamingPostBody) UnsetDataSource() {
	o.DataSource.Unset()
}

// GetTemplateModel returns the TemplateModel field value if set, zero value otherwise.
func (o *CustomDataStreamingPostBody) GetTemplateModel() string {
	if o == nil || IsNil(o.TemplateModel) {
		var ret string
		return ret
	}
	return *o.TemplateModel
}

// GetTemplateModelOk returns a tuple with the TemplateModel field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CustomDataStreamingPostBody) GetTemplateModelOk() (*string, bool) {
	if o == nil || IsNil(o.TemplateModel) {
		return nil, false
	}
	return o.TemplateModel, true
}

// HasTemplateModel returns a boolean if a field has been set.
func (o *CustomDataStreamingPostBody) HasTemplateModel() bool {
	if o != nil && !IsNil(o.TemplateModel) {
		return true
	}

	return false
}

// SetTemplateModel gets a reference to the given string and assigns it to the TemplateModel field.
func (o *CustomDataStreamingPostBody) SetTemplateModel(v string) {
	o.TemplateModel = &v
}

// GetActive returns the Active field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *CustomDataStreamingPostBody) GetActive() bool {
	if o == nil || IsNil(o.Active.Get()) {
		var ret bool
		return ret
	}
	return *o.Active.Get()
}

// GetActiveOk returns a tuple with the Active field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CustomDataStreamingPostBody) GetActiveOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.Active.Get(), o.Active.IsSet()
}

// HasActive returns a boolean if a field has been set.
func (o *CustomDataStreamingPostBody) HasActive() bool {
	if o != nil && o.Active.IsSet() {
		return true
	}

	return false
}

// SetActive gets a reference to the given NullableBool and assigns it to the Active field.
func (o *CustomDataStreamingPostBody) SetActive(v bool) {
	o.Active.Set(&v)
}
// SetActiveNil sets the value for Active to be an explicit nil
func (o *CustomDataStreamingPostBody) SetActiveNil() {
	o.Active.Set(nil)
}

// UnsetActive ensures that no value is present for Active, not even an explicit nil
func (o *CustomDataStreamingPostBody) UnsetActive() {
	o.Active.Unset()
}

func (o CustomDataStreamingPostBody) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CustomDataStreamingPostBody) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if o.DataSource.IsSet() {
		toSerialize["data_source"] = o.DataSource.Get()
	}
	if !IsNil(o.TemplateModel) {
		toSerialize["template_model"] = o.TemplateModel
	}
	if o.Active.IsSet() {
		toSerialize["active"] = o.Active.Get()
	}
	return toSerialize, nil
}

type NullableCustomDataStreamingPostBody struct {
	value *CustomDataStreamingPostBody
	isSet bool
}

func (v NullableCustomDataStreamingPostBody) Get() *CustomDataStreamingPostBody {
	return v.value
}

func (v *NullableCustomDataStreamingPostBody) Set(val *CustomDataStreamingPostBody) {
	v.value = val
	v.isSet = true
}

func (v NullableCustomDataStreamingPostBody) IsSet() bool {
	return v.isSet
}

func (v *NullableCustomDataStreamingPostBody) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCustomDataStreamingPostBody(val *CustomDataStreamingPostBody) *NullableCustomDataStreamingPostBody {
	return &NullableCustomDataStreamingPostBody{value: val, isSet: true}
}

func (v NullableCustomDataStreamingPostBody) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCustomDataStreamingPostBody) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


