/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the DataStreamingEndpointTypeStandard type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DataStreamingEndpointTypeStandard{}

// DataStreamingEndpointTypeStandard struct for DataStreamingEndpointTypeStandard
type DataStreamingEndpointTypeStandard struct {
	EndpointType *string `json:"endpoint_type,omitempty"`
	Url *string `json:"url,omitempty"`
	LogLineSeparator *string `json:"log_line_separator,omitempty"`
	PayloadFormat *string `json:"payload_format,omitempty"`
	MaxSize *int32 `json:"max_size,omitempty"`
	Headers *DataStreamingEndpointTypeStandardHeadersExample `json:"headers,omitempty"`
}

// NewDataStreamingEndpointTypeStandard instantiates a new DataStreamingEndpointTypeStandard object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDataStreamingEndpointTypeStandard() *DataStreamingEndpointTypeStandard {
	this := DataStreamingEndpointTypeStandard{}
	return &this
}

// NewDataStreamingEndpointTypeStandardWithDefaults instantiates a new DataStreamingEndpointTypeStandard object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDataStreamingEndpointTypeStandardWithDefaults() *DataStreamingEndpointTypeStandard {
	this := DataStreamingEndpointTypeStandard{}
	return &this
}

// GetEndpointType returns the EndpointType field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeStandard) GetEndpointType() string {
	if o == nil || IsNil(o.EndpointType) {
		var ret string
		return ret
	}
	return *o.EndpointType
}

// GetEndpointTypeOk returns a tuple with the EndpointType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeStandard) GetEndpointTypeOk() (*string, bool) {
	if o == nil || IsNil(o.EndpointType) {
		return nil, false
	}
	return o.EndpointType, true
}

// HasEndpointType returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeStandard) HasEndpointType() bool {
	if o != nil && !IsNil(o.EndpointType) {
		return true
	}

	return false
}

// SetEndpointType gets a reference to the given string and assigns it to the EndpointType field.
func (o *DataStreamingEndpointTypeStandard) SetEndpointType(v string) {
	o.EndpointType = &v
}

// GetUrl returns the Url field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeStandard) GetUrl() string {
	if o == nil || IsNil(o.Url) {
		var ret string
		return ret
	}
	return *o.Url
}

// GetUrlOk returns a tuple with the Url field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeStandard) GetUrlOk() (*string, bool) {
	if o == nil || IsNil(o.Url) {
		return nil, false
	}
	return o.Url, true
}

// HasUrl returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeStandard) HasUrl() bool {
	if o != nil && !IsNil(o.Url) {
		return true
	}

	return false
}

// SetUrl gets a reference to the given string and assigns it to the Url field.
func (o *DataStreamingEndpointTypeStandard) SetUrl(v string) {
	o.Url = &v
}

// GetLogLineSeparator returns the LogLineSeparator field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeStandard) GetLogLineSeparator() string {
	if o == nil || IsNil(o.LogLineSeparator) {
		var ret string
		return ret
	}
	return *o.LogLineSeparator
}

// GetLogLineSeparatorOk returns a tuple with the LogLineSeparator field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeStandard) GetLogLineSeparatorOk() (*string, bool) {
	if o == nil || IsNil(o.LogLineSeparator) {
		return nil, false
	}
	return o.LogLineSeparator, true
}

// HasLogLineSeparator returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeStandard) HasLogLineSeparator() bool {
	if o != nil && !IsNil(o.LogLineSeparator) {
		return true
	}

	return false
}

// SetLogLineSeparator gets a reference to the given string and assigns it to the LogLineSeparator field.
func (o *DataStreamingEndpointTypeStandard) SetLogLineSeparator(v string) {
	o.LogLineSeparator = &v
}

// GetPayloadFormat returns the PayloadFormat field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeStandard) GetPayloadFormat() string {
	if o == nil || IsNil(o.PayloadFormat) {
		var ret string
		return ret
	}
	return *o.PayloadFormat
}

// GetPayloadFormatOk returns a tuple with the PayloadFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeStandard) GetPayloadFormatOk() (*string, bool) {
	if o == nil || IsNil(o.PayloadFormat) {
		return nil, false
	}
	return o.PayloadFormat, true
}

// HasPayloadFormat returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeStandard) HasPayloadFormat() bool {
	if o != nil && !IsNil(o.PayloadFormat) {
		return true
	}

	return false
}

// SetPayloadFormat gets a reference to the given string and assigns it to the PayloadFormat field.
func (o *DataStreamingEndpointTypeStandard) SetPayloadFormat(v string) {
	o.PayloadFormat = &v
}

// GetMaxSize returns the MaxSize field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeStandard) GetMaxSize() int32 {
	if o == nil || IsNil(o.MaxSize) {
		var ret int32
		return ret
	}
	return *o.MaxSize
}

// GetMaxSizeOk returns a tuple with the MaxSize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeStandard) GetMaxSizeOk() (*int32, bool) {
	if o == nil || IsNil(o.MaxSize) {
		return nil, false
	}
	return o.MaxSize, true
}

// HasMaxSize returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeStandard) HasMaxSize() bool {
	if o != nil && !IsNil(o.MaxSize) {
		return true
	}

	return false
}

// SetMaxSize gets a reference to the given int32 and assigns it to the MaxSize field.
func (o *DataStreamingEndpointTypeStandard) SetMaxSize(v int32) {
	o.MaxSize = &v
}

// GetHeaders returns the Headers field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeStandard) GetHeaders() DataStreamingEndpointTypeStandardHeadersExample {
	if o == nil || IsNil(o.Headers) {
		var ret DataStreamingEndpointTypeStandardHeadersExample
		return ret
	}
	return *o.Headers
}

// GetHeadersOk returns a tuple with the Headers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeStandard) GetHeadersOk() (*DataStreamingEndpointTypeStandardHeadersExample, bool) {
	if o == nil || IsNil(o.Headers) {
		return nil, false
	}
	return o.Headers, true
}

// HasHeaders returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeStandard) HasHeaders() bool {
	if o != nil && !IsNil(o.Headers) {
		return true
	}

	return false
}

// SetHeaders gets a reference to the given DataStreamingEndpointTypeStandardHeadersExample and assigns it to the Headers field.
func (o *DataStreamingEndpointTypeStandard) SetHeaders(v DataStreamingEndpointTypeStandardHeadersExample) {
	o.Headers = &v
}

func (o DataStreamingEndpointTypeStandard) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DataStreamingEndpointTypeStandard) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.EndpointType) {
		toSerialize["endpoint_type"] = o.EndpointType
	}
	if !IsNil(o.Url) {
		toSerialize["url"] = o.Url
	}
	if !IsNil(o.LogLineSeparator) {
		toSerialize["log_line_separator"] = o.LogLineSeparator
	}
	if !IsNil(o.PayloadFormat) {
		toSerialize["payload_format"] = o.PayloadFormat
	}
	if !IsNil(o.MaxSize) {
		toSerialize["max_size"] = o.MaxSize
	}
	if !IsNil(o.Headers) {
		toSerialize["headers"] = o.Headers
	}
	return toSerialize, nil
}

type NullableDataStreamingEndpointTypeStandard struct {
	value *DataStreamingEndpointTypeStandard
	isSet bool
}

func (v NullableDataStreamingEndpointTypeStandard) Get() *DataStreamingEndpointTypeStandard {
	return v.value
}

func (v *NullableDataStreamingEndpointTypeStandard) Set(val *DataStreamingEndpointTypeStandard) {
	v.value = val
	v.isSet = true
}

func (v NullableDataStreamingEndpointTypeStandard) IsSet() bool {
	return v.isSet
}

func (v *NullableDataStreamingEndpointTypeStandard) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDataStreamingEndpointTypeStandard(val *DataStreamingEndpointTypeStandard) *NullableDataStreamingEndpointTypeStandard {
	return &NullableDataStreamingEndpointTypeStandard{value: val, isSet: true}
}

func (v NullableDataStreamingEndpointTypeStandard) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDataStreamingEndpointTypeStandard) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


