/*
Edge Node API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package edgenode

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
)


// DefaultApiService DefaultApi service
type DefaultApiService service

type ApiAuthorizeEdgeNodeRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	authorizeEdgeNodesRequest *AuthorizeEdgeNodesRequest
}

func (r ApiAuthorizeEdgeNodeRequest) AuthorizeEdgeNodesRequest(authorizeEdgeNodesRequest AuthorizeEdgeNodesRequest) ApiAuthorizeEdgeNodeRequest {
	r.authorizeEdgeNodesRequest = &authorizeEdgeNodesRequest
	return r
}

func (r ApiAuthorizeEdgeNodeRequest) Execute() (*AuthorizeEdgeNodesResponse, *http.Response, error) {
	return r.ApiService.AuthorizeEdgeNodeExecute(r)
}

/*
AuthorizeEdgeNode Authorize edge-node

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiAuthorizeEdgeNodeRequest
*/
func (a *DefaultApiService) AuthorizeEdgeNode(ctx context.Context) ApiAuthorizeEdgeNodeRequest {
	return ApiAuthorizeEdgeNodeRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AuthorizeEdgeNodesResponse
func (a *DefaultApiService) AuthorizeEdgeNodeExecute(r ApiAuthorizeEdgeNodeRequest) (*AuthorizeEdgeNodesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AuthorizeEdgeNodesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.AuthorizeEdgeNode")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/authorize"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.authorizeEdgeNodesRequest == nil {
		return localVarReturnValue, nil, reportError("authorizeEdgeNodesRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.authorizeEdgeNodesRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiCreateEdgeNodeSvcsRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	edgenodeId int64
	serviceBindRequest *ServiceBindRequest
}

func (r ApiCreateEdgeNodeSvcsRequest) ServiceBindRequest(serviceBindRequest ServiceBindRequest) ApiCreateEdgeNodeSvcsRequest {
	r.serviceBindRequest = &serviceBindRequest
	return r
}

func (r ApiCreateEdgeNodeSvcsRequest) Execute() (*ServiceBindDetailResponse, *http.Response, error) {
	return r.ApiService.CreateEdgeNodeSvcsExecute(r)
}

/*
CreateEdgeNodeSvcs Create an edge-node Service association

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgenodeId
 @return ApiCreateEdgeNodeSvcsRequest
*/
func (a *DefaultApiService) CreateEdgeNodeSvcs(ctx context.Context, edgenodeId int64) ApiCreateEdgeNodeSvcsRequest {
	return ApiCreateEdgeNodeSvcsRequest{
		ApiService: a,
		ctx: ctx,
		edgenodeId: edgenodeId,
	}
}

// Execute executes the request
//  @return ServiceBindDetailResponse
func (a *DefaultApiService) CreateEdgeNodeSvcsExecute(r ApiCreateEdgeNodeSvcsRequest) (*ServiceBindDetailResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ServiceBindDetailResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.CreateEdgeNodeSvcs")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/{edgenodeId}/services"
	localVarPath = strings.Replace(localVarPath, "{"+"edgenodeId"+"}", url.PathEscape(parameterValueToString(r.edgenodeId, "edgenodeId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.serviceBindRequest == nil {
		return localVarReturnValue, nil, reportError("serviceBindRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.serviceBindRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiDelEdgeNodeRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	edgenodeId int64
}

func (r ApiDelEdgeNodeRequest) Execute() (*http.Response, error) {
	return r.ApiService.DelEdgeNodeExecute(r)
}

/*
DelEdgeNode Delete edge-node by ID

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgenodeId
 @return ApiDelEdgeNodeRequest
*/
func (a *DefaultApiService) DelEdgeNode(ctx context.Context, edgenodeId int64) ApiDelEdgeNodeRequest {
	return ApiDelEdgeNodeRequest{
		ApiService: a,
		ctx: ctx,
		edgenodeId: edgenodeId,
	}
}

// Execute executes the request
func (a *DefaultApiService) DelEdgeNodeExecute(r ApiDelEdgeNodeRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.DelEdgeNode")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/{edgenodeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"edgenodeId"+"}", url.PathEscape(parameterValueToString(r.edgenodeId, "edgenodeId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDelEdgeNodeSvcRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	edgenodeId int64
	bindId int64
}

func (r ApiDelEdgeNodeSvcRequest) Execute() (*http.Response, error) {
	return r.ApiService.DelEdgeNodeSvcExecute(r)
}

/*
DelEdgeNodeSvc Delete an edge-node Service association

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgenodeId
 @param bindId
 @return ApiDelEdgeNodeSvcRequest
*/
func (a *DefaultApiService) DelEdgeNodeSvc(ctx context.Context, edgenodeId int64, bindId int64) ApiDelEdgeNodeSvcRequest {
	return ApiDelEdgeNodeSvcRequest{
		ApiService: a,
		ctx: ctx,
		edgenodeId: edgenodeId,
		bindId: bindId,
	}
}

// Execute executes the request
func (a *DefaultApiService) DelEdgeNodeSvcExecute(r ApiDelEdgeNodeSvcRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.DelEdgeNodeSvc")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/{edgenodeId}/services/{bindId}"
	localVarPath = strings.Replace(localVarPath, "{"+"edgenodeId"+"}", url.PathEscape(parameterValueToString(r.edgenodeId, "edgenodeId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"bindId"+"}", url.PathEscape(parameterValueToString(r.bindId, "bindId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiGetEdgeNodeRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	edgenodeId int64
}

func (r ApiGetEdgeNodeRequest) Execute() (*EdgeNodeDetailResponse, *http.Response, error) {
	return r.ApiService.GetEdgeNodeExecute(r)
}

/*
GetEdgeNode Return edge-node by ID

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgenodeId
 @return ApiGetEdgeNodeRequest
*/
func (a *DefaultApiService) GetEdgeNode(ctx context.Context, edgenodeId int64) ApiGetEdgeNodeRequest {
	return ApiGetEdgeNodeRequest{
		ApiService: a,
		ctx: ctx,
		edgenodeId: edgenodeId,
	}
}

// Execute executes the request
//  @return EdgeNodeDetailResponse
func (a *DefaultApiService) GetEdgeNodeExecute(r ApiGetEdgeNodeRequest) (*EdgeNodeDetailResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *EdgeNodeDetailResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.GetEdgeNode")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/{edgenodeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"edgenodeId"+"}", url.PathEscape(parameterValueToString(r.edgenodeId, "edgenodeId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetEdgeNodeGroupsRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
}

func (r ApiGetEdgeNodeGroupsRequest) Execute() ([]NodeGroupResponse, *http.Response, error) {
	return r.ApiService.GetEdgeNodeGroupsExecute(r)
}

/*
GetEdgeNodeGroups Return edge-node groups

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiGetEdgeNodeGroupsRequest
*/
func (a *DefaultApiService) GetEdgeNodeGroups(ctx context.Context) ApiGetEdgeNodeGroupsRequest {
	return ApiGetEdgeNodeGroupsRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return []NodeGroupResponse
func (a *DefaultApiService) GetEdgeNodeGroupsExecute(r ApiGetEdgeNodeGroupsRequest) ([]NodeGroupResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  []NodeGroupResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.GetEdgeNodeGroups")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetEdgeNodeSvcDetailRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	edgenodeId int64
	bindId int64
}

func (r ApiGetEdgeNodeSvcDetailRequest) Execute() (*ServiceBindDetailResponse, *http.Response, error) {
	return r.ApiService.GetEdgeNodeSvcDetailExecute(r)
}

/*
GetEdgeNodeSvcDetail Return edge-node Service association by ID

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgenodeId
 @param bindId
 @return ApiGetEdgeNodeSvcDetailRequest
*/
func (a *DefaultApiService) GetEdgeNodeSvcDetail(ctx context.Context, edgenodeId int64, bindId int64) ApiGetEdgeNodeSvcDetailRequest {
	return ApiGetEdgeNodeSvcDetailRequest{
		ApiService: a,
		ctx: ctx,
		edgenodeId: edgenodeId,
		bindId: bindId,
	}
}

// Execute executes the request
//  @return ServiceBindDetailResponse
func (a *DefaultApiService) GetEdgeNodeSvcDetailExecute(r ApiGetEdgeNodeSvcDetailRequest) (*ServiceBindDetailResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ServiceBindDetailResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.GetEdgeNodeSvcDetail")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/{edgenodeId}/services/{bindId}"
	localVarPath = strings.Replace(localVarPath, "{"+"edgenodeId"+"}", url.PathEscape(parameterValueToString(r.edgenodeId, "edgenodeId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"bindId"+"}", url.PathEscape(parameterValueToString(r.bindId, "bindId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetEdgeNodeSvcsRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	edgenodeId int64
	isBound *bool
	filter *string
	orderBy *string
	sort *string
	page *int64
	pageSize *int64
}

func (r ApiGetEdgeNodeSvcsRequest) IsBound(isBound bool) ApiGetEdgeNodeSvcsRequest {
	r.isBound = &isBound
	return r
}

func (r ApiGetEdgeNodeSvcsRequest) Filter(filter string) ApiGetEdgeNodeSvcsRequest {
	r.filter = &filter
	return r
}

func (r ApiGetEdgeNodeSvcsRequest) OrderBy(orderBy string) ApiGetEdgeNodeSvcsRequest {
	r.orderBy = &orderBy
	return r
}

func (r ApiGetEdgeNodeSvcsRequest) Sort(sort string) ApiGetEdgeNodeSvcsRequest {
	r.sort = &sort
	return r
}

func (r ApiGetEdgeNodeSvcsRequest) Page(page int64) ApiGetEdgeNodeSvcsRequest {
	r.page = &page
	return r
}

func (r ApiGetEdgeNodeSvcsRequest) PageSize(pageSize int64) ApiGetEdgeNodeSvcsRequest {
	r.pageSize = &pageSize
	return r
}

func (r ApiGetEdgeNodeSvcsRequest) Execute() (*ServiceResponseWithTotal, *http.Response, error) {
	return r.ApiService.GetEdgeNodeSvcsExecute(r)
}

/*
GetEdgeNodeSvcs Return edge-node Services association

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgenodeId
 @return ApiGetEdgeNodeSvcsRequest
*/
func (a *DefaultApiService) GetEdgeNodeSvcs(ctx context.Context, edgenodeId int64) ApiGetEdgeNodeSvcsRequest {
	return ApiGetEdgeNodeSvcsRequest{
		ApiService: a,
		ctx: ctx,
		edgenodeId: edgenodeId,
	}
}

// Execute executes the request
//  @return ServiceResponseWithTotal
func (a *DefaultApiService) GetEdgeNodeSvcsExecute(r ApiGetEdgeNodeSvcsRequest) (*ServiceResponseWithTotal, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ServiceResponseWithTotal
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.GetEdgeNodeSvcs")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/{edgenodeId}/services"
	localVarPath = strings.Replace(localVarPath, "{"+"edgenodeId"+"}", url.PathEscape(parameterValueToString(r.edgenodeId, "edgenodeId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.isBound != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "is_bound", r.isBound, "")
	}
	if r.filter != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "filter", r.filter, "")
	}
	if r.orderBy != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "order_by", r.orderBy, "")
	}
	if r.sort != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sort", r.sort, "")
	}
	if r.page != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page", r.page, "")
	}
	if r.pageSize != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page_size", r.pageSize, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetEdgeNodesRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	filter *string
	orderBy *string
	sort *string
	onlyIds *bool
	pageSize *int64
}

func (r ApiGetEdgeNodesRequest) Filter(filter string) ApiGetEdgeNodesRequest {
	r.filter = &filter
	return r
}

func (r ApiGetEdgeNodesRequest) OrderBy(orderBy string) ApiGetEdgeNodesRequest {
	r.orderBy = &orderBy
	return r
}

func (r ApiGetEdgeNodesRequest) Sort(sort string) ApiGetEdgeNodesRequest {
	r.sort = &sort
	return r
}

func (r ApiGetEdgeNodesRequest) OnlyIds(onlyIds bool) ApiGetEdgeNodesRequest {
	r.onlyIds = &onlyIds
	return r
}

func (r ApiGetEdgeNodesRequest) PageSize(pageSize int64) ApiGetEdgeNodesRequest {
	r.pageSize = &pageSize
	return r
}

func (r ApiGetEdgeNodesRequest) Execute() (*EdgeNodeResponseWithTotal, *http.Response, error) {
	return r.ApiService.GetEdgeNodesExecute(r)
}

/*
GetEdgeNodes Return edge-nodes

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiGetEdgeNodesRequest
*/
func (a *DefaultApiService) GetEdgeNodes(ctx context.Context) ApiGetEdgeNodesRequest {
	return ApiGetEdgeNodesRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return EdgeNodeResponseWithTotal
func (a *DefaultApiService) GetEdgeNodesExecute(r ApiGetEdgeNodesRequest) (*EdgeNodeResponseWithTotal, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *EdgeNodeResponseWithTotal
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.GetEdgeNodes")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.filter != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "filter", r.filter, "")
	}
	if r.orderBy != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "order_by", r.orderBy, "")
	}
	if r.sort != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sort", r.sort, "")
	}
	if r.onlyIds != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "only_ids", r.onlyIds, "")
	}
	if r.pageSize != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page_size", r.pageSize, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiUpdateEdgeNodeRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	edgenodeId int64
}

func (r ApiUpdateEdgeNodeRequest) Execute() (*UpdateEdgeNodeResponse, *http.Response, error) {
	return r.ApiService.UpdateEdgeNodeExecute(r)
}

/*
UpdateEdgeNode Update edge-node

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgenodeId
 @return ApiUpdateEdgeNodeRequest
*/
func (a *DefaultApiService) UpdateEdgeNode(ctx context.Context, edgenodeId int64) ApiUpdateEdgeNodeRequest {
	return ApiUpdateEdgeNodeRequest{
		ApiService: a,
		ctx: ctx,
		edgenodeId: edgenodeId,
	}
}

// Execute executes the request
//  @return UpdateEdgeNodeResponse
func (a *DefaultApiService) UpdateEdgeNodeExecute(r ApiUpdateEdgeNodeRequest) (*UpdateEdgeNodeResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UpdateEdgeNodeResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.UpdateEdgeNode")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/{edgenodeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"edgenodeId"+"}", url.PathEscape(parameterValueToString(r.edgenodeId, "edgenodeId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiUpdateEdgeNodeSvcDetailRequest struct {
	ctx context.Context
	ApiService *DefaultApiService
	edgenodeId int64
	bindId int64
	updateServiceBindRequest *UpdateServiceBindRequest
}

func (r ApiUpdateEdgeNodeSvcDetailRequest) UpdateServiceBindRequest(updateServiceBindRequest UpdateServiceBindRequest) ApiUpdateEdgeNodeSvcDetailRequest {
	r.updateServiceBindRequest = &updateServiceBindRequest
	return r
}

func (r ApiUpdateEdgeNodeSvcDetailRequest) Execute() (*ServiceBindDetailResponse, *http.Response, error) {
	return r.ApiService.UpdateEdgeNodeSvcDetailExecute(r)
}

/*
UpdateEdgeNodeSvcDetail Update edge-node Service association by ID

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgenodeId
 @param bindId
 @return ApiUpdateEdgeNodeSvcDetailRequest
*/
func (a *DefaultApiService) UpdateEdgeNodeSvcDetail(ctx context.Context, edgenodeId int64, bindId int64) ApiUpdateEdgeNodeSvcDetailRequest {
	return ApiUpdateEdgeNodeSvcDetailRequest{
		ApiService: a,
		ctx: ctx,
		edgenodeId: edgenodeId,
		bindId: bindId,
	}
}

// Execute executes the request
//  @return ServiceBindDetailResponse
func (a *DefaultApiService) UpdateEdgeNodeSvcDetailExecute(r ApiUpdateEdgeNodeSvcDetailRequest) (*ServiceBindDetailResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ServiceBindDetailResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultApiService.UpdateEdgeNodeSvcDetail")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_nodes/{edgenodeId}/services/{bindId}"
	localVarPath = strings.Replace(localVarPath, "{"+"edgenodeId"+"}", url.PathEscape(parameterValueToString(r.edgenodeId, "edgenodeId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"bindId"+"}", url.PathEscape(parameterValueToString(r.bindId, "bindId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.updateServiceBindRequest == nil {
		return localVarReturnValue, nil, reportError("updateServiceBindRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.updateServiceBindRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
