/*
Object Storage

REST API OpenAPI documentation for the Object Storage

API version: 1.0.0 (v1)
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package storage

import (
	"encoding/json"
)

// checks if the ResponseS3Credential type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ResponseS3Credential{}

// ResponseS3Credential struct for ResponseS3Credential
type ResponseS3Credential struct {
	State *string `json:"state,omitempty" validate:"regexp=.*"`
	Data *S3Credential `json:"data,omitempty"`
}

// NewResponseS3Credential instantiates a new ResponseS3Credential object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewResponseS3Credential() *ResponseS3Credential {
	this := ResponseS3Credential{}
	return &this
}

// NewResponseS3CredentialWithDefaults instantiates a new ResponseS3Credential object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewResponseS3CredentialWithDefaults() *ResponseS3Credential {
	this := ResponseS3Credential{}
	return &this
}

// GetState returns the State field value if set, zero value otherwise.
func (o *ResponseS3Credential) GetState() string {
	if o == nil || IsNil(o.State) {
		var ret string
		return ret
	}
	return *o.State
}

// GetStateOk returns a tuple with the State field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ResponseS3Credential) GetStateOk() (*string, bool) {
	if o == nil || IsNil(o.State) {
		return nil, false
	}
	return o.State, true
}

// HasState returns a boolean if a field has been set.
func (o *ResponseS3Credential) HasState() bool {
	if o != nil && !IsNil(o.State) {
		return true
	}

	return false
}

// SetState gets a reference to the given string and assigns it to the State field.
func (o *ResponseS3Credential) SetState(v string) {
	o.State = &v
}

// GetData returns the Data field value if set, zero value otherwise.
func (o *ResponseS3Credential) GetData() S3Credential {
	if o == nil || IsNil(o.Data) {
		var ret S3Credential
		return ret
	}
	return *o.Data
}

// GetDataOk returns a tuple with the Data field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ResponseS3Credential) GetDataOk() (*S3Credential, bool) {
	if o == nil || IsNil(o.Data) {
		return nil, false
	}
	return o.Data, true
}

// HasData returns a boolean if a field has been set.
func (o *ResponseS3Credential) HasData() bool {
	if o != nil && !IsNil(o.Data) {
		return true
	}

	return false
}

// SetData gets a reference to the given S3Credential and assigns it to the Data field.
func (o *ResponseS3Credential) SetData(v S3Credential) {
	o.Data = &v
}

func (o ResponseS3Credential) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ResponseS3Credential) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.State) {
		toSerialize["state"] = o.State
	}
	if !IsNil(o.Data) {
		toSerialize["data"] = o.Data
	}
	return toSerialize, nil
}

type NullableResponseS3Credential struct {
	value *ResponseS3Credential
	isSet bool
}

func (v NullableResponseS3Credential) Get() *ResponseS3Credential {
	return v.value
}

func (v *NullableResponseS3Credential) Set(val *ResponseS3Credential) {
	v.value = val
	v.isSet = true
}

func (v NullableResponseS3Credential) IsSet() bool {
	return v.isSet
}

func (v *NullableResponseS3Credential) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableResponseS3Credential(val *ResponseS3Credential) *NullableResponseS3Credential {
	return &NullableResponseS3Credential{value: val, isSet: true}
}

func (v NullableResponseS3Credential) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableResponseS3Credential) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


