/*
Object Storage

REST API OpenAPI documentation for the Object Storage

API version: 1.0.0 (v1)
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package storage

import (
	"encoding/json"
	"time"
)

// checks if the S3CredentialCreate type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &S3CredentialCreate{}

// S3CredentialCreate struct for S3CredentialCreate
type S3CredentialCreate struct {
	Name *string `json:"name,omitempty" validate:"regexp=.*"`
	Capabilities []string `json:"capabilities,omitempty"`
	Bucket *string `json:"bucket,omitempty" validate:"regexp=.*"`
	ExpirationDate *time.Time `json:"expiration_date,omitempty" validate:"regexp=.*"`
}

// NewS3CredentialCreate instantiates a new S3CredentialCreate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewS3CredentialCreate() *S3CredentialCreate {
	this := S3CredentialCreate{}
	return &this
}

// NewS3CredentialCreateWithDefaults instantiates a new S3CredentialCreate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewS3CredentialCreateWithDefaults() *S3CredentialCreate {
	this := S3CredentialCreate{}
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *S3CredentialCreate) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *S3CredentialCreate) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *S3CredentialCreate) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *S3CredentialCreate) SetName(v string) {
	o.Name = &v
}

// GetCapabilities returns the Capabilities field value if set, zero value otherwise.
func (o *S3CredentialCreate) GetCapabilities() []string {
	if o == nil || IsNil(o.Capabilities) {
		var ret []string
		return ret
	}
	return o.Capabilities
}

// GetCapabilitiesOk returns a tuple with the Capabilities field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *S3CredentialCreate) GetCapabilitiesOk() ([]string, bool) {
	if o == nil || IsNil(o.Capabilities) {
		return nil, false
	}
	return o.Capabilities, true
}

// HasCapabilities returns a boolean if a field has been set.
func (o *S3CredentialCreate) HasCapabilities() bool {
	if o != nil && !IsNil(o.Capabilities) {
		return true
	}

	return false
}

// SetCapabilities gets a reference to the given []string and assigns it to the Capabilities field.
func (o *S3CredentialCreate) SetCapabilities(v []string) {
	o.Capabilities = v
}

// GetBucket returns the Bucket field value if set, zero value otherwise.
func (o *S3CredentialCreate) GetBucket() string {
	if o == nil || IsNil(o.Bucket) {
		var ret string
		return ret
	}
	return *o.Bucket
}

// GetBucketOk returns a tuple with the Bucket field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *S3CredentialCreate) GetBucketOk() (*string, bool) {
	if o == nil || IsNil(o.Bucket) {
		return nil, false
	}
	return o.Bucket, true
}

// HasBucket returns a boolean if a field has been set.
func (o *S3CredentialCreate) HasBucket() bool {
	if o != nil && !IsNil(o.Bucket) {
		return true
	}

	return false
}

// SetBucket gets a reference to the given string and assigns it to the Bucket field.
func (o *S3CredentialCreate) SetBucket(v string) {
	o.Bucket = &v
}

// GetExpirationDate returns the ExpirationDate field value if set, zero value otherwise.
func (o *S3CredentialCreate) GetExpirationDate() time.Time {
	if o == nil || IsNil(o.ExpirationDate) {
		var ret time.Time
		return ret
	}
	return *o.ExpirationDate
}

// GetExpirationDateOk returns a tuple with the ExpirationDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *S3CredentialCreate) GetExpirationDateOk() (*time.Time, bool) {
	if o == nil || IsNil(o.ExpirationDate) {
		return nil, false
	}
	return o.ExpirationDate, true
}

// HasExpirationDate returns a boolean if a field has been set.
func (o *S3CredentialCreate) HasExpirationDate() bool {
	if o != nil && !IsNil(o.ExpirationDate) {
		return true
	}

	return false
}

// SetExpirationDate gets a reference to the given time.Time and assigns it to the ExpirationDate field.
func (o *S3CredentialCreate) SetExpirationDate(v time.Time) {
	o.ExpirationDate = &v
}

func (o S3CredentialCreate) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o S3CredentialCreate) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Capabilities) {
		toSerialize["capabilities"] = o.Capabilities
	}
	if !IsNil(o.Bucket) {
		toSerialize["bucket"] = o.Bucket
	}
	if !IsNil(o.ExpirationDate) {
		toSerialize["expiration_date"] = o.ExpirationDate
	}
	return toSerialize, nil
}

type NullableS3CredentialCreate struct {
	value *S3CredentialCreate
	isSet bool
}

func (v NullableS3CredentialCreate) Get() *S3CredentialCreate {
	return v.value
}

func (v *NullableS3CredentialCreate) Set(val *S3CredentialCreate) {
	v.value = val
	v.isSet = true
}

func (v NullableS3CredentialCreate) IsSet() bool {
	return v.isSet
}

func (v *NullableS3CredentialCreate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableS3CredentialCreate(val *S3CredentialCreate) *NullableS3CredentialCreate {
	return &NullableS3CredentialCreate{value: val, isSet: true}
}

func (v NullableS3CredentialCreate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableS3CredentialCreate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


