//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/common/mutation_rules/v3/mutation_rules.proto

package mutation_rulesv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on HeaderMutationRules with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HeaderMutationRules) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderMutationRules with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HeaderMutationRulesMultiError, or nil if none found.
func (m *HeaderMutationRules) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderMutationRules) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetAllowAllRouting()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "AllowAllRouting",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "AllowAllRouting",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAllowAllRouting()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMutationRulesValidationError{
				field:  "AllowAllRouting",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAllowEnvoy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "AllowEnvoy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "AllowEnvoy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAllowEnvoy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMutationRulesValidationError{
				field:  "AllowEnvoy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDisallowSystem()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "DisallowSystem",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "DisallowSystem",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDisallowSystem()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMutationRulesValidationError{
				field:  "DisallowSystem",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDisallowAll()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "DisallowAll",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "DisallowAll",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDisallowAll()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMutationRulesValidationError{
				field:  "DisallowAll",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAllowExpression()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "AllowExpression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "AllowExpression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAllowExpression()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMutationRulesValidationError{
				field:  "AllowExpression",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDisallowExpression()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "DisallowExpression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "DisallowExpression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDisallowExpression()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMutationRulesValidationError{
				field:  "DisallowExpression",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDisallowIsError()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "DisallowIsError",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderMutationRulesValidationError{
					field:  "DisallowIsError",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDisallowIsError()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMutationRulesValidationError{
				field:  "DisallowIsError",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return HeaderMutationRulesMultiError(errors)
	}

	return nil
}

// HeaderMutationRulesMultiError is an error wrapping multiple validation
// errors returned by HeaderMutationRules.ValidateAll() if the designated
// constraints aren't met.
type HeaderMutationRulesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderMutationRulesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderMutationRulesMultiError) AllErrors() []error { return m }

// HeaderMutationRulesValidationError is the validation error returned by
// HeaderMutationRules.Validate if the designated constraints aren't met.
type HeaderMutationRulesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderMutationRulesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderMutationRulesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderMutationRulesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderMutationRulesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderMutationRulesValidationError) ErrorName() string {
	return "HeaderMutationRulesValidationError"
}

// Error satisfies the builtin error interface
func (e HeaderMutationRulesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMutationRules.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderMutationRulesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderMutationRulesValidationError{}

// Validate checks the field values on HeaderMutation with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HeaderMutation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderMutation with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HeaderMutationMultiError,
// or nil if none found.
func (m *HeaderMutation) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderMutation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofActionPresent := false
	switch v := m.Action.(type) {
	case *HeaderMutation_Remove:
		if v == nil {
			err := HeaderMutationValidationError{
				field:  "Action",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionPresent = true

		if !_HeaderMutation_Remove_Pattern.MatchString(m.GetRemove()) {
			err := HeaderMutationValidationError{
				field:  "Remove",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *HeaderMutation_Append:
		if v == nil {
			err := HeaderMutationValidationError{
				field:  "Action",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionPresent = true

		if all {
			switch v := interface{}(m.GetAppend()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderMutationValidationError{
						field:  "Append",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderMutationValidationError{
						field:  "Append",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAppend()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMutationValidationError{
					field:  "Append",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HeaderMutation_RemoveOnMatch_:
		if v == nil {
			err := HeaderMutationValidationError{
				field:  "Action",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionPresent = true

		if all {
			switch v := interface{}(m.GetRemoveOnMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderMutationValidationError{
						field:  "RemoveOnMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderMutationValidationError{
						field:  "RemoveOnMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRemoveOnMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMutationValidationError{
					field:  "RemoveOnMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofActionPresent {
		err := HeaderMutationValidationError{
			field:  "Action",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return HeaderMutationMultiError(errors)
	}

	return nil
}

// HeaderMutationMultiError is an error wrapping multiple validation errors
// returned by HeaderMutation.ValidateAll() if the designated constraints
// aren't met.
type HeaderMutationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderMutationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderMutationMultiError) AllErrors() []error { return m }

// HeaderMutationValidationError is the validation error returned by
// HeaderMutation.Validate if the designated constraints aren't met.
type HeaderMutationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderMutationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderMutationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderMutationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderMutationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderMutationValidationError) ErrorName() string { return "HeaderMutationValidationError" }

// Error satisfies the builtin error interface
func (e HeaderMutationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMutation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderMutationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderMutationValidationError{}

var _HeaderMutation_Remove_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on HeaderMutation_RemoveOnMatch with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HeaderMutation_RemoveOnMatch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderMutation_RemoveOnMatch with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HeaderMutation_RemoveOnMatchMultiError, or nil if none found.
func (m *HeaderMutation_RemoveOnMatch) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderMutation_RemoveOnMatch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetKeyMatcher() == nil {
		err := HeaderMutation_RemoveOnMatchValidationError{
			field:  "KeyMatcher",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetKeyMatcher()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderMutation_RemoveOnMatchValidationError{
					field:  "KeyMatcher",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderMutation_RemoveOnMatchValidationError{
					field:  "KeyMatcher",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetKeyMatcher()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMutation_RemoveOnMatchValidationError{
				field:  "KeyMatcher",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return HeaderMutation_RemoveOnMatchMultiError(errors)
	}

	return nil
}

// HeaderMutation_RemoveOnMatchMultiError is an error wrapping multiple
// validation errors returned by HeaderMutation_RemoveOnMatch.ValidateAll() if
// the designated constraints aren't met.
type HeaderMutation_RemoveOnMatchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderMutation_RemoveOnMatchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderMutation_RemoveOnMatchMultiError) AllErrors() []error { return m }

// HeaderMutation_RemoveOnMatchValidationError is the validation error returned
// by HeaderMutation_RemoveOnMatch.Validate if the designated constraints
// aren't met.
type HeaderMutation_RemoveOnMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderMutation_RemoveOnMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderMutation_RemoveOnMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderMutation_RemoveOnMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderMutation_RemoveOnMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderMutation_RemoveOnMatchValidationError) ErrorName() string {
	return "HeaderMutation_RemoveOnMatchValidationError"
}

// Error satisfies the builtin error interface
func (e HeaderMutation_RemoveOnMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMutation_RemoveOnMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderMutation_RemoveOnMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderMutation_RemoveOnMatchValidationError{}
