// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyKeyValueAndUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueAndUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewKeyValueAndUnit()
				CopyKeyValueAndUnit(dest, src)
				assert.Equal(t, src, dest)
				CopyKeyValueAndUnit(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyKeyValueAndUnitSlice(t *testing.T) {
	src := []KeyValueAndUnit{}
	dest := []KeyValueAndUnit{}
	// Test CopyTo empty
	dest = CopyKeyValueAndUnitSlice(dest, src)
	assert.Equal(t, []KeyValueAndUnit{}, dest)

	// Test CopyTo larger slice
	src = GenTestKeyValueAndUnitSlice()
	dest = CopyKeyValueAndUnitSlice(dest, src)
	assert.Equal(t, GenTestKeyValueAndUnitSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyKeyValueAndUnitSlice(dest, src)
	assert.Equal(t, GenTestKeyValueAndUnitSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyKeyValueAndUnitSlice(dest, []KeyValueAndUnit{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyKeyValueAndUnitSlice(dest, src)
	assert.Equal(t, GenTestKeyValueAndUnitSlice(), dest)
}

func TestCopyKeyValueAndUnitPtrSlice(t *testing.T) {
	src := []*KeyValueAndUnit{}
	dest := []*KeyValueAndUnit{}
	// Test CopyTo empty
	dest = CopyKeyValueAndUnitPtrSlice(dest, src)
	assert.Equal(t, []*KeyValueAndUnit{}, dest)

	// Test CopyTo larger slice
	src = GenTestKeyValueAndUnitPtrSlice()
	dest = CopyKeyValueAndUnitPtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValueAndUnitPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyKeyValueAndUnitPtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValueAndUnitPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyKeyValueAndUnitPtrSlice(dest, []*KeyValueAndUnit{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyKeyValueAndUnitPtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValueAndUnitPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONKeyValueAndUnitUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewKeyValueAndUnit()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewKeyValueAndUnit(), dest)
}

func TestMarshalAndUnmarshalJSONKeyValueAndUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueAndUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewKeyValueAndUnit()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteKeyValueAndUnit(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoKeyValueAndUnitFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesKeyValueAndUnit() {
		t.Run(name, func(t *testing.T) {
			dest := NewKeyValueAndUnit()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoKeyValueAndUnitUnknown(t *testing.T) {
	dest := NewKeyValueAndUnit()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewKeyValueAndUnit(), dest)
}

func TestMarshalAndUnmarshalProtoKeyValueAndUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueAndUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewKeyValueAndUnit()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteKeyValueAndUnit(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufKeyValueAndUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueAndUnit() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.KeyValueAndUnit{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewKeyValueAndUnit()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesKeyValueAndUnit() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                {0x02},
		"KeyStrindex/wrong_wire_type":  {0xc},
		"KeyStrindex/missing_value":    {0x8},
		"Value/wrong_wire_type":        {0x14},
		"Value/missing_value":          {0x12},
		"UnitStrindex/wrong_wire_type": {0x1c},
		"UnitStrindex/missing_value":   {0x18},
	}
}

func genTestEncodingValuesKeyValueAndUnit() map[string]*KeyValueAndUnit {
	return map[string]*KeyValueAndUnit{
		"empty":             NewKeyValueAndUnit(),
		"KeyStrindex/test":  {KeyStrindex: int32(13)},
		"Value/test":        {Value: *GenTestAnyValue()},
		"UnitStrindex/test": {UnitStrindex: int32(13)},
	}
}
