// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyRequestContext(t *testing.T) {
	for name, src := range genTestEncodingValuesRequestContext() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewRequestContext()
				CopyRequestContext(dest, src)
				assert.Equal(t, src, dest)
				CopyRequestContext(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyRequestContextSlice(t *testing.T) {
	src := []RequestContext{}
	dest := []RequestContext{}
	// Test CopyTo empty
	dest = CopyRequestContextSlice(dest, src)
	assert.Equal(t, []RequestContext{}, dest)

	// Test CopyTo larger slice
	src = GenTestRequestContextSlice()
	dest = CopyRequestContextSlice(dest, src)
	assert.Equal(t, GenTestRequestContextSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyRequestContextSlice(dest, src)
	assert.Equal(t, GenTestRequestContextSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyRequestContextSlice(dest, []RequestContext{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyRequestContextSlice(dest, src)
	assert.Equal(t, GenTestRequestContextSlice(), dest)
}

func TestCopyRequestContextPtrSlice(t *testing.T) {
	src := []*RequestContext{}
	dest := []*RequestContext{}
	// Test CopyTo empty
	dest = CopyRequestContextPtrSlice(dest, src)
	assert.Equal(t, []*RequestContext{}, dest)

	// Test CopyTo larger slice
	src = GenTestRequestContextPtrSlice()
	dest = CopyRequestContextPtrSlice(dest, src)
	assert.Equal(t, GenTestRequestContextPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyRequestContextPtrSlice(dest, src)
	assert.Equal(t, GenTestRequestContextPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyRequestContextPtrSlice(dest, []*RequestContext{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyRequestContextPtrSlice(dest, src)
	assert.Equal(t, GenTestRequestContextPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONRequestContextUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewRequestContext()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewRequestContext(), dest)
}

func TestMarshalAndUnmarshalJSONRequestContext(t *testing.T) {
	for name, src := range genTestEncodingValuesRequestContext() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewRequestContext()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteRequestContext(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoRequestContextFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesRequestContext() {
		t.Run(name, func(t *testing.T) {
			dest := NewRequestContext()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoRequestContextUnknown(t *testing.T) {
	dest := NewRequestContext()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewRequestContext(), dest)
}

func TestMarshalAndUnmarshalProtoRequestContext(t *testing.T) {
	for name, src := range genTestEncodingValuesRequestContext() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewRequestContext()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteRequestContext(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufRequestContext(t *testing.T) {
	for name, src := range genTestEncodingValuesRequestContext() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewRequestContext()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesRequestContext() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"SpanContext/wrong_wire_type":    {0xc},
		"SpanContext/missing_value":      {0xa},
		"ClientMetadata/wrong_wire_type": {0x14},
		"ClientMetadata/missing_value":   {0x12},

		"IP/wrong_wire_type": {0x1c},
		"IP/missing_value":   {0x1a},

		"TCP/wrong_wire_type": {0x24},
		"TCP/missing_value":   {0x22},

		"UDP/wrong_wire_type": {0x2c},
		"UDP/missing_value":   {0x2a},

		"Unix/wrong_wire_type": {0x34},
		"Unix/missing_value":   {0x32},
	}
}

func genTestEncodingValuesRequestContext() map[string]*RequestContext {
	return map[string]*RequestContext{
		"empty":               NewRequestContext(),
		"SpanContext/test":    {SpanContext: GenTestSpanContext()},
		"ClientMetadata/test": {ClientMetadata: []KeyValue{{}, *GenTestKeyValue()}},
		"IP/default":          {ClientAddress: &RequestContext_IP{IP: &IPAddr{}}},
		"IP/test":             {ClientAddress: &RequestContext_IP{IP: GenTestIPAddr()}},
		"TCP/default":         {ClientAddress: &RequestContext_TCP{TCP: &TCPAddr{}}},
		"TCP/test":            {ClientAddress: &RequestContext_TCP{TCP: GenTestTCPAddr()}},
		"UDP/default":         {ClientAddress: &RequestContext_UDP{UDP: &UDPAddr{}}},
		"UDP/test":            {ClientAddress: &RequestContext_UDP{UDP: GenTestUDPAddr()}},
		"Unix/default":        {ClientAddress: &RequestContext_Unix{Unix: &UnixAddr{}}},
		"Unix/test":           {ClientAddress: &RequestContext_Unix{Unix: GenTestUnixAddr()}},
	}
}
