// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySummary(t *testing.T) {
	for name, src := range genTestEncodingValuesSummary() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSummary()
				CopySummary(dest, src)
				assert.Equal(t, src, dest)
				CopySummary(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySummarySlice(t *testing.T) {
	src := []Summary{}
	dest := []Summary{}
	// Test CopyTo empty
	dest = CopySummarySlice(dest, src)
	assert.Equal(t, []Summary{}, dest)

	// Test CopyTo larger slice
	src = GenTestSummarySlice()
	dest = CopySummarySlice(dest, src)
	assert.Equal(t, GenTestSummarySlice(), dest)

	// Test CopyTo same size slice
	dest = CopySummarySlice(dest, src)
	assert.Equal(t, GenTestSummarySlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySummarySlice(dest, []Summary{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySummarySlice(dest, src)
	assert.Equal(t, GenTestSummarySlice(), dest)
}

func TestCopySummaryPtrSlice(t *testing.T) {
	src := []*Summary{}
	dest := []*Summary{}
	// Test CopyTo empty
	dest = CopySummaryPtrSlice(dest, src)
	assert.Equal(t, []*Summary{}, dest)

	// Test CopyTo larger slice
	src = GenTestSummaryPtrSlice()
	dest = CopySummaryPtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySummaryPtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySummaryPtrSlice(dest, []*Summary{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySummaryPtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSummaryUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSummary()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSummary(), dest)
}

func TestMarshalAndUnmarshalJSONSummary(t *testing.T) {
	for name, src := range genTestEncodingValuesSummary() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSummary()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSummary(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSummaryFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSummary() {
		t.Run(name, func(t *testing.T) {
			dest := NewSummary()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSummaryUnknown(t *testing.T) {
	dest := NewSummary()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSummary(), dest)
}

func TestMarshalAndUnmarshalProtoSummary(t *testing.T) {
	for name, src := range genTestEncodingValuesSummary() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSummary()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSummary(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSummary(t *testing.T) {
	for name, src := range genTestEncodingValuesSummary() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.Summary{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSummary()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSummary() map[string][]byte {
	return map[string][]byte{
		"invalid_field":              {0x02},
		"DataPoints/wrong_wire_type": {0xc},
		"DataPoints/missing_value":   {0xa},
	}
}

func genTestEncodingValuesSummary() map[string]*Summary {
	return map[string]*Summary{
		"empty":           NewSummary(),
		"DataPoints/test": {DataPoints: []*SummaryDataPoint{{}, GenTestSummaryDataPoint()}},
	}
}
