/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.PatternExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class IfPatternMatchProcessor {
    public static boolean matchInstanceof(RootStatement root) {
        boolean res = IfPatternMatchProcessor.matchInstanceofRec(root, root);
        if (res) {
            ValidationHelper.validateStatement(root);
            SequenceHelper.condenseSequences(root);
            if (IfHelper.mergeAllIfs(root)) {
                IfPatternMatchProcessor.improvePatternTypes(root);
            } else {
                SequenceHelper.condenseSequences(root);
            }
        }
        return res;
    }

    private static boolean matchInstanceofRec(Statement statement, RootStatement root) {
        boolean res = false;
        for (Statement stat : statement.getStats()) {
            if (!IfPatternMatchProcessor.matchInstanceofRec(stat, root)) continue;
            res = true;
        }
        if (statement instanceof IfStatement) {
            res |= IfPatternMatchProcessor.handleIf((IfStatement)statement, root);
        }
        return res;
    }

    private static boolean handleIf(IfStatement statement, RootStatement root) {
        Exprent condition = statement.getHeadexprent().getCondition();
        Exprent lastIfTrue = IfPatternMatchProcessor.getLastExprentWhen(condition, true, true);
        Exprent lastIfFalse = IfPatternMatchProcessor.getLastExprentWhen(condition, false, true);
        boolean updated = false;
        if (lastIfTrue != null && IfPatternMatchProcessor.checkBranch(lastIfTrue, statement, statement.getIfEdge().getDestination(), root)) {
            updated = true;
            statement.fixIfInvariantEmptyIfBranch();
        }
        if (!updated && lastIfFalse != null) {
            if (statement.getElseEdge() != null) {
                if (IfPatternMatchProcessor.checkBranch(lastIfFalse, statement, statement.getElseEdge().getDestination(), root)) {
                    updated = true;
                    statement.fixIfInvariantEmptyElseBranch();
                }
            } else {
                List<StatEdge> allSuc = statement.getAllSuccessorEdges();
                if (allSuc.size() == 1 && IfPatternMatchProcessor.checkBranch(lastIfFalse, statement, allSuc.get(0).getDestination(), root)) {
                    updated = true;
                }
            }
        }
        return updated;
    }

    private static boolean checkBranch(Exprent exprent, IfStatement statement, Statement branch, RootStatement root) {
        Exprent exprent2;
        if (!(exprent instanceof FunctionExprent) || branch.getAllPredecessorEdges().size() != 1) {
            return false;
        }
        FunctionExprent iof = (FunctionExprent)exprent;
        if (iof.getFuncType() != FunctionExprent.FunctionType.INSTANCEOF || iof.getLstOperands().size() != 2) {
            return false;
        }
        Exprent source = iof.getLstOperands().get(0);
        if ((source.getExprentUse() & 1) == 0) {
            return false;
        }
        Exprent target = iof.getLstOperands().get(1);
        BasicBlockStatement head = branch.getBasichead();
        if (head.getExprents() == null || head.getExprents().isEmpty()) {
            return false;
        }
        Exprent first = head.getExprents().get(0);
        if (!(first instanceof AssignmentExprent)) {
            return false;
        }
        Exprent left = first.getAllExprents().get(0);
        Exprent right = first.getAllExprents().get(1);
        boolean result = IfPatternMatchProcessor.findPatternMatchingInstanceof(left, right, source, target, branch, iof, head);
        if (head.getExprents() != null && !head.getExprents().isEmpty() && (exprent2 = head.getExprents().get(0)) instanceof AssignmentExprent) {
            AssignmentExprent assignment = (AssignmentExprent)exprent2;
            left = assignment.getAllExprents().get(0);
            right = assignment.getAllExprents().get(1);
            if (!(right instanceof FunctionExprent)) {
                result |= IfPatternMatchProcessor.identifyIfRecordPatternMatch(statement, branch, iof, assignment);
            }
        }
        if (result) {
            Exprent last;
            statement.setPatternMatched(true);
            BasicBlockStatement before = statement.getBasichead();
            if (before.getExprents() != null && before.getExprents().size() > 0 && (last = before.getExprents().get(before.getExprents().size() - 1)) instanceof AssignmentExprent) {
                AssignmentExprent assign = (AssignmentExprent)last;
                if (source instanceof VarExprent) {
                    VarExprent checked = (VarExprent)source;
                    Exprent stored = assign.getLeft();
                    Exprent method = assign.getRight();
                    if (!(method instanceof FunctionExprent && ((FunctionExprent)method).getFuncType() == FunctionExprent.FunctionType.CAST || !checked.equals(stored) || checked.isVarReferenced(root, (VarExprent)stored))) {
                        iof.getLstOperands().set(0, assign.getRight());
                        before.getExprents().remove(before.getExprents().size() - 1);
                    }
                }
            }
        }
        return result;
    }

    private static boolean findPatternMatchingInstanceof(Exprent left, Exprent right, Exprent source, Exprent target, Statement branch, FunctionExprent iof, Statement head) {
        FunctionExprent function;
        if (!(right instanceof FunctionExprent) || (function = (FunctionExprent)right).getFuncType() != FunctionExprent.FunctionType.CAST) {
            return false;
        }
        Exprent casted = right.getAllExprents().get(0);
        if (!source.equals(casted)) {
            return false;
        }
        if (!(left instanceof VarExprent) || !target.getExprType().equals(left.getExprType())) {
            return false;
        }
        ArrayList<VarVersionPair> vvs = new ArrayList<VarVersionPair>();
        IfPatternMatchProcessor.findVarsInPredecessors(vvs, branch);
        VarVersionPair var = ((VarExprent)left).getVarVersionPair();
        for (VarVersionPair vv : vvs) {
            if (var.var != vv.var) continue;
            return false;
        }
        VarType storeType = left.getInferredExprType(null);
        iof.getLstOperands().add(2, left);
        head.getExprents().remove(0);
        if (storeType.isGeneric()) {
            iof.getLstOperands().set(1, new ConstExprent(storeType, null, iof.getLstOperands().get((int)1).bytecode));
        }
        return true;
    }

    private static void findVarsInPredecessors(List<VarVersionPair> vvs, Statement root) {
        ArrayDeque<Statement> stack = new ArrayDeque<Statement>();
        HashSet<Statement> seen = new HashSet<Statement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement st = (Statement)stack.pop();
            if (!seen.add(st)) continue;
            if (st.getParent() instanceof IfStatement || st instanceof IfStatement) {
                stack.add(st.getParent());
            }
            for (StatEdge pred : st.getAllPredecessorEdges()) {
                Statement stat = pred.getSource();
                stack.add(stat);
                if (root.containsStatement(stat) || stat.getExprents() == null) continue;
                for (Exprent exprent : stat.getExprents()) {
                    AssignmentExprent assignment;
                    if (!(exprent instanceof AssignmentExprent) || !((assignment = (AssignmentExprent)exprent).getLeft() instanceof VarExprent)) continue;
                    vvs.add(((VarExprent)assignment.getLeft()).getVarVersionPair());
                }
            }
        }
    }

    private static boolean identifyIfRecordPatternMatch(IfStatement stat, Statement branch, FunctionExprent instOf, AssignmentExprent head) {
        if (!stat.getTopParent().mt.getBytecodeVersion().hasRecordPatternMatching()) {
            return false;
        }
        Exprent headRight = head.getRight();
        if (!(instOf.getLstOperands().size() > 2 ? instOf.getLstOperands().get(2) : instOf.getLstOperands().get(0)).equals(headRight)) {
            return false;
        }
        VarType type = instOf.getLstOperands().get(1).getExprType();
        PatternExprent exprent = IfPatternMatchProcessor.identifyRecordPatternMatch(stat, branch, headRight, type, false);
        if (exprent == null) {
            return false;
        }
        if (instOf.getLstOperands().size() > 2) {
            instOf.getLstOperands().set(2, exprent);
        } else {
            instOf.getLstOperands().add(2, exprent);
        }
        stat.setPatternMatched(true);
        return true;
    }

    public static PatternExprent identifyRecordPatternMatch(Statement parent, Statement branch, Exprent storeVariable, VarType type, boolean simulate) {
        Statement original = branch;
        StructClass cl = DecompilerContext.getStructContext().getClass(type.value);
        if (cl == null || cl.getRecordComponents() == null || cl.getRecordComponents().isEmpty()) {
            return null;
        }
        ArrayList<Statement> toDestroy = new ArrayList<Statement>();
        HashMap<BasicBlockStatement, Exprent> remove = new HashMap<BasicBlockStatement, Exprent>();
        PatternData pattern = IfPatternMatchProcessor.getChildPattern(cl, storeVariable, type, branch, 1, toDestroy, remove);
        if (pattern == null) {
            return null;
        }
        branch = pattern.stat;
        if (simulate) {
            return pattern.exp;
        }
        if (original != branch) {
            parent.replaceStatement(original, branch);
        }
        for (Statement statement : toDestroy) {
            statement.replaceWithEmpty();
        }
        for (Map.Entry entry : remove.entrySet()) {
            ((BasicBlockStatement)entry.getKey()).getExprents().remove(entry.getValue());
        }
        return pattern.exp;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static PatternData getChildPattern(StructClass cl, Exprent storeVariable, VarType type, Statement branch, int stIdx, List<Statement> toDestroy, Map<BasicBlockStatement, Exprent> remove) {
        if (cl == null || cl.getRecordComponents() == null) {
            return null;
        }
        record PatternStore(StructRecordComponent component, StructClass cl, VarType type, VarExprent store) {
        }
        ArrayList<PatternStore> patternStores = new ArrayList<PatternStore>();
        List<StructRecordComponent> comp = cl.getRecordComponents();
        LinkedHashMap<StructRecordComponent, Exprent> vars = new LinkedHashMap<StructRecordComponent, Exprent>();
        for (StructRecordComponent c : comp) {
            block22: {
                boolean ok;
                VarExprent foundVar;
                block24: {
                    Exprent exprent;
                    Exprent assign;
                    Statement next;
                    block23: {
                        AssignmentExprent assign2;
                        Exprent exprent2;
                        Exprent exprent3;
                        Statement inner;
                        CatchStatement catchSt;
                        if (branch.getStats().size() <= stIdx) {
                            return null;
                        }
                        next = (Statement)branch.getStats().get(stIdx);
                        if (!(next instanceof CatchStatement) || (catchSt = (CatchStatement)next).getVars().size() != 1 || !catchSt.getVars().get((int)0).getVarType().value.equals("java/lang/Throwable")) break block22;
                        foundVar = null;
                        if (catchSt.getStats().size() == 2 && IfPatternMatchProcessor.isStatementMatchThrow((Statement)catchSt.getStats().get(1)) && (inner = (Statement)catchSt.getStats().get(0)) instanceof BasicBlockStatement && inner.getExprents().size() == 1 && (exprent3 = inner.getExprents().get(0)) instanceof AssignmentExprent && (exprent2 = (assign2 = (AssignmentExprent)exprent3).getLeft()) instanceof VarExprent) {
                            InvocationExprent invok;
                            VarExprent var = (VarExprent)exprent2;
                            exprent2 = assign2.getRight();
                            if (exprent2 instanceof InvocationExprent && (invok = (InvocationExprent)exprent2).getClassname().equals(type.value) && invok.getName().equals(c.getName())) {
                                foundVar = var;
                            }
                        }
                        if (foundVar == null) {
                            return null;
                        }
                        toDestroy.add(next);
                        if (branch.getStats().size() <= ++stIdx) continue;
                        next = (Statement)branch.getStats().get(stIdx);
                        ok = false;
                        if (!(next instanceof BasicBlockStatement)) break block23;
                        BasicBlockStatement bb = (BasicBlockStatement)next;
                        if (next.getExprents().size() <= 0) break block23;
                        Exprent exprent4 = next.getExprents().get(0);
                        if (!(exprent4 instanceof AssignmentExprent) || !((exprent4 = ((AssignmentExprent)(assign = (AssignmentExprent)exprent4)).getLeft()) instanceof VarExprent)) break block24;
                        VarExprent var = (VarExprent)exprent4;
                        if (((AssignmentExprent)assign).getRight().equals(foundVar)) {
                            AssignmentExprent nAssign;
                            vars.put(c, var);
                            ok = true;
                            boolean destroyed = false;
                            if (next.getExprents().size() == 2 && (exprent = next.getExprents().get(1)) instanceof AssignmentExprent && (nAssign = (AssignmentExprent)exprent).getRight().equals(storeVariable)) {
                                toDestroy.add(next);
                                destroyed = true;
                            }
                            if (!destroyed) {
                                remove.put(bb, assign);
                            }
                        }
                        break block24;
                    }
                    if (next instanceof IfStatement) {
                        IfStatement ifSt = (IfStatement)next;
                        if (ifSt.iftype == 0 && (assign = ifSt.getHeadexprent().getCondition()) instanceof FunctionExprent) {
                            FunctionExprent inner;
                            FunctionExprent func = (FunctionExprent)assign;
                            FunctionExprent function = null;
                            boolean found = false;
                            boolean inverted = false;
                            if (func.getFuncType() == FunctionExprent.FunctionType.INSTANCEOF) {
                                found = true;
                                function = func;
                            } else if (func.getFuncType() == FunctionExprent.FunctionType.BOOL_NOT && (exprent = func.getLstOperands().get(0)) instanceof FunctionExprent && (inner = (FunctionExprent)exprent).getFuncType() == FunctionExprent.FunctionType.INSTANCEOF) {
                                found = true;
                                inverted = true;
                                function = inner;
                            }
                            if (found) {
                                Exprent store;
                                AssignmentExprent assign3;
                                if (branch.getBasichead().getExprents().size() == 1 && (exprent = branch.getBasichead().getExprents().get(0)) instanceof AssignmentExprent && (assign3 = (AssignmentExprent)exprent).getLeft() instanceof VarExprent && assign3.getRight() instanceof VarExprent) {
                                    toDestroy.add(branch.getBasichead());
                                }
                                Exprent exprent5 = store = function.getLstOperands().size() > 2 ? function.getLstOperands().get(2) : function.getLstOperands().get(0);
                                if (store instanceof VarExprent) {
                                    VarExprent variable = (VarExprent)store;
                                    patternStores.add(new PatternStore(c, DecompilerContext.getStructContext().getClass(variable.getExprType().value), variable.getExprType(), variable));
                                    vars.put(c, variable);
                                    ok = true;
                                }
                                if (inverted) {
                                    ++stIdx;
                                    toDestroy.add(ifSt);
                                } else {
                                    branch = ifSt.getIfstat();
                                    stIdx = 0;
                                }
                            }
                        }
                    }
                }
                if (!ok) {
                    vars.put(c, foundVar);
                }
                ++stIdx;
                continue;
            }
            return null;
        }
        Iterator<StructRecordComponent> iterator = patternStores.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                PatternExprent pattern = new PatternExprent(PatternExprent.recordData(cl), type, new ArrayList<Exprent>(vars.values()));
                return new PatternData(pattern, branch, stIdx);
            }
            PatternStore patternStore = (PatternStore)((Object)iterator.next());
            ArrayList<Statement> tmpToDestroy = new ArrayList<Statement>();
            HashMap<BasicBlockStatement, Exprent> tmpRemove = new HashMap<BasicBlockStatement, Exprent>();
            PatternData patternData = IfPatternMatchProcessor.getChildPattern(patternStore.cl, patternStore.store, patternStore.type, branch, stIdx, tmpToDestroy, tmpRemove);
            if (patternData == null) continue;
            vars.put(patternStore.component, patternData.exp);
            branch = patternData.stat;
            stIdx = patternData.index;
            toDestroy.addAll(tmpToDestroy);
            remove.putAll(tmpRemove);
        }
    }

    public static boolean isStatementMatchThrow(Statement st) {
        Exprent exprent;
        ExitExprent exit;
        Exprent exprent2;
        if (st instanceof BasicBlockStatement && st.getExprents().size() == 1 && (exprent2 = st.getExprents().get(0)) instanceof ExitExprent && (exit = (ExitExprent)exprent2).getExitType() == ExitExprent.Type.THROW && (exprent = exit.getValue()) instanceof NewExprent) {
            NewExprent newEx = (NewExprent)exprent;
            return newEx.getNewType().value.equals("java/lang/MatchException");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Exprent getLastExprentWhen(Exprent base, boolean ifTrue, boolean onlyIfTrue) {
        switch (base.type) {
            case FUNCTION: {
                FunctionExprent func = (FunctionExprent)base;
                switch (func.getFuncType()) {
                    case BOOLEAN_AND: {
                        if (!ifTrue) break;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(1), true, onlyIfTrue);
                    }
                    case BOOLEAN_OR: {
                        if (ifTrue) break;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(1), false, onlyIfTrue);
                    }
                    case BOOL_NOT: {
                        boolean bl;
                        if (!ifTrue) {
                            bl = true;
                            return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                        }
                        bl = false;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                    }
                    case EQ: {
                        boolean bl;
                        ConstExprent constExprent;
                        Exprent rhs = func.getLstOperands().get(1);
                        if (rhs.type != Exprent.Type.CONST || (constExprent = (ConstExprent)rhs).getConstType() != VarType.VARTYPE_BOOLEAN) break;
                        if (constExprent.getIntValue() != 0) return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), ifTrue, onlyIfTrue);
                        if (!ifTrue) {
                            bl = true;
                            return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                        }
                        bl = false;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                    }
                    case NE: {
                        boolean bl;
                        ConstExprent constExprent;
                        Exprent rhs = func.getLstOperands().get(1);
                        if (rhs.type != Exprent.Type.CONST || (constExprent = (ConstExprent)rhs).getConstType() != VarType.VARTYPE_BOOLEAN) break;
                        if (constExprent.getIntValue() == 0) {
                            return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), ifTrue, onlyIfTrue);
                        }
                        if (!ifTrue) {
                            bl = true;
                            return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                        }
                        bl = false;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                    }
                }
                break;
            }
        }
        if (!onlyIfTrue) return base;
        if (ifTrue) return base;
        return null;
    }

    private static boolean improvePatternTypes(Statement stat) {
        boolean res = false;
        for (Statement st : stat.getStats()) {
            res |= IfPatternMatchProcessor.improvePatternTypes(st);
        }
        if (stat instanceof IfStatement) {
            IfStatement ifSt = (IfStatement)stat;
            Exprent cond = ifSt.getHeadexprent().getCondition();
            if (IfPatternMatchProcessor.improvePatternType(ifSt.getHeadexprent(), cond, ifSt.getIfstat())) {
                res = true;
            }
        }
        return res;
    }

    private static boolean improvePatternType(Exprent parent, Exprent ex, Statement st) {
        boolean res = false;
        for (Exprent e : ex.getAllExprents(false, true)) {
            PatternExprent pattern;
            Exprent exprent;
            FunctionExprent baseFn;
            Exprent base;
            FunctionExprent fn;
            if (e != ex) {
                res |= IfPatternMatchProcessor.improvePatternType(ex, e, st);
            }
            if (!(e instanceof FunctionExprent) || (fn = (FunctionExprent)e).getFuncType() != FunctionExprent.FunctionType.BOOLEAN_AND || !((base = fn.getLstOperands().get(0)) instanceof FunctionExprent) || (baseFn = (FunctionExprent)base).getFuncType() != FunctionExprent.FunctionType.INSTANCEOF || baseFn.getLstOperands().size() <= 2 || !((exprent = baseFn.getLstOperands().get(2)) instanceof PatternExprent) || !((pattern = (PatternExprent)exprent).getData() instanceof PatternExprent.PatternData.RecordPatternData)) continue;
            ArrayList<VarExprent> vars = new ArrayList<VarExprent>();
            for (Exprent patternEx : pattern.getExprents()) {
                if (patternEx instanceof VarExprent) {
                    VarExprent var = (VarExprent)patternEx;
                    vars.add(var);
                    continue;
                }
                vars.add(null);
            }
            block2: for (int j = 0; j < vars.size(); ++j) {
                VarExprent var = (VarExprent)vars.get(j);
                if (var == null || var.isVarReferenced(st, new VarExprent[0])) continue;
                for (Exprent exp : parent.getAllExprents(true, true)) {
                    for (Exprent inst : exp.getAllExprents()) {
                        FunctionExprent instFun;
                        if (!(inst instanceof FunctionExprent) || (instFun = (FunctionExprent)inst).getFuncType() != FunctionExprent.FunctionType.BOOLEAN_AND) continue;
                        for (int i = 0; i < 2; ++i) {
                            FunctionExprent innerFun;
                            Exprent inner = instFun.getLstOperands().get(i);
                            if (!(inner instanceof FunctionExprent) || (innerFun = (FunctionExprent)inner).getFuncType() != FunctionExprent.FunctionType.INSTANCEOF || innerFun.getLstOperands().size() <= 2 || !innerFun.getLstOperands().get(0).equals(var)) continue;
                            pattern.getExprents().set(j, innerFun.getLstOperands().get(2));
                            pattern.getBoundTypes().set(j, innerFun.getLstOperands().get(1).getExprType());
                            exp.replaceExprent(inst, instFun.getLstOperands().get(i ^ 1));
                            continue block2;
                        }
                    }
                }
            }
        }
        return res;
    }

    private record PatternData(PatternExprent exp, Statement stat, int index) {
    }
}

