/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.IfPatternMatchProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchHeadExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.TypeFamily;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.Pair;

public final class SwitchHelper {
    public static final int STATIC_FINAL_SYNTHETIC = 4120;

    public static boolean simplifySwitches(Statement stat, StructMethod mt, RootStatement root) {
        boolean ret = false;
        if (stat instanceof SwitchStatement) {
            ret = SwitchHelper.simplify((SwitchStatement)stat, mt, root);
        }
        for (int i = 0; i < stat.getStats().size(); ++i) {
            ret |= SwitchHelper.simplifySwitches((Statement)stat.getStats().get(i), mt, root);
        }
        return ret;
    }

    private static boolean simplify(SwitchStatement switchStatement, StructMethod mt, RootStatement root) {
        if (SwitchHelper.simplifySwitchOnEnumJ21(switchStatement, root)) {
            return true;
        }
        SwitchHeadExprent switchHeadExprent = (SwitchHeadExprent)switchStatement.getHeadexprent();
        Exprent value = switchHeadExprent.getValue();
        ArrayExprent array = SwitchHelper.getEnumArrayExprent(value, root);
        if (array != null) {
            List<List<Exprent>> caseValues = switchStatement.getCaseValues();
            HashMap mapping = new HashMap(caseValues.size());
            if (array.getArray() instanceof FieldExprent) {
                ClassWrapper classWrapper;
                FieldExprent arrayField = (FieldExprent)array.getArray();
                classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(arrayField.getClassname());
                if (classNode != null && (classWrapper = ((ClassesProcessor.ClassNode)classNode).getWrapper()) != null && (wrapper = classWrapper.getMethodWrapper("<clinit>", "()V")) != null && wrapper.root != null) {
                    List<AssignmentExprent> fieldAssignments = SwitchHelper.getAssignmentsOfWithinOneStatement(wrapper.root, arrayField);
                    if (fieldAssignments.size() > 1) {
                        fieldAssignments.clear();
                    }
                    boolean[] fieldAssignmentEncountered = new boolean[]{false};
                    wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                        if (exprent instanceof AssignmentExprent) {
                            AssignmentExprent assignment = (AssignmentExprent)exprent;
                            Exprent left = assignment.getLeft();
                            if (left instanceof ArrayExprent) {
                                Exprent assignmentArray = ((ArrayExprent)left).getArray();
                                boolean targetsField = assignmentArray.equals(arrayField);
                                if (!targetsField && assignmentArray instanceof VarExprent && !fieldAssignmentEncountered[0]) {
                                    for (AssignmentExprent fieldAssignment : fieldAssignments) {
                                        if (!fieldAssignment.getRight().equals(assignmentArray)) continue;
                                        targetsField = true;
                                        break;
                                    }
                                }
                                if (targetsField && ((ArrayExprent)left).getIndex() instanceof InvocationExprent) {
                                    mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                                }
                            } else if (fieldAssignments.contains(exprent)) {
                                fieldAssignmentEncountered[0] = true;
                            }
                        }
                        return 0;
                    });
                }
            } else {
                InvocationExprent invocation = (InvocationExprent)array.getArray();
                classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(invocation.getClassname());
                if (classNode != null) {
                    ClassWrapper classWrapper = ((ClassesProcessor.ClassNode)classNode).getWrapper();
                    if (classWrapper != null) {
                        wrapper = classWrapper.getMethodWrapper(invocation.getName(), "()[I");
                        if (wrapper != null && wrapper.root != null) {
                            wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                                AssignmentExprent assignment;
                                Exprent left;
                                if (exprent instanceof AssignmentExprent && (left = (assignment = (AssignmentExprent)exprent).getLeft()) instanceof ArrayExprent) {
                                    mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                                }
                                return 0;
                            });
                        }
                    } else {
                        return false;
                    }
                }
            }
            ArrayList realCaseValues = new ArrayList(caseValues.size());
            for (List list : caseValues) {
                ArrayList<Exprent> values = new ArrayList<Exprent>(list.size());
                realCaseValues.add(values);
                block1: for (Exprent exprent2 : list) {
                    if (exprent2 == null) {
                        values.add(null);
                        continue;
                    }
                    Exprent realConst = (Exprent)mapping.get(exprent2);
                    if (realConst == null) {
                        if (exprent2 instanceof ConstExprent) {
                            ConstExprent constLabel = (ConstExprent)exprent2;
                            if (constLabel.getConstType().typeFamily == TypeFamily.INTEGER) {
                                int intLabel = constLabel.getIntValue();
                                if (intLabel == -1) {
                                    values.add(new ConstExprent(VarType.VARTYPE_NULL, null, null));
                                    continue;
                                }
                                for (Exprent key : mapping.keySet()) {
                                    if (!(key instanceof ConstExprent) || ((ConstExprent)key).getConstType().typeFamily != TypeFamily.INTEGER || ((ConstExprent)key).getIntValue() <= intLabel) continue;
                                    values.add(key.copy());
                                    continue block1;
                                }
                            }
                        }
                        root.addComment("$VF: Unable to simplify switch on enum", true);
                        DecompilerContext.getLogger().writeMessage("Unable to simplify switch on enum: " + String.valueOf(exprent2) + " not found, available: " + String.valueOf(mapping) + " in method " + mt.getClassQualifiedName() + " " + mt.getName(), IFernflowerLogger.Severity.ERROR);
                        return false;
                    }
                    values.add(realConst.copy());
                }
            }
            caseValues.clear();
            caseValues.addAll(realCaseValues);
            Exprent newExpr = ((InvocationExprent)array.getIndex()).getInstance().copy();
            switchHeadExprent.replaceExprent(value, newExpr);
            newExpr.addBytecodeOffsets(value.bytecode);
            if (value instanceof VarExprent) {
                VarExprent varExprent = (VarExprent)value;
                ArrayList references = new ArrayList();
                SwitchHelper.findExprents(root, Exprent.class, x$0 -> var.isVarReferenced((Exprent)x$0, new VarExprent[0]), false, (stat, expr) -> references.add(Pair.of(stat, expr)));
                if (references.size() == 1) {
                    Pair ref = (Pair)references.get(0);
                    if (ref.b instanceof AssignmentExprent && ((AssignmentExprent)ref.b).getLeft().equals(value)) {
                        ((Statement)ref.a).getExprents().remove(ref.b);
                    }
                }
            }
            return true;
        }
        if (SwitchHelper.isSwitchOnString(switchStatement)) {
            SwitchStatement following;
            HashMap<Integer, Exprent> caseMap = new HashMap<Integer, Exprent>();
            boolean nullable = false;
            IfStatement containingNullCheck = null;
            List<StatEdge> list = switchStatement.getSuccessorEdges(1);
            if (list.size() == 1 && list.get(0).getDestination() instanceof SwitchStatement) {
                following = (SwitchStatement)list.get(0).getDestination();
            } else {
                nullable = true;
                containingNullCheck = (IfStatement)switchStatement.getParent();
                following = (SwitchStatement)containingNullCheck.getSuccessorEdges(1).get(0).getDestination();
            }
            for (int i = 0; i < switchStatement.getCaseStatements().size(); ++i) {
                Statement curr = switchStatement.getCaseStatements().get(i);
                while (curr instanceof IfStatement) {
                    IfStatement ifStat = (IfStatement)curr;
                    Exprent condition = ifStat.getHeadexprent().getCondition();
                    if (condition instanceof FunctionExprent && ((FunctionExprent)condition).getFuncType() == FunctionExprent.FunctionType.NE) {
                        condition = ((FunctionExprent)condition).getLstOperands().get(0);
                    }
                    if (condition instanceof InvocationExprent && ((InvocationExprent)condition).getLstParameters().size() == 1) {
                        Exprent assign = ifStat.getIfstat().getExprents().get(0);
                        int caseVal = ((ConstExprent)((AssignmentExprent)assign).getRight()).getIntValue();
                        caseMap.put(caseVal, ((InvocationExprent)condition).getLstParameters().get(0));
                    }
                    curr = ifStat.getElsestat();
                }
            }
            if (nullable) {
                Statement elseBranch = containingNullCheck.getElsestat();
                AssignmentExprent assign = (AssignmentExprent)elseBranch.getExprents().get(0);
                caseMap.put(((ConstExprent)assign.getRight()).getIntValue(), new ConstExprent(VarType.VARTYPE_NULL, null, null));
            }
            List realCaseValues = following.getCaseValues().stream().map(l -> l.stream().map(e -> e instanceof ConstExprent ? Integer.valueOf(((ConstExprent)e).getIntValue()) : null).map(caseMap::get).collect(Collectors.toList())).collect(Collectors.toList());
            following.getCaseValues().clear();
            following.getCaseValues().addAll(realCaseValues);
            Exprent followingVal = ((SwitchHeadExprent)following.getHeadexprent()).getValue();
            following.getHeadexprent().replaceExprent(followingVal, ((InvocationExprent)value).getInstance());
            List<Exprent> firsts = switchStatement.getFirst().getExprents();
            if (firsts.size() > 0) {
                firsts.remove(firsts.size() - 1);
            }
            switchStatement.getFirst().getAllPredecessorEdges().forEach(switchStatement.getFirst()::removePredecessor);
            switchStatement.getFirst().getAllSuccessorEdges().forEach(switchStatement.getFirst()::removeSuccessor);
            switchStatement.getParent().replaceStatement(switchStatement, switchStatement.getFirst());
            if (nullable) {
                BasicBlockStatement replaced = containingNullCheck.replaceWithEmpty();
                new HashSet<StatEdge>(replaced.getLabelEdges()).forEach(e -> {
                    following.removePredecessor((StatEdge)e);
                    e.removeClosure();
                });
            }
            following.getAllPredecessorEdges().stream().filter(e -> switchStatement.containsStatement(e.getSource()) && e.getSource() != switchStatement.getFirst()).forEach(e -> e.getSource().removeSuccessor((StatEdge)e));
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean simplifySwitchOnEnumJ21(SwitchStatement switchSt, RootStatement root) {
        SwitchHeadExprent head = (SwitchHeadExprent)switchSt.getHeadexprent();
        Exprent inner = head.getValue();
        HashMap mapping = new HashMap();
        List<List<Exprent>> values = switchSt.getCaseValues();
        for (List<Exprent> list : values) {
            for (Exprent exprent : list) {
                if (exprent == null) continue;
                if (!(exprent instanceof ConstExprent)) {
                    return false;
                }
                if (exprent.getExprType().typeFamily != TypeFamily.INTEGER) {
                    return false;
                }
                mapping.put((ConstExprent)exprent, null);
            }
        }
        if (inner instanceof InvocationExprent && ((InvocationExprent)inner).getName().equals("ordinal")) {
            InvocationExprent invInner = (InvocationExprent)inner;
            StructClass classStruct = DecompilerContext.getStructContext().getClass(invInner.getClassname());
            if (classStruct == null) {
                root.addComment("$VF: Unable to simplify switch-on-enum, as the enum class was not able to be found.", true);
                return false;
            }
            if ((classStruct.getAccessFlags() & 0x4000) == 16384) {
                ArrayList<String> enumNames = new ArrayList<String>();
                for (StructField fd : classStruct.getFields()) {
                    if ((fd.getAccessFlags() & 0x4000) != 16384) continue;
                    enumNames.add(fd.getName());
                }
                for (ConstExprent e : new HashSet(mapping.keySet())) {
                    for (List<Exprent> lst : values) {
                        for (int i = 0; i < lst.size(); ++i) {
                            Exprent ex = lst.get(i);
                            if (e != ex) continue;
                            int idx = e.getIntValue();
                            String name = (String)enumNames.get(idx);
                            lst.set(i, new FieldExprent(name, invInner.getClassname(), true, null, FieldDescriptor.parseDescriptor("L" + invInner.getClassname() + ";"), null));
                        }
                    }
                }
                if (switchSt.isPhantom()) {
                    void var9_13;
                    boolean bl = false;
                    while (var9_13 < values.size()) {
                        Statement st;
                        List<Exprent> list = values.get((int)var9_13);
                        if (list.size() == 1 && list.get(0) == null && IfPatternMatchProcessor.isStatementMatchThrow(st = switchSt.getCaseStatements().get((int)var9_13))) {
                            st.replaceWithEmpty();
                        }
                        ++var9_13;
                    }
                }
                head.replaceExprent(inner, ((InvocationExprent)inner).getInstance());
                return true;
            }
        }
        return false;
    }

    private static boolean isEnumArray(Exprent exprent) {
        if (exprent instanceof ArrayExprent) {
            InvocationExprent inv;
            ArrayExprent arr = (ArrayExprent)exprent;
            Exprent tmp = arr.getArray();
            if (tmp instanceof FieldExprent) {
                boolean isSyntheticClass;
                FieldExprent field = (FieldExprent)tmp;
                Exprent index = arr.getIndex();
                ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(field.getClassname());
                if (classNode == null || !"[I".equals(field.getDescriptor().descriptorString)) {
                    return field.getName().startsWith("$SwitchMap") || index instanceof InvocationExprent && ((InvocationExprent)index).getName().equals("ordinal") && field.isStatic();
                }
                StructField stField = classNode.getWrapper() == null ? classNode.classStruct.getField(field.getName(), field.getDescriptor().descriptorString) : classNode.getWrapper().getClassStruct().getField(field.getName(), field.getDescriptor().descriptorString);
                if ((stField.getAccessFlags() & 0x1018) != 4120) {
                    return false;
                }
                if (classNode.getWrapper() == null) {
                    isSyntheticClass = (classNode.classStruct.getAccessFlags() & 0x1000) == 4096;
                } else {
                    boolean bl = isSyntheticClass = (classNode.getWrapper().getClassStruct().getAccessFlags() & 0x1000) == 4096;
                }
                if (isSyntheticClass) {
                    return true;
                }
            } else if (tmp instanceof InvocationExprent && (inv = (InvocationExprent)tmp).getName().startsWith("$SWITCH_TABLE$")) {
                return true;
            }
        }
        return false;
    }

    private static ArrayExprent getEnumArrayExprent(Exprent switchHead, RootStatement root) {
        ConstExprent minusOne;
        FunctionExprent nn;
        List<Exprent> ops;
        FunctionExprent func;
        Exprent candidate = switchHead;
        if (switchHead instanceof FunctionExprent && (func = (FunctionExprent)switchHead).getFuncType() == FunctionExprent.FunctionType.TERNARY && func.getLstOperands().size() == 3 && (ops = func.getLstOperands()).get(0) instanceof FunctionExprent && (nn = (FunctionExprent)ops.get(0)).getFuncType() == FunctionExprent.FunctionType.NE && nn.getLstOperands().get(0) instanceof VarExprent && nn.getLstOperands().get(1).getExprType().equals(VarType.VARTYPE_NULL) && ops.get(2) instanceof ConstExprent && (minusOne = (ConstExprent)ops.get(2)).getConstType().equals(VarType.VARTYPE_INT) && minusOne.getIntValue() == -1) {
            candidate = ops.get(1);
        }
        if (switchHead instanceof VarExprent) {
            VarExprent var = (VarExprent)switchHead;
            if (!"I".equals(var.getVarType().toString())) {
                return null;
            }
            List<AssignmentExprent> assignments = SwitchHelper.getAssignmentsOfWithinOneStatement(root, var);
            if (!assignments.isEmpty()) {
                if (assignments.size() == 1) {
                    AssignmentExprent assignment = assignments.get(0);
                    candidate = assignment.getRight();
                } else {
                    return null;
                }
            }
        }
        return SwitchHelper.isEnumArray(candidate) ? (ArrayExprent)candidate : null;
    }

    private static List<AssignmentExprent> getAssignmentsOfWithinOneStatement(Statement start, Exprent target) {
        ArrayList<AssignmentExprent> exprents = new ArrayList<AssignmentExprent>();
        SwitchHelper.findExprents(start, AssignmentExprent.class, assignment -> assignment.getLeft().equals(target), true, (stat, expr) -> exprents.add((AssignmentExprent)expr));
        return exprents;
    }

    public static <T extends Exprent> void findExprents(Statement start, Class<? extends T> exprClass, Predicate<T> predicate, boolean onlyOneStat, BiConsumer<Statement, T> consumer) {
        ArrayDeque<Statement> statQueue = new ArrayDeque<Statement>();
        statQueue.offer(start);
        while (!statQueue.isEmpty()) {
            Statement stat = (Statement)statQueue.remove();
            statQueue.addAll(stat.getStats());
            if (stat.getExprents() == null) continue;
            boolean foundAny = false;
            for (Exprent expr : stat.getExprents()) {
                if (!exprClass.isInstance(expr) || !predicate.test(expr)) continue;
                consumer.accept(stat, (Statement)((Object)expr));
                foundAny = true;
            }
            if (!onlyOneStat || !foundAny) continue;
            break;
        }
    }

    private static boolean isSwitchOnString(SwitchStatement first) {
        SwitchStatement second = null;
        List<StatEdge> edges = first.getSuccessorEdges(1);
        if (edges.size() == 1 && edges.get(0).getDestination() instanceof SwitchStatement) {
            second = (SwitchStatement)edges.get(0).getDestination();
        }
        AssignmentExprent nullAssign = null;
        if (first.getParent() instanceof IfStatement && !first.hasSuccessor(1)) {
            Exprent assign;
            Statement elseStat;
            Exprent right;
            FunctionExprent func;
            IfStatement parent = (IfStatement)first.getParent();
            Exprent ifCond = parent.getHeadexprent().getCondition();
            if (parent.iftype == 1 && ifCond instanceof FunctionExprent && (func = (FunctionExprent)ifCond).getFuncType() == FunctionExprent.FunctionType.NE && func.getLstOperands().size() == 2 && (right = func.getLstOperands().get(1)) instanceof ConstExprent && right.getExprType() == VarType.VARTYPE_NULL && (elseStat = parent.getElsestat()) instanceof BasicBlockStatement && elseStat.getExprents().size() == 1 && (assign = elseStat.getExprents().get(0)) instanceof AssignmentExprent) {
                nullAssign = (AssignmentExprent)assign;
                edges = parent.getSuccessorEdges(1);
                if (edges.size() == 1 && edges.get(0).getDestination() instanceof SwitchStatement) {
                    second = (SwitchStatement)edges.get(0).getDestination();
                }
            }
        }
        if (second != null) {
            Exprent firstValue = ((SwitchHeadExprent)first.getHeadexprent()).getValue();
            Exprent secondValue = ((SwitchHeadExprent)second.getHeadexprent()).getValue();
            if (firstValue instanceof InvocationExprent && secondValue instanceof VarExprent && first.getCaseStatements().get(0) instanceof IfStatement) {
                InvocationExprent invExpr = (InvocationExprent)firstValue;
                VarExprent varExpr = (VarExprent)secondValue;
                if (nullAssign != null && !nullAssign.getLeft().equals(varExpr)) {
                    return false;
                }
                if (invExpr.getName().equals("hashCode") && invExpr.getClassname().equals("java/lang/String")) {
                    boolean matches = true;
                    for (int i = 0; matches && i < first.getCaseStatements().size(); ++i) {
                        if (first.getCaseEdges().get(i).contains(first.getDefaultEdge())) continue;
                        Statement curr = first.getCaseStatements().get(i);
                        while (matches && curr != null) {
                            if (curr instanceof IfStatement) {
                                AssignmentExprent assign;
                                List<Exprent> block;
                                InvocationExprent condInvocation;
                                IfStatement ifStat = (IfStatement)curr;
                                Exprent condition = ifStat.getHeadexprent().getCondition();
                                if (condition instanceof FunctionExprent && ((FunctionExprent)condition).getFuncType() == FunctionExprent.FunctionType.NE) {
                                    condition = ((FunctionExprent)condition).getLstOperands().get(0);
                                }
                                if (condition instanceof InvocationExprent && (condInvocation = (InvocationExprent)condition).getName().equals("equals") && condInvocation.getInstance().equals(invExpr.getInstance()) && (block = ifStat.getIfstat().getExprents()) != null && block.size() == 1 && block.get(0) instanceof AssignmentExprent && (assign = (AssignmentExprent)block.get(0)).getRight() instanceof ConstExprent && varExpr.equals(assign.getLeft())) {
                                    curr = ifStat.getElsestat();
                                    continue;
                                }
                            }
                            matches = false;
                        }
                    }
                    return matches;
                }
            }
        }
        return false;
    }
}

