/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util.collections.fixed;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.util.collections.fixed.FastFixedSetFactory;

public abstract class FastFixedSet<E>
extends AbstractCollection<E>
implements Set<E> {
    protected final FastFixedSetFactory<E> factory;

    protected FastFixedSet(FastFixedSetFactory<E> factory) {
        this.factory = factory;
    }

    @Override
    @Deprecated
    public final int size() {
        ValidationHelper.validateTrue(false, "The behaviour of FastFixedSet.size() is not correct");
        return this.factory.getEntries().size();
    }

    public abstract int getRealSize();

    public abstract FastFixedSet<E> clone();

    public abstract void setAllElements();

    @Override
    public abstract boolean add(E var1);

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public abstract boolean containsAll(FastFixedSet<E> var1);

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof FastFixedSet) {
            FastFixedSet c1 = (FastFixedSet)c;
            if (c1.factory == this.factory) {
                return this.containsAll(c1);
            }
        }
        return this.containsAll(c);
    }

    @Override
    public abstract boolean addAll(FastFixedSet<E> var1);

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c instanceof FastFixedSet) {
            FastFixedSet c1 = (FastFixedSet)c;
            if (c1.factory == this.factory) {
                return this.addAll(c1);
            }
        }
        return super.addAll(c);
    }

    @Override
    public abstract boolean retainAll(FastFixedSet<E> var1);

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof FastFixedSet) {
            FastFixedSet c1 = (FastFixedSet)c;
            if (c1.factory == this.factory) {
                return this.retainAll(c1);
            }
        }
        HashSet<E> stuffs = new HashSet<E>(this.factory.getEntries());
        stuffs.removeAll(c);
        return this.removeAll(stuffs);
    }

    @Override
    public abstract boolean removeAll(FastFixedSet<E> var1);

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof FastFixedSet) {
            FastFixedSet c1 = (FastFixedSet)c;
            if (c1.factory == this.factory) {
                return this.removeAll(c1);
            }
        }
        boolean mutated = false;
        for (Object o : c) {
            mutated |= this.remove(o);
        }
        return mutated;
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    @Override
    public abstract String toString();

    public Set<E> toPlainSet() {
        HashSet set = new HashSet(this.getRealSize());
        set.addAll(this);
        return set;
    }

    @Deprecated
    public boolean containsKey(E id) {
        return this.factory.getEntries().contains(id);
    }

    @Deprecated
    public boolean contains(FastFixedSet<E> set) {
        return this.containsAll(set);
    }

    @Deprecated
    public void complement(FastFixedSet<E> set) {
        this.removeAll(set);
    }

    @Deprecated
    public FastFixedSet<E> getCopy() {
        return this.clone();
    }

    @Deprecated
    public void union(FastFixedSet<E> set) {
        this.addAll(set);
    }

    @Deprecated
    public void intersection(FastFixedSet<E> set) {
        this.retainAll(set);
    }
}

