// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
	"net/http"
	"net/url"
	"regexp"
)

// ObjectReplicationPoliciesServer is a fake server for instances of the armstorage.ObjectReplicationPoliciesClient type.
type ObjectReplicationPoliciesServer struct {
	// CreateOrUpdate is the fake for method ObjectReplicationPoliciesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, accountName string, objectReplicationPolicyID string, properties armstorage.ObjectReplicationPolicy, options *armstorage.ObjectReplicationPoliciesClientCreateOrUpdateOptions) (resp azfake.Responder[armstorage.ObjectReplicationPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ObjectReplicationPoliciesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, accountName string, objectReplicationPolicyID string, options *armstorage.ObjectReplicationPoliciesClientDeleteOptions) (resp azfake.Responder[armstorage.ObjectReplicationPoliciesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ObjectReplicationPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, objectReplicationPolicyID string, options *armstorage.ObjectReplicationPoliciesClientGetOptions) (resp azfake.Responder[armstorage.ObjectReplicationPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ObjectReplicationPoliciesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, options *armstorage.ObjectReplicationPoliciesClientListOptions) (resp azfake.PagerResponder[armstorage.ObjectReplicationPoliciesClientListResponse])
}

// NewObjectReplicationPoliciesServerTransport creates a new instance of ObjectReplicationPoliciesServerTransport with the provided implementation.
// The returned ObjectReplicationPoliciesServerTransport instance is connected to an instance of armstorage.ObjectReplicationPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewObjectReplicationPoliciesServerTransport(srv *ObjectReplicationPoliciesServer) *ObjectReplicationPoliciesServerTransport {
	return &ObjectReplicationPoliciesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armstorage.ObjectReplicationPoliciesClientListResponse]](),
	}
}

// ObjectReplicationPoliciesServerTransport connects instances of armstorage.ObjectReplicationPoliciesClient to instances of ObjectReplicationPoliciesServer.
// Don't use this type directly, use NewObjectReplicationPoliciesServerTransport instead.
type ObjectReplicationPoliciesServerTransport struct {
	srv          *ObjectReplicationPoliciesServer
	newListPager *tracker[azfake.PagerResponder[armstorage.ObjectReplicationPoliciesClientListResponse]]
}

// Do implements the policy.Transporter interface for ObjectReplicationPoliciesServerTransport.
func (o *ObjectReplicationPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	return o.dispatchToMethodFake(req, method)
}

func (o *ObjectReplicationPoliciesServerTransport) dispatchToMethodFake(req *http.Request, method string) (*http.Response, error) {
	resultChan := make(chan result)
	defer close(resultChan)

	go func() {
		var intercepted bool
		var res result
		if objectReplicationPoliciesServerTransportInterceptor != nil {
			res.resp, res.err, intercepted = objectReplicationPoliciesServerTransportInterceptor.Do(req)
		}
		if !intercepted {
			switch method {
			case "ObjectReplicationPoliciesClient.CreateOrUpdate":
				res.resp, res.err = o.dispatchCreateOrUpdate(req)
			case "ObjectReplicationPoliciesClient.Delete":
				res.resp, res.err = o.dispatchDelete(req)
			case "ObjectReplicationPoliciesClient.Get":
				res.resp, res.err = o.dispatchGet(req)
			case "ObjectReplicationPoliciesClient.NewListPager":
				res.resp, res.err = o.dispatchNewListPager(req)
			default:
				res.err = fmt.Errorf("unhandled API %s", method)
			}

		}
		select {
		case resultChan <- res:
		case <-req.Context().Done():
		}
	}()

	select {
	case <-req.Context().Done():
		return nil, req.Context().Err()
	case res := <-resultChan:
		return res.resp, res.err
	}
}

func (o *ObjectReplicationPoliciesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if o.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/objectReplicationPolicies/(?P<objectReplicationPolicyId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.ObjectReplicationPolicy](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	objectReplicationPolicyIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("objectReplicationPolicyId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, accountNameParam, objectReplicationPolicyIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ObjectReplicationPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (o *ObjectReplicationPoliciesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if o.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/objectReplicationPolicies/(?P<objectReplicationPolicyId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	objectReplicationPolicyIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("objectReplicationPolicyId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.Delete(req.Context(), resourceGroupNameParam, accountNameParam, objectReplicationPolicyIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (o *ObjectReplicationPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if o.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/objectReplicationPolicies/(?P<objectReplicationPolicyId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	objectReplicationPolicyIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("objectReplicationPolicyId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, objectReplicationPolicyIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ObjectReplicationPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (o *ObjectReplicationPoliciesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := o.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/objectReplicationPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := o.srv.NewListPager(resourceGroupNameParam, accountNameParam, nil)
		newListPager = &resp
		o.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		o.newListPager.remove(req)
	}
	return resp, nil
}

// set this to conditionally intercept incoming requests to ObjectReplicationPoliciesServerTransport
var objectReplicationPoliciesServerTransportInterceptor interface {
	// Do returns true if the server transport should use the returned response/error
	Do(*http.Request) (*http.Response, error, bool)
}
