// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/workflows/executions/v1/executions.proto

package executionspb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Executions_ListExecutions_FullMethodName  = "/google.cloud.workflows.executions.v1.Executions/ListExecutions"
	Executions_CreateExecution_FullMethodName = "/google.cloud.workflows.executions.v1.Executions/CreateExecution"
	Executions_GetExecution_FullMethodName    = "/google.cloud.workflows.executions.v1.Executions/GetExecution"
	Executions_CancelExecution_FullMethodName = "/google.cloud.workflows.executions.v1.Executions/CancelExecution"
)

// ExecutionsClient is the client API for Executions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ExecutionsClient interface {
	// Returns a list of executions which belong to the workflow with
	// the given name. The method returns executions of all workflow
	// revisions. Returned executions are ordered by their start time (newest
	// first).
	ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error)
	// Creates a new execution using the latest revision of the given workflow.
	CreateExecution(ctx context.Context, in *CreateExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Returns an execution of the given name.
	GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Cancels an execution of the given name.
	CancelExecution(ctx context.Context, in *CancelExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
}

type executionsClient struct {
	cc grpc.ClientConnInterface
}

func NewExecutionsClient(cc grpc.ClientConnInterface) ExecutionsClient {
	return &executionsClient{cc}
}

func (c *executionsClient) ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error) {
	out := new(ListExecutionsResponse)
	err := c.cc.Invoke(ctx, Executions_ListExecutions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) CreateExecution(ctx context.Context, in *CreateExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, Executions_CreateExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, Executions_GetExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) CancelExecution(ctx context.Context, in *CancelExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, Executions_CancelExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExecutionsServer is the server API for Executions service.
// All implementations should embed UnimplementedExecutionsServer
// for forward compatibility
type ExecutionsServer interface {
	// Returns a list of executions which belong to the workflow with
	// the given name. The method returns executions of all workflow
	// revisions. Returned executions are ordered by their start time (newest
	// first).
	ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error)
	// Creates a new execution using the latest revision of the given workflow.
	CreateExecution(context.Context, *CreateExecutionRequest) (*Execution, error)
	// Returns an execution of the given name.
	GetExecution(context.Context, *GetExecutionRequest) (*Execution, error)
	// Cancels an execution of the given name.
	CancelExecution(context.Context, *CancelExecutionRequest) (*Execution, error)
}

// UnimplementedExecutionsServer should be embedded to have forward compatible implementations.
type UnimplementedExecutionsServer struct {
}

func (UnimplementedExecutionsServer) ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExecutions not implemented")
}
func (UnimplementedExecutionsServer) CreateExecution(context.Context, *CreateExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExecution not implemented")
}
func (UnimplementedExecutionsServer) GetExecution(context.Context, *GetExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExecution not implemented")
}
func (UnimplementedExecutionsServer) CancelExecution(context.Context, *CancelExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelExecution not implemented")
}

// UnsafeExecutionsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ExecutionsServer will
// result in compilation errors.
type UnsafeExecutionsServer interface {
	mustEmbedUnimplementedExecutionsServer()
}

func RegisterExecutionsServer(s grpc.ServiceRegistrar, srv ExecutionsServer) {
	s.RegisterService(&Executions_ServiceDesc, srv)
}

func _Executions_ListExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).ListExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Executions_ListExecutions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).ListExecutions(ctx, req.(*ListExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_CreateExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).CreateExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Executions_CreateExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).CreateExecution(ctx, req.(*CreateExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_GetExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).GetExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Executions_GetExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).GetExecution(ctx, req.(*GetExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_CancelExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).CancelExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Executions_CancelExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).CancelExecution(ctx, req.(*CancelExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Executions_ServiceDesc is the grpc.ServiceDesc for Executions service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Executions_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.workflows.executions.v1.Executions",
	HandlerType: (*ExecutionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListExecutions",
			Handler:    _Executions_ListExecutions_Handler,
		},
		{
			MethodName: "CreateExecution",
			Handler:    _Executions_CreateExecution_Handler,
		},
		{
			MethodName: "GetExecution",
			Handler:    _Executions_GetExecution_Handler,
		},
		{
			MethodName: "CancelExecution",
			Handler:    _Executions_CancelExecution_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/workflows/executions/v1/executions.proto",
}
