// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2beta1/conversation_profile.proto

package dialogflowpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ConversationProfiles_ListConversationProfiles_FullMethodName     = "/google.cloud.dialogflow.v2beta1.ConversationProfiles/ListConversationProfiles"
	ConversationProfiles_GetConversationProfile_FullMethodName       = "/google.cloud.dialogflow.v2beta1.ConversationProfiles/GetConversationProfile"
	ConversationProfiles_CreateConversationProfile_FullMethodName    = "/google.cloud.dialogflow.v2beta1.ConversationProfiles/CreateConversationProfile"
	ConversationProfiles_UpdateConversationProfile_FullMethodName    = "/google.cloud.dialogflow.v2beta1.ConversationProfiles/UpdateConversationProfile"
	ConversationProfiles_DeleteConversationProfile_FullMethodName    = "/google.cloud.dialogflow.v2beta1.ConversationProfiles/DeleteConversationProfile"
	ConversationProfiles_SetSuggestionFeatureConfig_FullMethodName   = "/google.cloud.dialogflow.v2beta1.ConversationProfiles/SetSuggestionFeatureConfig"
	ConversationProfiles_ClearSuggestionFeatureConfig_FullMethodName = "/google.cloud.dialogflow.v2beta1.ConversationProfiles/ClearSuggestionFeatureConfig"
)

// ConversationProfilesClient is the client API for ConversationProfiles service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ConversationProfilesClient interface {
	// Returns the list of all conversation profiles in the specified project.
	ListConversationProfiles(ctx context.Context, in *ListConversationProfilesRequest, opts ...grpc.CallOption) (*ListConversationProfilesResponse, error)
	// Retrieves the specified conversation profile.
	GetConversationProfile(ctx context.Context, in *GetConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error)
	// Creates a conversation profile in the specified project.
	//
	// [ConversationProfile.CreateTime][] and [ConversationProfile.UpdateTime][]
	// aren't populated in the response. You can retrieve them via
	// [GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile]
	// API.
	CreateConversationProfile(ctx context.Context, in *CreateConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error)
	// Updates the specified conversation profile.
	//
	// [ConversationProfile.CreateTime][] and [ConversationProfile.UpdateTime][]
	// aren't populated in the response. You can retrieve them via
	// [GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile]
	// API.
	UpdateConversationProfile(ctx context.Context, in *UpdateConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error)
	// Deletes the specified conversation profile.
	DeleteConversationProfile(ctx context.Context, in *DeleteConversationProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Adds or updates a suggestion feature in a conversation profile.
	// If the conversation profile contains the type of suggestion feature for
	// the participant role, it will update it. Otherwise it will insert the
	// suggestion feature.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [SetSuggestionFeatureConfigOperationMetadata][google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigOperationMetadata]
	// - `response`:
	// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile]
	//
	// If a long running operation to add or update suggestion feature
	// config for the same conversation profile, participant role and suggestion
	// feature type exists, please cancel the existing long running operation
	// before sending such request, otherwise the request will be rejected.
	SetSuggestionFeatureConfig(ctx context.Context, in *SetSuggestionFeatureConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Clears a suggestion feature from a conversation profile for the given
	// participant role.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ClearSuggestionFeatureConfigOperationMetadata][google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigOperationMetadata]
	// - `response`:
	// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile]
	ClearSuggestionFeatureConfig(ctx context.Context, in *ClearSuggestionFeatureConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type conversationProfilesClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationProfilesClient(cc grpc.ClientConnInterface) ConversationProfilesClient {
	return &conversationProfilesClient{cc}
}

func (c *conversationProfilesClient) ListConversationProfiles(ctx context.Context, in *ListConversationProfilesRequest, opts ...grpc.CallOption) (*ListConversationProfilesResponse, error) {
	out := new(ListConversationProfilesResponse)
	err := c.cc.Invoke(ctx, ConversationProfiles_ListConversationProfiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) GetConversationProfile(ctx context.Context, in *GetConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error) {
	out := new(ConversationProfile)
	err := c.cc.Invoke(ctx, ConversationProfiles_GetConversationProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) CreateConversationProfile(ctx context.Context, in *CreateConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error) {
	out := new(ConversationProfile)
	err := c.cc.Invoke(ctx, ConversationProfiles_CreateConversationProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) UpdateConversationProfile(ctx context.Context, in *UpdateConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error) {
	out := new(ConversationProfile)
	err := c.cc.Invoke(ctx, ConversationProfiles_UpdateConversationProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) DeleteConversationProfile(ctx context.Context, in *DeleteConversationProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ConversationProfiles_DeleteConversationProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) SetSuggestionFeatureConfig(ctx context.Context, in *SetSuggestionFeatureConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationProfiles_SetSuggestionFeatureConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) ClearSuggestionFeatureConfig(ctx context.Context, in *ClearSuggestionFeatureConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationProfiles_ClearSuggestionFeatureConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationProfilesServer is the server API for ConversationProfiles service.
// All implementations should embed UnimplementedConversationProfilesServer
// for forward compatibility
type ConversationProfilesServer interface {
	// Returns the list of all conversation profiles in the specified project.
	ListConversationProfiles(context.Context, *ListConversationProfilesRequest) (*ListConversationProfilesResponse, error)
	// Retrieves the specified conversation profile.
	GetConversationProfile(context.Context, *GetConversationProfileRequest) (*ConversationProfile, error)
	// Creates a conversation profile in the specified project.
	//
	// [ConversationProfile.CreateTime][] and [ConversationProfile.UpdateTime][]
	// aren't populated in the response. You can retrieve them via
	// [GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile]
	// API.
	CreateConversationProfile(context.Context, *CreateConversationProfileRequest) (*ConversationProfile, error)
	// Updates the specified conversation profile.
	//
	// [ConversationProfile.CreateTime][] and [ConversationProfile.UpdateTime][]
	// aren't populated in the response. You can retrieve them via
	// [GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile]
	// API.
	UpdateConversationProfile(context.Context, *UpdateConversationProfileRequest) (*ConversationProfile, error)
	// Deletes the specified conversation profile.
	DeleteConversationProfile(context.Context, *DeleteConversationProfileRequest) (*emptypb.Empty, error)
	// Adds or updates a suggestion feature in a conversation profile.
	// If the conversation profile contains the type of suggestion feature for
	// the participant role, it will update it. Otherwise it will insert the
	// suggestion feature.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [SetSuggestionFeatureConfigOperationMetadata][google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigOperationMetadata]
	// - `response`:
	// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile]
	//
	// If a long running operation to add or update suggestion feature
	// config for the same conversation profile, participant role and suggestion
	// feature type exists, please cancel the existing long running operation
	// before sending such request, otherwise the request will be rejected.
	SetSuggestionFeatureConfig(context.Context, *SetSuggestionFeatureConfigRequest) (*longrunningpb.Operation, error)
	// Clears a suggestion feature from a conversation profile for the given
	// participant role.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ClearSuggestionFeatureConfigOperationMetadata][google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigOperationMetadata]
	// - `response`:
	// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile]
	ClearSuggestionFeatureConfig(context.Context, *ClearSuggestionFeatureConfigRequest) (*longrunningpb.Operation, error)
}

// UnimplementedConversationProfilesServer should be embedded to have forward compatible implementations.
type UnimplementedConversationProfilesServer struct {
}

func (UnimplementedConversationProfilesServer) ListConversationProfiles(context.Context, *ListConversationProfilesRequest) (*ListConversationProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversationProfiles not implemented")
}
func (UnimplementedConversationProfilesServer) GetConversationProfile(context.Context, *GetConversationProfileRequest) (*ConversationProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationProfile not implemented")
}
func (UnimplementedConversationProfilesServer) CreateConversationProfile(context.Context, *CreateConversationProfileRequest) (*ConversationProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversationProfile not implemented")
}
func (UnimplementedConversationProfilesServer) UpdateConversationProfile(context.Context, *UpdateConversationProfileRequest) (*ConversationProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversationProfile not implemented")
}
func (UnimplementedConversationProfilesServer) DeleteConversationProfile(context.Context, *DeleteConversationProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversationProfile not implemented")
}
func (UnimplementedConversationProfilesServer) SetSuggestionFeatureConfig(context.Context, *SetSuggestionFeatureConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetSuggestionFeatureConfig not implemented")
}
func (UnimplementedConversationProfilesServer) ClearSuggestionFeatureConfig(context.Context, *ClearSuggestionFeatureConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClearSuggestionFeatureConfig not implemented")
}

// UnsafeConversationProfilesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConversationProfilesServer will
// result in compilation errors.
type UnsafeConversationProfilesServer interface {
	mustEmbedUnimplementedConversationProfilesServer()
}

func RegisterConversationProfilesServer(s grpc.ServiceRegistrar, srv ConversationProfilesServer) {
	s.RegisterService(&ConversationProfiles_ServiceDesc, srv)
}

func _ConversationProfiles_ListConversationProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).ListConversationProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationProfiles_ListConversationProfiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).ListConversationProfiles(ctx, req.(*ListConversationProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_GetConversationProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).GetConversationProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationProfiles_GetConversationProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).GetConversationProfile(ctx, req.(*GetConversationProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_CreateConversationProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).CreateConversationProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationProfiles_CreateConversationProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).CreateConversationProfile(ctx, req.(*CreateConversationProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_UpdateConversationProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversationProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).UpdateConversationProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationProfiles_UpdateConversationProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).UpdateConversationProfile(ctx, req.(*UpdateConversationProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_DeleteConversationProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).DeleteConversationProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationProfiles_DeleteConversationProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).DeleteConversationProfile(ctx, req.(*DeleteConversationProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_SetSuggestionFeatureConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSuggestionFeatureConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).SetSuggestionFeatureConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationProfiles_SetSuggestionFeatureConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).SetSuggestionFeatureConfig(ctx, req.(*SetSuggestionFeatureConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_ClearSuggestionFeatureConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClearSuggestionFeatureConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).ClearSuggestionFeatureConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationProfiles_ClearSuggestionFeatureConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).ClearSuggestionFeatureConfig(ctx, req.(*ClearSuggestionFeatureConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ConversationProfiles_ServiceDesc is the grpc.ServiceDesc for ConversationProfiles service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ConversationProfiles_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.ConversationProfiles",
	HandlerType: (*ConversationProfilesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConversationProfiles",
			Handler:    _ConversationProfiles_ListConversationProfiles_Handler,
		},
		{
			MethodName: "GetConversationProfile",
			Handler:    _ConversationProfiles_GetConversationProfile_Handler,
		},
		{
			MethodName: "CreateConversationProfile",
			Handler:    _ConversationProfiles_CreateConversationProfile_Handler,
		},
		{
			MethodName: "UpdateConversationProfile",
			Handler:    _ConversationProfiles_UpdateConversationProfile_Handler,
		},
		{
			MethodName: "DeleteConversationProfile",
			Handler:    _ConversationProfiles_DeleteConversationProfile_Handler,
		},
		{
			MethodName: "SetSuggestionFeatureConfig",
			Handler:    _ConversationProfiles_SetSuggestionFeatureConfig_Handler,
		},
		{
			MethodName: "ClearSuggestionFeatureConfig",
			Handler:    _ConversationProfiles_ClearSuggestionFeatureConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/conversation_profile.proto",
}
