// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networkmanagement/v1/reachability.proto

package networkmanagementpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ReachabilityService_ListConnectivityTests_FullMethodName  = "/google.cloud.networkmanagement.v1.ReachabilityService/ListConnectivityTests"
	ReachabilityService_GetConnectivityTest_FullMethodName    = "/google.cloud.networkmanagement.v1.ReachabilityService/GetConnectivityTest"
	ReachabilityService_CreateConnectivityTest_FullMethodName = "/google.cloud.networkmanagement.v1.ReachabilityService/CreateConnectivityTest"
	ReachabilityService_UpdateConnectivityTest_FullMethodName = "/google.cloud.networkmanagement.v1.ReachabilityService/UpdateConnectivityTest"
	ReachabilityService_RerunConnectivityTest_FullMethodName  = "/google.cloud.networkmanagement.v1.ReachabilityService/RerunConnectivityTest"
	ReachabilityService_DeleteConnectivityTest_FullMethodName = "/google.cloud.networkmanagement.v1.ReachabilityService/DeleteConnectivityTest"
)

// ReachabilityServiceClient is the client API for ReachabilityService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ReachabilityServiceClient interface {
	// Lists all Connectivity Tests owned by a project.
	ListConnectivityTests(ctx context.Context, in *ListConnectivityTestsRequest, opts ...grpc.CallOption) (*ListConnectivityTestsResponse, error)
	// Gets the details of a specific Connectivity Test.
	GetConnectivityTest(ctx context.Context, in *GetConnectivityTestRequest, opts ...grpc.CallOption) (*ConnectivityTest, error)
	// Creates a new Connectivity Test.
	// After you create a test, the reachability analysis is performed as part
	// of the long running operation, which completes when the analysis completes.
	//
	// If the endpoint specifications in `ConnectivityTest` are invalid
	// (for example, containing non-existent resources in the network, or you
	// don't have read permissions to the network configurations of listed
	// projects), then the reachability result returns a value of `UNKNOWN`.
	//
	// If the endpoint specifications in `ConnectivityTest` are
	// incomplete, the reachability result returns a value of
	// <code>AMBIGUOUS</code>. For more information,
	// see the Connectivity Test documentation.
	CreateConnectivityTest(ctx context.Context, in *CreateConnectivityTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the configuration of an existing `ConnectivityTest`.
	// After you update a test, the reachability analysis is performed as part
	// of the long running operation, which completes when the analysis completes.
	// The Reachability state in the test resource is updated with the new result.
	//
	// If the endpoint specifications in `ConnectivityTest` are invalid
	// (for example, they contain non-existent resources in the network, or the
	// user does not have read permissions to the network configurations of
	// listed projects), then the reachability result returns a value of
	// <code>UNKNOWN</code>.
	//
	// If the endpoint specifications in `ConnectivityTest` are incomplete, the
	// reachability result returns a value of `AMBIGUOUS`. See the documentation
	// in `ConnectivityTest` for more details.
	UpdateConnectivityTest(ctx context.Context, in *UpdateConnectivityTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rerun an existing `ConnectivityTest`.
	// After the user triggers the rerun, the reachability analysis is performed
	// as part of the long running operation, which completes when the analysis
	// completes.
	//
	// Even though the test configuration remains the same, the reachability
	// result may change due to underlying network configuration changes.
	//
	// If the endpoint specifications in `ConnectivityTest` become invalid (for
	// example, specified resources are deleted in the network, or you lost
	// read permissions to the network configurations of listed projects), then
	// the reachability result returns a value of `UNKNOWN`.
	RerunConnectivityTest(ctx context.Context, in *RerunConnectivityTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a specific `ConnectivityTest`.
	DeleteConnectivityTest(ctx context.Context, in *DeleteConnectivityTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type reachabilityServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReachabilityServiceClient(cc grpc.ClientConnInterface) ReachabilityServiceClient {
	return &reachabilityServiceClient{cc}
}

func (c *reachabilityServiceClient) ListConnectivityTests(ctx context.Context, in *ListConnectivityTestsRequest, opts ...grpc.CallOption) (*ListConnectivityTestsResponse, error) {
	out := new(ListConnectivityTestsResponse)
	err := c.cc.Invoke(ctx, ReachabilityService_ListConnectivityTests_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachabilityServiceClient) GetConnectivityTest(ctx context.Context, in *GetConnectivityTestRequest, opts ...grpc.CallOption) (*ConnectivityTest, error) {
	out := new(ConnectivityTest)
	err := c.cc.Invoke(ctx, ReachabilityService_GetConnectivityTest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachabilityServiceClient) CreateConnectivityTest(ctx context.Context, in *CreateConnectivityTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ReachabilityService_CreateConnectivityTest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachabilityServiceClient) UpdateConnectivityTest(ctx context.Context, in *UpdateConnectivityTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ReachabilityService_UpdateConnectivityTest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachabilityServiceClient) RerunConnectivityTest(ctx context.Context, in *RerunConnectivityTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ReachabilityService_RerunConnectivityTest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachabilityServiceClient) DeleteConnectivityTest(ctx context.Context, in *DeleteConnectivityTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ReachabilityService_DeleteConnectivityTest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReachabilityServiceServer is the server API for ReachabilityService service.
// All implementations should embed UnimplementedReachabilityServiceServer
// for forward compatibility
type ReachabilityServiceServer interface {
	// Lists all Connectivity Tests owned by a project.
	ListConnectivityTests(context.Context, *ListConnectivityTestsRequest) (*ListConnectivityTestsResponse, error)
	// Gets the details of a specific Connectivity Test.
	GetConnectivityTest(context.Context, *GetConnectivityTestRequest) (*ConnectivityTest, error)
	// Creates a new Connectivity Test.
	// After you create a test, the reachability analysis is performed as part
	// of the long running operation, which completes when the analysis completes.
	//
	// If the endpoint specifications in `ConnectivityTest` are invalid
	// (for example, containing non-existent resources in the network, or you
	// don't have read permissions to the network configurations of listed
	// projects), then the reachability result returns a value of `UNKNOWN`.
	//
	// If the endpoint specifications in `ConnectivityTest` are
	// incomplete, the reachability result returns a value of
	// <code>AMBIGUOUS</code>. For more information,
	// see the Connectivity Test documentation.
	CreateConnectivityTest(context.Context, *CreateConnectivityTestRequest) (*longrunningpb.Operation, error)
	// Updates the configuration of an existing `ConnectivityTest`.
	// After you update a test, the reachability analysis is performed as part
	// of the long running operation, which completes when the analysis completes.
	// The Reachability state in the test resource is updated with the new result.
	//
	// If the endpoint specifications in `ConnectivityTest` are invalid
	// (for example, they contain non-existent resources in the network, or the
	// user does not have read permissions to the network configurations of
	// listed projects), then the reachability result returns a value of
	// <code>UNKNOWN</code>.
	//
	// If the endpoint specifications in `ConnectivityTest` are incomplete, the
	// reachability result returns a value of `AMBIGUOUS`. See the documentation
	// in `ConnectivityTest` for more details.
	UpdateConnectivityTest(context.Context, *UpdateConnectivityTestRequest) (*longrunningpb.Operation, error)
	// Rerun an existing `ConnectivityTest`.
	// After the user triggers the rerun, the reachability analysis is performed
	// as part of the long running operation, which completes when the analysis
	// completes.
	//
	// Even though the test configuration remains the same, the reachability
	// result may change due to underlying network configuration changes.
	//
	// If the endpoint specifications in `ConnectivityTest` become invalid (for
	// example, specified resources are deleted in the network, or you lost
	// read permissions to the network configurations of listed projects), then
	// the reachability result returns a value of `UNKNOWN`.
	RerunConnectivityTest(context.Context, *RerunConnectivityTestRequest) (*longrunningpb.Operation, error)
	// Deletes a specific `ConnectivityTest`.
	DeleteConnectivityTest(context.Context, *DeleteConnectivityTestRequest) (*longrunningpb.Operation, error)
}

// UnimplementedReachabilityServiceServer should be embedded to have forward compatible implementations.
type UnimplementedReachabilityServiceServer struct {
}

func (UnimplementedReachabilityServiceServer) ListConnectivityTests(context.Context, *ListConnectivityTestsRequest) (*ListConnectivityTestsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectivityTests not implemented")
}
func (UnimplementedReachabilityServiceServer) GetConnectivityTest(context.Context, *GetConnectivityTestRequest) (*ConnectivityTest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectivityTest not implemented")
}
func (UnimplementedReachabilityServiceServer) CreateConnectivityTest(context.Context, *CreateConnectivityTestRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnectivityTest not implemented")
}
func (UnimplementedReachabilityServiceServer) UpdateConnectivityTest(context.Context, *UpdateConnectivityTestRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnectivityTest not implemented")
}
func (UnimplementedReachabilityServiceServer) RerunConnectivityTest(context.Context, *RerunConnectivityTestRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RerunConnectivityTest not implemented")
}
func (UnimplementedReachabilityServiceServer) DeleteConnectivityTest(context.Context, *DeleteConnectivityTestRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnectivityTest not implemented")
}

// UnsafeReachabilityServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ReachabilityServiceServer will
// result in compilation errors.
type UnsafeReachabilityServiceServer interface {
	mustEmbedUnimplementedReachabilityServiceServer()
}

func RegisterReachabilityServiceServer(s grpc.ServiceRegistrar, srv ReachabilityServiceServer) {
	s.RegisterService(&ReachabilityService_ServiceDesc, srv)
}

func _ReachabilityService_ListConnectivityTests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectivityTestsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachabilityServiceServer).ListConnectivityTests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReachabilityService_ListConnectivityTests_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachabilityServiceServer).ListConnectivityTests(ctx, req.(*ListConnectivityTestsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachabilityService_GetConnectivityTest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectivityTestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachabilityServiceServer).GetConnectivityTest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReachabilityService_GetConnectivityTest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachabilityServiceServer).GetConnectivityTest(ctx, req.(*GetConnectivityTestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachabilityService_CreateConnectivityTest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectivityTestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachabilityServiceServer).CreateConnectivityTest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReachabilityService_CreateConnectivityTest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachabilityServiceServer).CreateConnectivityTest(ctx, req.(*CreateConnectivityTestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachabilityService_UpdateConnectivityTest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectivityTestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachabilityServiceServer).UpdateConnectivityTest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReachabilityService_UpdateConnectivityTest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachabilityServiceServer).UpdateConnectivityTest(ctx, req.(*UpdateConnectivityTestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachabilityService_RerunConnectivityTest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RerunConnectivityTestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachabilityServiceServer).RerunConnectivityTest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReachabilityService_RerunConnectivityTest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachabilityServiceServer).RerunConnectivityTest(ctx, req.(*RerunConnectivityTestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachabilityService_DeleteConnectivityTest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectivityTestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachabilityServiceServer).DeleteConnectivityTest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReachabilityService_DeleteConnectivityTest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachabilityServiceServer).DeleteConnectivityTest(ctx, req.(*DeleteConnectivityTestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ReachabilityService_ServiceDesc is the grpc.ServiceDesc for ReachabilityService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ReachabilityService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkmanagement.v1.ReachabilityService",
	HandlerType: (*ReachabilityServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConnectivityTests",
			Handler:    _ReachabilityService_ListConnectivityTests_Handler,
		},
		{
			MethodName: "GetConnectivityTest",
			Handler:    _ReachabilityService_GetConnectivityTest_Handler,
		},
		{
			MethodName: "CreateConnectivityTest",
			Handler:    _ReachabilityService_CreateConnectivityTest_Handler,
		},
		{
			MethodName: "UpdateConnectivityTest",
			Handler:    _ReachabilityService_UpdateConnectivityTest_Handler,
		},
		{
			MethodName: "RerunConnectivityTest",
			Handler:    _ReachabilityService_RerunConnectivityTest_Handler,
		},
		{
			MethodName: "DeleteConnectivityTest",
			Handler:    _ReachabilityService_DeleteConnectivityTest_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkmanagement/v1/reachability.proto",
}
