// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/speech/v1p1beta1/cloud_speech_adaptation.proto

package speechpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Adaptation_CreatePhraseSet_FullMethodName   = "/google.cloud.speech.v1p1beta1.Adaptation/CreatePhraseSet"
	Adaptation_GetPhraseSet_FullMethodName      = "/google.cloud.speech.v1p1beta1.Adaptation/GetPhraseSet"
	Adaptation_ListPhraseSet_FullMethodName     = "/google.cloud.speech.v1p1beta1.Adaptation/ListPhraseSet"
	Adaptation_UpdatePhraseSet_FullMethodName   = "/google.cloud.speech.v1p1beta1.Adaptation/UpdatePhraseSet"
	Adaptation_DeletePhraseSet_FullMethodName   = "/google.cloud.speech.v1p1beta1.Adaptation/DeletePhraseSet"
	Adaptation_CreateCustomClass_FullMethodName = "/google.cloud.speech.v1p1beta1.Adaptation/CreateCustomClass"
	Adaptation_GetCustomClass_FullMethodName    = "/google.cloud.speech.v1p1beta1.Adaptation/GetCustomClass"
	Adaptation_ListCustomClasses_FullMethodName = "/google.cloud.speech.v1p1beta1.Adaptation/ListCustomClasses"
	Adaptation_UpdateCustomClass_FullMethodName = "/google.cloud.speech.v1p1beta1.Adaptation/UpdateCustomClass"
	Adaptation_DeleteCustomClass_FullMethodName = "/google.cloud.speech.v1p1beta1.Adaptation/DeleteCustomClass"
)

// AdaptationClient is the client API for Adaptation service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AdaptationClient interface {
	// Create a set of phrase hints. Each item in the set can be a single word or
	// a multi-word phrase. The items in the PhraseSet are favored by the
	// recognition model when you send a call that includes the PhraseSet.
	CreatePhraseSet(ctx context.Context, in *CreatePhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error)
	// Get a phrase set.
	GetPhraseSet(ctx context.Context, in *GetPhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error)
	// List phrase sets.
	ListPhraseSet(ctx context.Context, in *ListPhraseSetRequest, opts ...grpc.CallOption) (*ListPhraseSetResponse, error)
	// Update a phrase set.
	UpdatePhraseSet(ctx context.Context, in *UpdatePhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error)
	// Delete a phrase set.
	DeletePhraseSet(ctx context.Context, in *DeletePhraseSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a custom class.
	CreateCustomClass(ctx context.Context, in *CreateCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error)
	// Get a custom class.
	GetCustomClass(ctx context.Context, in *GetCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error)
	// List custom classes.
	ListCustomClasses(ctx context.Context, in *ListCustomClassesRequest, opts ...grpc.CallOption) (*ListCustomClassesResponse, error)
	// Update a custom class.
	UpdateCustomClass(ctx context.Context, in *UpdateCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error)
	// Delete a custom class.
	DeleteCustomClass(ctx context.Context, in *DeleteCustomClassRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type adaptationClient struct {
	cc grpc.ClientConnInterface
}

func NewAdaptationClient(cc grpc.ClientConnInterface) AdaptationClient {
	return &adaptationClient{cc}
}

func (c *adaptationClient) CreatePhraseSet(ctx context.Context, in *CreatePhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error) {
	out := new(PhraseSet)
	err := c.cc.Invoke(ctx, Adaptation_CreatePhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) GetPhraseSet(ctx context.Context, in *GetPhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error) {
	out := new(PhraseSet)
	err := c.cc.Invoke(ctx, Adaptation_GetPhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) ListPhraseSet(ctx context.Context, in *ListPhraseSetRequest, opts ...grpc.CallOption) (*ListPhraseSetResponse, error) {
	out := new(ListPhraseSetResponse)
	err := c.cc.Invoke(ctx, Adaptation_ListPhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) UpdatePhraseSet(ctx context.Context, in *UpdatePhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error) {
	out := new(PhraseSet)
	err := c.cc.Invoke(ctx, Adaptation_UpdatePhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) DeletePhraseSet(ctx context.Context, in *DeletePhraseSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Adaptation_DeletePhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) CreateCustomClass(ctx context.Context, in *CreateCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error) {
	out := new(CustomClass)
	err := c.cc.Invoke(ctx, Adaptation_CreateCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) GetCustomClass(ctx context.Context, in *GetCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error) {
	out := new(CustomClass)
	err := c.cc.Invoke(ctx, Adaptation_GetCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) ListCustomClasses(ctx context.Context, in *ListCustomClassesRequest, opts ...grpc.CallOption) (*ListCustomClassesResponse, error) {
	out := new(ListCustomClassesResponse)
	err := c.cc.Invoke(ctx, Adaptation_ListCustomClasses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) UpdateCustomClass(ctx context.Context, in *UpdateCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error) {
	out := new(CustomClass)
	err := c.cc.Invoke(ctx, Adaptation_UpdateCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) DeleteCustomClass(ctx context.Context, in *DeleteCustomClassRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Adaptation_DeleteCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdaptationServer is the server API for Adaptation service.
// All implementations should embed UnimplementedAdaptationServer
// for forward compatibility
type AdaptationServer interface {
	// Create a set of phrase hints. Each item in the set can be a single word or
	// a multi-word phrase. The items in the PhraseSet are favored by the
	// recognition model when you send a call that includes the PhraseSet.
	CreatePhraseSet(context.Context, *CreatePhraseSetRequest) (*PhraseSet, error)
	// Get a phrase set.
	GetPhraseSet(context.Context, *GetPhraseSetRequest) (*PhraseSet, error)
	// List phrase sets.
	ListPhraseSet(context.Context, *ListPhraseSetRequest) (*ListPhraseSetResponse, error)
	// Update a phrase set.
	UpdatePhraseSet(context.Context, *UpdatePhraseSetRequest) (*PhraseSet, error)
	// Delete a phrase set.
	DeletePhraseSet(context.Context, *DeletePhraseSetRequest) (*emptypb.Empty, error)
	// Create a custom class.
	CreateCustomClass(context.Context, *CreateCustomClassRequest) (*CustomClass, error)
	// Get a custom class.
	GetCustomClass(context.Context, *GetCustomClassRequest) (*CustomClass, error)
	// List custom classes.
	ListCustomClasses(context.Context, *ListCustomClassesRequest) (*ListCustomClassesResponse, error)
	// Update a custom class.
	UpdateCustomClass(context.Context, *UpdateCustomClassRequest) (*CustomClass, error)
	// Delete a custom class.
	DeleteCustomClass(context.Context, *DeleteCustomClassRequest) (*emptypb.Empty, error)
}

// UnimplementedAdaptationServer should be embedded to have forward compatible implementations.
type UnimplementedAdaptationServer struct {
}

func (UnimplementedAdaptationServer) CreatePhraseSet(context.Context, *CreatePhraseSetRequest) (*PhraseSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePhraseSet not implemented")
}
func (UnimplementedAdaptationServer) GetPhraseSet(context.Context, *GetPhraseSetRequest) (*PhraseSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPhraseSet not implemented")
}
func (UnimplementedAdaptationServer) ListPhraseSet(context.Context, *ListPhraseSetRequest) (*ListPhraseSetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPhraseSet not implemented")
}
func (UnimplementedAdaptationServer) UpdatePhraseSet(context.Context, *UpdatePhraseSetRequest) (*PhraseSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePhraseSet not implemented")
}
func (UnimplementedAdaptationServer) DeletePhraseSet(context.Context, *DeletePhraseSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePhraseSet not implemented")
}
func (UnimplementedAdaptationServer) CreateCustomClass(context.Context, *CreateCustomClassRequest) (*CustomClass, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomClass not implemented")
}
func (UnimplementedAdaptationServer) GetCustomClass(context.Context, *GetCustomClassRequest) (*CustomClass, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomClass not implemented")
}
func (UnimplementedAdaptationServer) ListCustomClasses(context.Context, *ListCustomClassesRequest) (*ListCustomClassesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomClasses not implemented")
}
func (UnimplementedAdaptationServer) UpdateCustomClass(context.Context, *UpdateCustomClassRequest) (*CustomClass, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomClass not implemented")
}
func (UnimplementedAdaptationServer) DeleteCustomClass(context.Context, *DeleteCustomClassRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomClass not implemented")
}

// UnsafeAdaptationServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AdaptationServer will
// result in compilation errors.
type UnsafeAdaptationServer interface {
	mustEmbedUnimplementedAdaptationServer()
}

func RegisterAdaptationServer(s grpc.ServiceRegistrar, srv AdaptationServer) {
	s.RegisterService(&Adaptation_ServiceDesc, srv)
}

func _Adaptation_CreatePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).CreatePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_CreatePhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).CreatePhraseSet(ctx, req.(*CreatePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_GetPhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).GetPhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_GetPhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).GetPhraseSet(ctx, req.(*GetPhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_ListPhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).ListPhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_ListPhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).ListPhraseSet(ctx, req.(*ListPhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_UpdatePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).UpdatePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_UpdatePhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).UpdatePhraseSet(ctx, req.(*UpdatePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_DeletePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).DeletePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_DeletePhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).DeletePhraseSet(ctx, req.(*DeletePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_CreateCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).CreateCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_CreateCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).CreateCustomClass(ctx, req.(*CreateCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_GetCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).GetCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_GetCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).GetCustomClass(ctx, req.(*GetCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_ListCustomClasses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomClassesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).ListCustomClasses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_ListCustomClasses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).ListCustomClasses(ctx, req.(*ListCustomClassesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_UpdateCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).UpdateCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_UpdateCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).UpdateCustomClass(ctx, req.(*UpdateCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_DeleteCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).DeleteCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adaptation_DeleteCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).DeleteCustomClass(ctx, req.(*DeleteCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Adaptation_ServiceDesc is the grpc.ServiceDesc for Adaptation service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Adaptation_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v1p1beta1.Adaptation",
	HandlerType: (*AdaptationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePhraseSet",
			Handler:    _Adaptation_CreatePhraseSet_Handler,
		},
		{
			MethodName: "GetPhraseSet",
			Handler:    _Adaptation_GetPhraseSet_Handler,
		},
		{
			MethodName: "ListPhraseSet",
			Handler:    _Adaptation_ListPhraseSet_Handler,
		},
		{
			MethodName: "UpdatePhraseSet",
			Handler:    _Adaptation_UpdatePhraseSet_Handler,
		},
		{
			MethodName: "DeletePhraseSet",
			Handler:    _Adaptation_DeletePhraseSet_Handler,
		},
		{
			MethodName: "CreateCustomClass",
			Handler:    _Adaptation_CreateCustomClass_Handler,
		},
		{
			MethodName: "GetCustomClass",
			Handler:    _Adaptation_GetCustomClass_Handler,
		},
		{
			MethodName: "ListCustomClasses",
			Handler:    _Adaptation_ListCustomClasses_Handler,
		},
		{
			MethodName: "UpdateCustomClass",
			Handler:    _Adaptation_UpdateCustomClass_Handler,
		},
		{
			MethodName: "DeleteCustomClass",
			Handler:    _Adaptation_DeleteCustomClass_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/speech/v1p1beta1/cloud_speech_adaptation.proto",
}
