/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1 "sigs.k8s.io/gateway-api/apis/v1"
)

// GatewayClassLister helps list GatewayClasses.
// All objects returned here must be treated as read-only.
type GatewayClassLister interface {
	// List lists all GatewayClasses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.GatewayClass, err error)
	// Get retrieves the GatewayClass from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.GatewayClass, error)
	GatewayClassListerExpansion
}

// gatewayClassLister implements the GatewayClassLister interface.
type gatewayClassLister struct {
	indexer cache.Indexer
}

// NewGatewayClassLister returns a new GatewayClassLister.
func NewGatewayClassLister(indexer cache.Indexer) GatewayClassLister {
	return &gatewayClassLister{indexer: indexer}
}

// List lists all GatewayClasses in the indexer.
func (s *gatewayClassLister) List(selector labels.Selector) (ret []*v1.GatewayClass, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.GatewayClass))
	})
	return ret, err
}

// Get retrieves the GatewayClass from the index for a given name.
func (s *gatewayClassLister) Get(name string) (*v1.GatewayClass, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("gatewayclass"), name)
	}
	return obj.(*v1.GatewayClass), nil
}
