/*
Copyright 2023 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was generated by "go run gen/main.go -mode test > gen_test.go". Do not edit
// directly.

package cloud

import (
	"context"
	"reflect"
	"testing"

	computealpha "google.golang.org/api/compute/v0.alpha"
	computebeta "google.golang.org/api/compute/v0.beta"
	computega "google.golang.org/api/compute/v1"

	networkservicesga "google.golang.org/api/networkservices/v1"
	networkservicesbeta "google.golang.org/api/networkservices/v1beta1"

	"github.com/GoogleCloudPlatform/k8s-cloud-provider/pkg/cloud/filter"
	"github.com/GoogleCloudPlatform/k8s-cloud-provider/pkg/cloud/meta"
)

const location = "location"

func TestAddressesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaAddresses().Get(ctx, key); err == nil {
		t.Errorf("AlphaAddresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaAddresses().Get(ctx, key); err == nil {
		t.Errorf("BetaAddresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Addresses().Get(ctx, key); err == nil {
		t.Errorf("Addresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.Address{}
		if err := mock.AlphaAddresses().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaAddresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.Address{}
		if err := mock.BetaAddresses().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaAddresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.Address{}
		if err := mock.Addresses().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Addresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaAddresses().Get(ctx, key); err != nil {
		t.Errorf("AlphaAddresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaAddresses().Get(ctx, key); err != nil {
		t.Errorf("BetaAddresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Addresses().Get(ctx, key); err != nil {
		t.Errorf("Addresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaAddresses.Objects[*keyAlpha] = mock.MockAlphaAddresses.Obj(&computealpha.Address{Name: keyAlpha.Name})
	mock.MockBetaAddresses.Objects[*keyBeta] = mock.MockBetaAddresses.Obj(&computebeta.Address{Name: keyBeta.Name})
	mock.MockAddresses.Objects[*keyGA] = mock.MockAddresses.Obj(&computega.Address{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaAddresses().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaAddresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaAddresses().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaAddresses().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaAddresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaAddresses().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Addresses().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("Addresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Addresses().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaAddresses().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaAddresses().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaAddresses().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaAddresses().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Addresses().Delete(ctx, keyGA); err != nil {
		t.Errorf("Addresses().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaAddresses().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaAddresses().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaAddresses().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaAddresses().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Addresses().Delete(ctx, keyGA); err == nil {
		t.Errorf("Addresses().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestBackendServicesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaBackendServices().Get(ctx, key); err == nil {
		t.Errorf("AlphaBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaBackendServices().Get(ctx, key); err == nil {
		t.Errorf("BetaBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BackendServices().Get(ctx, key); err == nil {
		t.Errorf("BackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.BackendService{}
		if err := mock.AlphaBackendServices().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.BackendService{}
		if err := mock.BetaBackendServices().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.BackendService{}
		if err := mock.BackendServices().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("BackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaBackendServices().Get(ctx, key); err != nil {
		t.Errorf("AlphaBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaBackendServices().Get(ctx, key); err != nil {
		t.Errorf("BetaBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BackendServices().Get(ctx, key); err != nil {
		t.Errorf("BackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaBackendServices.Objects[*keyAlpha] = mock.MockAlphaBackendServices.Obj(&computealpha.BackendService{Name: keyAlpha.Name})
	mock.MockBetaBackendServices.Objects[*keyBeta] = mock.MockBetaBackendServices.Obj(&computebeta.BackendService{Name: keyBeta.Name})
	mock.MockBackendServices.Objects[*keyGA] = mock.MockBackendServices.Obj(&computega.BackendService{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaBackendServices().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaBackendServices().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BackendServices().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaBackendServices().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaBackendServices().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.BackendServices().Delete(ctx, keyGA); err != nil {
		t.Errorf("BackendServices().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaBackendServices().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaBackendServices().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaBackendServices().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaBackendServices().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.BackendServices().Delete(ctx, keyGA); err == nil {
		t.Errorf("BackendServices().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestDisksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.ZonalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Disks().Get(ctx, key); err == nil {
		t.Errorf("Disks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.Disk{}
		if err := mock.Disks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Disks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.Disks().Get(ctx, key); err != nil {
		t.Errorf("Disks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockDisks.Objects[*keyGA] = mock.MockDisks.Obj(&computega.Disk{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Disks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("Disks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Disks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.Disks().Delete(ctx, keyGA); err != nil {
		t.Errorf("Disks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.Disks().Delete(ctx, keyGA); err == nil {
		t.Errorf("Disks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestFirewallsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaFirewalls().Get(ctx, key); err == nil {
		t.Errorf("AlphaFirewalls().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaFirewalls().Get(ctx, key); err == nil {
		t.Errorf("BetaFirewalls().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Firewalls().Get(ctx, key); err == nil {
		t.Errorf("Firewalls().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.Firewall{}
		if err := mock.AlphaFirewalls().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaFirewalls().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.Firewall{}
		if err := mock.BetaFirewalls().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaFirewalls().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.Firewall{}
		if err := mock.Firewalls().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Firewalls().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaFirewalls().Get(ctx, key); err != nil {
		t.Errorf("AlphaFirewalls().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaFirewalls().Get(ctx, key); err != nil {
		t.Errorf("BetaFirewalls().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Firewalls().Get(ctx, key); err != nil {
		t.Errorf("Firewalls().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaFirewalls.Objects[*keyAlpha] = mock.MockAlphaFirewalls.Obj(&computealpha.Firewall{Name: keyAlpha.Name})
	mock.MockBetaFirewalls.Objects[*keyBeta] = mock.MockBetaFirewalls.Obj(&computebeta.Firewall{Name: keyBeta.Name})
	mock.MockFirewalls.Objects[*keyGA] = mock.MockFirewalls.Obj(&computega.Firewall{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaFirewalls().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaFirewalls().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaFirewalls().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaFirewalls().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaFirewalls().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaFirewalls().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Firewalls().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Firewalls().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Firewalls().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaFirewalls().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaFirewalls().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaFirewalls().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaFirewalls().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Firewalls().Delete(ctx, keyGA); err != nil {
		t.Errorf("Firewalls().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaFirewalls().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaFirewalls().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaFirewalls().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaFirewalls().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Firewalls().Delete(ctx, keyGA); err == nil {
		t.Errorf("Firewalls().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestForwardingRulesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("AlphaForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("BetaForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.ForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("ForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.ForwardingRule{}
		if err := mock.AlphaForwardingRules().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.ForwardingRule{}
		if err := mock.BetaForwardingRules().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.ForwardingRule{}
		if err := mock.ForwardingRules().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("ForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("AlphaForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("BetaForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.ForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("ForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaForwardingRules.Objects[*keyAlpha] = mock.MockAlphaForwardingRules.Obj(&computealpha.ForwardingRule{Name: keyAlpha.Name})
	mock.MockBetaForwardingRules.Objects[*keyBeta] = mock.MockBetaForwardingRules.Obj(&computebeta.ForwardingRule{Name: keyBeta.Name})
	mock.MockForwardingRules.Objects[*keyGA] = mock.MockForwardingRules.Obj(&computega.ForwardingRule{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaForwardingRules().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaForwardingRules().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.ForwardingRules().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("ForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("ForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaForwardingRules().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaForwardingRules().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.ForwardingRules().Delete(ctx, keyGA); err != nil {
		t.Errorf("ForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaForwardingRules().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaForwardingRules().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.ForwardingRules().Delete(ctx, keyGA); err == nil {
		t.Errorf("ForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestGlobalAddressesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaGlobalAddresses().Get(ctx, key); err == nil {
		t.Errorf("AlphaGlobalAddresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaGlobalAddresses().Get(ctx, key); err == nil {
		t.Errorf("BetaGlobalAddresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.GlobalAddresses().Get(ctx, key); err == nil {
		t.Errorf("GlobalAddresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.Address{}
		if err := mock.AlphaGlobalAddresses().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaGlobalAddresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.Address{}
		if err := mock.BetaGlobalAddresses().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaGlobalAddresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.Address{}
		if err := mock.GlobalAddresses().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("GlobalAddresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaGlobalAddresses().Get(ctx, key); err != nil {
		t.Errorf("AlphaGlobalAddresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaGlobalAddresses().Get(ctx, key); err != nil {
		t.Errorf("BetaGlobalAddresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.GlobalAddresses().Get(ctx, key); err != nil {
		t.Errorf("GlobalAddresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaGlobalAddresses.Objects[*keyAlpha] = mock.MockAlphaGlobalAddresses.Obj(&computealpha.Address{Name: keyAlpha.Name})
	mock.MockBetaGlobalAddresses.Objects[*keyBeta] = mock.MockBetaGlobalAddresses.Obj(&computebeta.Address{Name: keyBeta.Name})
	mock.MockGlobalAddresses.Objects[*keyGA] = mock.MockGlobalAddresses.Obj(&computega.Address{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaGlobalAddresses().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaGlobalAddresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaGlobalAddresses().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaGlobalAddresses().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaGlobalAddresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaGlobalAddresses().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.GlobalAddresses().List(ctx, filter.None)
		if err != nil {
			t.Errorf("GlobalAddresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("GlobalAddresses().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaGlobalAddresses().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaGlobalAddresses().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaGlobalAddresses().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaGlobalAddresses().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.GlobalAddresses().Delete(ctx, keyGA); err != nil {
		t.Errorf("GlobalAddresses().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaGlobalAddresses().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaGlobalAddresses().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaGlobalAddresses().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaGlobalAddresses().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.GlobalAddresses().Delete(ctx, keyGA); err == nil {
		t.Errorf("GlobalAddresses().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestGlobalForwardingRulesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaGlobalForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("AlphaGlobalForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaGlobalForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("BetaGlobalForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.GlobalForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("GlobalForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.ForwardingRule{}
		if err := mock.AlphaGlobalForwardingRules().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaGlobalForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.ForwardingRule{}
		if err := mock.BetaGlobalForwardingRules().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaGlobalForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.ForwardingRule{}
		if err := mock.GlobalForwardingRules().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("GlobalForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaGlobalForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("AlphaGlobalForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaGlobalForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("BetaGlobalForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.GlobalForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("GlobalForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaGlobalForwardingRules.Objects[*keyAlpha] = mock.MockAlphaGlobalForwardingRules.Obj(&computealpha.ForwardingRule{Name: keyAlpha.Name})
	mock.MockBetaGlobalForwardingRules.Objects[*keyBeta] = mock.MockBetaGlobalForwardingRules.Obj(&computebeta.ForwardingRule{Name: keyBeta.Name})
	mock.MockGlobalForwardingRules.Objects[*keyGA] = mock.MockGlobalForwardingRules.Obj(&computega.ForwardingRule{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaGlobalForwardingRules().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaGlobalForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaGlobalForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaGlobalForwardingRules().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaGlobalForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaGlobalForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.GlobalForwardingRules().List(ctx, filter.None)
		if err != nil {
			t.Errorf("GlobalForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("GlobalForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaGlobalForwardingRules().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaGlobalForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaGlobalForwardingRules().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaGlobalForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.GlobalForwardingRules().Delete(ctx, keyGA); err != nil {
		t.Errorf("GlobalForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaGlobalForwardingRules().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaGlobalForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaGlobalForwardingRules().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaGlobalForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.GlobalForwardingRules().Delete(ctx, keyGA); err == nil {
		t.Errorf("GlobalForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestGlobalNetworkEndpointGroupsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaGlobalNetworkEndpointGroups().Get(ctx, key); err == nil {
		t.Errorf("AlphaGlobalNetworkEndpointGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaGlobalNetworkEndpointGroups().Get(ctx, key); err == nil {
		t.Errorf("BetaGlobalNetworkEndpointGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.GlobalNetworkEndpointGroups().Get(ctx, key); err == nil {
		t.Errorf("GlobalNetworkEndpointGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.NetworkEndpointGroup{}
		if err := mock.AlphaGlobalNetworkEndpointGroups().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaGlobalNetworkEndpointGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.NetworkEndpointGroup{}
		if err := mock.BetaGlobalNetworkEndpointGroups().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaGlobalNetworkEndpointGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.NetworkEndpointGroup{}
		if err := mock.GlobalNetworkEndpointGroups().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("GlobalNetworkEndpointGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaGlobalNetworkEndpointGroups().Get(ctx, key); err != nil {
		t.Errorf("AlphaGlobalNetworkEndpointGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaGlobalNetworkEndpointGroups().Get(ctx, key); err != nil {
		t.Errorf("BetaGlobalNetworkEndpointGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.GlobalNetworkEndpointGroups().Get(ctx, key); err != nil {
		t.Errorf("GlobalNetworkEndpointGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaGlobalNetworkEndpointGroups.Objects[*keyAlpha] = mock.MockAlphaGlobalNetworkEndpointGroups.Obj(&computealpha.NetworkEndpointGroup{Name: keyAlpha.Name})
	mock.MockBetaGlobalNetworkEndpointGroups.Objects[*keyBeta] = mock.MockBetaGlobalNetworkEndpointGroups.Obj(&computebeta.NetworkEndpointGroup{Name: keyBeta.Name})
	mock.MockGlobalNetworkEndpointGroups.Objects[*keyGA] = mock.MockGlobalNetworkEndpointGroups.Obj(&computega.NetworkEndpointGroup{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaGlobalNetworkEndpointGroups().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaGlobalNetworkEndpointGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaGlobalNetworkEndpointGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaGlobalNetworkEndpointGroups().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaGlobalNetworkEndpointGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaGlobalNetworkEndpointGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.GlobalNetworkEndpointGroups().List(ctx, filter.None)
		if err != nil {
			t.Errorf("GlobalNetworkEndpointGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("GlobalNetworkEndpointGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaGlobalNetworkEndpointGroups().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaGlobalNetworkEndpointGroups().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaGlobalNetworkEndpointGroups().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaGlobalNetworkEndpointGroups().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.GlobalNetworkEndpointGroups().Delete(ctx, keyGA); err != nil {
		t.Errorf("GlobalNetworkEndpointGroups().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaGlobalNetworkEndpointGroups().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaGlobalNetworkEndpointGroups().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaGlobalNetworkEndpointGroups().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaGlobalNetworkEndpointGroups().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.GlobalNetworkEndpointGroups().Delete(ctx, keyGA); err == nil {
		t.Errorf("GlobalNetworkEndpointGroups().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestHealthChecksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("AlphaHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("BetaHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.HealthChecks().Get(ctx, key); err == nil {
		t.Errorf("HealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.HealthCheck{}
		if err := mock.AlphaHealthChecks().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.HealthCheck{}
		if err := mock.BetaHealthChecks().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.HealthCheck{}
		if err := mock.HealthChecks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("HealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("AlphaHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("BetaHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.HealthChecks().Get(ctx, key); err != nil {
		t.Errorf("HealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaHealthChecks.Objects[*keyAlpha] = mock.MockAlphaHealthChecks.Obj(&computealpha.HealthCheck{Name: keyAlpha.Name})
	mock.MockBetaHealthChecks.Objects[*keyBeta] = mock.MockBetaHealthChecks.Obj(&computebeta.HealthCheck{Name: keyBeta.Name})
	mock.MockHealthChecks.Objects[*keyGA] = mock.MockHealthChecks.Obj(&computega.HealthCheck{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaHealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaHealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.HealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("HealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("HealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaHealthChecks().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaHealthChecks().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.HealthChecks().Delete(ctx, keyGA); err != nil {
		t.Errorf("HealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaHealthChecks().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaHealthChecks().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.HealthChecks().Delete(ctx, keyGA); err == nil {
		t.Errorf("HealthChecks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestHttpHealthChecksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.HttpHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("HttpHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.HttpHealthCheck{}
		if err := mock.HttpHealthChecks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("HttpHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.HttpHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("HttpHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockHttpHealthChecks.Objects[*keyGA] = mock.MockHttpHealthChecks.Obj(&computega.HttpHealthCheck{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.HttpHealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("HttpHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("HttpHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.HttpHealthChecks().Delete(ctx, keyGA); err != nil {
		t.Errorf("HttpHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.HttpHealthChecks().Delete(ctx, keyGA); err == nil {
		t.Errorf("HttpHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestHttpsHealthChecksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.HttpsHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("HttpsHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.HttpsHealthCheck{}
		if err := mock.HttpsHealthChecks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("HttpsHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.HttpsHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("HttpsHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockHttpsHealthChecks.Objects[*keyGA] = mock.MockHttpsHealthChecks.Obj(&computega.HttpsHealthCheck{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.HttpsHealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("HttpsHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("HttpsHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.HttpsHealthChecks().Delete(ctx, keyGA); err != nil {
		t.Errorf("HttpsHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.HttpsHealthChecks().Delete(ctx, keyGA); err == nil {
		t.Errorf("HttpsHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestImagesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaImages().Get(ctx, key); err == nil {
		t.Errorf("AlphaImages().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaImages().Get(ctx, key); err == nil {
		t.Errorf("BetaImages().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Images().Get(ctx, key); err == nil {
		t.Errorf("Images().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.Image{}
		if err := mock.AlphaImages().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaImages().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.Image{}
		if err := mock.BetaImages().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaImages().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.Image{}
		if err := mock.Images().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Images().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaImages().Get(ctx, key); err != nil {
		t.Errorf("AlphaImages().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaImages().Get(ctx, key); err != nil {
		t.Errorf("BetaImages().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Images().Get(ctx, key); err != nil {
		t.Errorf("Images().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaImages.Objects[*keyAlpha] = mock.MockAlphaImages.Obj(&computealpha.Image{Name: keyAlpha.Name})
	mock.MockBetaImages.Objects[*keyBeta] = mock.MockBetaImages.Obj(&computebeta.Image{Name: keyBeta.Name})
	mock.MockImages.Objects[*keyGA] = mock.MockImages.Obj(&computega.Image{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaImages().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaImages().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaImages().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaImages().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaImages().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaImages().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Images().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Images().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Images().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaImages().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaImages().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaImages().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaImages().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Images().Delete(ctx, keyGA); err != nil {
		t.Errorf("Images().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaImages().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaImages().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaImages().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaImages().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Images().Delete(ctx, keyGA); err == nil {
		t.Errorf("Images().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestInstanceGroupManagersGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.ZonalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.InstanceGroupManagers().Get(ctx, key); err == nil {
		t.Errorf("InstanceGroupManagers().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.InstanceGroupManager{}
		if err := mock.InstanceGroupManagers().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("InstanceGroupManagers().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.InstanceGroupManagers().Get(ctx, key); err != nil {
		t.Errorf("InstanceGroupManagers().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockInstanceGroupManagers.Objects[*keyGA] = mock.MockInstanceGroupManagers.Obj(&computega.InstanceGroupManager{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.InstanceGroupManagers().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("InstanceGroupManagers().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("InstanceGroupManagers().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.InstanceGroupManagers().Delete(ctx, keyGA); err != nil {
		t.Errorf("InstanceGroupManagers().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.InstanceGroupManagers().Delete(ctx, keyGA); err == nil {
		t.Errorf("InstanceGroupManagers().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestInstanceGroupsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.ZonalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.InstanceGroups().Get(ctx, key); err == nil {
		t.Errorf("InstanceGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.InstanceGroup{}
		if err := mock.InstanceGroups().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("InstanceGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.InstanceGroups().Get(ctx, key); err != nil {
		t.Errorf("InstanceGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockInstanceGroups.Objects[*keyGA] = mock.MockInstanceGroups.Obj(&computega.InstanceGroup{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.InstanceGroups().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("InstanceGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("InstanceGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.InstanceGroups().Delete(ctx, keyGA); err != nil {
		t.Errorf("InstanceGroups().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.InstanceGroups().Delete(ctx, keyGA); err == nil {
		t.Errorf("InstanceGroups().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestInstanceTemplatesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.InstanceTemplates().Get(ctx, key); err == nil {
		t.Errorf("InstanceTemplates().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.InstanceTemplate{}
		if err := mock.InstanceTemplates().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("InstanceTemplates().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.InstanceTemplates().Get(ctx, key); err != nil {
		t.Errorf("InstanceTemplates().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockInstanceTemplates.Objects[*keyGA] = mock.MockInstanceTemplates.Obj(&computega.InstanceTemplate{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.InstanceTemplates().List(ctx, filter.None)
		if err != nil {
			t.Errorf("InstanceTemplates().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("InstanceTemplates().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.InstanceTemplates().Delete(ctx, keyGA); err != nil {
		t.Errorf("InstanceTemplates().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.InstanceTemplates().Delete(ctx, keyGA); err == nil {
		t.Errorf("InstanceTemplates().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestInstancesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.ZonalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.ZonalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.ZonalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaInstances().Get(ctx, key); err == nil {
		t.Errorf("AlphaInstances().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaInstances().Get(ctx, key); err == nil {
		t.Errorf("BetaInstances().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Instances().Get(ctx, key); err == nil {
		t.Errorf("Instances().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.Instance{}
		if err := mock.AlphaInstances().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaInstances().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.Instance{}
		if err := mock.BetaInstances().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaInstances().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.Instance{}
		if err := mock.Instances().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Instances().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaInstances().Get(ctx, key); err != nil {
		t.Errorf("AlphaInstances().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaInstances().Get(ctx, key); err != nil {
		t.Errorf("BetaInstances().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Instances().Get(ctx, key); err != nil {
		t.Errorf("Instances().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaInstances.Objects[*keyAlpha] = mock.MockAlphaInstances.Obj(&computealpha.Instance{Name: keyAlpha.Name})
	mock.MockBetaInstances.Objects[*keyBeta] = mock.MockBetaInstances.Obj(&computebeta.Instance{Name: keyBeta.Name})
	mock.MockInstances.Objects[*keyGA] = mock.MockInstances.Obj(&computega.Instance{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaInstances().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaInstances().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaInstances().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaInstances().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaInstances().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaInstances().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Instances().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("Instances().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Instances().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaInstances().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaInstances().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaInstances().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaInstances().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Instances().Delete(ctx, keyGA); err != nil {
		t.Errorf("Instances().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaInstances().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaInstances().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaInstances().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaInstances().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Instances().Delete(ctx, keyGA); err == nil {
		t.Errorf("Instances().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestMeshesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.BetaMeshes().Get(ctx, key); err == nil {
		t.Errorf("BetaMeshes().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Meshes().Get(ctx, key); err == nil {
		t.Errorf("Meshes().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &networkservicesbeta.Mesh{}
		if err := mock.BetaMeshes().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaMeshes().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &networkservicesga.Mesh{}
		if err := mock.Meshes().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Meshes().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.BetaMeshes().Get(ctx, key); err != nil {
		t.Errorf("BetaMeshes().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Meshes().Get(ctx, key); err != nil {
		t.Errorf("Meshes().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockBetaMeshes.Objects[*keyBeta] = mock.MockBetaMeshes.Obj(&networkservicesbeta.Mesh{Name: keyBeta.Name})
	mock.MockMeshes.Objects[*keyGA] = mock.MockMeshes.Obj(&networkservicesga.Mesh{Name: keyGA.Name})
	want := map[string]bool{
		"key-beta": true,
		"key-ga":   true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.BetaMeshes().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaMeshes().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaMeshes().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Meshes().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Meshes().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Meshes().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.BetaMeshes().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaMeshes().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Meshes().Delete(ctx, keyGA); err != nil {
		t.Errorf("Meshes().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.BetaMeshes().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaMeshes().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Meshes().Delete(ctx, keyGA); err == nil {
		t.Errorf("Meshes().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestNetworkEndpointGroupsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.ZonalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.ZonalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.ZonalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaNetworkEndpointGroups().Get(ctx, key); err == nil {
		t.Errorf("AlphaNetworkEndpointGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaNetworkEndpointGroups().Get(ctx, key); err == nil {
		t.Errorf("BetaNetworkEndpointGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.NetworkEndpointGroups().Get(ctx, key); err == nil {
		t.Errorf("NetworkEndpointGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.NetworkEndpointGroup{}
		if err := mock.AlphaNetworkEndpointGroups().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaNetworkEndpointGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.NetworkEndpointGroup{}
		if err := mock.BetaNetworkEndpointGroups().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaNetworkEndpointGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.NetworkEndpointGroup{}
		if err := mock.NetworkEndpointGroups().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("NetworkEndpointGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaNetworkEndpointGroups().Get(ctx, key); err != nil {
		t.Errorf("AlphaNetworkEndpointGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaNetworkEndpointGroups().Get(ctx, key); err != nil {
		t.Errorf("BetaNetworkEndpointGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.NetworkEndpointGroups().Get(ctx, key); err != nil {
		t.Errorf("NetworkEndpointGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaNetworkEndpointGroups.Objects[*keyAlpha] = mock.MockAlphaNetworkEndpointGroups.Obj(&computealpha.NetworkEndpointGroup{Name: keyAlpha.Name})
	mock.MockBetaNetworkEndpointGroups.Objects[*keyBeta] = mock.MockBetaNetworkEndpointGroups.Obj(&computebeta.NetworkEndpointGroup{Name: keyBeta.Name})
	mock.MockNetworkEndpointGroups.Objects[*keyGA] = mock.MockNetworkEndpointGroups.Obj(&computega.NetworkEndpointGroup{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaNetworkEndpointGroups().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaNetworkEndpointGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaNetworkEndpointGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaNetworkEndpointGroups().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaNetworkEndpointGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaNetworkEndpointGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.NetworkEndpointGroups().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("NetworkEndpointGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("NetworkEndpointGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaNetworkEndpointGroups().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaNetworkEndpointGroups().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaNetworkEndpointGroups().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaNetworkEndpointGroups().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.NetworkEndpointGroups().Delete(ctx, keyGA); err != nil {
		t.Errorf("NetworkEndpointGroups().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaNetworkEndpointGroups().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaNetworkEndpointGroups().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaNetworkEndpointGroups().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaNetworkEndpointGroups().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.NetworkEndpointGroups().Delete(ctx, keyGA); err == nil {
		t.Errorf("NetworkEndpointGroups().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestNetworkFirewallPoliciesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaNetworkFirewallPolicies().Get(ctx, key); err == nil {
		t.Errorf("AlphaNetworkFirewallPolicies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.FirewallPolicy{}
		if err := mock.AlphaNetworkFirewallPolicies().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaNetworkFirewallPolicies().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaNetworkFirewallPolicies().Get(ctx, key); err != nil {
		t.Errorf("AlphaNetworkFirewallPolicies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaNetworkFirewallPolicies.Objects[*keyAlpha] = mock.MockAlphaNetworkFirewallPolicies.Obj(&computealpha.FirewallPolicy{Name: keyAlpha.Name})
	want := map[string]bool{
		"key-alpha": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaNetworkFirewallPolicies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaNetworkFirewallPolicies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaNetworkFirewallPolicies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaNetworkFirewallPolicies().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaNetworkFirewallPolicies().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}

	// Delete not found.
	if err := mock.AlphaNetworkFirewallPolicies().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaNetworkFirewallPolicies().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
}

func TestNetworksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaNetworks().Get(ctx, key); err == nil {
		t.Errorf("AlphaNetworks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaNetworks().Get(ctx, key); err == nil {
		t.Errorf("BetaNetworks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Networks().Get(ctx, key); err == nil {
		t.Errorf("Networks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.Network{}
		if err := mock.AlphaNetworks().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaNetworks().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.Network{}
		if err := mock.BetaNetworks().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaNetworks().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.Network{}
		if err := mock.Networks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Networks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaNetworks().Get(ctx, key); err != nil {
		t.Errorf("AlphaNetworks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaNetworks().Get(ctx, key); err != nil {
		t.Errorf("BetaNetworks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Networks().Get(ctx, key); err != nil {
		t.Errorf("Networks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaNetworks.Objects[*keyAlpha] = mock.MockAlphaNetworks.Obj(&computealpha.Network{Name: keyAlpha.Name})
	mock.MockBetaNetworks.Objects[*keyBeta] = mock.MockBetaNetworks.Obj(&computebeta.Network{Name: keyBeta.Name})
	mock.MockNetworks.Objects[*keyGA] = mock.MockNetworks.Obj(&computega.Network{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaNetworks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaNetworks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaNetworks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaNetworks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaNetworks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaNetworks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Networks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Networks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Networks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaNetworks().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaNetworks().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaNetworks().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaNetworks().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Networks().Delete(ctx, keyGA); err != nil {
		t.Errorf("Networks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaNetworks().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaNetworks().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaNetworks().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaNetworks().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Networks().Delete(ctx, keyGA); err == nil {
		t.Errorf("Networks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestProjectsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.

	// Insert.

	// Get across versions.

	// List.
	mock.MockProjects.Objects[*keyGA] = mock.MockProjects.Obj(&computega.Project{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.

	// Delete across versions.

	// Delete not found.
}

func TestRegionBackendServicesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRegionBackendServices().Get(ctx, key); err == nil {
		t.Errorf("AlphaRegionBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaRegionBackendServices().Get(ctx, key); err == nil {
		t.Errorf("BetaRegionBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.RegionBackendServices().Get(ctx, key); err == nil {
		t.Errorf("RegionBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.BackendService{}
		if err := mock.AlphaRegionBackendServices().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRegionBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.BackendService{}
		if err := mock.BetaRegionBackendServices().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaRegionBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.BackendService{}
		if err := mock.RegionBackendServices().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRegionBackendServices().Get(ctx, key); err != nil {
		t.Errorf("AlphaRegionBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaRegionBackendServices().Get(ctx, key); err != nil {
		t.Errorf("BetaRegionBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.RegionBackendServices().Get(ctx, key); err != nil {
		t.Errorf("RegionBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRegionBackendServices.Objects[*keyAlpha] = mock.MockAlphaRegionBackendServices.Obj(&computealpha.BackendService{Name: keyAlpha.Name})
	mock.MockBetaRegionBackendServices.Objects[*keyBeta] = mock.MockBetaRegionBackendServices.Obj(&computebeta.BackendService{Name: keyBeta.Name})
	mock.MockRegionBackendServices.Objects[*keyGA] = mock.MockRegionBackendServices.Obj(&computega.BackendService{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRegionBackendServices().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRegionBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRegionBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaRegionBackendServices().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaRegionBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaRegionBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.RegionBackendServices().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRegionBackendServices().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRegionBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaRegionBackendServices().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaRegionBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.RegionBackendServices().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaRegionBackendServices().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRegionBackendServices().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaRegionBackendServices().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaRegionBackendServices().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.RegionBackendServices().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionBackendServices().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionDisksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.RegionDisks().Get(ctx, key); err == nil {
		t.Errorf("RegionDisks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.Disk{}
		if err := mock.RegionDisks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionDisks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.RegionDisks().Get(ctx, key); err != nil {
		t.Errorf("RegionDisks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockRegionDisks.Objects[*keyGA] = mock.MockRegionDisks.Obj(&computega.Disk{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.RegionDisks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionDisks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionDisks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.RegionDisks().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionDisks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.RegionDisks().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionDisks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionHealthChecksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRegionHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("AlphaRegionHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaRegionHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("BetaRegionHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.RegionHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("RegionHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.HealthCheck{}
		if err := mock.AlphaRegionHealthChecks().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRegionHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.HealthCheck{}
		if err := mock.BetaRegionHealthChecks().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaRegionHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.HealthCheck{}
		if err := mock.RegionHealthChecks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRegionHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("AlphaRegionHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaRegionHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("BetaRegionHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.RegionHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("RegionHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRegionHealthChecks.Objects[*keyAlpha] = mock.MockAlphaRegionHealthChecks.Obj(&computealpha.HealthCheck{Name: keyAlpha.Name})
	mock.MockBetaRegionHealthChecks.Objects[*keyBeta] = mock.MockBetaRegionHealthChecks.Obj(&computebeta.HealthCheck{Name: keyBeta.Name})
	mock.MockRegionHealthChecks.Objects[*keyGA] = mock.MockRegionHealthChecks.Obj(&computega.HealthCheck{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRegionHealthChecks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRegionHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRegionHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaRegionHealthChecks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaRegionHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaRegionHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.RegionHealthChecks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRegionHealthChecks().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRegionHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaRegionHealthChecks().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaRegionHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.RegionHealthChecks().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaRegionHealthChecks().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRegionHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaRegionHealthChecks().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaRegionHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.RegionHealthChecks().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionNetworkFirewallPoliciesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRegionNetworkFirewallPolicies().Get(ctx, key); err == nil {
		t.Errorf("AlphaRegionNetworkFirewallPolicies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.FirewallPolicy{}
		if err := mock.AlphaRegionNetworkFirewallPolicies().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRegionNetworkFirewallPolicies().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRegionNetworkFirewallPolicies().Get(ctx, key); err != nil {
		t.Errorf("AlphaRegionNetworkFirewallPolicies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRegionNetworkFirewallPolicies.Objects[*keyAlpha] = mock.MockAlphaRegionNetworkFirewallPolicies.Obj(&computealpha.FirewallPolicy{Name: keyAlpha.Name})
	want := map[string]bool{
		"key-alpha": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRegionNetworkFirewallPolicies().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRegionNetworkFirewallPolicies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRegionNetworkFirewallPolicies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRegionNetworkFirewallPolicies().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRegionNetworkFirewallPolicies().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}

	// Delete not found.
	if err := mock.AlphaRegionNetworkFirewallPolicies().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRegionNetworkFirewallPolicies().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
}

func TestRegionSslCertificatesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRegionSslCertificates().Get(ctx, key); err == nil {
		t.Errorf("AlphaRegionSslCertificates().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaRegionSslCertificates().Get(ctx, key); err == nil {
		t.Errorf("BetaRegionSslCertificates().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.RegionSslCertificates().Get(ctx, key); err == nil {
		t.Errorf("RegionSslCertificates().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.SslCertificate{}
		if err := mock.AlphaRegionSslCertificates().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRegionSslCertificates().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.SslCertificate{}
		if err := mock.BetaRegionSslCertificates().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaRegionSslCertificates().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.SslCertificate{}
		if err := mock.RegionSslCertificates().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionSslCertificates().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRegionSslCertificates().Get(ctx, key); err != nil {
		t.Errorf("AlphaRegionSslCertificates().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaRegionSslCertificates().Get(ctx, key); err != nil {
		t.Errorf("BetaRegionSslCertificates().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.RegionSslCertificates().Get(ctx, key); err != nil {
		t.Errorf("RegionSslCertificates().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRegionSslCertificates.Objects[*keyAlpha] = mock.MockAlphaRegionSslCertificates.Obj(&computealpha.SslCertificate{Name: keyAlpha.Name})
	mock.MockBetaRegionSslCertificates.Objects[*keyBeta] = mock.MockBetaRegionSslCertificates.Obj(&computebeta.SslCertificate{Name: keyBeta.Name})
	mock.MockRegionSslCertificates.Objects[*keyGA] = mock.MockRegionSslCertificates.Obj(&computega.SslCertificate{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRegionSslCertificates().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRegionSslCertificates().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRegionSslCertificates().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaRegionSslCertificates().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaRegionSslCertificates().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaRegionSslCertificates().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.RegionSslCertificates().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionSslCertificates().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionSslCertificates().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRegionSslCertificates().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRegionSslCertificates().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaRegionSslCertificates().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaRegionSslCertificates().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.RegionSslCertificates().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionSslCertificates().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaRegionSslCertificates().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRegionSslCertificates().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaRegionSslCertificates().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaRegionSslCertificates().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.RegionSslCertificates().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionSslCertificates().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionSslPoliciesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.RegionSslPolicies().Get(ctx, key); err == nil {
		t.Errorf("RegionSslPolicies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.SslPolicy{}
		if err := mock.RegionSslPolicies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionSslPolicies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.RegionSslPolicies().Get(ctx, key); err != nil {
		t.Errorf("RegionSslPolicies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockRegionSslPolicies.Objects[*keyGA] = mock.MockRegionSslPolicies.Obj(&computega.SslPolicy{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.

	// Delete across versions.
	if err := mock.RegionSslPolicies().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionSslPolicies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.RegionSslPolicies().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionSslPolicies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionTargetHttpProxiesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRegionTargetHttpProxies().Get(ctx, key); err == nil {
		t.Errorf("AlphaRegionTargetHttpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaRegionTargetHttpProxies().Get(ctx, key); err == nil {
		t.Errorf("BetaRegionTargetHttpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.RegionTargetHttpProxies().Get(ctx, key); err == nil {
		t.Errorf("RegionTargetHttpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.TargetHttpProxy{}
		if err := mock.AlphaRegionTargetHttpProxies().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRegionTargetHttpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.TargetHttpProxy{}
		if err := mock.BetaRegionTargetHttpProxies().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaRegionTargetHttpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.TargetHttpProxy{}
		if err := mock.RegionTargetHttpProxies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionTargetHttpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRegionTargetHttpProxies().Get(ctx, key); err != nil {
		t.Errorf("AlphaRegionTargetHttpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaRegionTargetHttpProxies().Get(ctx, key); err != nil {
		t.Errorf("BetaRegionTargetHttpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.RegionTargetHttpProxies().Get(ctx, key); err != nil {
		t.Errorf("RegionTargetHttpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRegionTargetHttpProxies.Objects[*keyAlpha] = mock.MockAlphaRegionTargetHttpProxies.Obj(&computealpha.TargetHttpProxy{Name: keyAlpha.Name})
	mock.MockBetaRegionTargetHttpProxies.Objects[*keyBeta] = mock.MockBetaRegionTargetHttpProxies.Obj(&computebeta.TargetHttpProxy{Name: keyBeta.Name})
	mock.MockRegionTargetHttpProxies.Objects[*keyGA] = mock.MockRegionTargetHttpProxies.Obj(&computega.TargetHttpProxy{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRegionTargetHttpProxies().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRegionTargetHttpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRegionTargetHttpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaRegionTargetHttpProxies().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaRegionTargetHttpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaRegionTargetHttpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.RegionTargetHttpProxies().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionTargetHttpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionTargetHttpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRegionTargetHttpProxies().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRegionTargetHttpProxies().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaRegionTargetHttpProxies().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaRegionTargetHttpProxies().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.RegionTargetHttpProxies().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionTargetHttpProxies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaRegionTargetHttpProxies().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRegionTargetHttpProxies().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaRegionTargetHttpProxies().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaRegionTargetHttpProxies().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.RegionTargetHttpProxies().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionTargetHttpProxies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionTargetHttpsProxiesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRegionTargetHttpsProxies().Get(ctx, key); err == nil {
		t.Errorf("AlphaRegionTargetHttpsProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaRegionTargetHttpsProxies().Get(ctx, key); err == nil {
		t.Errorf("BetaRegionTargetHttpsProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.RegionTargetHttpsProxies().Get(ctx, key); err == nil {
		t.Errorf("RegionTargetHttpsProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.TargetHttpsProxy{}
		if err := mock.AlphaRegionTargetHttpsProxies().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRegionTargetHttpsProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.TargetHttpsProxy{}
		if err := mock.BetaRegionTargetHttpsProxies().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaRegionTargetHttpsProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.TargetHttpsProxy{}
		if err := mock.RegionTargetHttpsProxies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionTargetHttpsProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRegionTargetHttpsProxies().Get(ctx, key); err != nil {
		t.Errorf("AlphaRegionTargetHttpsProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaRegionTargetHttpsProxies().Get(ctx, key); err != nil {
		t.Errorf("BetaRegionTargetHttpsProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.RegionTargetHttpsProxies().Get(ctx, key); err != nil {
		t.Errorf("RegionTargetHttpsProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRegionTargetHttpsProxies.Objects[*keyAlpha] = mock.MockAlphaRegionTargetHttpsProxies.Obj(&computealpha.TargetHttpsProxy{Name: keyAlpha.Name})
	mock.MockBetaRegionTargetHttpsProxies.Objects[*keyBeta] = mock.MockBetaRegionTargetHttpsProxies.Obj(&computebeta.TargetHttpsProxy{Name: keyBeta.Name})
	mock.MockRegionTargetHttpsProxies.Objects[*keyGA] = mock.MockRegionTargetHttpsProxies.Obj(&computega.TargetHttpsProxy{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRegionTargetHttpsProxies().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRegionTargetHttpsProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRegionTargetHttpsProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaRegionTargetHttpsProxies().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaRegionTargetHttpsProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaRegionTargetHttpsProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.RegionTargetHttpsProxies().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionTargetHttpsProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionTargetHttpsProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRegionTargetHttpsProxies().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRegionTargetHttpsProxies().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaRegionTargetHttpsProxies().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaRegionTargetHttpsProxies().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.RegionTargetHttpsProxies().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionTargetHttpsProxies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaRegionTargetHttpsProxies().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRegionTargetHttpsProxies().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaRegionTargetHttpsProxies().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaRegionTargetHttpsProxies().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.RegionTargetHttpsProxies().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionTargetHttpsProxies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionUrlMapsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRegionUrlMaps().Get(ctx, key); err == nil {
		t.Errorf("AlphaRegionUrlMaps().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaRegionUrlMaps().Get(ctx, key); err == nil {
		t.Errorf("BetaRegionUrlMaps().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.RegionUrlMaps().Get(ctx, key); err == nil {
		t.Errorf("RegionUrlMaps().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.UrlMap{}
		if err := mock.AlphaRegionUrlMaps().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRegionUrlMaps().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.UrlMap{}
		if err := mock.BetaRegionUrlMaps().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaRegionUrlMaps().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.UrlMap{}
		if err := mock.RegionUrlMaps().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionUrlMaps().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRegionUrlMaps().Get(ctx, key); err != nil {
		t.Errorf("AlphaRegionUrlMaps().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaRegionUrlMaps().Get(ctx, key); err != nil {
		t.Errorf("BetaRegionUrlMaps().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.RegionUrlMaps().Get(ctx, key); err != nil {
		t.Errorf("RegionUrlMaps().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRegionUrlMaps.Objects[*keyAlpha] = mock.MockAlphaRegionUrlMaps.Obj(&computealpha.UrlMap{Name: keyAlpha.Name})
	mock.MockBetaRegionUrlMaps.Objects[*keyBeta] = mock.MockBetaRegionUrlMaps.Obj(&computebeta.UrlMap{Name: keyBeta.Name})
	mock.MockRegionUrlMaps.Objects[*keyGA] = mock.MockRegionUrlMaps.Obj(&computega.UrlMap{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRegionUrlMaps().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRegionUrlMaps().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRegionUrlMaps().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaRegionUrlMaps().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaRegionUrlMaps().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaRegionUrlMaps().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.RegionUrlMaps().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionUrlMaps().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionUrlMaps().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRegionUrlMaps().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRegionUrlMaps().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaRegionUrlMaps().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaRegionUrlMaps().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.RegionUrlMaps().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionUrlMaps().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaRegionUrlMaps().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRegionUrlMaps().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaRegionUrlMaps().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaRegionUrlMaps().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.RegionUrlMaps().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionUrlMaps().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Regions().Get(ctx, key); err == nil {
		t.Errorf("Regions().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.

	// Get across versions.

	// List.
	mock.MockRegions.Objects[*keyGA] = mock.MockRegions.Obj(&computega.Region{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Regions().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Regions().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Regions().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.

	// Delete not found.
}

func TestRoutersGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRouters().Get(ctx, key); err == nil {
		t.Errorf("AlphaRouters().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaRouters().Get(ctx, key); err == nil {
		t.Errorf("BetaRouters().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Routers().Get(ctx, key); err == nil {
		t.Errorf("Routers().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.Router{}
		if err := mock.AlphaRouters().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRouters().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.Router{}
		if err := mock.BetaRouters().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaRouters().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.Router{}
		if err := mock.Routers().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Routers().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRouters().Get(ctx, key); err != nil {
		t.Errorf("AlphaRouters().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaRouters().Get(ctx, key); err != nil {
		t.Errorf("BetaRouters().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Routers().Get(ctx, key); err != nil {
		t.Errorf("Routers().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRouters.Objects[*keyAlpha] = mock.MockAlphaRouters.Obj(&computealpha.Router{Name: keyAlpha.Name})
	mock.MockBetaRouters.Objects[*keyBeta] = mock.MockBetaRouters.Obj(&computebeta.Router{Name: keyBeta.Name})
	mock.MockRouters.Objects[*keyGA] = mock.MockRouters.Obj(&computega.Router{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRouters().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRouters().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRouters().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaRouters().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaRouters().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaRouters().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Routers().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("Routers().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Routers().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRouters().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRouters().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaRouters().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaRouters().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Routers().Delete(ctx, keyGA); err != nil {
		t.Errorf("Routers().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaRouters().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRouters().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaRouters().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaRouters().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Routers().Delete(ctx, keyGA); err == nil {
		t.Errorf("Routers().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRoutesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Routes().Get(ctx, key); err == nil {
		t.Errorf("Routes().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.Route{}
		if err := mock.Routes().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Routes().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.Routes().Get(ctx, key); err != nil {
		t.Errorf("Routes().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockRoutes.Objects[*keyGA] = mock.MockRoutes.Obj(&computega.Route{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Routes().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Routes().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Routes().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.Routes().Delete(ctx, keyGA); err != nil {
		t.Errorf("Routes().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.Routes().Delete(ctx, keyGA); err == nil {
		t.Errorf("Routes().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestSecurityPoliciesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.BetaSecurityPolicies().Get(ctx, key); err == nil {
		t.Errorf("BetaSecurityPolicies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computebeta.SecurityPolicy{}
		if err := mock.BetaSecurityPolicies().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaSecurityPolicies().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.BetaSecurityPolicies().Get(ctx, key); err != nil {
		t.Errorf("BetaSecurityPolicies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockBetaSecurityPolicies.Objects[*keyBeta] = mock.MockBetaSecurityPolicies.Obj(&computebeta.SecurityPolicy{Name: keyBeta.Name})
	want := map[string]bool{
		"key-beta": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.BetaSecurityPolicies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaSecurityPolicies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaSecurityPolicies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.BetaSecurityPolicies().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaSecurityPolicies().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}

	// Delete not found.
	if err := mock.BetaSecurityPolicies().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaSecurityPolicies().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
}

func TestServiceAttachmentsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaServiceAttachments().Get(ctx, key); err == nil {
		t.Errorf("AlphaServiceAttachments().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaServiceAttachments().Get(ctx, key); err == nil {
		t.Errorf("BetaServiceAttachments().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.ServiceAttachments().Get(ctx, key); err == nil {
		t.Errorf("ServiceAttachments().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.ServiceAttachment{}
		if err := mock.AlphaServiceAttachments().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaServiceAttachments().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.ServiceAttachment{}
		if err := mock.BetaServiceAttachments().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaServiceAttachments().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.ServiceAttachment{}
		if err := mock.ServiceAttachments().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("ServiceAttachments().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaServiceAttachments().Get(ctx, key); err != nil {
		t.Errorf("AlphaServiceAttachments().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaServiceAttachments().Get(ctx, key); err != nil {
		t.Errorf("BetaServiceAttachments().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.ServiceAttachments().Get(ctx, key); err != nil {
		t.Errorf("ServiceAttachments().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaServiceAttachments.Objects[*keyAlpha] = mock.MockAlphaServiceAttachments.Obj(&computealpha.ServiceAttachment{Name: keyAlpha.Name})
	mock.MockBetaServiceAttachments.Objects[*keyBeta] = mock.MockBetaServiceAttachments.Obj(&computebeta.ServiceAttachment{Name: keyBeta.Name})
	mock.MockServiceAttachments.Objects[*keyGA] = mock.MockServiceAttachments.Obj(&computega.ServiceAttachment{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaServiceAttachments().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaServiceAttachments().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaServiceAttachments().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaServiceAttachments().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaServiceAttachments().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaServiceAttachments().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.ServiceAttachments().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("ServiceAttachments().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("ServiceAttachments().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaServiceAttachments().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaServiceAttachments().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaServiceAttachments().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaServiceAttachments().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.ServiceAttachments().Delete(ctx, keyGA); err != nil {
		t.Errorf("ServiceAttachments().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaServiceAttachments().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaServiceAttachments().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaServiceAttachments().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaServiceAttachments().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.ServiceAttachments().Delete(ctx, keyGA); err == nil {
		t.Errorf("ServiceAttachments().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestSslCertificatesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaSslCertificates().Get(ctx, key); err == nil {
		t.Errorf("AlphaSslCertificates().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaSslCertificates().Get(ctx, key); err == nil {
		t.Errorf("BetaSslCertificates().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.SslCertificates().Get(ctx, key); err == nil {
		t.Errorf("SslCertificates().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.SslCertificate{}
		if err := mock.AlphaSslCertificates().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaSslCertificates().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.SslCertificate{}
		if err := mock.BetaSslCertificates().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaSslCertificates().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.SslCertificate{}
		if err := mock.SslCertificates().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("SslCertificates().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaSslCertificates().Get(ctx, key); err != nil {
		t.Errorf("AlphaSslCertificates().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaSslCertificates().Get(ctx, key); err != nil {
		t.Errorf("BetaSslCertificates().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.SslCertificates().Get(ctx, key); err != nil {
		t.Errorf("SslCertificates().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaSslCertificates.Objects[*keyAlpha] = mock.MockAlphaSslCertificates.Obj(&computealpha.SslCertificate{Name: keyAlpha.Name})
	mock.MockBetaSslCertificates.Objects[*keyBeta] = mock.MockBetaSslCertificates.Obj(&computebeta.SslCertificate{Name: keyBeta.Name})
	mock.MockSslCertificates.Objects[*keyGA] = mock.MockSslCertificates.Obj(&computega.SslCertificate{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaSslCertificates().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaSslCertificates().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaSslCertificates().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaSslCertificates().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaSslCertificates().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaSslCertificates().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.SslCertificates().List(ctx, filter.None)
		if err != nil {
			t.Errorf("SslCertificates().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("SslCertificates().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaSslCertificates().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaSslCertificates().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaSslCertificates().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaSslCertificates().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.SslCertificates().Delete(ctx, keyGA); err != nil {
		t.Errorf("SslCertificates().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaSslCertificates().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaSslCertificates().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaSslCertificates().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaSslCertificates().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.SslCertificates().Delete(ctx, keyGA); err == nil {
		t.Errorf("SslCertificates().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestSslPoliciesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.SslPolicies().Get(ctx, key); err == nil {
		t.Errorf("SslPolicies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.SslPolicy{}
		if err := mock.SslPolicies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("SslPolicies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.SslPolicies().Get(ctx, key); err != nil {
		t.Errorf("SslPolicies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockSslPolicies.Objects[*keyGA] = mock.MockSslPolicies.Obj(&computega.SslPolicy{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.

	// Delete across versions.
	if err := mock.SslPolicies().Delete(ctx, keyGA); err != nil {
		t.Errorf("SslPolicies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.SslPolicies().Delete(ctx, keyGA); err == nil {
		t.Errorf("SslPolicies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestSubnetworksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaSubnetworks().Get(ctx, key); err == nil {
		t.Errorf("AlphaSubnetworks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaSubnetworks().Get(ctx, key); err == nil {
		t.Errorf("BetaSubnetworks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Subnetworks().Get(ctx, key); err == nil {
		t.Errorf("Subnetworks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.Subnetwork{}
		if err := mock.AlphaSubnetworks().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaSubnetworks().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.Subnetwork{}
		if err := mock.BetaSubnetworks().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaSubnetworks().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.Subnetwork{}
		if err := mock.Subnetworks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Subnetworks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaSubnetworks().Get(ctx, key); err != nil {
		t.Errorf("AlphaSubnetworks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaSubnetworks().Get(ctx, key); err != nil {
		t.Errorf("BetaSubnetworks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Subnetworks().Get(ctx, key); err != nil {
		t.Errorf("Subnetworks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaSubnetworks.Objects[*keyAlpha] = mock.MockAlphaSubnetworks.Obj(&computealpha.Subnetwork{Name: keyAlpha.Name})
	mock.MockBetaSubnetworks.Objects[*keyBeta] = mock.MockBetaSubnetworks.Obj(&computebeta.Subnetwork{Name: keyBeta.Name})
	mock.MockSubnetworks.Objects[*keyGA] = mock.MockSubnetworks.Obj(&computega.Subnetwork{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaSubnetworks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaSubnetworks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaSubnetworks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaSubnetworks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaSubnetworks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaSubnetworks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Subnetworks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("Subnetworks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Subnetworks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaSubnetworks().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaSubnetworks().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaSubnetworks().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaSubnetworks().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Subnetworks().Delete(ctx, keyGA); err != nil {
		t.Errorf("Subnetworks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaSubnetworks().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaSubnetworks().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaSubnetworks().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaSubnetworks().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Subnetworks().Delete(ctx, keyGA); err == nil {
		t.Errorf("Subnetworks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestTargetHttpProxiesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaTargetHttpProxies().Get(ctx, key); err == nil {
		t.Errorf("AlphaTargetHttpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaTargetHttpProxies().Get(ctx, key); err == nil {
		t.Errorf("BetaTargetHttpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.TargetHttpProxies().Get(ctx, key); err == nil {
		t.Errorf("TargetHttpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.TargetHttpProxy{}
		if err := mock.AlphaTargetHttpProxies().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaTargetHttpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.TargetHttpProxy{}
		if err := mock.BetaTargetHttpProxies().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaTargetHttpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.TargetHttpProxy{}
		if err := mock.TargetHttpProxies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("TargetHttpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaTargetHttpProxies().Get(ctx, key); err != nil {
		t.Errorf("AlphaTargetHttpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaTargetHttpProxies().Get(ctx, key); err != nil {
		t.Errorf("BetaTargetHttpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.TargetHttpProxies().Get(ctx, key); err != nil {
		t.Errorf("TargetHttpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaTargetHttpProxies.Objects[*keyAlpha] = mock.MockAlphaTargetHttpProxies.Obj(&computealpha.TargetHttpProxy{Name: keyAlpha.Name})
	mock.MockBetaTargetHttpProxies.Objects[*keyBeta] = mock.MockBetaTargetHttpProxies.Obj(&computebeta.TargetHttpProxy{Name: keyBeta.Name})
	mock.MockTargetHttpProxies.Objects[*keyGA] = mock.MockTargetHttpProxies.Obj(&computega.TargetHttpProxy{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaTargetHttpProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaTargetHttpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaTargetHttpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaTargetHttpProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaTargetHttpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaTargetHttpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.TargetHttpProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("TargetHttpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("TargetHttpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaTargetHttpProxies().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaTargetHttpProxies().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaTargetHttpProxies().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaTargetHttpProxies().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.TargetHttpProxies().Delete(ctx, keyGA); err != nil {
		t.Errorf("TargetHttpProxies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaTargetHttpProxies().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaTargetHttpProxies().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaTargetHttpProxies().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaTargetHttpProxies().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.TargetHttpProxies().Delete(ctx, keyGA); err == nil {
		t.Errorf("TargetHttpProxies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestTargetHttpsProxiesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaTargetHttpsProxies().Get(ctx, key); err == nil {
		t.Errorf("AlphaTargetHttpsProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaTargetHttpsProxies().Get(ctx, key); err == nil {
		t.Errorf("BetaTargetHttpsProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.TargetHttpsProxies().Get(ctx, key); err == nil {
		t.Errorf("TargetHttpsProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.TargetHttpsProxy{}
		if err := mock.AlphaTargetHttpsProxies().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaTargetHttpsProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.TargetHttpsProxy{}
		if err := mock.BetaTargetHttpsProxies().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaTargetHttpsProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.TargetHttpsProxy{}
		if err := mock.TargetHttpsProxies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("TargetHttpsProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaTargetHttpsProxies().Get(ctx, key); err != nil {
		t.Errorf("AlphaTargetHttpsProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaTargetHttpsProxies().Get(ctx, key); err != nil {
		t.Errorf("BetaTargetHttpsProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.TargetHttpsProxies().Get(ctx, key); err != nil {
		t.Errorf("TargetHttpsProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaTargetHttpsProxies.Objects[*keyAlpha] = mock.MockAlphaTargetHttpsProxies.Obj(&computealpha.TargetHttpsProxy{Name: keyAlpha.Name})
	mock.MockBetaTargetHttpsProxies.Objects[*keyBeta] = mock.MockBetaTargetHttpsProxies.Obj(&computebeta.TargetHttpsProxy{Name: keyBeta.Name})
	mock.MockTargetHttpsProxies.Objects[*keyGA] = mock.MockTargetHttpsProxies.Obj(&computega.TargetHttpsProxy{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaTargetHttpsProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaTargetHttpsProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaTargetHttpsProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaTargetHttpsProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaTargetHttpsProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaTargetHttpsProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.TargetHttpsProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("TargetHttpsProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("TargetHttpsProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaTargetHttpsProxies().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaTargetHttpsProxies().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaTargetHttpsProxies().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaTargetHttpsProxies().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.TargetHttpsProxies().Delete(ctx, keyGA); err != nil {
		t.Errorf("TargetHttpsProxies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaTargetHttpsProxies().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaTargetHttpsProxies().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaTargetHttpsProxies().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaTargetHttpsProxies().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.TargetHttpsProxies().Delete(ctx, keyGA); err == nil {
		t.Errorf("TargetHttpsProxies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestTargetPoolsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.TargetPools().Get(ctx, key); err == nil {
		t.Errorf("TargetPools().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computega.TargetPool{}
		if err := mock.TargetPools().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("TargetPools().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.TargetPools().Get(ctx, key); err != nil {
		t.Errorf("TargetPools().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockTargetPools.Objects[*keyGA] = mock.MockTargetPools.Obj(&computega.TargetPool{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.TargetPools().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("TargetPools().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("TargetPools().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.TargetPools().Delete(ctx, keyGA); err != nil {
		t.Errorf("TargetPools().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.TargetPools().Delete(ctx, keyGA); err == nil {
		t.Errorf("TargetPools().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestTargetTcpProxiesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaTargetTcpProxies().Get(ctx, key); err == nil {
		t.Errorf("AlphaTargetTcpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaTargetTcpProxies().Get(ctx, key); err == nil {
		t.Errorf("BetaTargetTcpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.TargetTcpProxies().Get(ctx, key); err == nil {
		t.Errorf("TargetTcpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.TargetTcpProxy{}
		if err := mock.AlphaTargetTcpProxies().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaTargetTcpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.TargetTcpProxy{}
		if err := mock.BetaTargetTcpProxies().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaTargetTcpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.TargetTcpProxy{}
		if err := mock.TargetTcpProxies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("TargetTcpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaTargetTcpProxies().Get(ctx, key); err != nil {
		t.Errorf("AlphaTargetTcpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaTargetTcpProxies().Get(ctx, key); err != nil {
		t.Errorf("BetaTargetTcpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.TargetTcpProxies().Get(ctx, key); err != nil {
		t.Errorf("TargetTcpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaTargetTcpProxies.Objects[*keyAlpha] = mock.MockAlphaTargetTcpProxies.Obj(&computealpha.TargetTcpProxy{Name: keyAlpha.Name})
	mock.MockBetaTargetTcpProxies.Objects[*keyBeta] = mock.MockBetaTargetTcpProxies.Obj(&computebeta.TargetTcpProxy{Name: keyBeta.Name})
	mock.MockTargetTcpProxies.Objects[*keyGA] = mock.MockTargetTcpProxies.Obj(&computega.TargetTcpProxy{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaTargetTcpProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaTargetTcpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaTargetTcpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaTargetTcpProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaTargetTcpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaTargetTcpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.TargetTcpProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("TargetTcpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("TargetTcpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaTargetTcpProxies().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaTargetTcpProxies().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaTargetTcpProxies().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaTargetTcpProxies().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.TargetTcpProxies().Delete(ctx, keyGA); err != nil {
		t.Errorf("TargetTcpProxies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaTargetTcpProxies().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaTargetTcpProxies().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaTargetTcpProxies().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaTargetTcpProxies().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.TargetTcpProxies().Delete(ctx, keyGA); err == nil {
		t.Errorf("TargetTcpProxies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestTcpRoutesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.BetaTcpRoutes().Get(ctx, key); err == nil {
		t.Errorf("BetaTcpRoutes().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.TcpRoutes().Get(ctx, key); err == nil {
		t.Errorf("TcpRoutes().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &networkservicesbeta.TcpRoute{}
		if err := mock.BetaTcpRoutes().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaTcpRoutes().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &networkservicesga.TcpRoute{}
		if err := mock.TcpRoutes().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("TcpRoutes().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.BetaTcpRoutes().Get(ctx, key); err != nil {
		t.Errorf("BetaTcpRoutes().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.TcpRoutes().Get(ctx, key); err != nil {
		t.Errorf("TcpRoutes().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockBetaTcpRoutes.Objects[*keyBeta] = mock.MockBetaTcpRoutes.Obj(&networkservicesbeta.TcpRoute{Name: keyBeta.Name})
	mock.MockTcpRoutes.Objects[*keyGA] = mock.MockTcpRoutes.Obj(&networkservicesga.TcpRoute{Name: keyGA.Name})
	want := map[string]bool{
		"key-beta": true,
		"key-ga":   true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.BetaTcpRoutes().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaTcpRoutes().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaTcpRoutes().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.TcpRoutes().List(ctx, filter.None)
		if err != nil {
			t.Errorf("TcpRoutes().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("TcpRoutes().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.BetaTcpRoutes().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaTcpRoutes().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.TcpRoutes().Delete(ctx, keyGA); err != nil {
		t.Errorf("TcpRoutes().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.BetaTcpRoutes().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaTcpRoutes().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.TcpRoutes().Delete(ctx, keyGA); err == nil {
		t.Errorf("TcpRoutes().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestUrlMapsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaUrlMaps().Get(ctx, key); err == nil {
		t.Errorf("AlphaUrlMaps().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaUrlMaps().Get(ctx, key); err == nil {
		t.Errorf("BetaUrlMaps().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.UrlMaps().Get(ctx, key); err == nil {
		t.Errorf("UrlMaps().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &computealpha.UrlMap{}
		if err := mock.AlphaUrlMaps().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaUrlMaps().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &computebeta.UrlMap{}
		if err := mock.BetaUrlMaps().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaUrlMaps().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &computega.UrlMap{}
		if err := mock.UrlMaps().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("UrlMaps().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaUrlMaps().Get(ctx, key); err != nil {
		t.Errorf("AlphaUrlMaps().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaUrlMaps().Get(ctx, key); err != nil {
		t.Errorf("BetaUrlMaps().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.UrlMaps().Get(ctx, key); err != nil {
		t.Errorf("UrlMaps().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaUrlMaps.Objects[*keyAlpha] = mock.MockAlphaUrlMaps.Obj(&computealpha.UrlMap{Name: keyAlpha.Name})
	mock.MockBetaUrlMaps.Objects[*keyBeta] = mock.MockBetaUrlMaps.Obj(&computebeta.UrlMap{Name: keyBeta.Name})
	mock.MockUrlMaps.Objects[*keyGA] = mock.MockUrlMaps.Obj(&computega.UrlMap{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaUrlMaps().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaUrlMaps().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaUrlMaps().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaUrlMaps().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaUrlMaps().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaUrlMaps().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.UrlMaps().List(ctx, filter.None)
		if err != nil {
			t.Errorf("UrlMaps().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("UrlMaps().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaUrlMaps().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaUrlMaps().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaUrlMaps().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaUrlMaps().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.UrlMaps().Delete(ctx, keyGA); err != nil {
		t.Errorf("UrlMaps().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaUrlMaps().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaUrlMaps().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaUrlMaps().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaUrlMaps().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.UrlMaps().Delete(ctx, keyGA); err == nil {
		t.Errorf("UrlMaps().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestZonesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Zones().Get(ctx, key); err == nil {
		t.Errorf("Zones().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.

	// Get across versions.

	// List.
	mock.MockZones.Objects[*keyGA] = mock.MockZones.Obj(&computega.Zone{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Zones().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Zones().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Zones().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.

	// Delete not found.
}

func TestResourceIDConversion(t *testing.T) {
	t.Parallel()

	for _, id := range []*ResourceID{
		NewAddressesResourceID("some-project", "us-central1", "my-addresses-resource"),
		NewBackendServicesResourceID("some-project", "my-backendServices-resource"),
		NewDisksResourceID("some-project", "us-east1-b", "my-disks-resource"),
		NewFirewallsResourceID("some-project", "my-firewalls-resource"),
		NewForwardingRulesResourceID("some-project", "us-central1", "my-forwardingRules-resource"),
		NewGlobalAddressesResourceID("some-project", "my-addresses-resource"),
		NewGlobalForwardingRulesResourceID("some-project", "my-forwardingRules-resource"),
		NewGlobalNetworkEndpointGroupsResourceID("some-project", "my-networkEndpointGroups-resource"),
		NewHealthChecksResourceID("some-project", "my-healthChecks-resource"),
		NewHttpHealthChecksResourceID("some-project", "my-httpHealthChecks-resource"),
		NewHttpsHealthChecksResourceID("some-project", "my-httpsHealthChecks-resource"),
		NewImagesResourceID("some-project", "my-Images-resource"),
		NewInstanceGroupManagersResourceID("some-project", "us-east1-b", "my-instanceGroupManagers-resource"),
		NewInstanceGroupsResourceID("some-project", "us-east1-b", "my-instanceGroups-resource"),
		NewInstanceTemplatesResourceID("some-project", "my-instanceTemplates-resource"),
		NewInstancesResourceID("some-project", "us-east1-b", "my-instances-resource"),
		NewMeshesResourceID("some-project", "my-meshes-resource"),
		NewNetworkEndpointGroupsResourceID("some-project", "us-east1-b", "my-networkEndpointGroups-resource"),
		NewNetworkFirewallPoliciesResourceID("some-project", "my-networkFirewallPolicies-resource"),
		NewNetworksResourceID("some-project", "my-networks-resource"),
		NewProjectsResourceID("my-projects-resource"),
		NewRegionBackendServicesResourceID("some-project", "us-central1", "my-backendServices-resource"),
		NewRegionDisksResourceID("some-project", "us-central1", "my-disks-resource"),
		NewRegionHealthChecksResourceID("some-project", "us-central1", "my-healthChecks-resource"),
		NewRegionNetworkFirewallPoliciesResourceID("some-project", "us-central1", "my-regionNetworkFirewallPolicies-resource"),
		NewRegionSslCertificatesResourceID("some-project", "us-central1", "my-sslCertificates-resource"),
		NewRegionSslPoliciesResourceID("some-project", "us-central1", "my-sslPolicies-resource"),
		NewRegionTargetHttpProxiesResourceID("some-project", "us-central1", "my-targetHttpProxies-resource"),
		NewRegionTargetHttpsProxiesResourceID("some-project", "us-central1", "my-targetHttpsProxies-resource"),
		NewRegionUrlMapsResourceID("some-project", "us-central1", "my-urlMaps-resource"),
		NewRegionsResourceID("some-project", "my-regions-resource"),
		NewRoutersResourceID("some-project", "us-central1", "my-routers-resource"),
		NewRoutesResourceID("some-project", "my-routes-resource"),
		NewSecurityPoliciesResourceID("some-project", "my-securityPolicies-resource"),
		NewServiceAttachmentsResourceID("some-project", "us-central1", "my-serviceAttachments-resource"),
		NewSslCertificatesResourceID("some-project", "my-sslCertificates-resource"),
		NewSslPoliciesResourceID("some-project", "my-sslPolicies-resource"),
		NewSubnetworksResourceID("some-project", "us-central1", "my-subnetworks-resource"),
		NewTargetHttpProxiesResourceID("some-project", "my-targetHttpProxies-resource"),
		NewTargetHttpsProxiesResourceID("some-project", "my-targetHttpsProxies-resource"),
		NewTargetPoolsResourceID("some-project", "us-central1", "my-targetPools-resource"),
		NewTargetTcpProxiesResourceID("some-project", "my-targetTcpProxies-resource"),
		NewTcpRoutesResourceID("some-project", "my-tcpRoutes-resource"),
		NewUrlMapsResourceID("some-project", "my-urlMaps-resource"),
		NewZonesResourceID("some-project", "my-zones-resource"),
	} {
		t.Run(id.Resource, func(t *testing.T) {
			// Test conversion to and from full URL.
			fullURL := id.SelfLink(meta.VersionGA)
			parsedID, err := ParseResourceURL(fullURL)
			if err != nil {
				t.Errorf("ParseResourceURL(%s) = _, %v, want nil", fullURL, err)
			}
			if !reflect.DeepEqual(id, parsedID) {
				t.Errorf("id.SelfLink(%+v) -> ParseResourceURL(%s) = %+v, want original ID", id, fullURL, parsedID)
			}

			// Note that when the NetworkServices API Group was added it meant
			// that the partial paths returned from the functions below that
			// exclude API Group can't be round tripped.

			// Test conversion to relative resource name.
			relativeName := id.RelativeResourceName()
			_, err = ParseResourceURL(relativeName)
			if err != nil {
				t.Errorf("ParseResourceURL(%s) = _, %v, want nil", relativeName, err)
			}

			// Do not test ResourcePath for projects.
			if id.Resource == "projects" {
				return
			}

			// Test conversion to resource path.
			resourcePath := id.ResourcePath()
			_, err = ParseResourceURL(resourcePath)
			if err != nil {
				t.Errorf("ParseResourceURL(%s) = _, %v, want nil", resourcePath, err)
			}
		})
	}
}
