// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/datastore/v1/datastore.proto

package datastorepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Datastore_Lookup_FullMethodName              = "/google.datastore.v1.Datastore/Lookup"
	Datastore_RunQuery_FullMethodName            = "/google.datastore.v1.Datastore/RunQuery"
	Datastore_RunAggregationQuery_FullMethodName = "/google.datastore.v1.Datastore/RunAggregationQuery"
	Datastore_BeginTransaction_FullMethodName    = "/google.datastore.v1.Datastore/BeginTransaction"
	Datastore_Commit_FullMethodName              = "/google.datastore.v1.Datastore/Commit"
	Datastore_Rollback_FullMethodName            = "/google.datastore.v1.Datastore/Rollback"
	Datastore_AllocateIds_FullMethodName         = "/google.datastore.v1.Datastore/AllocateIds"
	Datastore_ReserveIds_FullMethodName          = "/google.datastore.v1.Datastore/ReserveIds"
)

// DatastoreClient is the client API for Datastore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DatastoreClient interface {
	// Looks up entities by key.
	Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error)
	// Runs an aggregation query.
	RunAggregationQuery(ctx context.Context, in *RunAggregationQueryRequest, opts ...grpc.CallOption) (*RunAggregationQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error)
	// Prevents the supplied keys' IDs from being auto-allocated by Cloud
	// Datastore.
	ReserveIds(ctx context.Context, in *ReserveIdsRequest, opts ...grpc.CallOption) (*ReserveIdsResponse, error)
}

type datastoreClient struct {
	cc grpc.ClientConnInterface
}

func NewDatastoreClient(cc grpc.ClientConnInterface) DatastoreClient {
	return &datastoreClient{cc}
}

func (c *datastoreClient) Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error) {
	out := new(LookupResponse)
	err := c.cc.Invoke(ctx, Datastore_Lookup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error) {
	out := new(RunQueryResponse)
	err := c.cc.Invoke(ctx, Datastore_RunQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) RunAggregationQuery(ctx context.Context, in *RunAggregationQueryRequest, opts ...grpc.CallOption) (*RunAggregationQueryResponse, error) {
	out := new(RunAggregationQueryResponse)
	err := c.cc.Invoke(ctx, Datastore_RunAggregationQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := c.cc.Invoke(ctx, Datastore_BeginTransaction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, Datastore_Commit_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error) {
	out := new(RollbackResponse)
	err := c.cc.Invoke(ctx, Datastore_Rollback_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error) {
	out := new(AllocateIdsResponse)
	err := c.cc.Invoke(ctx, Datastore_AllocateIds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) ReserveIds(ctx context.Context, in *ReserveIdsRequest, opts ...grpc.CallOption) (*ReserveIdsResponse, error) {
	out := new(ReserveIdsResponse)
	err := c.cc.Invoke(ctx, Datastore_ReserveIds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatastoreServer is the server API for Datastore service.
// All implementations should embed UnimplementedDatastoreServer
// for forward compatibility
type DatastoreServer interface {
	// Looks up entities by key.
	Lookup(context.Context, *LookupRequest) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(context.Context, *RunQueryRequest) (*RunQueryResponse, error)
	// Runs an aggregation query.
	RunAggregationQuery(context.Context, *RunAggregationQueryRequest) (*RunAggregationQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(context.Context, *AllocateIdsRequest) (*AllocateIdsResponse, error)
	// Prevents the supplied keys' IDs from being auto-allocated by Cloud
	// Datastore.
	ReserveIds(context.Context, *ReserveIdsRequest) (*ReserveIdsResponse, error)
}

// UnimplementedDatastoreServer should be embedded to have forward compatible implementations.
type UnimplementedDatastoreServer struct {
}

func (UnimplementedDatastoreServer) Lookup(context.Context, *LookupRequest) (*LookupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Lookup not implemented")
}
func (UnimplementedDatastoreServer) RunQuery(context.Context, *RunQueryRequest) (*RunQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunQuery not implemented")
}
func (UnimplementedDatastoreServer) RunAggregationQuery(context.Context, *RunAggregationQueryRequest) (*RunAggregationQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunAggregationQuery not implemented")
}
func (UnimplementedDatastoreServer) BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BeginTransaction not implemented")
}
func (UnimplementedDatastoreServer) Commit(context.Context, *CommitRequest) (*CommitResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (UnimplementedDatastoreServer) Rollback(context.Context, *RollbackRequest) (*RollbackResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rollback not implemented")
}
func (UnimplementedDatastoreServer) AllocateIds(context.Context, *AllocateIdsRequest) (*AllocateIdsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AllocateIds not implemented")
}
func (UnimplementedDatastoreServer) ReserveIds(context.Context, *ReserveIdsRequest) (*ReserveIdsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReserveIds not implemented")
}

// UnsafeDatastoreServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DatastoreServer will
// result in compilation errors.
type UnsafeDatastoreServer interface {
	mustEmbedUnimplementedDatastoreServer()
}

func RegisterDatastoreServer(s grpc.ServiceRegistrar, srv DatastoreServer) {
	s.RegisterService(&Datastore_ServiceDesc, srv)
}

func _Datastore_Lookup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Lookup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastore_Lookup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Lookup(ctx, req.(*LookupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_RunQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).RunQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastore_RunQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).RunQuery(ctx, req.(*RunQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_RunAggregationQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAggregationQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).RunAggregationQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastore_RunAggregationQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).RunAggregationQuery(ctx, req.(*RunAggregationQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastore_BeginTransaction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastore_Commit_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastore_Rollback_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_AllocateIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocateIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).AllocateIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastore_AllocateIds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).AllocateIds(ctx, req.(*AllocateIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_ReserveIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReserveIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).ReserveIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastore_ReserveIds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).ReserveIds(ctx, req.(*ReserveIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Datastore_ServiceDesc is the grpc.ServiceDesc for Datastore service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Datastore_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.v1.Datastore",
	HandlerType: (*DatastoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Lookup",
			Handler:    _Datastore_Lookup_Handler,
		},
		{
			MethodName: "RunQuery",
			Handler:    _Datastore_RunQuery_Handler,
		},
		{
			MethodName: "RunAggregationQuery",
			Handler:    _Datastore_RunAggregationQuery_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Datastore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Datastore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Datastore_Rollback_Handler,
		},
		{
			MethodName: "AllocateIds",
			Handler:    _Datastore_AllocateIds_Handler,
		},
		{
			MethodName: "ReserveIds",
			Handler:    _Datastore_ReserveIds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/datastore/v1/datastore.proto",
}
