// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestKeyValueAndUnit_MoveTo(t *testing.T) {
	ms := generateTestKeyValueAndUnit()
	dest := NewKeyValueAndUnit()
	ms.MoveTo(dest)
	assert.Equal(t, NewKeyValueAndUnit(), ms)
	assert.Equal(t, generateTestKeyValueAndUnit(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestKeyValueAndUnit(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newKeyValueAndUnit(internal.NewKeyValueAndUnit(), sharedState)) })
	assert.Panics(t, func() { newKeyValueAndUnit(internal.NewKeyValueAndUnit(), sharedState).MoveTo(dest) })
}

func TestKeyValueAndUnit_CopyTo(t *testing.T) {
	ms := NewKeyValueAndUnit()
	orig := NewKeyValueAndUnit()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestKeyValueAndUnit()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newKeyValueAndUnit(internal.NewKeyValueAndUnit(), sharedState)) })
}

func TestKeyValueAndUnit_KeyStrindex(t *testing.T) {
	ms := NewKeyValueAndUnit()
	assert.Equal(t, int32(0), ms.KeyStrindex())
	ms.SetKeyStrindex(int32(13))
	assert.Equal(t, int32(13), ms.KeyStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newKeyValueAndUnit(internal.NewKeyValueAndUnit(), sharedState).SetKeyStrindex(int32(13)) })
}

func TestKeyValueAndUnit_Value(t *testing.T) {
	ms := NewKeyValueAndUnit()
	assert.Equal(t, pcommon.NewValueEmpty(), ms.Value())
	ms.orig.Value = *internal.GenTestAnyValue()
	assert.Equal(t, pcommon.Value(internal.GenTestValueWrapper()), ms.Value())
}

func TestKeyValueAndUnit_UnitStrindex(t *testing.T) {
	ms := NewKeyValueAndUnit()
	assert.Equal(t, int32(0), ms.UnitStrindex())
	ms.SetUnitStrindex(int32(13))
	assert.Equal(t, int32(13), ms.UnitStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newKeyValueAndUnit(internal.NewKeyValueAndUnit(), sharedState).SetUnitStrindex(int32(13)) })
}

func generateTestKeyValueAndUnit() KeyValueAndUnit {
	return newKeyValueAndUnit(internal.GenTestKeyValueAndUnit(), internal.NewState())
}
