// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataform/v1beta1/dataform.proto

package dataformpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Dataform_ListRepositories_FullMethodName                   = "/google.cloud.dataform.v1beta1.Dataform/ListRepositories"
	Dataform_GetRepository_FullMethodName                      = "/google.cloud.dataform.v1beta1.Dataform/GetRepository"
	Dataform_CreateRepository_FullMethodName                   = "/google.cloud.dataform.v1beta1.Dataform/CreateRepository"
	Dataform_UpdateRepository_FullMethodName                   = "/google.cloud.dataform.v1beta1.Dataform/UpdateRepository"
	Dataform_DeleteRepository_FullMethodName                   = "/google.cloud.dataform.v1beta1.Dataform/DeleteRepository"
	Dataform_CommitRepositoryChanges_FullMethodName            = "/google.cloud.dataform.v1beta1.Dataform/CommitRepositoryChanges"
	Dataform_ReadRepositoryFile_FullMethodName                 = "/google.cloud.dataform.v1beta1.Dataform/ReadRepositoryFile"
	Dataform_QueryRepositoryDirectoryContents_FullMethodName   = "/google.cloud.dataform.v1beta1.Dataform/QueryRepositoryDirectoryContents"
	Dataform_FetchRepositoryHistory_FullMethodName             = "/google.cloud.dataform.v1beta1.Dataform/FetchRepositoryHistory"
	Dataform_ComputeRepositoryAccessTokenStatus_FullMethodName = "/google.cloud.dataform.v1beta1.Dataform/ComputeRepositoryAccessTokenStatus"
	Dataform_FetchRemoteBranches_FullMethodName                = "/google.cloud.dataform.v1beta1.Dataform/FetchRemoteBranches"
	Dataform_ListWorkspaces_FullMethodName                     = "/google.cloud.dataform.v1beta1.Dataform/ListWorkspaces"
	Dataform_GetWorkspace_FullMethodName                       = "/google.cloud.dataform.v1beta1.Dataform/GetWorkspace"
	Dataform_CreateWorkspace_FullMethodName                    = "/google.cloud.dataform.v1beta1.Dataform/CreateWorkspace"
	Dataform_DeleteWorkspace_FullMethodName                    = "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkspace"
	Dataform_InstallNpmPackages_FullMethodName                 = "/google.cloud.dataform.v1beta1.Dataform/InstallNpmPackages"
	Dataform_PullGitCommits_FullMethodName                     = "/google.cloud.dataform.v1beta1.Dataform/PullGitCommits"
	Dataform_PushGitCommits_FullMethodName                     = "/google.cloud.dataform.v1beta1.Dataform/PushGitCommits"
	Dataform_FetchFileGitStatuses_FullMethodName               = "/google.cloud.dataform.v1beta1.Dataform/FetchFileGitStatuses"
	Dataform_FetchGitAheadBehind_FullMethodName                = "/google.cloud.dataform.v1beta1.Dataform/FetchGitAheadBehind"
	Dataform_CommitWorkspaceChanges_FullMethodName             = "/google.cloud.dataform.v1beta1.Dataform/CommitWorkspaceChanges"
	Dataform_ResetWorkspaceChanges_FullMethodName              = "/google.cloud.dataform.v1beta1.Dataform/ResetWorkspaceChanges"
	Dataform_FetchFileDiff_FullMethodName                      = "/google.cloud.dataform.v1beta1.Dataform/FetchFileDiff"
	Dataform_QueryDirectoryContents_FullMethodName             = "/google.cloud.dataform.v1beta1.Dataform/QueryDirectoryContents"
	Dataform_SearchFiles_FullMethodName                        = "/google.cloud.dataform.v1beta1.Dataform/SearchFiles"
	Dataform_MakeDirectory_FullMethodName                      = "/google.cloud.dataform.v1beta1.Dataform/MakeDirectory"
	Dataform_RemoveDirectory_FullMethodName                    = "/google.cloud.dataform.v1beta1.Dataform/RemoveDirectory"
	Dataform_MoveDirectory_FullMethodName                      = "/google.cloud.dataform.v1beta1.Dataform/MoveDirectory"
	Dataform_ReadFile_FullMethodName                           = "/google.cloud.dataform.v1beta1.Dataform/ReadFile"
	Dataform_RemoveFile_FullMethodName                         = "/google.cloud.dataform.v1beta1.Dataform/RemoveFile"
	Dataform_MoveFile_FullMethodName                           = "/google.cloud.dataform.v1beta1.Dataform/MoveFile"
	Dataform_WriteFile_FullMethodName                          = "/google.cloud.dataform.v1beta1.Dataform/WriteFile"
	Dataform_ListReleaseConfigs_FullMethodName                 = "/google.cloud.dataform.v1beta1.Dataform/ListReleaseConfigs"
	Dataform_GetReleaseConfig_FullMethodName                   = "/google.cloud.dataform.v1beta1.Dataform/GetReleaseConfig"
	Dataform_CreateReleaseConfig_FullMethodName                = "/google.cloud.dataform.v1beta1.Dataform/CreateReleaseConfig"
	Dataform_UpdateReleaseConfig_FullMethodName                = "/google.cloud.dataform.v1beta1.Dataform/UpdateReleaseConfig"
	Dataform_DeleteReleaseConfig_FullMethodName                = "/google.cloud.dataform.v1beta1.Dataform/DeleteReleaseConfig"
	Dataform_ListCompilationResults_FullMethodName             = "/google.cloud.dataform.v1beta1.Dataform/ListCompilationResults"
	Dataform_GetCompilationResult_FullMethodName               = "/google.cloud.dataform.v1beta1.Dataform/GetCompilationResult"
	Dataform_CreateCompilationResult_FullMethodName            = "/google.cloud.dataform.v1beta1.Dataform/CreateCompilationResult"
	Dataform_QueryCompilationResultActions_FullMethodName      = "/google.cloud.dataform.v1beta1.Dataform/QueryCompilationResultActions"
	Dataform_ListWorkflowConfigs_FullMethodName                = "/google.cloud.dataform.v1beta1.Dataform/ListWorkflowConfigs"
	Dataform_GetWorkflowConfig_FullMethodName                  = "/google.cloud.dataform.v1beta1.Dataform/GetWorkflowConfig"
	Dataform_CreateWorkflowConfig_FullMethodName               = "/google.cloud.dataform.v1beta1.Dataform/CreateWorkflowConfig"
	Dataform_UpdateWorkflowConfig_FullMethodName               = "/google.cloud.dataform.v1beta1.Dataform/UpdateWorkflowConfig"
	Dataform_DeleteWorkflowConfig_FullMethodName               = "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkflowConfig"
	Dataform_ListWorkflowInvocations_FullMethodName            = "/google.cloud.dataform.v1beta1.Dataform/ListWorkflowInvocations"
	Dataform_GetWorkflowInvocation_FullMethodName              = "/google.cloud.dataform.v1beta1.Dataform/GetWorkflowInvocation"
	Dataform_CreateWorkflowInvocation_FullMethodName           = "/google.cloud.dataform.v1beta1.Dataform/CreateWorkflowInvocation"
	Dataform_DeleteWorkflowInvocation_FullMethodName           = "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkflowInvocation"
	Dataform_CancelWorkflowInvocation_FullMethodName           = "/google.cloud.dataform.v1beta1.Dataform/CancelWorkflowInvocation"
	Dataform_QueryWorkflowInvocationActions_FullMethodName     = "/google.cloud.dataform.v1beta1.Dataform/QueryWorkflowInvocationActions"
	Dataform_GetConfig_FullMethodName                          = "/google.cloud.dataform.v1beta1.Dataform/GetConfig"
	Dataform_UpdateConfig_FullMethodName                       = "/google.cloud.dataform.v1beta1.Dataform/UpdateConfig"
)

// DataformClient is the client API for Dataform service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataformClient interface {
	// Lists Repositories in a given project and location.
	//
	// **Note:** *This method can return repositories not shown in the [Dataform
	// UI](https://console.cloud.google.com/bigquery/dataform)*.
	ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error)
	// Fetches a single Repository.
	GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Creates a new Repository in a given project and location.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Updates a single Repository.
	//
	// **Note:** *This method does not fully implement
	// [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
	// as a bad request, and when the `field_mask` is omitted, the request is
	// treated as a full update on all modifiable fields.*
	UpdateRepository(ctx context.Context, in *UpdateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Deletes a single Repository.
	DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Applies a Git commit to a Repository. The Repository must not have a value
	// for `git_remote_settings.url`.
	CommitRepositoryChanges(ctx context.Context, in *CommitRepositoryChangesRequest, opts ...grpc.CallOption) (*CommitRepositoryChangesResponse, error)
	// Returns the contents of a file (inside a Repository). The Repository
	// must not have a value for `git_remote_settings.url`.
	ReadRepositoryFile(ctx context.Context, in *ReadRepositoryFileRequest, opts ...grpc.CallOption) (*ReadRepositoryFileResponse, error)
	// Returns the contents of a given Repository directory. The Repository must
	// not have a value for `git_remote_settings.url`.
	QueryRepositoryDirectoryContents(ctx context.Context, in *QueryRepositoryDirectoryContentsRequest, opts ...grpc.CallOption) (*QueryRepositoryDirectoryContentsResponse, error)
	// Fetches a Repository's history of commits.  The Repository must not have a
	// value for `git_remote_settings.url`.
	FetchRepositoryHistory(ctx context.Context, in *FetchRepositoryHistoryRequest, opts ...grpc.CallOption) (*FetchRepositoryHistoryResponse, error)
	// Computes a Repository's Git access token status.
	ComputeRepositoryAccessTokenStatus(ctx context.Context, in *ComputeRepositoryAccessTokenStatusRequest, opts ...grpc.CallOption) (*ComputeRepositoryAccessTokenStatusResponse, error)
	// Fetches a Repository's remote branches.
	FetchRemoteBranches(ctx context.Context, in *FetchRemoteBranchesRequest, opts ...grpc.CallOption) (*FetchRemoteBranchesResponse, error)
	// Lists Workspaces in a given Repository.
	ListWorkspaces(ctx context.Context, in *ListWorkspacesRequest, opts ...grpc.CallOption) (*ListWorkspacesResponse, error)
	// Fetches a single Workspace.
	GetWorkspace(ctx context.Context, in *GetWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error)
	// Creates a new Workspace in a given Repository.
	CreateWorkspace(ctx context.Context, in *CreateWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error)
	// Deletes a single Workspace.
	DeleteWorkspace(ctx context.Context, in *DeleteWorkspaceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Installs dependency NPM packages (inside a Workspace).
	InstallNpmPackages(ctx context.Context, in *InstallNpmPackagesRequest, opts ...grpc.CallOption) (*InstallNpmPackagesResponse, error)
	// Pulls Git commits from the Repository's remote into a Workspace.
	PullGitCommits(ctx context.Context, in *PullGitCommitsRequest, opts ...grpc.CallOption) (*PullGitCommitsResponse, error)
	// Pushes Git commits from a Workspace to the Repository's remote.
	PushGitCommits(ctx context.Context, in *PushGitCommitsRequest, opts ...grpc.CallOption) (*PushGitCommitsResponse, error)
	// Fetches Git statuses for the files in a Workspace.
	FetchFileGitStatuses(ctx context.Context, in *FetchFileGitStatusesRequest, opts ...grpc.CallOption) (*FetchFileGitStatusesResponse, error)
	// Fetches Git ahead/behind against a remote branch.
	FetchGitAheadBehind(ctx context.Context, in *FetchGitAheadBehindRequest, opts ...grpc.CallOption) (*FetchGitAheadBehindResponse, error)
	// Applies a Git commit for uncommitted files in a Workspace.
	CommitWorkspaceChanges(ctx context.Context, in *CommitWorkspaceChangesRequest, opts ...grpc.CallOption) (*CommitWorkspaceChangesResponse, error)
	// Performs a Git reset for uncommitted files in a Workspace.
	ResetWorkspaceChanges(ctx context.Context, in *ResetWorkspaceChangesRequest, opts ...grpc.CallOption) (*ResetWorkspaceChangesResponse, error)
	// Fetches Git diff for an uncommitted file in a Workspace.
	FetchFileDiff(ctx context.Context, in *FetchFileDiffRequest, opts ...grpc.CallOption) (*FetchFileDiffResponse, error)
	// Returns the contents of a given Workspace directory.
	QueryDirectoryContents(ctx context.Context, in *QueryDirectoryContentsRequest, opts ...grpc.CallOption) (*QueryDirectoryContentsResponse, error)
	// Finds the contents of a given Workspace directory by filter.
	SearchFiles(ctx context.Context, in *SearchFilesRequest, opts ...grpc.CallOption) (*SearchFilesResponse, error)
	// Creates a directory inside a Workspace.
	MakeDirectory(ctx context.Context, in *MakeDirectoryRequest, opts ...grpc.CallOption) (*MakeDirectoryResponse, error)
	// Deletes a directory (inside a Workspace) and all of its contents.
	RemoveDirectory(ctx context.Context, in *RemoveDirectoryRequest, opts ...grpc.CallOption) (*RemoveDirectoryResponse, error)
	// Moves a directory (inside a Workspace), and all of its contents, to a new
	// location.
	MoveDirectory(ctx context.Context, in *MoveDirectoryRequest, opts ...grpc.CallOption) (*MoveDirectoryResponse, error)
	// Returns the contents of a file (inside a Workspace).
	ReadFile(ctx context.Context, in *ReadFileRequest, opts ...grpc.CallOption) (*ReadFileResponse, error)
	// Deletes a file (inside a Workspace).
	RemoveFile(ctx context.Context, in *RemoveFileRequest, opts ...grpc.CallOption) (*RemoveFileResponse, error)
	// Moves a file (inside a Workspace) to a new location.
	MoveFile(ctx context.Context, in *MoveFileRequest, opts ...grpc.CallOption) (*MoveFileResponse, error)
	// Writes to a file (inside a Workspace).
	WriteFile(ctx context.Context, in *WriteFileRequest, opts ...grpc.CallOption) (*WriteFileResponse, error)
	// Lists ReleaseConfigs in a given Repository.
	ListReleaseConfigs(ctx context.Context, in *ListReleaseConfigsRequest, opts ...grpc.CallOption) (*ListReleaseConfigsResponse, error)
	// Fetches a single ReleaseConfig.
	GetReleaseConfig(ctx context.Context, in *GetReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error)
	// Creates a new ReleaseConfig in a given Repository.
	CreateReleaseConfig(ctx context.Context, in *CreateReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error)
	// Updates a single ReleaseConfig.
	//
	// **Note:** *This method does not fully implement
	// [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
	// as a bad request, and when the `field_mask` is omitted, the request is
	// treated as a full update on all modifiable fields.*
	UpdateReleaseConfig(ctx context.Context, in *UpdateReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error)
	// Deletes a single ReleaseConfig.
	DeleteReleaseConfig(ctx context.Context, in *DeleteReleaseConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists CompilationResults in a given Repository.
	ListCompilationResults(ctx context.Context, in *ListCompilationResultsRequest, opts ...grpc.CallOption) (*ListCompilationResultsResponse, error)
	// Fetches a single CompilationResult.
	GetCompilationResult(ctx context.Context, in *GetCompilationResultRequest, opts ...grpc.CallOption) (*CompilationResult, error)
	// Creates a new CompilationResult in a given project and location.
	CreateCompilationResult(ctx context.Context, in *CreateCompilationResultRequest, opts ...grpc.CallOption) (*CompilationResult, error)
	// Returns CompilationResultActions in a given CompilationResult.
	QueryCompilationResultActions(ctx context.Context, in *QueryCompilationResultActionsRequest, opts ...grpc.CallOption) (*QueryCompilationResultActionsResponse, error)
	// Lists WorkflowConfigs in a given Repository.
	ListWorkflowConfigs(ctx context.Context, in *ListWorkflowConfigsRequest, opts ...grpc.CallOption) (*ListWorkflowConfigsResponse, error)
	// Fetches a single WorkflowConfig.
	GetWorkflowConfig(ctx context.Context, in *GetWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error)
	// Creates a new WorkflowConfig in a given Repository.
	CreateWorkflowConfig(ctx context.Context, in *CreateWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error)
	// Updates a single WorkflowConfig.
	//
	// **Note:** *This method does not fully implement
	// [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
	// as a bad request, and when the `field_mask` is omitted, the request is
	// treated as a full update on all modifiable fields.*
	UpdateWorkflowConfig(ctx context.Context, in *UpdateWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error)
	// Deletes a single WorkflowConfig.
	DeleteWorkflowConfig(ctx context.Context, in *DeleteWorkflowConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists WorkflowInvocations in a given Repository.
	ListWorkflowInvocations(ctx context.Context, in *ListWorkflowInvocationsRequest, opts ...grpc.CallOption) (*ListWorkflowInvocationsResponse, error)
	// Fetches a single WorkflowInvocation.
	GetWorkflowInvocation(ctx context.Context, in *GetWorkflowInvocationRequest, opts ...grpc.CallOption) (*WorkflowInvocation, error)
	// Creates a new WorkflowInvocation in a given Repository.
	CreateWorkflowInvocation(ctx context.Context, in *CreateWorkflowInvocationRequest, opts ...grpc.CallOption) (*WorkflowInvocation, error)
	// Deletes a single WorkflowInvocation.
	DeleteWorkflowInvocation(ctx context.Context, in *DeleteWorkflowInvocationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Requests cancellation of a running WorkflowInvocation.
	CancelWorkflowInvocation(ctx context.Context, in *CancelWorkflowInvocationRequest, opts ...grpc.CallOption) (*CancelWorkflowInvocationResponse, error)
	// Returns WorkflowInvocationActions in a given WorkflowInvocation.
	QueryWorkflowInvocationActions(ctx context.Context, in *QueryWorkflowInvocationActionsRequest, opts ...grpc.CallOption) (*QueryWorkflowInvocationActionsResponse, error)
	// Get default config for a given project and location.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error)
	// Update default config for a given project and location.
	//
	// **Note:** *This method does not fully implement
	// [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
	// as a bad request, and when the `field_mask` is omitted, the request is
	// treated as a full update on all modifiable fields.*
	UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*Config, error)
}

type dataformClient struct {
	cc grpc.ClientConnInterface
}

func NewDataformClient(cc grpc.ClientConnInterface) DataformClient {
	return &dataformClient{cc}
}

func (c *dataformClient) ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error) {
	out := new(ListRepositoriesResponse)
	err := c.cc.Invoke(ctx, Dataform_ListRepositories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, Dataform_GetRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, Dataform_CreateRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) UpdateRepository(ctx context.Context, in *UpdateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, Dataform_UpdateRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Dataform_DeleteRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CommitRepositoryChanges(ctx context.Context, in *CommitRepositoryChangesRequest, opts ...grpc.CallOption) (*CommitRepositoryChangesResponse, error) {
	out := new(CommitRepositoryChangesResponse)
	err := c.cc.Invoke(ctx, Dataform_CommitRepositoryChanges_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ReadRepositoryFile(ctx context.Context, in *ReadRepositoryFileRequest, opts ...grpc.CallOption) (*ReadRepositoryFileResponse, error) {
	out := new(ReadRepositoryFileResponse)
	err := c.cc.Invoke(ctx, Dataform_ReadRepositoryFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) QueryRepositoryDirectoryContents(ctx context.Context, in *QueryRepositoryDirectoryContentsRequest, opts ...grpc.CallOption) (*QueryRepositoryDirectoryContentsResponse, error) {
	out := new(QueryRepositoryDirectoryContentsResponse)
	err := c.cc.Invoke(ctx, Dataform_QueryRepositoryDirectoryContents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchRepositoryHistory(ctx context.Context, in *FetchRepositoryHistoryRequest, opts ...grpc.CallOption) (*FetchRepositoryHistoryResponse, error) {
	out := new(FetchRepositoryHistoryResponse)
	err := c.cc.Invoke(ctx, Dataform_FetchRepositoryHistory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ComputeRepositoryAccessTokenStatus(ctx context.Context, in *ComputeRepositoryAccessTokenStatusRequest, opts ...grpc.CallOption) (*ComputeRepositoryAccessTokenStatusResponse, error) {
	out := new(ComputeRepositoryAccessTokenStatusResponse)
	err := c.cc.Invoke(ctx, Dataform_ComputeRepositoryAccessTokenStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchRemoteBranches(ctx context.Context, in *FetchRemoteBranchesRequest, opts ...grpc.CallOption) (*FetchRemoteBranchesResponse, error) {
	out := new(FetchRemoteBranchesResponse)
	err := c.cc.Invoke(ctx, Dataform_FetchRemoteBranches_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListWorkspaces(ctx context.Context, in *ListWorkspacesRequest, opts ...grpc.CallOption) (*ListWorkspacesResponse, error) {
	out := new(ListWorkspacesResponse)
	err := c.cc.Invoke(ctx, Dataform_ListWorkspaces_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetWorkspace(ctx context.Context, in *GetWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error) {
	out := new(Workspace)
	err := c.cc.Invoke(ctx, Dataform_GetWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateWorkspace(ctx context.Context, in *CreateWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error) {
	out := new(Workspace)
	err := c.cc.Invoke(ctx, Dataform_CreateWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteWorkspace(ctx context.Context, in *DeleteWorkspaceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Dataform_DeleteWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) InstallNpmPackages(ctx context.Context, in *InstallNpmPackagesRequest, opts ...grpc.CallOption) (*InstallNpmPackagesResponse, error) {
	out := new(InstallNpmPackagesResponse)
	err := c.cc.Invoke(ctx, Dataform_InstallNpmPackages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) PullGitCommits(ctx context.Context, in *PullGitCommitsRequest, opts ...grpc.CallOption) (*PullGitCommitsResponse, error) {
	out := new(PullGitCommitsResponse)
	err := c.cc.Invoke(ctx, Dataform_PullGitCommits_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) PushGitCommits(ctx context.Context, in *PushGitCommitsRequest, opts ...grpc.CallOption) (*PushGitCommitsResponse, error) {
	out := new(PushGitCommitsResponse)
	err := c.cc.Invoke(ctx, Dataform_PushGitCommits_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchFileGitStatuses(ctx context.Context, in *FetchFileGitStatusesRequest, opts ...grpc.CallOption) (*FetchFileGitStatusesResponse, error) {
	out := new(FetchFileGitStatusesResponse)
	err := c.cc.Invoke(ctx, Dataform_FetchFileGitStatuses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchGitAheadBehind(ctx context.Context, in *FetchGitAheadBehindRequest, opts ...grpc.CallOption) (*FetchGitAheadBehindResponse, error) {
	out := new(FetchGitAheadBehindResponse)
	err := c.cc.Invoke(ctx, Dataform_FetchGitAheadBehind_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CommitWorkspaceChanges(ctx context.Context, in *CommitWorkspaceChangesRequest, opts ...grpc.CallOption) (*CommitWorkspaceChangesResponse, error) {
	out := new(CommitWorkspaceChangesResponse)
	err := c.cc.Invoke(ctx, Dataform_CommitWorkspaceChanges_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ResetWorkspaceChanges(ctx context.Context, in *ResetWorkspaceChangesRequest, opts ...grpc.CallOption) (*ResetWorkspaceChangesResponse, error) {
	out := new(ResetWorkspaceChangesResponse)
	err := c.cc.Invoke(ctx, Dataform_ResetWorkspaceChanges_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchFileDiff(ctx context.Context, in *FetchFileDiffRequest, opts ...grpc.CallOption) (*FetchFileDiffResponse, error) {
	out := new(FetchFileDiffResponse)
	err := c.cc.Invoke(ctx, Dataform_FetchFileDiff_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) QueryDirectoryContents(ctx context.Context, in *QueryDirectoryContentsRequest, opts ...grpc.CallOption) (*QueryDirectoryContentsResponse, error) {
	out := new(QueryDirectoryContentsResponse)
	err := c.cc.Invoke(ctx, Dataform_QueryDirectoryContents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) SearchFiles(ctx context.Context, in *SearchFilesRequest, opts ...grpc.CallOption) (*SearchFilesResponse, error) {
	out := new(SearchFilesResponse)
	err := c.cc.Invoke(ctx, Dataform_SearchFiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) MakeDirectory(ctx context.Context, in *MakeDirectoryRequest, opts ...grpc.CallOption) (*MakeDirectoryResponse, error) {
	out := new(MakeDirectoryResponse)
	err := c.cc.Invoke(ctx, Dataform_MakeDirectory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) RemoveDirectory(ctx context.Context, in *RemoveDirectoryRequest, opts ...grpc.CallOption) (*RemoveDirectoryResponse, error) {
	out := new(RemoveDirectoryResponse)
	err := c.cc.Invoke(ctx, Dataform_RemoveDirectory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) MoveDirectory(ctx context.Context, in *MoveDirectoryRequest, opts ...grpc.CallOption) (*MoveDirectoryResponse, error) {
	out := new(MoveDirectoryResponse)
	err := c.cc.Invoke(ctx, Dataform_MoveDirectory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ReadFile(ctx context.Context, in *ReadFileRequest, opts ...grpc.CallOption) (*ReadFileResponse, error) {
	out := new(ReadFileResponse)
	err := c.cc.Invoke(ctx, Dataform_ReadFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) RemoveFile(ctx context.Context, in *RemoveFileRequest, opts ...grpc.CallOption) (*RemoveFileResponse, error) {
	out := new(RemoveFileResponse)
	err := c.cc.Invoke(ctx, Dataform_RemoveFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) MoveFile(ctx context.Context, in *MoveFileRequest, opts ...grpc.CallOption) (*MoveFileResponse, error) {
	out := new(MoveFileResponse)
	err := c.cc.Invoke(ctx, Dataform_MoveFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) WriteFile(ctx context.Context, in *WriteFileRequest, opts ...grpc.CallOption) (*WriteFileResponse, error) {
	out := new(WriteFileResponse)
	err := c.cc.Invoke(ctx, Dataform_WriteFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListReleaseConfigs(ctx context.Context, in *ListReleaseConfigsRequest, opts ...grpc.CallOption) (*ListReleaseConfigsResponse, error) {
	out := new(ListReleaseConfigsResponse)
	err := c.cc.Invoke(ctx, Dataform_ListReleaseConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetReleaseConfig(ctx context.Context, in *GetReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error) {
	out := new(ReleaseConfig)
	err := c.cc.Invoke(ctx, Dataform_GetReleaseConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateReleaseConfig(ctx context.Context, in *CreateReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error) {
	out := new(ReleaseConfig)
	err := c.cc.Invoke(ctx, Dataform_CreateReleaseConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) UpdateReleaseConfig(ctx context.Context, in *UpdateReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error) {
	out := new(ReleaseConfig)
	err := c.cc.Invoke(ctx, Dataform_UpdateReleaseConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteReleaseConfig(ctx context.Context, in *DeleteReleaseConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Dataform_DeleteReleaseConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListCompilationResults(ctx context.Context, in *ListCompilationResultsRequest, opts ...grpc.CallOption) (*ListCompilationResultsResponse, error) {
	out := new(ListCompilationResultsResponse)
	err := c.cc.Invoke(ctx, Dataform_ListCompilationResults_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetCompilationResult(ctx context.Context, in *GetCompilationResultRequest, opts ...grpc.CallOption) (*CompilationResult, error) {
	out := new(CompilationResult)
	err := c.cc.Invoke(ctx, Dataform_GetCompilationResult_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateCompilationResult(ctx context.Context, in *CreateCompilationResultRequest, opts ...grpc.CallOption) (*CompilationResult, error) {
	out := new(CompilationResult)
	err := c.cc.Invoke(ctx, Dataform_CreateCompilationResult_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) QueryCompilationResultActions(ctx context.Context, in *QueryCompilationResultActionsRequest, opts ...grpc.CallOption) (*QueryCompilationResultActionsResponse, error) {
	out := new(QueryCompilationResultActionsResponse)
	err := c.cc.Invoke(ctx, Dataform_QueryCompilationResultActions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListWorkflowConfigs(ctx context.Context, in *ListWorkflowConfigsRequest, opts ...grpc.CallOption) (*ListWorkflowConfigsResponse, error) {
	out := new(ListWorkflowConfigsResponse)
	err := c.cc.Invoke(ctx, Dataform_ListWorkflowConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetWorkflowConfig(ctx context.Context, in *GetWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error) {
	out := new(WorkflowConfig)
	err := c.cc.Invoke(ctx, Dataform_GetWorkflowConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateWorkflowConfig(ctx context.Context, in *CreateWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error) {
	out := new(WorkflowConfig)
	err := c.cc.Invoke(ctx, Dataform_CreateWorkflowConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) UpdateWorkflowConfig(ctx context.Context, in *UpdateWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error) {
	out := new(WorkflowConfig)
	err := c.cc.Invoke(ctx, Dataform_UpdateWorkflowConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteWorkflowConfig(ctx context.Context, in *DeleteWorkflowConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Dataform_DeleteWorkflowConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListWorkflowInvocations(ctx context.Context, in *ListWorkflowInvocationsRequest, opts ...grpc.CallOption) (*ListWorkflowInvocationsResponse, error) {
	out := new(ListWorkflowInvocationsResponse)
	err := c.cc.Invoke(ctx, Dataform_ListWorkflowInvocations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetWorkflowInvocation(ctx context.Context, in *GetWorkflowInvocationRequest, opts ...grpc.CallOption) (*WorkflowInvocation, error) {
	out := new(WorkflowInvocation)
	err := c.cc.Invoke(ctx, Dataform_GetWorkflowInvocation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateWorkflowInvocation(ctx context.Context, in *CreateWorkflowInvocationRequest, opts ...grpc.CallOption) (*WorkflowInvocation, error) {
	out := new(WorkflowInvocation)
	err := c.cc.Invoke(ctx, Dataform_CreateWorkflowInvocation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteWorkflowInvocation(ctx context.Context, in *DeleteWorkflowInvocationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Dataform_DeleteWorkflowInvocation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CancelWorkflowInvocation(ctx context.Context, in *CancelWorkflowInvocationRequest, opts ...grpc.CallOption) (*CancelWorkflowInvocationResponse, error) {
	out := new(CancelWorkflowInvocationResponse)
	err := c.cc.Invoke(ctx, Dataform_CancelWorkflowInvocation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) QueryWorkflowInvocationActions(ctx context.Context, in *QueryWorkflowInvocationActionsRequest, opts ...grpc.CallOption) (*QueryWorkflowInvocationActionsResponse, error) {
	out := new(QueryWorkflowInvocationActionsResponse)
	err := c.cc.Invoke(ctx, Dataform_QueryWorkflowInvocationActions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error) {
	out := new(Config)
	err := c.cc.Invoke(ctx, Dataform_GetConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*Config, error) {
	out := new(Config)
	err := c.cc.Invoke(ctx, Dataform_UpdateConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataformServer is the server API for Dataform service.
// All implementations should embed UnimplementedDataformServer
// for forward compatibility
type DataformServer interface {
	// Lists Repositories in a given project and location.
	//
	// **Note:** *This method can return repositories not shown in the [Dataform
	// UI](https://console.cloud.google.com/bigquery/dataform)*.
	ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error)
	// Fetches a single Repository.
	GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error)
	// Creates a new Repository in a given project and location.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*Repository, error)
	// Updates a single Repository.
	//
	// **Note:** *This method does not fully implement
	// [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
	// as a bad request, and when the `field_mask` is omitted, the request is
	// treated as a full update on all modifiable fields.*
	UpdateRepository(context.Context, *UpdateRepositoryRequest) (*Repository, error)
	// Deletes a single Repository.
	DeleteRepository(context.Context, *DeleteRepositoryRequest) (*emptypb.Empty, error)
	// Applies a Git commit to a Repository. The Repository must not have a value
	// for `git_remote_settings.url`.
	CommitRepositoryChanges(context.Context, *CommitRepositoryChangesRequest) (*CommitRepositoryChangesResponse, error)
	// Returns the contents of a file (inside a Repository). The Repository
	// must not have a value for `git_remote_settings.url`.
	ReadRepositoryFile(context.Context, *ReadRepositoryFileRequest) (*ReadRepositoryFileResponse, error)
	// Returns the contents of a given Repository directory. The Repository must
	// not have a value for `git_remote_settings.url`.
	QueryRepositoryDirectoryContents(context.Context, *QueryRepositoryDirectoryContentsRequest) (*QueryRepositoryDirectoryContentsResponse, error)
	// Fetches a Repository's history of commits.  The Repository must not have a
	// value for `git_remote_settings.url`.
	FetchRepositoryHistory(context.Context, *FetchRepositoryHistoryRequest) (*FetchRepositoryHistoryResponse, error)
	// Computes a Repository's Git access token status.
	ComputeRepositoryAccessTokenStatus(context.Context, *ComputeRepositoryAccessTokenStatusRequest) (*ComputeRepositoryAccessTokenStatusResponse, error)
	// Fetches a Repository's remote branches.
	FetchRemoteBranches(context.Context, *FetchRemoteBranchesRequest) (*FetchRemoteBranchesResponse, error)
	// Lists Workspaces in a given Repository.
	ListWorkspaces(context.Context, *ListWorkspacesRequest) (*ListWorkspacesResponse, error)
	// Fetches a single Workspace.
	GetWorkspace(context.Context, *GetWorkspaceRequest) (*Workspace, error)
	// Creates a new Workspace in a given Repository.
	CreateWorkspace(context.Context, *CreateWorkspaceRequest) (*Workspace, error)
	// Deletes a single Workspace.
	DeleteWorkspace(context.Context, *DeleteWorkspaceRequest) (*emptypb.Empty, error)
	// Installs dependency NPM packages (inside a Workspace).
	InstallNpmPackages(context.Context, *InstallNpmPackagesRequest) (*InstallNpmPackagesResponse, error)
	// Pulls Git commits from the Repository's remote into a Workspace.
	PullGitCommits(context.Context, *PullGitCommitsRequest) (*PullGitCommitsResponse, error)
	// Pushes Git commits from a Workspace to the Repository's remote.
	PushGitCommits(context.Context, *PushGitCommitsRequest) (*PushGitCommitsResponse, error)
	// Fetches Git statuses for the files in a Workspace.
	FetchFileGitStatuses(context.Context, *FetchFileGitStatusesRequest) (*FetchFileGitStatusesResponse, error)
	// Fetches Git ahead/behind against a remote branch.
	FetchGitAheadBehind(context.Context, *FetchGitAheadBehindRequest) (*FetchGitAheadBehindResponse, error)
	// Applies a Git commit for uncommitted files in a Workspace.
	CommitWorkspaceChanges(context.Context, *CommitWorkspaceChangesRequest) (*CommitWorkspaceChangesResponse, error)
	// Performs a Git reset for uncommitted files in a Workspace.
	ResetWorkspaceChanges(context.Context, *ResetWorkspaceChangesRequest) (*ResetWorkspaceChangesResponse, error)
	// Fetches Git diff for an uncommitted file in a Workspace.
	FetchFileDiff(context.Context, *FetchFileDiffRequest) (*FetchFileDiffResponse, error)
	// Returns the contents of a given Workspace directory.
	QueryDirectoryContents(context.Context, *QueryDirectoryContentsRequest) (*QueryDirectoryContentsResponse, error)
	// Finds the contents of a given Workspace directory by filter.
	SearchFiles(context.Context, *SearchFilesRequest) (*SearchFilesResponse, error)
	// Creates a directory inside a Workspace.
	MakeDirectory(context.Context, *MakeDirectoryRequest) (*MakeDirectoryResponse, error)
	// Deletes a directory (inside a Workspace) and all of its contents.
	RemoveDirectory(context.Context, *RemoveDirectoryRequest) (*RemoveDirectoryResponse, error)
	// Moves a directory (inside a Workspace), and all of its contents, to a new
	// location.
	MoveDirectory(context.Context, *MoveDirectoryRequest) (*MoveDirectoryResponse, error)
	// Returns the contents of a file (inside a Workspace).
	ReadFile(context.Context, *ReadFileRequest) (*ReadFileResponse, error)
	// Deletes a file (inside a Workspace).
	RemoveFile(context.Context, *RemoveFileRequest) (*RemoveFileResponse, error)
	// Moves a file (inside a Workspace) to a new location.
	MoveFile(context.Context, *MoveFileRequest) (*MoveFileResponse, error)
	// Writes to a file (inside a Workspace).
	WriteFile(context.Context, *WriteFileRequest) (*WriteFileResponse, error)
	// Lists ReleaseConfigs in a given Repository.
	ListReleaseConfigs(context.Context, *ListReleaseConfigsRequest) (*ListReleaseConfigsResponse, error)
	// Fetches a single ReleaseConfig.
	GetReleaseConfig(context.Context, *GetReleaseConfigRequest) (*ReleaseConfig, error)
	// Creates a new ReleaseConfig in a given Repository.
	CreateReleaseConfig(context.Context, *CreateReleaseConfigRequest) (*ReleaseConfig, error)
	// Updates a single ReleaseConfig.
	//
	// **Note:** *This method does not fully implement
	// [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
	// as a bad request, and when the `field_mask` is omitted, the request is
	// treated as a full update on all modifiable fields.*
	UpdateReleaseConfig(context.Context, *UpdateReleaseConfigRequest) (*ReleaseConfig, error)
	// Deletes a single ReleaseConfig.
	DeleteReleaseConfig(context.Context, *DeleteReleaseConfigRequest) (*emptypb.Empty, error)
	// Lists CompilationResults in a given Repository.
	ListCompilationResults(context.Context, *ListCompilationResultsRequest) (*ListCompilationResultsResponse, error)
	// Fetches a single CompilationResult.
	GetCompilationResult(context.Context, *GetCompilationResultRequest) (*CompilationResult, error)
	// Creates a new CompilationResult in a given project and location.
	CreateCompilationResult(context.Context, *CreateCompilationResultRequest) (*CompilationResult, error)
	// Returns CompilationResultActions in a given CompilationResult.
	QueryCompilationResultActions(context.Context, *QueryCompilationResultActionsRequest) (*QueryCompilationResultActionsResponse, error)
	// Lists WorkflowConfigs in a given Repository.
	ListWorkflowConfigs(context.Context, *ListWorkflowConfigsRequest) (*ListWorkflowConfigsResponse, error)
	// Fetches a single WorkflowConfig.
	GetWorkflowConfig(context.Context, *GetWorkflowConfigRequest) (*WorkflowConfig, error)
	// Creates a new WorkflowConfig in a given Repository.
	CreateWorkflowConfig(context.Context, *CreateWorkflowConfigRequest) (*WorkflowConfig, error)
	// Updates a single WorkflowConfig.
	//
	// **Note:** *This method does not fully implement
	// [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
	// as a bad request, and when the `field_mask` is omitted, the request is
	// treated as a full update on all modifiable fields.*
	UpdateWorkflowConfig(context.Context, *UpdateWorkflowConfigRequest) (*WorkflowConfig, error)
	// Deletes a single WorkflowConfig.
	DeleteWorkflowConfig(context.Context, *DeleteWorkflowConfigRequest) (*emptypb.Empty, error)
	// Lists WorkflowInvocations in a given Repository.
	ListWorkflowInvocations(context.Context, *ListWorkflowInvocationsRequest) (*ListWorkflowInvocationsResponse, error)
	// Fetches a single WorkflowInvocation.
	GetWorkflowInvocation(context.Context, *GetWorkflowInvocationRequest) (*WorkflowInvocation, error)
	// Creates a new WorkflowInvocation in a given Repository.
	CreateWorkflowInvocation(context.Context, *CreateWorkflowInvocationRequest) (*WorkflowInvocation, error)
	// Deletes a single WorkflowInvocation.
	DeleteWorkflowInvocation(context.Context, *DeleteWorkflowInvocationRequest) (*emptypb.Empty, error)
	// Requests cancellation of a running WorkflowInvocation.
	CancelWorkflowInvocation(context.Context, *CancelWorkflowInvocationRequest) (*CancelWorkflowInvocationResponse, error)
	// Returns WorkflowInvocationActions in a given WorkflowInvocation.
	QueryWorkflowInvocationActions(context.Context, *QueryWorkflowInvocationActionsRequest) (*QueryWorkflowInvocationActionsResponse, error)
	// Get default config for a given project and location.
	GetConfig(context.Context, *GetConfigRequest) (*Config, error)
	// Update default config for a given project and location.
	//
	// **Note:** *This method does not fully implement
	// [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
	// as a bad request, and when the `field_mask` is omitted, the request is
	// treated as a full update on all modifiable fields.*
	UpdateConfig(context.Context, *UpdateConfigRequest) (*Config, error)
}

// UnimplementedDataformServer should be embedded to have forward compatible implementations.
type UnimplementedDataformServer struct {
}

func (UnimplementedDataformServer) ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRepositories not implemented")
}
func (UnimplementedDataformServer) GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepository not implemented")
}
func (UnimplementedDataformServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (UnimplementedDataformServer) UpdateRepository(context.Context, *UpdateRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRepository not implemented")
}
func (UnimplementedDataformServer) DeleteRepository(context.Context, *DeleteRepositoryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRepository not implemented")
}
func (UnimplementedDataformServer) CommitRepositoryChanges(context.Context, *CommitRepositoryChangesRequest) (*CommitRepositoryChangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitRepositoryChanges not implemented")
}
func (UnimplementedDataformServer) ReadRepositoryFile(context.Context, *ReadRepositoryFileRequest) (*ReadRepositoryFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadRepositoryFile not implemented")
}
func (UnimplementedDataformServer) QueryRepositoryDirectoryContents(context.Context, *QueryRepositoryDirectoryContentsRequest) (*QueryRepositoryDirectoryContentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryRepositoryDirectoryContents not implemented")
}
func (UnimplementedDataformServer) FetchRepositoryHistory(context.Context, *FetchRepositoryHistoryRequest) (*FetchRepositoryHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchRepositoryHistory not implemented")
}
func (UnimplementedDataformServer) ComputeRepositoryAccessTokenStatus(context.Context, *ComputeRepositoryAccessTokenStatusRequest) (*ComputeRepositoryAccessTokenStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeRepositoryAccessTokenStatus not implemented")
}
func (UnimplementedDataformServer) FetchRemoteBranches(context.Context, *FetchRemoteBranchesRequest) (*FetchRemoteBranchesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchRemoteBranches not implemented")
}
func (UnimplementedDataformServer) ListWorkspaces(context.Context, *ListWorkspacesRequest) (*ListWorkspacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkspaces not implemented")
}
func (UnimplementedDataformServer) GetWorkspace(context.Context, *GetWorkspaceRequest) (*Workspace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkspace not implemented")
}
func (UnimplementedDataformServer) CreateWorkspace(context.Context, *CreateWorkspaceRequest) (*Workspace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkspace not implemented")
}
func (UnimplementedDataformServer) DeleteWorkspace(context.Context, *DeleteWorkspaceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkspace not implemented")
}
func (UnimplementedDataformServer) InstallNpmPackages(context.Context, *InstallNpmPackagesRequest) (*InstallNpmPackagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InstallNpmPackages not implemented")
}
func (UnimplementedDataformServer) PullGitCommits(context.Context, *PullGitCommitsRequest) (*PullGitCommitsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PullGitCommits not implemented")
}
func (UnimplementedDataformServer) PushGitCommits(context.Context, *PushGitCommitsRequest) (*PushGitCommitsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushGitCommits not implemented")
}
func (UnimplementedDataformServer) FetchFileGitStatuses(context.Context, *FetchFileGitStatusesRequest) (*FetchFileGitStatusesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchFileGitStatuses not implemented")
}
func (UnimplementedDataformServer) FetchGitAheadBehind(context.Context, *FetchGitAheadBehindRequest) (*FetchGitAheadBehindResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchGitAheadBehind not implemented")
}
func (UnimplementedDataformServer) CommitWorkspaceChanges(context.Context, *CommitWorkspaceChangesRequest) (*CommitWorkspaceChangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitWorkspaceChanges not implemented")
}
func (UnimplementedDataformServer) ResetWorkspaceChanges(context.Context, *ResetWorkspaceChangesRequest) (*ResetWorkspaceChangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetWorkspaceChanges not implemented")
}
func (UnimplementedDataformServer) FetchFileDiff(context.Context, *FetchFileDiffRequest) (*FetchFileDiffResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchFileDiff not implemented")
}
func (UnimplementedDataformServer) QueryDirectoryContents(context.Context, *QueryDirectoryContentsRequest) (*QueryDirectoryContentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryDirectoryContents not implemented")
}
func (UnimplementedDataformServer) SearchFiles(context.Context, *SearchFilesRequest) (*SearchFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchFiles not implemented")
}
func (UnimplementedDataformServer) MakeDirectory(context.Context, *MakeDirectoryRequest) (*MakeDirectoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MakeDirectory not implemented")
}
func (UnimplementedDataformServer) RemoveDirectory(context.Context, *RemoveDirectoryRequest) (*RemoveDirectoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveDirectory not implemented")
}
func (UnimplementedDataformServer) MoveDirectory(context.Context, *MoveDirectoryRequest) (*MoveDirectoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveDirectory not implemented")
}
func (UnimplementedDataformServer) ReadFile(context.Context, *ReadFileRequest) (*ReadFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadFile not implemented")
}
func (UnimplementedDataformServer) RemoveFile(context.Context, *RemoveFileRequest) (*RemoveFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveFile not implemented")
}
func (UnimplementedDataformServer) MoveFile(context.Context, *MoveFileRequest) (*MoveFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveFile not implemented")
}
func (UnimplementedDataformServer) WriteFile(context.Context, *WriteFileRequest) (*WriteFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteFile not implemented")
}
func (UnimplementedDataformServer) ListReleaseConfigs(context.Context, *ListReleaseConfigsRequest) (*ListReleaseConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReleaseConfigs not implemented")
}
func (UnimplementedDataformServer) GetReleaseConfig(context.Context, *GetReleaseConfigRequest) (*ReleaseConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReleaseConfig not implemented")
}
func (UnimplementedDataformServer) CreateReleaseConfig(context.Context, *CreateReleaseConfigRequest) (*ReleaseConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReleaseConfig not implemented")
}
func (UnimplementedDataformServer) UpdateReleaseConfig(context.Context, *UpdateReleaseConfigRequest) (*ReleaseConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReleaseConfig not implemented")
}
func (UnimplementedDataformServer) DeleteReleaseConfig(context.Context, *DeleteReleaseConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReleaseConfig not implemented")
}
func (UnimplementedDataformServer) ListCompilationResults(context.Context, *ListCompilationResultsRequest) (*ListCompilationResultsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCompilationResults not implemented")
}
func (UnimplementedDataformServer) GetCompilationResult(context.Context, *GetCompilationResultRequest) (*CompilationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCompilationResult not implemented")
}
func (UnimplementedDataformServer) CreateCompilationResult(context.Context, *CreateCompilationResultRequest) (*CompilationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCompilationResult not implemented")
}
func (UnimplementedDataformServer) QueryCompilationResultActions(context.Context, *QueryCompilationResultActionsRequest) (*QueryCompilationResultActionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryCompilationResultActions not implemented")
}
func (UnimplementedDataformServer) ListWorkflowConfigs(context.Context, *ListWorkflowConfigsRequest) (*ListWorkflowConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkflowConfigs not implemented")
}
func (UnimplementedDataformServer) GetWorkflowConfig(context.Context, *GetWorkflowConfigRequest) (*WorkflowConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkflowConfig not implemented")
}
func (UnimplementedDataformServer) CreateWorkflowConfig(context.Context, *CreateWorkflowConfigRequest) (*WorkflowConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkflowConfig not implemented")
}
func (UnimplementedDataformServer) UpdateWorkflowConfig(context.Context, *UpdateWorkflowConfigRequest) (*WorkflowConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkflowConfig not implemented")
}
func (UnimplementedDataformServer) DeleteWorkflowConfig(context.Context, *DeleteWorkflowConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkflowConfig not implemented")
}
func (UnimplementedDataformServer) ListWorkflowInvocations(context.Context, *ListWorkflowInvocationsRequest) (*ListWorkflowInvocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkflowInvocations not implemented")
}
func (UnimplementedDataformServer) GetWorkflowInvocation(context.Context, *GetWorkflowInvocationRequest) (*WorkflowInvocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkflowInvocation not implemented")
}
func (UnimplementedDataformServer) CreateWorkflowInvocation(context.Context, *CreateWorkflowInvocationRequest) (*WorkflowInvocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkflowInvocation not implemented")
}
func (UnimplementedDataformServer) DeleteWorkflowInvocation(context.Context, *DeleteWorkflowInvocationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkflowInvocation not implemented")
}
func (UnimplementedDataformServer) CancelWorkflowInvocation(context.Context, *CancelWorkflowInvocationRequest) (*CancelWorkflowInvocationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelWorkflowInvocation not implemented")
}
func (UnimplementedDataformServer) QueryWorkflowInvocationActions(context.Context, *QueryWorkflowInvocationActionsRequest) (*QueryWorkflowInvocationActionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWorkflowInvocationActions not implemented")
}
func (UnimplementedDataformServer) GetConfig(context.Context, *GetConfigRequest) (*Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (UnimplementedDataformServer) UpdateConfig(context.Context, *UpdateConfigRequest) (*Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConfig not implemented")
}

// UnsafeDataformServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataformServer will
// result in compilation errors.
type UnsafeDataformServer interface {
	mustEmbedUnimplementedDataformServer()
}

func RegisterDataformServer(s grpc.ServiceRegistrar, srv DataformServer) {
	s.RegisterService(&Dataform_ServiceDesc, srv)
}

func _Dataform_ListRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ListRepositories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListRepositories(ctx, req.(*ListRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_GetRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetRepository(ctx, req.(*GetRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CreateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_UpdateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).UpdateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_UpdateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).UpdateRepository(ctx, req.(*UpdateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_DeleteRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteRepository(ctx, req.(*DeleteRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CommitRepositoryChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRepositoryChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CommitRepositoryChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CommitRepositoryChanges_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CommitRepositoryChanges(ctx, req.(*CommitRepositoryChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ReadRepositoryFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadRepositoryFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ReadRepositoryFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ReadRepositoryFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ReadRepositoryFile(ctx, req.(*ReadRepositoryFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_QueryRepositoryDirectoryContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryRepositoryDirectoryContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).QueryRepositoryDirectoryContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_QueryRepositoryDirectoryContents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).QueryRepositoryDirectoryContents(ctx, req.(*QueryRepositoryDirectoryContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchRepositoryHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchRepositoryHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchRepositoryHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_FetchRepositoryHistory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchRepositoryHistory(ctx, req.(*FetchRepositoryHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ComputeRepositoryAccessTokenStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeRepositoryAccessTokenStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ComputeRepositoryAccessTokenStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ComputeRepositoryAccessTokenStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ComputeRepositoryAccessTokenStatus(ctx, req.(*ComputeRepositoryAccessTokenStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchRemoteBranches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchRemoteBranchesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchRemoteBranches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_FetchRemoteBranches_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchRemoteBranches(ctx, req.(*FetchRemoteBranchesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListWorkspaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkspacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListWorkspaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ListWorkspaces_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListWorkspaces(ctx, req.(*ListWorkspacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_GetWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetWorkspace(ctx, req.(*GetWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CreateWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateWorkspace(ctx, req.(*CreateWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_DeleteWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteWorkspace(ctx, req.(*DeleteWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_InstallNpmPackages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstallNpmPackagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).InstallNpmPackages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_InstallNpmPackages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).InstallNpmPackages(ctx, req.(*InstallNpmPackagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_PullGitCommits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullGitCommitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).PullGitCommits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_PullGitCommits_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).PullGitCommits(ctx, req.(*PullGitCommitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_PushGitCommits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushGitCommitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).PushGitCommits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_PushGitCommits_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).PushGitCommits(ctx, req.(*PushGitCommitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchFileGitStatuses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchFileGitStatusesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchFileGitStatuses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_FetchFileGitStatuses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchFileGitStatuses(ctx, req.(*FetchFileGitStatusesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchGitAheadBehind_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchGitAheadBehindRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchGitAheadBehind(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_FetchGitAheadBehind_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchGitAheadBehind(ctx, req.(*FetchGitAheadBehindRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CommitWorkspaceChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitWorkspaceChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CommitWorkspaceChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CommitWorkspaceChanges_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CommitWorkspaceChanges(ctx, req.(*CommitWorkspaceChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ResetWorkspaceChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetWorkspaceChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ResetWorkspaceChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ResetWorkspaceChanges_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ResetWorkspaceChanges(ctx, req.(*ResetWorkspaceChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchFileDiff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchFileDiffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchFileDiff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_FetchFileDiff_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchFileDiff(ctx, req.(*FetchFileDiffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_QueryDirectoryContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryDirectoryContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).QueryDirectoryContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_QueryDirectoryContents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).QueryDirectoryContents(ctx, req.(*QueryDirectoryContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_SearchFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).SearchFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_SearchFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).SearchFiles(ctx, req.(*SearchFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_MakeDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MakeDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).MakeDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_MakeDirectory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).MakeDirectory(ctx, req.(*MakeDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_RemoveDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).RemoveDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_RemoveDirectory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).RemoveDirectory(ctx, req.(*RemoveDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_MoveDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).MoveDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_MoveDirectory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).MoveDirectory(ctx, req.(*MoveDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ReadFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ReadFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ReadFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ReadFile(ctx, req.(*ReadFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_RemoveFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).RemoveFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_RemoveFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).RemoveFile(ctx, req.(*RemoveFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_MoveFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).MoveFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_MoveFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).MoveFile(ctx, req.(*MoveFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_WriteFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).WriteFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_WriteFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).WriteFile(ctx, req.(*WriteFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListReleaseConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReleaseConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListReleaseConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ListReleaseConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListReleaseConfigs(ctx, req.(*ListReleaseConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetReleaseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetReleaseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_GetReleaseConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetReleaseConfig(ctx, req.(*GetReleaseConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateReleaseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReleaseConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateReleaseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CreateReleaseConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateReleaseConfig(ctx, req.(*CreateReleaseConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_UpdateReleaseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReleaseConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).UpdateReleaseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_UpdateReleaseConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).UpdateReleaseConfig(ctx, req.(*UpdateReleaseConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteReleaseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReleaseConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteReleaseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_DeleteReleaseConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteReleaseConfig(ctx, req.(*DeleteReleaseConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListCompilationResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCompilationResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListCompilationResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ListCompilationResults_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListCompilationResults(ctx, req.(*ListCompilationResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetCompilationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCompilationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetCompilationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_GetCompilationResult_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetCompilationResult(ctx, req.(*GetCompilationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateCompilationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCompilationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateCompilationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CreateCompilationResult_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateCompilationResult(ctx, req.(*CreateCompilationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_QueryCompilationResultActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryCompilationResultActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).QueryCompilationResultActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_QueryCompilationResultActions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).QueryCompilationResultActions(ctx, req.(*QueryCompilationResultActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListWorkflowConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkflowConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListWorkflowConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ListWorkflowConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListWorkflowConfigs(ctx, req.(*ListWorkflowConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetWorkflowConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetWorkflowConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_GetWorkflowConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetWorkflowConfig(ctx, req.(*GetWorkflowConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateWorkflowConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkflowConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateWorkflowConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CreateWorkflowConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateWorkflowConfig(ctx, req.(*CreateWorkflowConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_UpdateWorkflowConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkflowConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).UpdateWorkflowConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_UpdateWorkflowConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).UpdateWorkflowConfig(ctx, req.(*UpdateWorkflowConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteWorkflowConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteWorkflowConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_DeleteWorkflowConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteWorkflowConfig(ctx, req.(*DeleteWorkflowConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListWorkflowInvocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkflowInvocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListWorkflowInvocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_ListWorkflowInvocations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListWorkflowInvocations(ctx, req.(*ListWorkflowInvocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetWorkflowInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetWorkflowInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_GetWorkflowInvocation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetWorkflowInvocation(ctx, req.(*GetWorkflowInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateWorkflowInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkflowInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateWorkflowInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CreateWorkflowInvocation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateWorkflowInvocation(ctx, req.(*CreateWorkflowInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteWorkflowInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteWorkflowInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_DeleteWorkflowInvocation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteWorkflowInvocation(ctx, req.(*DeleteWorkflowInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CancelWorkflowInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelWorkflowInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CancelWorkflowInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_CancelWorkflowInvocation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CancelWorkflowInvocation(ctx, req.(*CancelWorkflowInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_QueryWorkflowInvocationActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWorkflowInvocationActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).QueryWorkflowInvocationActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_QueryWorkflowInvocationActions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).QueryWorkflowInvocationActions(ctx, req.(*QueryWorkflowInvocationActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_GetConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_UpdateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).UpdateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Dataform_UpdateConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).UpdateConfig(ctx, req.(*UpdateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Dataform_ServiceDesc is the grpc.ServiceDesc for Dataform service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Dataform_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataform.v1beta1.Dataform",
	HandlerType: (*DataformServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRepositories",
			Handler:    _Dataform_ListRepositories_Handler,
		},
		{
			MethodName: "GetRepository",
			Handler:    _Dataform_GetRepository_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _Dataform_CreateRepository_Handler,
		},
		{
			MethodName: "UpdateRepository",
			Handler:    _Dataform_UpdateRepository_Handler,
		},
		{
			MethodName: "DeleteRepository",
			Handler:    _Dataform_DeleteRepository_Handler,
		},
		{
			MethodName: "CommitRepositoryChanges",
			Handler:    _Dataform_CommitRepositoryChanges_Handler,
		},
		{
			MethodName: "ReadRepositoryFile",
			Handler:    _Dataform_ReadRepositoryFile_Handler,
		},
		{
			MethodName: "QueryRepositoryDirectoryContents",
			Handler:    _Dataform_QueryRepositoryDirectoryContents_Handler,
		},
		{
			MethodName: "FetchRepositoryHistory",
			Handler:    _Dataform_FetchRepositoryHistory_Handler,
		},
		{
			MethodName: "ComputeRepositoryAccessTokenStatus",
			Handler:    _Dataform_ComputeRepositoryAccessTokenStatus_Handler,
		},
		{
			MethodName: "FetchRemoteBranches",
			Handler:    _Dataform_FetchRemoteBranches_Handler,
		},
		{
			MethodName: "ListWorkspaces",
			Handler:    _Dataform_ListWorkspaces_Handler,
		},
		{
			MethodName: "GetWorkspace",
			Handler:    _Dataform_GetWorkspace_Handler,
		},
		{
			MethodName: "CreateWorkspace",
			Handler:    _Dataform_CreateWorkspace_Handler,
		},
		{
			MethodName: "DeleteWorkspace",
			Handler:    _Dataform_DeleteWorkspace_Handler,
		},
		{
			MethodName: "InstallNpmPackages",
			Handler:    _Dataform_InstallNpmPackages_Handler,
		},
		{
			MethodName: "PullGitCommits",
			Handler:    _Dataform_PullGitCommits_Handler,
		},
		{
			MethodName: "PushGitCommits",
			Handler:    _Dataform_PushGitCommits_Handler,
		},
		{
			MethodName: "FetchFileGitStatuses",
			Handler:    _Dataform_FetchFileGitStatuses_Handler,
		},
		{
			MethodName: "FetchGitAheadBehind",
			Handler:    _Dataform_FetchGitAheadBehind_Handler,
		},
		{
			MethodName: "CommitWorkspaceChanges",
			Handler:    _Dataform_CommitWorkspaceChanges_Handler,
		},
		{
			MethodName: "ResetWorkspaceChanges",
			Handler:    _Dataform_ResetWorkspaceChanges_Handler,
		},
		{
			MethodName: "FetchFileDiff",
			Handler:    _Dataform_FetchFileDiff_Handler,
		},
		{
			MethodName: "QueryDirectoryContents",
			Handler:    _Dataform_QueryDirectoryContents_Handler,
		},
		{
			MethodName: "SearchFiles",
			Handler:    _Dataform_SearchFiles_Handler,
		},
		{
			MethodName: "MakeDirectory",
			Handler:    _Dataform_MakeDirectory_Handler,
		},
		{
			MethodName: "RemoveDirectory",
			Handler:    _Dataform_RemoveDirectory_Handler,
		},
		{
			MethodName: "MoveDirectory",
			Handler:    _Dataform_MoveDirectory_Handler,
		},
		{
			MethodName: "ReadFile",
			Handler:    _Dataform_ReadFile_Handler,
		},
		{
			MethodName: "RemoveFile",
			Handler:    _Dataform_RemoveFile_Handler,
		},
		{
			MethodName: "MoveFile",
			Handler:    _Dataform_MoveFile_Handler,
		},
		{
			MethodName: "WriteFile",
			Handler:    _Dataform_WriteFile_Handler,
		},
		{
			MethodName: "ListReleaseConfigs",
			Handler:    _Dataform_ListReleaseConfigs_Handler,
		},
		{
			MethodName: "GetReleaseConfig",
			Handler:    _Dataform_GetReleaseConfig_Handler,
		},
		{
			MethodName: "CreateReleaseConfig",
			Handler:    _Dataform_CreateReleaseConfig_Handler,
		},
		{
			MethodName: "UpdateReleaseConfig",
			Handler:    _Dataform_UpdateReleaseConfig_Handler,
		},
		{
			MethodName: "DeleteReleaseConfig",
			Handler:    _Dataform_DeleteReleaseConfig_Handler,
		},
		{
			MethodName: "ListCompilationResults",
			Handler:    _Dataform_ListCompilationResults_Handler,
		},
		{
			MethodName: "GetCompilationResult",
			Handler:    _Dataform_GetCompilationResult_Handler,
		},
		{
			MethodName: "CreateCompilationResult",
			Handler:    _Dataform_CreateCompilationResult_Handler,
		},
		{
			MethodName: "QueryCompilationResultActions",
			Handler:    _Dataform_QueryCompilationResultActions_Handler,
		},
		{
			MethodName: "ListWorkflowConfigs",
			Handler:    _Dataform_ListWorkflowConfigs_Handler,
		},
		{
			MethodName: "GetWorkflowConfig",
			Handler:    _Dataform_GetWorkflowConfig_Handler,
		},
		{
			MethodName: "CreateWorkflowConfig",
			Handler:    _Dataform_CreateWorkflowConfig_Handler,
		},
		{
			MethodName: "UpdateWorkflowConfig",
			Handler:    _Dataform_UpdateWorkflowConfig_Handler,
		},
		{
			MethodName: "DeleteWorkflowConfig",
			Handler:    _Dataform_DeleteWorkflowConfig_Handler,
		},
		{
			MethodName: "ListWorkflowInvocations",
			Handler:    _Dataform_ListWorkflowInvocations_Handler,
		},
		{
			MethodName: "GetWorkflowInvocation",
			Handler:    _Dataform_GetWorkflowInvocation_Handler,
		},
		{
			MethodName: "CreateWorkflowInvocation",
			Handler:    _Dataform_CreateWorkflowInvocation_Handler,
		},
		{
			MethodName: "DeleteWorkflowInvocation",
			Handler:    _Dataform_DeleteWorkflowInvocation_Handler,
		},
		{
			MethodName: "CancelWorkflowInvocation",
			Handler:    _Dataform_CancelWorkflowInvocation_Handler,
		},
		{
			MethodName: "QueryWorkflowInvocationActions",
			Handler:    _Dataform_QueryWorkflowInvocationActions_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _Dataform_GetConfig_Handler,
		},
		{
			MethodName: "UpdateConfig",
			Handler:    _Dataform_UpdateConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataform/v1beta1/dataform.proto",
}
