// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/language/v1beta2/language_service.proto

package languagepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	LanguageService_AnalyzeSentiment_FullMethodName       = "/google.cloud.language.v1beta2.LanguageService/AnalyzeSentiment"
	LanguageService_AnalyzeEntities_FullMethodName        = "/google.cloud.language.v1beta2.LanguageService/AnalyzeEntities"
	LanguageService_AnalyzeEntitySentiment_FullMethodName = "/google.cloud.language.v1beta2.LanguageService/AnalyzeEntitySentiment"
	LanguageService_AnalyzeSyntax_FullMethodName          = "/google.cloud.language.v1beta2.LanguageService/AnalyzeSyntax"
	LanguageService_ClassifyText_FullMethodName           = "/google.cloud.language.v1beta2.LanguageService/ClassifyText"
	LanguageService_ModerateText_FullMethodName           = "/google.cloud.language.v1beta2.LanguageService/ModerateText"
	LanguageService_AnnotateText_FullMethodName           = "/google.cloud.language.v1beta2.LanguageService/AnnotateText"
)

// LanguageServiceClient is the client API for LanguageService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LanguageServiceClient interface {
	// Analyzes the sentiment of the provided text.
	AnalyzeSentiment(ctx context.Context, in *AnalyzeSentimentRequest, opts ...grpc.CallOption) (*AnalyzeSentimentResponse, error)
	// Finds named entities (currently proper names and common nouns) in the text
	// along with entity types, salience, mentions for each entity, and
	// other properties.
	AnalyzeEntities(ctx context.Context, in *AnalyzeEntitiesRequest, opts ...grpc.CallOption) (*AnalyzeEntitiesResponse, error)
	// Finds entities, similar to
	// [AnalyzeEntities][google.cloud.language.v1beta2.LanguageService.AnalyzeEntities]
	// in the text and analyzes sentiment associated with each entity and its
	// mentions.
	AnalyzeEntitySentiment(ctx context.Context, in *AnalyzeEntitySentimentRequest, opts ...grpc.CallOption) (*AnalyzeEntitySentimentResponse, error)
	// Analyzes the syntax of the text and provides sentence boundaries and
	// tokenization along with part of speech tags, dependency trees, and other
	// properties.
	AnalyzeSyntax(ctx context.Context, in *AnalyzeSyntaxRequest, opts ...grpc.CallOption) (*AnalyzeSyntaxResponse, error)
	// Classifies a document into categories.
	ClassifyText(ctx context.Context, in *ClassifyTextRequest, opts ...grpc.CallOption) (*ClassifyTextResponse, error)
	// Moderates a document for harmful and sensitive categories.
	ModerateText(ctx context.Context, in *ModerateTextRequest, opts ...grpc.CallOption) (*ModerateTextResponse, error)
	// A convenience method that provides all syntax, sentiment, entity, and
	// classification features in one call.
	AnnotateText(ctx context.Context, in *AnnotateTextRequest, opts ...grpc.CallOption) (*AnnotateTextResponse, error)
}

type languageServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLanguageServiceClient(cc grpc.ClientConnInterface) LanguageServiceClient {
	return &languageServiceClient{cc}
}

func (c *languageServiceClient) AnalyzeSentiment(ctx context.Context, in *AnalyzeSentimentRequest, opts ...grpc.CallOption) (*AnalyzeSentimentResponse, error) {
	out := new(AnalyzeSentimentResponse)
	err := c.cc.Invoke(ctx, LanguageService_AnalyzeSentiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnalyzeEntities(ctx context.Context, in *AnalyzeEntitiesRequest, opts ...grpc.CallOption) (*AnalyzeEntitiesResponse, error) {
	out := new(AnalyzeEntitiesResponse)
	err := c.cc.Invoke(ctx, LanguageService_AnalyzeEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnalyzeEntitySentiment(ctx context.Context, in *AnalyzeEntitySentimentRequest, opts ...grpc.CallOption) (*AnalyzeEntitySentimentResponse, error) {
	out := new(AnalyzeEntitySentimentResponse)
	err := c.cc.Invoke(ctx, LanguageService_AnalyzeEntitySentiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnalyzeSyntax(ctx context.Context, in *AnalyzeSyntaxRequest, opts ...grpc.CallOption) (*AnalyzeSyntaxResponse, error) {
	out := new(AnalyzeSyntaxResponse)
	err := c.cc.Invoke(ctx, LanguageService_AnalyzeSyntax_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) ClassifyText(ctx context.Context, in *ClassifyTextRequest, opts ...grpc.CallOption) (*ClassifyTextResponse, error) {
	out := new(ClassifyTextResponse)
	err := c.cc.Invoke(ctx, LanguageService_ClassifyText_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) ModerateText(ctx context.Context, in *ModerateTextRequest, opts ...grpc.CallOption) (*ModerateTextResponse, error) {
	out := new(ModerateTextResponse)
	err := c.cc.Invoke(ctx, LanguageService_ModerateText_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnnotateText(ctx context.Context, in *AnnotateTextRequest, opts ...grpc.CallOption) (*AnnotateTextResponse, error) {
	out := new(AnnotateTextResponse)
	err := c.cc.Invoke(ctx, LanguageService_AnnotateText_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LanguageServiceServer is the server API for LanguageService service.
// All implementations should embed UnimplementedLanguageServiceServer
// for forward compatibility
type LanguageServiceServer interface {
	// Analyzes the sentiment of the provided text.
	AnalyzeSentiment(context.Context, *AnalyzeSentimentRequest) (*AnalyzeSentimentResponse, error)
	// Finds named entities (currently proper names and common nouns) in the text
	// along with entity types, salience, mentions for each entity, and
	// other properties.
	AnalyzeEntities(context.Context, *AnalyzeEntitiesRequest) (*AnalyzeEntitiesResponse, error)
	// Finds entities, similar to
	// [AnalyzeEntities][google.cloud.language.v1beta2.LanguageService.AnalyzeEntities]
	// in the text and analyzes sentiment associated with each entity and its
	// mentions.
	AnalyzeEntitySentiment(context.Context, *AnalyzeEntitySentimentRequest) (*AnalyzeEntitySentimentResponse, error)
	// Analyzes the syntax of the text and provides sentence boundaries and
	// tokenization along with part of speech tags, dependency trees, and other
	// properties.
	AnalyzeSyntax(context.Context, *AnalyzeSyntaxRequest) (*AnalyzeSyntaxResponse, error)
	// Classifies a document into categories.
	ClassifyText(context.Context, *ClassifyTextRequest) (*ClassifyTextResponse, error)
	// Moderates a document for harmful and sensitive categories.
	ModerateText(context.Context, *ModerateTextRequest) (*ModerateTextResponse, error)
	// A convenience method that provides all syntax, sentiment, entity, and
	// classification features in one call.
	AnnotateText(context.Context, *AnnotateTextRequest) (*AnnotateTextResponse, error)
}

// UnimplementedLanguageServiceServer should be embedded to have forward compatible implementations.
type UnimplementedLanguageServiceServer struct {
}

func (UnimplementedLanguageServiceServer) AnalyzeSentiment(context.Context, *AnalyzeSentimentRequest) (*AnalyzeSentimentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeSentiment not implemented")
}
func (UnimplementedLanguageServiceServer) AnalyzeEntities(context.Context, *AnalyzeEntitiesRequest) (*AnalyzeEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeEntities not implemented")
}
func (UnimplementedLanguageServiceServer) AnalyzeEntitySentiment(context.Context, *AnalyzeEntitySentimentRequest) (*AnalyzeEntitySentimentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeEntitySentiment not implemented")
}
func (UnimplementedLanguageServiceServer) AnalyzeSyntax(context.Context, *AnalyzeSyntaxRequest) (*AnalyzeSyntaxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeSyntax not implemented")
}
func (UnimplementedLanguageServiceServer) ClassifyText(context.Context, *ClassifyTextRequest) (*ClassifyTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClassifyText not implemented")
}
func (UnimplementedLanguageServiceServer) ModerateText(context.Context, *ModerateTextRequest) (*ModerateTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModerateText not implemented")
}
func (UnimplementedLanguageServiceServer) AnnotateText(context.Context, *AnnotateTextRequest) (*AnnotateTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateText not implemented")
}

// UnsafeLanguageServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LanguageServiceServer will
// result in compilation errors.
type UnsafeLanguageServiceServer interface {
	mustEmbedUnimplementedLanguageServiceServer()
}

func RegisterLanguageServiceServer(s grpc.ServiceRegistrar, srv LanguageServiceServer) {
	s.RegisterService(&LanguageService_ServiceDesc, srv)
}

func _LanguageService_AnalyzeSentiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeSentimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeSentiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LanguageService_AnalyzeSentiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeSentiment(ctx, req.(*AnalyzeSentimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnalyzeEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LanguageService_AnalyzeEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeEntities(ctx, req.(*AnalyzeEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnalyzeEntitySentiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeEntitySentimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeEntitySentiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LanguageService_AnalyzeEntitySentiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeEntitySentiment(ctx, req.(*AnalyzeEntitySentimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnalyzeSyntax_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeSyntaxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeSyntax(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LanguageService_AnalyzeSyntax_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeSyntax(ctx, req.(*AnalyzeSyntaxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_ClassifyText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClassifyTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).ClassifyText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LanguageService_ClassifyText_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).ClassifyText(ctx, req.(*ClassifyTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_ModerateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModerateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).ModerateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LanguageService_ModerateText_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).ModerateText(ctx, req.(*ModerateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnnotateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnnotateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LanguageService_AnnotateText_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnnotateText(ctx, req.(*AnnotateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LanguageService_ServiceDesc is the grpc.ServiceDesc for LanguageService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LanguageService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.language.v1beta2.LanguageService",
	HandlerType: (*LanguageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnalyzeSentiment",
			Handler:    _LanguageService_AnalyzeSentiment_Handler,
		},
		{
			MethodName: "AnalyzeEntities",
			Handler:    _LanguageService_AnalyzeEntities_Handler,
		},
		{
			MethodName: "AnalyzeEntitySentiment",
			Handler:    _LanguageService_AnalyzeEntitySentiment_Handler,
		},
		{
			MethodName: "AnalyzeSyntax",
			Handler:    _LanguageService_AnalyzeSyntax_Handler,
		},
		{
			MethodName: "ClassifyText",
			Handler:    _LanguageService_ClassifyText_Handler,
		},
		{
			MethodName: "ModerateText",
			Handler:    _LanguageService_ModerateText_Handler,
		},
		{
			MethodName: "AnnotateText",
			Handler:    _LanguageService_AnnotateText_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/language/v1beta2/language_service.proto",
}
