// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/tasks/v2beta2/cloudtasks.proto

package cloudtaskspb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudTasks_ListQueues_FullMethodName         = "/google.cloud.tasks.v2beta2.CloudTasks/ListQueues"
	CloudTasks_GetQueue_FullMethodName           = "/google.cloud.tasks.v2beta2.CloudTasks/GetQueue"
	CloudTasks_CreateQueue_FullMethodName        = "/google.cloud.tasks.v2beta2.CloudTasks/CreateQueue"
	CloudTasks_UpdateQueue_FullMethodName        = "/google.cloud.tasks.v2beta2.CloudTasks/UpdateQueue"
	CloudTasks_DeleteQueue_FullMethodName        = "/google.cloud.tasks.v2beta2.CloudTasks/DeleteQueue"
	CloudTasks_PurgeQueue_FullMethodName         = "/google.cloud.tasks.v2beta2.CloudTasks/PurgeQueue"
	CloudTasks_PauseQueue_FullMethodName         = "/google.cloud.tasks.v2beta2.CloudTasks/PauseQueue"
	CloudTasks_ResumeQueue_FullMethodName        = "/google.cloud.tasks.v2beta2.CloudTasks/ResumeQueue"
	CloudTasks_UploadQueueYaml_FullMethodName    = "/google.cloud.tasks.v2beta2.CloudTasks/UploadQueueYaml"
	CloudTasks_GetIamPolicy_FullMethodName       = "/google.cloud.tasks.v2beta2.CloudTasks/GetIamPolicy"
	CloudTasks_SetIamPolicy_FullMethodName       = "/google.cloud.tasks.v2beta2.CloudTasks/SetIamPolicy"
	CloudTasks_TestIamPermissions_FullMethodName = "/google.cloud.tasks.v2beta2.CloudTasks/TestIamPermissions"
	CloudTasks_ListTasks_FullMethodName          = "/google.cloud.tasks.v2beta2.CloudTasks/ListTasks"
	CloudTasks_GetTask_FullMethodName            = "/google.cloud.tasks.v2beta2.CloudTasks/GetTask"
	CloudTasks_CreateTask_FullMethodName         = "/google.cloud.tasks.v2beta2.CloudTasks/CreateTask"
	CloudTasks_DeleteTask_FullMethodName         = "/google.cloud.tasks.v2beta2.CloudTasks/DeleteTask"
	CloudTasks_LeaseTasks_FullMethodName         = "/google.cloud.tasks.v2beta2.CloudTasks/LeaseTasks"
	CloudTasks_AcknowledgeTask_FullMethodName    = "/google.cloud.tasks.v2beta2.CloudTasks/AcknowledgeTask"
	CloudTasks_RenewLease_FullMethodName         = "/google.cloud.tasks.v2beta2.CloudTasks/RenewLease"
	CloudTasks_CancelLease_FullMethodName        = "/google.cloud.tasks.v2beta2.CloudTasks/CancelLease"
	CloudTasks_RunTask_FullMethodName            = "/google.cloud.tasks.v2beta2.CloudTasks/RunTask"
)

// CloudTasksClient is the client API for CloudTasks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudTasksClient interface {
	// Lists queues.
	//
	// Queues are returned in lexicographical order.
	ListQueues(ctx context.Context, in *ListQueuesRequest, opts ...grpc.CallOption) (*ListQueuesResponse, error)
	// Gets a queue.
	GetQueue(ctx context.Context, in *GetQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Creates a queue.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of
	// whether it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	CreateQueue(ctx context.Context, in *CreateQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Updates a queue.
	//
	// This method creates the queue if it does not exist and updates
	// the queue if it does exist.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of
	// whether it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	UpdateQueue(ctx context.Context, in *UpdateQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Deletes a queue.
	//
	// This command will delete the queue even if it has tasks in it.
	//
	// Note: If you delete a queue, a queue with the same name can't be created
	// for 7 days.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	DeleteQueue(ctx context.Context, in *DeleteQueueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Purges a queue by deleting all of its tasks.
	//
	// All tasks created before this method is called are permanently deleted.
	//
	// Purge operations can take up to one minute to take effect. Tasks
	// might be dispatched before the purge takes effect. A purge is irreversible.
	PurgeQueue(ctx context.Context, in *PurgeQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Pauses the queue.
	//
	// If a queue is paused then the system will stop dispatching tasks
	// until the queue is resumed via
	// [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue]. Tasks can
	// still be added when the queue is paused. A queue is paused if its
	// [state][google.cloud.tasks.v2beta2.Queue.state] is
	// [PAUSED][google.cloud.tasks.v2beta2.Queue.State.PAUSED].
	PauseQueue(ctx context.Context, in *PauseQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Resume a queue.
	//
	// This method resumes a queue after it has been
	// [PAUSED][google.cloud.tasks.v2beta2.Queue.State.PAUSED] or
	// [DISABLED][google.cloud.tasks.v2beta2.Queue.State.DISABLED]. The state of a
	// queue is stored in the queue's
	// [state][google.cloud.tasks.v2beta2.Queue.state]; after calling this method
	// it will be set to
	// [RUNNING][google.cloud.tasks.v2beta2.Queue.State.RUNNING].
	//
	// WARNING: Resuming many high-QPS queues at the same time can
	// lead to target overloading. If you are resuming high-QPS
	// queues, follow the 500/50/5 pattern described in
	// [Managing Cloud Tasks Scaling
	// Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
	ResumeQueue(ctx context.Context, in *ResumeQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Update queue list by uploading a queue.yaml file.
	//
	// The queue.yaml file is supplied in the request body as a YAML encoded
	// string. This method was added to support gcloud clients versions before
	// 322.0.0. New clients should use CreateQueue instead of this method.
	UploadQueueYaml(ctx context.Context, in *UploadQueueYamlRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the access control policy for a
	// [Queue][google.cloud.tasks.v2beta2.Queue]. Returns an empty policy if the
	// resource exists and does not have a policy set.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.getIamPolicy`
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy for a
	// [Queue][google.cloud.tasks.v2beta2.Queue]. Replaces any existing policy.
	//
	// Note: The Cloud Console does not check queue-level IAM permissions yet.
	// Project-level permissions are required to use the Cloud Console.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.setIamPolicy`
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on a
	// [Queue][google.cloud.tasks.v2beta2.Queue]. If the resource does not exist,
	// this will return an empty set of permissions, not a
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Lists the tasks in a queue.
	//
	// By default, only the [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]
	// view is retrieved due to performance considerations;
	// [response_view][google.cloud.tasks.v2beta2.ListTasksRequest.response_view]
	// controls the subset of information which is returned.
	//
	// The tasks may be returned in any order. The ordering may change at any
	// time.
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	// Gets a task.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Creates a task and adds it to a queue.
	//
	// Tasks cannot be updated after creation; there is no UpdateTask command.
	//
	// * For [App Engine queues][google.cloud.tasks.v2beta2.AppEngineHttpTarget],
	// the maximum task size is
	//
	//	100KB.
	//
	// * For [pull queues][google.cloud.tasks.v2beta2.PullTarget], the maximum
	// task size is 1MB.
	CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Deletes a task.
	//
	// A task can be deleted if it is scheduled or dispatched. A task
	// cannot be deleted if it has completed successfully or permanently
	// failed.
	DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Leases tasks from a pull queue for
	// [lease_duration][google.cloud.tasks.v2beta2.LeaseTasksRequest.lease_duration].
	//
	// This method is invoked by the worker to obtain a lease. The
	// worker must acknowledge the task via
	// [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
	// after they have performed the work associated with the task.
	//
	// The [payload][google.cloud.tasks.v2beta2.PullMessage.payload] is intended
	// to store data that the worker needs to perform the work associated with the
	// task. To return the payloads in the
	// [response][google.cloud.tasks.v2beta2.LeaseTasksResponse], set
	// [response_view][google.cloud.tasks.v2beta2.LeaseTasksRequest.response_view]
	// to [FULL][google.cloud.tasks.v2beta2.Task.View.FULL].
	//
	// A maximum of 10 qps of
	// [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] requests are
	// allowed per queue. [RESOURCE_EXHAUSTED][google.rpc.Code.RESOURCE_EXHAUSTED]
	// is returned when this limit is
	// exceeded. [RESOURCE_EXHAUSTED][google.rpc.Code.RESOURCE_EXHAUSTED]
	// is also returned when
	// [max_tasks_dispatched_per_second][google.cloud.tasks.v2beta2.RateLimits.max_tasks_dispatched_per_second]
	// is exceeded.
	LeaseTasks(ctx context.Context, in *LeaseTasksRequest, opts ...grpc.CallOption) (*LeaseTasksResponse, error)
	// Acknowledges a pull task.
	//
	// The worker, that is, the entity that
	// [leased][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] this task must
	// call this method to indicate that the work associated with the task has
	// finished.
	//
	// The worker must acknowledge a task within the
	// [lease_duration][google.cloud.tasks.v2beta2.LeaseTasksRequest.lease_duration]
	// or the lease will expire and the task will become available to be leased
	// again. After the task is acknowledged, it will not be returned
	// by a later [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks],
	// [GetTask][google.cloud.tasks.v2beta2.CloudTasks.GetTask], or
	// [ListTasks][google.cloud.tasks.v2beta2.CloudTasks.ListTasks].
	AcknowledgeTask(ctx context.Context, in *AcknowledgeTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Renew the current lease of a pull task.
	//
	// The worker can use this method to extend the lease by a new
	// duration, starting from now. The new task lease will be
	// returned in the task's
	// [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
	RenewLease(ctx context.Context, in *RenewLeaseRequest, opts ...grpc.CallOption) (*Task, error)
	// Cancel a pull task's lease.
	//
	// The worker can use this method to cancel a task's lease by
	// setting its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]
	// to now. This will make the task available to be leased to the next caller
	// of [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks].
	CancelLease(ctx context.Context, in *CancelLeaseRequest, opts ...grpc.CallOption) (*Task, error)
	// Forces a task to run now.
	//
	// When this method is called, Cloud Tasks will dispatch the task, even if
	// the task is already running, the queue has reached its
	// [RateLimits][google.cloud.tasks.v2beta2.RateLimits] or is
	// [PAUSED][google.cloud.tasks.v2beta2.Queue.State.PAUSED].
	//
	// This command is meant to be used for manual debugging. For
	// example, [RunTask][google.cloud.tasks.v2beta2.CloudTasks.RunTask] can be
	// used to retry a failed task after a fix has been made or to manually force
	// a task to be dispatched now.
	//
	// The dispatched task is returned. That is, the task that is returned
	// contains the [status][google.cloud.tasks.v2beta2.Task.status] after the
	// task is dispatched but before the task is received by its target.
	//
	// If Cloud Tasks receives a successful response from the task's
	// target, then the task will be deleted; otherwise the task's
	// [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
	// reset to the time that
	// [RunTask][google.cloud.tasks.v2beta2.CloudTasks.RunTask] was called plus
	// the retry delay specified in the queue's
	// [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig].
	//
	// [RunTask][google.cloud.tasks.v2beta2.CloudTasks.RunTask] returns
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
	// task that has already succeeded or permanently failed.
	//
	// [RunTask][google.cloud.tasks.v2beta2.CloudTasks.RunTask] cannot be called
	// on a [pull task][google.cloud.tasks.v2beta2.PullMessage].
	RunTask(ctx context.Context, in *RunTaskRequest, opts ...grpc.CallOption) (*Task, error)
}

type cloudTasksClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudTasksClient(cc grpc.ClientConnInterface) CloudTasksClient {
	return &cloudTasksClient{cc}
}

func (c *cloudTasksClient) ListQueues(ctx context.Context, in *ListQueuesRequest, opts ...grpc.CallOption) (*ListQueuesResponse, error) {
	out := new(ListQueuesResponse)
	err := c.cc.Invoke(ctx, CloudTasks_ListQueues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetQueue(ctx context.Context, in *GetQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, CloudTasks_GetQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) CreateQueue(ctx context.Context, in *CreateQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, CloudTasks_CreateQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) UpdateQueue(ctx context.Context, in *UpdateQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, CloudTasks_UpdateQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) DeleteQueue(ctx context.Context, in *DeleteQueueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CloudTasks_DeleteQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) PurgeQueue(ctx context.Context, in *PurgeQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, CloudTasks_PurgeQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) PauseQueue(ctx context.Context, in *PauseQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, CloudTasks_PauseQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) ResumeQueue(ctx context.Context, in *ResumeQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, CloudTasks_ResumeQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) UploadQueueYaml(ctx context.Context, in *UploadQueueYamlRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CloudTasks_UploadQueueYaml_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, CloudTasks_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, CloudTasks_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, CloudTasks_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	out := new(ListTasksResponse)
	err := c.cc.Invoke(ctx, CloudTasks_ListTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, CloudTasks_GetTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, CloudTasks_CreateTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CloudTasks_DeleteTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) LeaseTasks(ctx context.Context, in *LeaseTasksRequest, opts ...grpc.CallOption) (*LeaseTasksResponse, error) {
	out := new(LeaseTasksResponse)
	err := c.cc.Invoke(ctx, CloudTasks_LeaseTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) AcknowledgeTask(ctx context.Context, in *AcknowledgeTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CloudTasks_AcknowledgeTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) RenewLease(ctx context.Context, in *RenewLeaseRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, CloudTasks_RenewLease_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) CancelLease(ctx context.Context, in *CancelLeaseRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, CloudTasks_CancelLease_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) RunTask(ctx context.Context, in *RunTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, CloudTasks_RunTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudTasksServer is the server API for CloudTasks service.
// All implementations should embed UnimplementedCloudTasksServer
// for forward compatibility
type CloudTasksServer interface {
	// Lists queues.
	//
	// Queues are returned in lexicographical order.
	ListQueues(context.Context, *ListQueuesRequest) (*ListQueuesResponse, error)
	// Gets a queue.
	GetQueue(context.Context, *GetQueueRequest) (*Queue, error)
	// Creates a queue.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of
	// whether it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	CreateQueue(context.Context, *CreateQueueRequest) (*Queue, error)
	// Updates a queue.
	//
	// This method creates the queue if it does not exist and updates
	// the queue if it does exist.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of
	// whether it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	UpdateQueue(context.Context, *UpdateQueueRequest) (*Queue, error)
	// Deletes a queue.
	//
	// This command will delete the queue even if it has tasks in it.
	//
	// Note: If you delete a queue, a queue with the same name can't be created
	// for 7 days.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	DeleteQueue(context.Context, *DeleteQueueRequest) (*emptypb.Empty, error)
	// Purges a queue by deleting all of its tasks.
	//
	// All tasks created before this method is called are permanently deleted.
	//
	// Purge operations can take up to one minute to take effect. Tasks
	// might be dispatched before the purge takes effect. A purge is irreversible.
	PurgeQueue(context.Context, *PurgeQueueRequest) (*Queue, error)
	// Pauses the queue.
	//
	// If a queue is paused then the system will stop dispatching tasks
	// until the queue is resumed via
	// [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue]. Tasks can
	// still be added when the queue is paused. A queue is paused if its
	// [state][google.cloud.tasks.v2beta2.Queue.state] is
	// [PAUSED][google.cloud.tasks.v2beta2.Queue.State.PAUSED].
	PauseQueue(context.Context, *PauseQueueRequest) (*Queue, error)
	// Resume a queue.
	//
	// This method resumes a queue after it has been
	// [PAUSED][google.cloud.tasks.v2beta2.Queue.State.PAUSED] or
	// [DISABLED][google.cloud.tasks.v2beta2.Queue.State.DISABLED]. The state of a
	// queue is stored in the queue's
	// [state][google.cloud.tasks.v2beta2.Queue.state]; after calling this method
	// it will be set to
	// [RUNNING][google.cloud.tasks.v2beta2.Queue.State.RUNNING].
	//
	// WARNING: Resuming many high-QPS queues at the same time can
	// lead to target overloading. If you are resuming high-QPS
	// queues, follow the 500/50/5 pattern described in
	// [Managing Cloud Tasks Scaling
	// Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
	ResumeQueue(context.Context, *ResumeQueueRequest) (*Queue, error)
	// Update queue list by uploading a queue.yaml file.
	//
	// The queue.yaml file is supplied in the request body as a YAML encoded
	// string. This method was added to support gcloud clients versions before
	// 322.0.0. New clients should use CreateQueue instead of this method.
	UploadQueueYaml(context.Context, *UploadQueueYamlRequest) (*emptypb.Empty, error)
	// Gets the access control policy for a
	// [Queue][google.cloud.tasks.v2beta2.Queue]. Returns an empty policy if the
	// resource exists and does not have a policy set.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.getIamPolicy`
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy for a
	// [Queue][google.cloud.tasks.v2beta2.Queue]. Replaces any existing policy.
	//
	// Note: The Cloud Console does not check queue-level IAM permissions yet.
	// Project-level permissions are required to use the Cloud Console.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.setIamPolicy`
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on a
	// [Queue][google.cloud.tasks.v2beta2.Queue]. If the resource does not exist,
	// this will return an empty set of permissions, not a
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Lists the tasks in a queue.
	//
	// By default, only the [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]
	// view is retrieved due to performance considerations;
	// [response_view][google.cloud.tasks.v2beta2.ListTasksRequest.response_view]
	// controls the subset of information which is returned.
	//
	// The tasks may be returned in any order. The ordering may change at any
	// time.
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	// Gets a task.
	GetTask(context.Context, *GetTaskRequest) (*Task, error)
	// Creates a task and adds it to a queue.
	//
	// Tasks cannot be updated after creation; there is no UpdateTask command.
	//
	// * For [App Engine queues][google.cloud.tasks.v2beta2.AppEngineHttpTarget],
	// the maximum task size is
	//
	//	100KB.
	//
	// * For [pull queues][google.cloud.tasks.v2beta2.PullTarget], the maximum
	// task size is 1MB.
	CreateTask(context.Context, *CreateTaskRequest) (*Task, error)
	// Deletes a task.
	//
	// A task can be deleted if it is scheduled or dispatched. A task
	// cannot be deleted if it has completed successfully or permanently
	// failed.
	DeleteTask(context.Context, *DeleteTaskRequest) (*emptypb.Empty, error)
	// Leases tasks from a pull queue for
	// [lease_duration][google.cloud.tasks.v2beta2.LeaseTasksRequest.lease_duration].
	//
	// This method is invoked by the worker to obtain a lease. The
	// worker must acknowledge the task via
	// [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
	// after they have performed the work associated with the task.
	//
	// The [payload][google.cloud.tasks.v2beta2.PullMessage.payload] is intended
	// to store data that the worker needs to perform the work associated with the
	// task. To return the payloads in the
	// [response][google.cloud.tasks.v2beta2.LeaseTasksResponse], set
	// [response_view][google.cloud.tasks.v2beta2.LeaseTasksRequest.response_view]
	// to [FULL][google.cloud.tasks.v2beta2.Task.View.FULL].
	//
	// A maximum of 10 qps of
	// [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] requests are
	// allowed per queue. [RESOURCE_EXHAUSTED][google.rpc.Code.RESOURCE_EXHAUSTED]
	// is returned when this limit is
	// exceeded. [RESOURCE_EXHAUSTED][google.rpc.Code.RESOURCE_EXHAUSTED]
	// is also returned when
	// [max_tasks_dispatched_per_second][google.cloud.tasks.v2beta2.RateLimits.max_tasks_dispatched_per_second]
	// is exceeded.
	LeaseTasks(context.Context, *LeaseTasksRequest) (*LeaseTasksResponse, error)
	// Acknowledges a pull task.
	//
	// The worker, that is, the entity that
	// [leased][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] this task must
	// call this method to indicate that the work associated with the task has
	// finished.
	//
	// The worker must acknowledge a task within the
	// [lease_duration][google.cloud.tasks.v2beta2.LeaseTasksRequest.lease_duration]
	// or the lease will expire and the task will become available to be leased
	// again. After the task is acknowledged, it will not be returned
	// by a later [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks],
	// [GetTask][google.cloud.tasks.v2beta2.CloudTasks.GetTask], or
	// [ListTasks][google.cloud.tasks.v2beta2.CloudTasks.ListTasks].
	AcknowledgeTask(context.Context, *AcknowledgeTaskRequest) (*emptypb.Empty, error)
	// Renew the current lease of a pull task.
	//
	// The worker can use this method to extend the lease by a new
	// duration, starting from now. The new task lease will be
	// returned in the task's
	// [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
	RenewLease(context.Context, *RenewLeaseRequest) (*Task, error)
	// Cancel a pull task's lease.
	//
	// The worker can use this method to cancel a task's lease by
	// setting its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]
	// to now. This will make the task available to be leased to the next caller
	// of [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks].
	CancelLease(context.Context, *CancelLeaseRequest) (*Task, error)
	// Forces a task to run now.
	//
	// When this method is called, Cloud Tasks will dispatch the task, even if
	// the task is already running, the queue has reached its
	// [RateLimits][google.cloud.tasks.v2beta2.RateLimits] or is
	// [PAUSED][google.cloud.tasks.v2beta2.Queue.State.PAUSED].
	//
	// This command is meant to be used for manual debugging. For
	// example, [RunTask][google.cloud.tasks.v2beta2.CloudTasks.RunTask] can be
	// used to retry a failed task after a fix has been made or to manually force
	// a task to be dispatched now.
	//
	// The dispatched task is returned. That is, the task that is returned
	// contains the [status][google.cloud.tasks.v2beta2.Task.status] after the
	// task is dispatched but before the task is received by its target.
	//
	// If Cloud Tasks receives a successful response from the task's
	// target, then the task will be deleted; otherwise the task's
	// [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
	// reset to the time that
	// [RunTask][google.cloud.tasks.v2beta2.CloudTasks.RunTask] was called plus
	// the retry delay specified in the queue's
	// [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig].
	//
	// [RunTask][google.cloud.tasks.v2beta2.CloudTasks.RunTask] returns
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
	// task that has already succeeded or permanently failed.
	//
	// [RunTask][google.cloud.tasks.v2beta2.CloudTasks.RunTask] cannot be called
	// on a [pull task][google.cloud.tasks.v2beta2.PullMessage].
	RunTask(context.Context, *RunTaskRequest) (*Task, error)
}

// UnimplementedCloudTasksServer should be embedded to have forward compatible implementations.
type UnimplementedCloudTasksServer struct {
}

func (UnimplementedCloudTasksServer) ListQueues(context.Context, *ListQueuesRequest) (*ListQueuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQueues not implemented")
}
func (UnimplementedCloudTasksServer) GetQueue(context.Context, *GetQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQueue not implemented")
}
func (UnimplementedCloudTasksServer) CreateQueue(context.Context, *CreateQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateQueue not implemented")
}
func (UnimplementedCloudTasksServer) UpdateQueue(context.Context, *UpdateQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateQueue not implemented")
}
func (UnimplementedCloudTasksServer) DeleteQueue(context.Context, *DeleteQueueRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteQueue not implemented")
}
func (UnimplementedCloudTasksServer) PurgeQueue(context.Context, *PurgeQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeQueue not implemented")
}
func (UnimplementedCloudTasksServer) PauseQueue(context.Context, *PauseQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseQueue not implemented")
}
func (UnimplementedCloudTasksServer) ResumeQueue(context.Context, *ResumeQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeQueue not implemented")
}
func (UnimplementedCloudTasksServer) UploadQueueYaml(context.Context, *UploadQueueYamlRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadQueueYaml not implemented")
}
func (UnimplementedCloudTasksServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedCloudTasksServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedCloudTasksServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedCloudTasksServer) ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTasks not implemented")
}
func (UnimplementedCloudTasksServer) GetTask(context.Context, *GetTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTask not implemented")
}
func (UnimplementedCloudTasksServer) CreateTask(context.Context, *CreateTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTask not implemented")
}
func (UnimplementedCloudTasksServer) DeleteTask(context.Context, *DeleteTaskRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTask not implemented")
}
func (UnimplementedCloudTasksServer) LeaseTasks(context.Context, *LeaseTasksRequest) (*LeaseTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LeaseTasks not implemented")
}
func (UnimplementedCloudTasksServer) AcknowledgeTask(context.Context, *AcknowledgeTaskRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcknowledgeTask not implemented")
}
func (UnimplementedCloudTasksServer) RenewLease(context.Context, *RenewLeaseRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenewLease not implemented")
}
func (UnimplementedCloudTasksServer) CancelLease(context.Context, *CancelLeaseRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelLease not implemented")
}
func (UnimplementedCloudTasksServer) RunTask(context.Context, *RunTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunTask not implemented")
}

// UnsafeCloudTasksServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudTasksServer will
// result in compilation errors.
type UnsafeCloudTasksServer interface {
	mustEmbedUnimplementedCloudTasksServer()
}

func RegisterCloudTasksServer(s grpc.ServiceRegistrar, srv CloudTasksServer) {
	s.RegisterService(&CloudTasks_ServiceDesc, srv)
}

func _CloudTasks_ListQueues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQueuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ListQueues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_ListQueues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ListQueues(ctx, req.(*ListQueuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_GetQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetQueue(ctx, req.(*GetQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_CreateQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).CreateQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_CreateQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).CreateQueue(ctx, req.(*CreateQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_UpdateQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).UpdateQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_UpdateQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).UpdateQueue(ctx, req.(*UpdateQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_DeleteQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).DeleteQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_DeleteQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).DeleteQueue(ctx, req.(*DeleteQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_PurgeQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).PurgeQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_PurgeQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).PurgeQueue(ctx, req.(*PurgeQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_PauseQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).PauseQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_PauseQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).PauseQueue(ctx, req.(*PauseQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_ResumeQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ResumeQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_ResumeQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ResumeQueue(ctx, req.(*ResumeQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_UploadQueueYaml_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadQueueYamlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).UploadQueueYaml(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_UploadQueueYaml_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).UploadQueueYaml(ctx, req.(*UploadQueueYamlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ListTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_ListTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ListTasks(ctx, req.(*ListTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_GetTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_CreateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).CreateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_CreateTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).CreateTask(ctx, req.(*CreateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_DeleteTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).DeleteTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_DeleteTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).DeleteTask(ctx, req.(*DeleteTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_LeaseTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LeaseTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).LeaseTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_LeaseTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).LeaseTasks(ctx, req.(*LeaseTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_AcknowledgeTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).AcknowledgeTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_AcknowledgeTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).AcknowledgeTask(ctx, req.(*AcknowledgeTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_RenewLease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenewLeaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).RenewLease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_RenewLease_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).RenewLease(ctx, req.(*RenewLeaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_CancelLease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelLeaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).CancelLease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_CancelLease_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).CancelLease(ctx, req.(*CancelLeaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_RunTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).RunTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudTasks_RunTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).RunTask(ctx, req.(*RunTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudTasks_ServiceDesc is the grpc.ServiceDesc for CloudTasks service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudTasks_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.tasks.v2beta2.CloudTasks",
	HandlerType: (*CloudTasksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListQueues",
			Handler:    _CloudTasks_ListQueues_Handler,
		},
		{
			MethodName: "GetQueue",
			Handler:    _CloudTasks_GetQueue_Handler,
		},
		{
			MethodName: "CreateQueue",
			Handler:    _CloudTasks_CreateQueue_Handler,
		},
		{
			MethodName: "UpdateQueue",
			Handler:    _CloudTasks_UpdateQueue_Handler,
		},
		{
			MethodName: "DeleteQueue",
			Handler:    _CloudTasks_DeleteQueue_Handler,
		},
		{
			MethodName: "PurgeQueue",
			Handler:    _CloudTasks_PurgeQueue_Handler,
		},
		{
			MethodName: "PauseQueue",
			Handler:    _CloudTasks_PauseQueue_Handler,
		},
		{
			MethodName: "ResumeQueue",
			Handler:    _CloudTasks_ResumeQueue_Handler,
		},
		{
			MethodName: "UploadQueueYaml",
			Handler:    _CloudTasks_UploadQueueYaml_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _CloudTasks_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _CloudTasks_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _CloudTasks_TestIamPermissions_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _CloudTasks_ListTasks_Handler,
		},
		{
			MethodName: "GetTask",
			Handler:    _CloudTasks_GetTask_Handler,
		},
		{
			MethodName: "CreateTask",
			Handler:    _CloudTasks_CreateTask_Handler,
		},
		{
			MethodName: "DeleteTask",
			Handler:    _CloudTasks_DeleteTask_Handler,
		},
		{
			MethodName: "LeaseTasks",
			Handler:    _CloudTasks_LeaseTasks_Handler,
		},
		{
			MethodName: "AcknowledgeTask",
			Handler:    _CloudTasks_AcknowledgeTask_Handler,
		},
		{
			MethodName: "RenewLease",
			Handler:    _CloudTasks_RenewLease_Handler,
		},
		{
			MethodName: "CancelLease",
			Handler:    _CloudTasks_CancelLease_Handler,
		},
		{
			MethodName: "RunTask",
			Handler:    _CloudTasks_RunTask_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/tasks/v2beta2/cloudtasks.proto",
}
