// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/datacatalog/v1/policytagmanagerserialization.proto

package datacatalogpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A nested protocol buffer that represents a taxonomy and the hierarchy of its
// policy tags. Used for taxonomy replacement, import, and
// export.
type SerializedTaxonomy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Display name of the taxonomy. At most 200 bytes when encoded in
	// UTF-8.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the serialized taxonomy. At most 2000 bytes when
	// encoded in UTF-8. If not set, defaults to an empty description.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Top level policy tags associated with the taxonomy, if any.
	PolicyTags []*SerializedPolicyTag `protobuf:"bytes,3,rep,name=policy_tags,json=policyTags,proto3" json:"policy_tags,omitempty"`
	// A list of policy types that are activated per taxonomy.
	ActivatedPolicyTypes []Taxonomy_PolicyType `protobuf:"varint,4,rep,packed,name=activated_policy_types,json=activatedPolicyTypes,proto3,enum=google.cloud.datacatalog.v1.Taxonomy_PolicyType" json:"activated_policy_types,omitempty"`
}

func (x *SerializedTaxonomy) Reset() {
	*x = SerializedTaxonomy{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SerializedTaxonomy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerializedTaxonomy) ProtoMessage() {}

func (x *SerializedTaxonomy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerializedTaxonomy.ProtoReflect.Descriptor instead.
func (*SerializedTaxonomy) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{0}
}

func (x *SerializedTaxonomy) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SerializedTaxonomy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SerializedTaxonomy) GetPolicyTags() []*SerializedPolicyTag {
	if x != nil {
		return x.PolicyTags
	}
	return nil
}

func (x *SerializedTaxonomy) GetActivatedPolicyTypes() []Taxonomy_PolicyType {
	if x != nil {
		return x.ActivatedPolicyTypes
	}
	return nil
}

// A nested protocol buffer that represents a policy tag and all its
// descendants.
type SerializedPolicyTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the policy tag.
	//
	// This field is ignored when calling `ImportTaxonomies`.
	PolicyTag string `protobuf:"bytes,1,opt,name=policy_tag,json=policyTag,proto3" json:"policy_tag,omitempty"`
	// Required. Display name of the policy tag. At most 200 bytes when encoded
	// in UTF-8.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the serialized policy tag. At most
	// 2000 bytes when encoded in UTF-8. If not set, defaults to an
	// empty description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Children of the policy tag, if any.
	ChildPolicyTags []*SerializedPolicyTag `protobuf:"bytes,4,rep,name=child_policy_tags,json=childPolicyTags,proto3" json:"child_policy_tags,omitempty"`
}

func (x *SerializedPolicyTag) Reset() {
	*x = SerializedPolicyTag{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SerializedPolicyTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerializedPolicyTag) ProtoMessage() {}

func (x *SerializedPolicyTag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerializedPolicyTag.ProtoReflect.Descriptor instead.
func (*SerializedPolicyTag) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{1}
}

func (x *SerializedPolicyTag) GetPolicyTag() string {
	if x != nil {
		return x.PolicyTag
	}
	return ""
}

func (x *SerializedPolicyTag) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SerializedPolicyTag) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SerializedPolicyTag) GetChildPolicyTags() []*SerializedPolicyTag {
	if x != nil {
		return x.ChildPolicyTags
	}
	return nil
}

// Request message for
// [ReplaceTaxonomy][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ReplaceTaxonomy].
type ReplaceTaxonomyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the taxonomy to update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Taxonomy to update along with its child policy tags.
	SerializedTaxonomy *SerializedTaxonomy `protobuf:"bytes,2,opt,name=serialized_taxonomy,json=serializedTaxonomy,proto3" json:"serialized_taxonomy,omitempty"`
}

func (x *ReplaceTaxonomyRequest) Reset() {
	*x = ReplaceTaxonomyRequest{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplaceTaxonomyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceTaxonomyRequest) ProtoMessage() {}

func (x *ReplaceTaxonomyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceTaxonomyRequest.ProtoReflect.Descriptor instead.
func (*ReplaceTaxonomyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{2}
}

func (x *ReplaceTaxonomyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReplaceTaxonomyRequest) GetSerializedTaxonomy() *SerializedTaxonomy {
	if x != nil {
		return x.SerializedTaxonomy
	}
	return nil
}

// Request message for
// [ImportTaxonomies][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ImportTaxonomies].
type ImportTaxonomiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of project that the imported taxonomies will belong
	// to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Source taxonomies to import.
	//
	// Types that are assignable to Source:
	//
	//	*ImportTaxonomiesRequest_InlineSource
	//	*ImportTaxonomiesRequest_CrossRegionalSource
	Source isImportTaxonomiesRequest_Source `protobuf_oneof:"source"`
}

func (x *ImportTaxonomiesRequest) Reset() {
	*x = ImportTaxonomiesRequest{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportTaxonomiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTaxonomiesRequest) ProtoMessage() {}

func (x *ImportTaxonomiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTaxonomiesRequest.ProtoReflect.Descriptor instead.
func (*ImportTaxonomiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{3}
}

func (x *ImportTaxonomiesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportTaxonomiesRequest) GetSource() isImportTaxonomiesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportTaxonomiesRequest) GetInlineSource() *InlineSource {
	if x, ok := x.GetSource().(*ImportTaxonomiesRequest_InlineSource); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportTaxonomiesRequest) GetCrossRegionalSource() *CrossRegionalSource {
	if x, ok := x.GetSource().(*ImportTaxonomiesRequest_CrossRegionalSource); ok {
		return x.CrossRegionalSource
	}
	return nil
}

type isImportTaxonomiesRequest_Source interface {
	isImportTaxonomiesRequest_Source()
}

type ImportTaxonomiesRequest_InlineSource struct {
	// Inline source taxonomy to import.
	InlineSource *InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type ImportTaxonomiesRequest_CrossRegionalSource struct {
	// Cross-regional source taxonomy to import.
	CrossRegionalSource *CrossRegionalSource `protobuf:"bytes,3,opt,name=cross_regional_source,json=crossRegionalSource,proto3,oneof"`
}

func (*ImportTaxonomiesRequest_InlineSource) isImportTaxonomiesRequest_Source() {}

func (*ImportTaxonomiesRequest_CrossRegionalSource) isImportTaxonomiesRequest_Source() {}

// Inline source containing taxonomies to import.
type InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Taxonomies to import.
	Taxonomies []*SerializedTaxonomy `protobuf:"bytes,1,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
}

func (x *InlineSource) Reset() {
	*x = InlineSource{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InlineSource) ProtoMessage() {}

func (x *InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InlineSource.ProtoReflect.Descriptor instead.
func (*InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{4}
}

func (x *InlineSource) GetTaxonomies() []*SerializedTaxonomy {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

// Cross-regional source used to import an existing taxonomy into a different
// region.
type CrossRegionalSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the source taxonomy to import.
	Taxonomy string `protobuf:"bytes,1,opt,name=taxonomy,proto3" json:"taxonomy,omitempty"`
}

func (x *CrossRegionalSource) Reset() {
	*x = CrossRegionalSource{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CrossRegionalSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CrossRegionalSource) ProtoMessage() {}

func (x *CrossRegionalSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CrossRegionalSource.ProtoReflect.Descriptor instead.
func (*CrossRegionalSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{5}
}

func (x *CrossRegionalSource) GetTaxonomy() string {
	if x != nil {
		return x.Taxonomy
	}
	return ""
}

// Response message for
// [ImportTaxonomies][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ImportTaxonomies].
type ImportTaxonomiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Imported taxonomies.
	Taxonomies []*Taxonomy `protobuf:"bytes,1,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
}

func (x *ImportTaxonomiesResponse) Reset() {
	*x = ImportTaxonomiesResponse{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportTaxonomiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTaxonomiesResponse) ProtoMessage() {}

func (x *ImportTaxonomiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTaxonomiesResponse.ProtoReflect.Descriptor instead.
func (*ImportTaxonomiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{6}
}

func (x *ImportTaxonomiesResponse) GetTaxonomies() []*Taxonomy {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

// Request message for
// [ExportTaxonomies][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ExportTaxonomies].
type ExportTaxonomiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project that the exported taxonomies belong
	// to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Resource names of the taxonomies to export.
	Taxonomies []string `protobuf:"bytes,2,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
	// Required. Export destination for taxonomies.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportTaxonomiesRequest_SerializedTaxonomies
	Destination isExportTaxonomiesRequest_Destination `protobuf_oneof:"destination"`
}

func (x *ExportTaxonomiesRequest) Reset() {
	*x = ExportTaxonomiesRequest{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportTaxonomiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTaxonomiesRequest) ProtoMessage() {}

func (x *ExportTaxonomiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTaxonomiesRequest.ProtoReflect.Descriptor instead.
func (*ExportTaxonomiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{7}
}

func (x *ExportTaxonomiesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportTaxonomiesRequest) GetTaxonomies() []string {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

func (m *ExportTaxonomiesRequest) GetDestination() isExportTaxonomiesRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportTaxonomiesRequest) GetSerializedTaxonomies() bool {
	if x, ok := x.GetDestination().(*ExportTaxonomiesRequest_SerializedTaxonomies); ok {
		return x.SerializedTaxonomies
	}
	return false
}

type isExportTaxonomiesRequest_Destination interface {
	isExportTaxonomiesRequest_Destination()
}

type ExportTaxonomiesRequest_SerializedTaxonomies struct {
	// Serialized export taxonomies that contain all the policy
	// tags as nested protocol buffers.
	SerializedTaxonomies bool `protobuf:"varint,3,opt,name=serialized_taxonomies,json=serializedTaxonomies,proto3,oneof"`
}

func (*ExportTaxonomiesRequest_SerializedTaxonomies) isExportTaxonomiesRequest_Destination() {}

// Response message for
// [ExportTaxonomies][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ExportTaxonomies].
type ExportTaxonomiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of taxonomies and policy tags as nested protocol buffers.
	Taxonomies []*SerializedTaxonomy `protobuf:"bytes,1,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
}

func (x *ExportTaxonomiesResponse) Reset() {
	*x = ExportTaxonomiesResponse{}
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportTaxonomiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTaxonomiesResponse) ProtoMessage() {}

func (x *ExportTaxonomiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTaxonomiesResponse.ProtoReflect.Descriptor instead.
func (*ExportTaxonomiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP(), []int{8}
}

func (x *ExportTaxonomiesResponse) GetTaxonomies() []*SerializedTaxonomy {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

var File_google_cloud_datacatalog_v1_policytagmanagerserialization_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x74, 0x61, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x73, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x61, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x99, 0x02, 0x0a, 0x12, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x0a, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x12, 0x66, 0x0a, 0x16, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x14, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x22, 0xdc, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x11, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52,
	0x0f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73,
	0x22, 0xc0, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x54, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x13,
	0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x78, 0x6f, 0x6e,
	0x6f, 0x6d, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x12, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x61, 0x78, 0x6f, 0x6e,
	0x6f, 0x6d, 0x79, 0x22, 0xa2, 0x02, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x66, 0x0a, 0x15, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x13, 0x63, 0x72, 0x6f, 0x73, 0x73,
	0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x64, 0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x74, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x22, 0x5e,
	0x0a, 0x13, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x08, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x22, 0x61,
	0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x74, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x78,
	0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65,
	0x73, 0x22, 0xf1, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x78, 0x6f, 0x6e,
	0x6f, 0x6d, 0x79, 0x52, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x12,
	0x35, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x74, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00,
	0x52, 0x14, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a, 0x18, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4f, 0x0a, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69,
	0x65, 0x73, 0x32, 0xa7, 0x05, 0x0a, 0x1d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0xb0, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x54, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x79, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22,
	0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0xc1, 0x01, 0x0a, 0x10, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f,
	0x6d, 0x69, 0x65, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xbe, 0x01, 0x0a, 0x10,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e,
	0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e,
	0x6f, 0x6d, 0x69, 0x65, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x4e, 0xca, 0x41,
	0x1a, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe7, 0x01, 0x0a,
	0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x42, 0x22, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescData = file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDesc
)

func file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDescData
}

var file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_goTypes = []any{
	(*SerializedTaxonomy)(nil),       // 0: google.cloud.datacatalog.v1.SerializedTaxonomy
	(*SerializedPolicyTag)(nil),      // 1: google.cloud.datacatalog.v1.SerializedPolicyTag
	(*ReplaceTaxonomyRequest)(nil),   // 2: google.cloud.datacatalog.v1.ReplaceTaxonomyRequest
	(*ImportTaxonomiesRequest)(nil),  // 3: google.cloud.datacatalog.v1.ImportTaxonomiesRequest
	(*InlineSource)(nil),             // 4: google.cloud.datacatalog.v1.InlineSource
	(*CrossRegionalSource)(nil),      // 5: google.cloud.datacatalog.v1.CrossRegionalSource
	(*ImportTaxonomiesResponse)(nil), // 6: google.cloud.datacatalog.v1.ImportTaxonomiesResponse
	(*ExportTaxonomiesRequest)(nil),  // 7: google.cloud.datacatalog.v1.ExportTaxonomiesRequest
	(*ExportTaxonomiesResponse)(nil), // 8: google.cloud.datacatalog.v1.ExportTaxonomiesResponse
	(Taxonomy_PolicyType)(0),         // 9: google.cloud.datacatalog.v1.Taxonomy.PolicyType
	(*Taxonomy)(nil),                 // 10: google.cloud.datacatalog.v1.Taxonomy
}
var file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_depIdxs = []int32{
	1,  // 0: google.cloud.datacatalog.v1.SerializedTaxonomy.policy_tags:type_name -> google.cloud.datacatalog.v1.SerializedPolicyTag
	9,  // 1: google.cloud.datacatalog.v1.SerializedTaxonomy.activated_policy_types:type_name -> google.cloud.datacatalog.v1.Taxonomy.PolicyType
	1,  // 2: google.cloud.datacatalog.v1.SerializedPolicyTag.child_policy_tags:type_name -> google.cloud.datacatalog.v1.SerializedPolicyTag
	0,  // 3: google.cloud.datacatalog.v1.ReplaceTaxonomyRequest.serialized_taxonomy:type_name -> google.cloud.datacatalog.v1.SerializedTaxonomy
	4,  // 4: google.cloud.datacatalog.v1.ImportTaxonomiesRequest.inline_source:type_name -> google.cloud.datacatalog.v1.InlineSource
	5,  // 5: google.cloud.datacatalog.v1.ImportTaxonomiesRequest.cross_regional_source:type_name -> google.cloud.datacatalog.v1.CrossRegionalSource
	0,  // 6: google.cloud.datacatalog.v1.InlineSource.taxonomies:type_name -> google.cloud.datacatalog.v1.SerializedTaxonomy
	10, // 7: google.cloud.datacatalog.v1.ImportTaxonomiesResponse.taxonomies:type_name -> google.cloud.datacatalog.v1.Taxonomy
	0,  // 8: google.cloud.datacatalog.v1.ExportTaxonomiesResponse.taxonomies:type_name -> google.cloud.datacatalog.v1.SerializedTaxonomy
	2,  // 9: google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ReplaceTaxonomy:input_type -> google.cloud.datacatalog.v1.ReplaceTaxonomyRequest
	3,  // 10: google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ImportTaxonomies:input_type -> google.cloud.datacatalog.v1.ImportTaxonomiesRequest
	7,  // 11: google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ExportTaxonomies:input_type -> google.cloud.datacatalog.v1.ExportTaxonomiesRequest
	10, // 12: google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ReplaceTaxonomy:output_type -> google.cloud.datacatalog.v1.Taxonomy
	6,  // 13: google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ImportTaxonomies:output_type -> google.cloud.datacatalog.v1.ImportTaxonomiesResponse
	8,  // 14: google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ExportTaxonomies:output_type -> google.cloud.datacatalog.v1.ExportTaxonomiesResponse
	12, // [12:15] is the sub-list for method output_type
	9,  // [9:12] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_init() }
func file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_init() {
	if File_google_cloud_datacatalog_v1_policytagmanagerserialization_proto != nil {
		return
	}
	file_google_cloud_datacatalog_v1_policytagmanager_proto_init()
	file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[3].OneofWrappers = []any{
		(*ImportTaxonomiesRequest_InlineSource)(nil),
		(*ImportTaxonomiesRequest_CrossRegionalSource)(nil),
	}
	file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes[7].OneofWrappers = []any{
		(*ExportTaxonomiesRequest_SerializedTaxonomies)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_depIdxs,
		MessageInfos:      file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1_policytagmanagerserialization_proto = out.File
	file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_goTypes = nil
	file_google_cloud_datacatalog_v1_policytagmanagerserialization_proto_depIdxs = nil
}
