// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/backup/v1/resource_service.proto

package backup

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ResourceService_List_FullMethodName                         = "/yandex.cloud.backup.v1.ResourceService/List"
	ResourceService_Get_FullMethodName                          = "/yandex.cloud.backup.v1.ResourceService/Get"
	ResourceService_Delete_FullMethodName                       = "/yandex.cloud.backup.v1.ResourceService/Delete"
	ResourceService_ListTasks_FullMethodName                    = "/yandex.cloud.backup.v1.ResourceService/ListTasks"
	ResourceService_ListDirectory_FullMethodName                = "/yandex.cloud.backup.v1.ResourceService/ListDirectory"
	ResourceService_CreateDirectory_FullMethodName              = "/yandex.cloud.backup.v1.ResourceService/CreateDirectory"
	ResourceService_ListOperations_FullMethodName               = "/yandex.cloud.backup.v1.ResourceService/ListOperations"
	ResourceService_GetInstanceRegistrationToken_FullMethodName = "/yandex.cloud.backup.v1.ResourceService/GetInstanceRegistrationToken"
)

// ResourceServiceClient is the client API for ResourceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing backup resources: [Compute Cloud instances](/docs/backup/concepts/vm-connection#os).
type ResourceServiceClient interface {
	// List resources: Compute Cloud instances.
	List(ctx context.Context, in *ListResourcesRequest, opts ...grpc.CallOption) (*ListResourcesResponse, error)
	// Get specific Compute Cloud instance.
	Get(ctx context.Context, in *GetResourceRequest, opts ...grpc.CallOption) (*GetResourceResponse, error)
	// Delete specific Compute Cloud instance from Cloud Backup. It does not delete
	// instance from Cloud Compute service.
	Delete(ctx context.Context, in *DeleteResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// List tasks of resources.
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	// ListDirectory returns all subdirectories found in requested directory identified
	// by the id.
	ListDirectory(ctx context.Context, in *ListDirectoryRequest, opts ...grpc.CallOption) (*ListDirectoryResponse, error)
	// CreateDirectory creates new directory by requested path.
	CreateDirectory(ctx context.Context, in *CreateDirectoryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// ListOperations return all operations in backup service for given instance
	ListOperations(ctx context.Context, in *ListResourceOperationsRequest, opts ...grpc.CallOption) (*ListResourceOperationsResponse, error)
	// Get instance registration token to install backup agent withot SA attached to instance
	GetInstanceRegistrationToken(ctx context.Context, in *GetInstanceRegistrationTokenRequest, opts ...grpc.CallOption) (*GetInstanceRegistrationTokenResponse, error)
}

type resourceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewResourceServiceClient(cc grpc.ClientConnInterface) ResourceServiceClient {
	return &resourceServiceClient{cc}
}

func (c *resourceServiceClient) List(ctx context.Context, in *ListResourcesRequest, opts ...grpc.CallOption) (*ListResourcesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListResourcesResponse)
	err := c.cc.Invoke(ctx, ResourceService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) Get(ctx context.Context, in *GetResourceRequest, opts ...grpc.CallOption) (*GetResourceResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetResourceResponse)
	err := c.cc.Invoke(ctx, ResourceService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) Delete(ctx context.Context, in *DeleteResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ResourceService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListTasksResponse)
	err := c.cc.Invoke(ctx, ResourceService_ListTasks_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) ListDirectory(ctx context.Context, in *ListDirectoryRequest, opts ...grpc.CallOption) (*ListDirectoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListDirectoryResponse)
	err := c.cc.Invoke(ctx, ResourceService_ListDirectory_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) CreateDirectory(ctx context.Context, in *CreateDirectoryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ResourceService_CreateDirectory_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) ListOperations(ctx context.Context, in *ListResourceOperationsRequest, opts ...grpc.CallOption) (*ListResourceOperationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListResourceOperationsResponse)
	err := c.cc.Invoke(ctx, ResourceService_ListOperations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) GetInstanceRegistrationToken(ctx context.Context, in *GetInstanceRegistrationTokenRequest, opts ...grpc.CallOption) (*GetInstanceRegistrationTokenResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetInstanceRegistrationTokenResponse)
	err := c.cc.Invoke(ctx, ResourceService_GetInstanceRegistrationToken_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResourceServiceServer is the server API for ResourceService service.
// All implementations should embed UnimplementedResourceServiceServer
// for forward compatibility.
//
// A set of methods for managing backup resources: [Compute Cloud instances](/docs/backup/concepts/vm-connection#os).
type ResourceServiceServer interface {
	// List resources: Compute Cloud instances.
	List(context.Context, *ListResourcesRequest) (*ListResourcesResponse, error)
	// Get specific Compute Cloud instance.
	Get(context.Context, *GetResourceRequest) (*GetResourceResponse, error)
	// Delete specific Compute Cloud instance from Cloud Backup. It does not delete
	// instance from Cloud Compute service.
	Delete(context.Context, *DeleteResourceRequest) (*operation.Operation, error)
	// List tasks of resources.
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	// ListDirectory returns all subdirectories found in requested directory identified
	// by the id.
	ListDirectory(context.Context, *ListDirectoryRequest) (*ListDirectoryResponse, error)
	// CreateDirectory creates new directory by requested path.
	CreateDirectory(context.Context, *CreateDirectoryRequest) (*operation.Operation, error)
	// ListOperations return all operations in backup service for given instance
	ListOperations(context.Context, *ListResourceOperationsRequest) (*ListResourceOperationsResponse, error)
	// Get instance registration token to install backup agent withot SA attached to instance
	GetInstanceRegistrationToken(context.Context, *GetInstanceRegistrationTokenRequest) (*GetInstanceRegistrationTokenResponse, error)
}

// UnimplementedResourceServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedResourceServiceServer struct{}

func (UnimplementedResourceServiceServer) List(context.Context, *ListResourcesRequest) (*ListResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedResourceServiceServer) Get(context.Context, *GetResourceRequest) (*GetResourceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedResourceServiceServer) Delete(context.Context, *DeleteResourceRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedResourceServiceServer) ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTasks not implemented")
}
func (UnimplementedResourceServiceServer) ListDirectory(context.Context, *ListDirectoryRequest) (*ListDirectoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDirectory not implemented")
}
func (UnimplementedResourceServiceServer) CreateDirectory(context.Context, *CreateDirectoryRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDirectory not implemented")
}
func (UnimplementedResourceServiceServer) ListOperations(context.Context, *ListResourceOperationsRequest) (*ListResourceOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (UnimplementedResourceServiceServer) GetInstanceRegistrationToken(context.Context, *GetInstanceRegistrationTokenRequest) (*GetInstanceRegistrationTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstanceRegistrationToken not implemented")
}
func (UnimplementedResourceServiceServer) testEmbeddedByValue() {}

// UnsafeResourceServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ResourceServiceServer will
// result in compilation errors.
type UnsafeResourceServiceServer interface {
	mustEmbedUnimplementedResourceServiceServer()
}

func RegisterResourceServiceServer(s grpc.ServiceRegistrar, srv ResourceServiceServer) {
	// If the following call pancis, it indicates UnimplementedResourceServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ResourceService_ServiceDesc, srv)
}

func _ResourceService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).List(ctx, req.(*ListResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).Get(ctx, req.(*GetResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).Delete(ctx, req.(*DeleteResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).ListTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_ListTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).ListTasks(ctx, req.(*ListTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_ListDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).ListDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_ListDirectory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).ListDirectory(ctx, req.(*ListDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_CreateDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).CreateDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_CreateDirectory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).CreateDirectory(ctx, req.(*CreateDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListResourceOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_ListOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).ListOperations(ctx, req.(*ListResourceOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_GetInstanceRegistrationToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRegistrationTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).GetInstanceRegistrationToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_GetInstanceRegistrationToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).GetInstanceRegistrationToken(ctx, req.(*GetInstanceRegistrationTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ResourceService_ServiceDesc is the grpc.ServiceDesc for ResourceService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ResourceService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.backup.v1.ResourceService",
	HandlerType: (*ResourceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _ResourceService_List_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ResourceService_Get_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ResourceService_Delete_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _ResourceService_ListTasks_Handler,
		},
		{
			MethodName: "ListDirectory",
			Handler:    _ResourceService_ListDirectory_Handler,
		},
		{
			MethodName: "CreateDirectory",
			Handler:    _ResourceService_CreateDirectory_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ResourceService_ListOperations_Handler,
		},
		{
			MethodName: "GetInstanceRegistrationToken",
			Handler:    _ResourceService_GetInstanceRegistrationToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/backup/v1/resource_service.proto",
}
