// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/cloudregistry/v1/registry_service.proto

package cloudregistry

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetRegistryRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Registry resource to return.
	//
	// To get the registry ID use a [RegistryService.List] request.
	RegistryId    string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetRegistryRequest) Reset() {
	*x = GetRegistryRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRegistryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRegistryRequest) ProtoMessage() {}

func (x *GetRegistryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRegistryRequest.ProtoReflect.Descriptor instead.
func (*GetRegistryRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetRegistryRequest) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

type ListRegistriesRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to list registries in.
	//
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListRegistriesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 10.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListRegistriesResponse.next_page_token] returned by a previous list request.
	PageToken     string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListRegistriesRequest) Reset() {
	*x = ListRegistriesRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRegistriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRegistriesRequest) ProtoMessage() {}

func (x *ListRegistriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRegistriesRequest.ProtoReflect.Descriptor instead.
func (*ListRegistriesRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListRegistriesRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListRegistriesRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRegistriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListRegistriesResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of Registry resources.
	Registries []*Registry `protobuf:"bytes,1,rep,name=registries,proto3" json:"registries,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListRegistriesRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListRegistriesRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListRegistriesResponse) Reset() {
	*x = ListRegistriesResponse{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRegistriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRegistriesResponse) ProtoMessage() {}

func (x *ListRegistriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRegistriesResponse.ProtoReflect.Descriptor instead.
func (*ListRegistriesResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListRegistriesResponse) GetRegistries() []*Registry {
	if x != nil {
		return x.Registries
	}
	return nil
}

func (x *ListRegistriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateRegistryRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to create a registry in.
	//
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the registry.
	//
	// There may be only one registry per folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Kind of the registry.
	Kind Registry_Kind `protobuf:"varint,4,opt,name=kind,proto3,enum=yandex.cloud.cloudregistry.v1.Registry_Kind" json:"kind,omitempty"`
	// Type of the registry.
	Type Registry_Type `protobuf:"varint,5,opt,name=type,proto3,enum=yandex.cloud.cloudregistry.v1.Registry_Type" json:"type,omitempty"`
	// Description of the registry. 0-1024 characters long.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Property names and values.
	Properties    map[string]string `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateRegistryRequest) Reset() {
	*x = CreateRegistryRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRegistryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRegistryRequest) ProtoMessage() {}

func (x *CreateRegistryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRegistryRequest.ProtoReflect.Descriptor instead.
func (*CreateRegistryRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateRegistryRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateRegistryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateRegistryRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateRegistryRequest) GetKind() Registry_Kind {
	if x != nil {
		return x.Kind
	}
	return Registry_KIND_UNSPECIFIED
}

func (x *CreateRegistryRequest) GetType() Registry_Type {
	if x != nil {
		return x.Type
	}
	return Registry_TYPE_UNSPECIFIED
}

func (x *CreateRegistryRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateRegistryRequest) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

type CreateRegistryMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the registry that is being created.
	RegistryId    string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateRegistryMetadata) Reset() {
	*x = CreateRegistryMetadata{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRegistryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRegistryMetadata) ProtoMessage() {}

func (x *CreateRegistryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRegistryMetadata.ProtoReflect.Descriptor instead.
func (*CreateRegistryMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateRegistryMetadata) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

type UpdateRegistryRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Registry resource to update.
	//
	// To get the registry ID use a [RegistryService.List] request.
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// Field mask that specifies which fields of the Registry resource are going to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the registry.
	//
	// There may be only one registry per folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Description of the registry. 0-1024 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Property names and values.
	Properties    map[string]string `protobuf:"bytes,6,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateRegistryRequest) Reset() {
	*x = UpdateRegistryRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRegistryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRegistryRequest) ProtoMessage() {}

func (x *UpdateRegistryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRegistryRequest.ProtoReflect.Descriptor instead.
func (*UpdateRegistryRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateRegistryRequest) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

func (x *UpdateRegistryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateRegistryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateRegistryRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *UpdateRegistryRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateRegistryRequest) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

type UpdateRegistryMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Registry resource that is being updated.
	RegistryId    string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateRegistryMetadata) Reset() {
	*x = UpdateRegistryMetadata{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRegistryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRegistryMetadata) ProtoMessage() {}

func (x *UpdateRegistryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRegistryMetadata.ProtoReflect.Descriptor instead.
func (*UpdateRegistryMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateRegistryMetadata) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

type DeleteRegistryRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the registry to delete.
	RegistryId    string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRegistryRequest) Reset() {
	*x = DeleteRegistryRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRegistryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRegistryRequest) ProtoMessage() {}

func (x *DeleteRegistryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRegistryRequest.ProtoReflect.Descriptor instead.
func (*DeleteRegistryRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteRegistryRequest) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

type DeleteRegistryMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the registry that is being deleted.
	RegistryId    string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRegistryMetadata) Reset() {
	*x = DeleteRegistryMetadata{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRegistryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRegistryMetadata) ProtoMessage() {}

func (x *DeleteRegistryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRegistryMetadata.ProtoReflect.Descriptor instead.
func (*DeleteRegistryMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteRegistryMetadata) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

type SetIpPermissionsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the registry for which ip permissions are being set.
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// IP permission to be set.
	IpPermissions []*IpPermission `protobuf:"bytes,2,rep,name=ip_permissions,json=ipPermissions,proto3" json:"ip_permissions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetIpPermissionsRequest) Reset() {
	*x = SetIpPermissionsRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetIpPermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetIpPermissionsRequest) ProtoMessage() {}

func (x *SetIpPermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetIpPermissionsRequest.ProtoReflect.Descriptor instead.
func (*SetIpPermissionsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{9}
}

func (x *SetIpPermissionsRequest) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

func (x *SetIpPermissionsRequest) GetIpPermissions() []*IpPermission {
	if x != nil {
		return x.IpPermissions
	}
	return nil
}

type UpdateIpPermissionsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the registry for which ip permissions are being updated.
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// Updates to IP permissions.
	IpPermissionDeltas []*IpPermissionDelta `protobuf:"bytes,2,rep,name=ip_permission_deltas,json=ipPermissionDeltas,proto3" json:"ip_permission_deltas,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *UpdateIpPermissionsRequest) Reset() {
	*x = UpdateIpPermissionsRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateIpPermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIpPermissionsRequest) ProtoMessage() {}

func (x *UpdateIpPermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIpPermissionsRequest.ProtoReflect.Descriptor instead.
func (*UpdateIpPermissionsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateIpPermissionsRequest) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

func (x *UpdateIpPermissionsRequest) GetIpPermissionDeltas() []*IpPermissionDelta {
	if x != nil {
		return x.IpPermissionDeltas
	}
	return nil
}

type ListIpPermissionsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Registry to return ip permission list.
	RegistryId    string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListIpPermissionsRequest) Reset() {
	*x = ListIpPermissionsRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListIpPermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIpPermissionsRequest) ProtoMessage() {}

func (x *ListIpPermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIpPermissionsRequest.ProtoReflect.Descriptor instead.
func (*ListIpPermissionsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListIpPermissionsRequest) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

type ListIpPermissionsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of ip permissions for registry
	Permissions   []*IpPermission `protobuf:"bytes,1,rep,name=permissions,proto3" json:"permissions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListIpPermissionsResponse) Reset() {
	*x = ListIpPermissionsResponse{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListIpPermissionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIpPermissionsResponse) ProtoMessage() {}

func (x *ListIpPermissionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIpPermissionsResponse.ProtoReflect.Descriptor instead.
func (*ListIpPermissionsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListIpPermissionsResponse) GetPermissions() []*IpPermission {
	if x != nil {
		return x.Permissions
	}
	return nil
}

type SetIpPermissionsMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the registry that ip permission is being set.
	RegistryId    string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetIpPermissionsMetadata) Reset() {
	*x = SetIpPermissionsMetadata{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetIpPermissionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetIpPermissionsMetadata) ProtoMessage() {}

func (x *SetIpPermissionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetIpPermissionsMetadata.ProtoReflect.Descriptor instead.
func (*SetIpPermissionsMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{13}
}

func (x *SetIpPermissionsMetadata) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

type UpdateIpPermissionsMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the registry that ip permission is being updated.
	RegistryId    string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateIpPermissionsMetadata) Reset() {
	*x = UpdateIpPermissionsMetadata{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateIpPermissionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIpPermissionsMetadata) ProtoMessage() {}

func (x *UpdateIpPermissionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIpPermissionsMetadata.ProtoReflect.Descriptor instead.
func (*UpdateIpPermissionsMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateIpPermissionsMetadata) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

type ListArtifactsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the registry artifact to list repositories in.
	//
	// To get the registry ID use a [ArtifactService.List] request.
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// The path to a specific node where the registry artifact is located.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListRepositoriesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 10.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListArtifactsResponse.next_page_token] returned by a previous list request.
	PageToken     string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListArtifactsRequest) Reset() {
	*x = ListArtifactsRequest{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListArtifactsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListArtifactsRequest) ProtoMessage() {}

func (x *ListArtifactsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListArtifactsRequest.ProtoReflect.Descriptor instead.
func (*ListArtifactsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{15}
}

func (x *ListArtifactsRequest) GetRegistryId() string {
	if x != nil {
		return x.RegistryId
	}
	return ""
}

func (x *ListArtifactsRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ListArtifactsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListArtifactsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListArtifactsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of Registry artifact resources.
	Artifacts []*Artifact `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListRegistriesRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListArtifactsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListArtifactsResponse) Reset() {
	*x = ListArtifactsResponse{}
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListArtifactsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListArtifactsResponse) ProtoMessage() {}

func (x *ListArtifactsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListArtifactsResponse.ProtoReflect.Descriptor instead.
func (*ListArtifactsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListArtifactsResponse) GetArtifacts() []*Artifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *ListArtifactsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_yandex_cloud_cloudregistry_v1_registry_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDesc = "" +
	"\n" +
	"4yandex/cloud/cloudregistry/v1/registry_service.proto\x12\x1dyandex.cloud.cloudregistry.v1\x1a yandex/cloud/api/operation.proto\x1a yandex/cloud/access/access.proto\x1a,yandex/cloud/cloudregistry/v1/registry.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\x1a google/protobuf/field_mask.proto\x1a1yandex/cloud/cloudregistry/v1/ip_permission.proto\x1a,yandex/cloud/cloudregistry/v1/artifact.proto\x1a\x1cgoogle/api/annotations.proto\"C\n" +
	"\x12GetRegistryRequest\x12-\n" +
	"\vregistry_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"registryId\"\x95\x01\n" +
	"\x15ListRegistriesRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\"\x89\x01\n" +
	"\x16ListRegistriesResponse\x12G\n" +
	"\n" +
	"registries\x18\x01 \x03(\v2'.yandex.cloud.cloudregistry.v1.RegistryR\n" +
	"registries\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xfc\x05\n" +
	"\x15CreateRegistryRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x125\n" +
	"\x04name\x18\x02 \x01(\tB!\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12\x95\x01\n" +
	"\x06labels\x18\x03 \x03(\v2@.yandex.cloud.cloudregistry.v1.CreateRegistryRequest.LabelsEntryB;\xf2\xc71\v[-_0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x18\x12\x10[a-z][-_0-9a-z]*\x1a\x041-63R\x06labels\x12F\n" +
	"\x04kind\x18\x04 \x01(\x0e2,.yandex.cloud.cloudregistry.v1.Registry.KindB\x04\xe8\xc71\x01R\x04kind\x12F\n" +
	"\x04type\x18\x05 \x01(\x0e2,.yandex.cloud.cloudregistry.v1.Registry.TypeB\x04\xe8\xc71\x01R\x04type\x12,\n" +
	"\vdescription\x18\x06 \x01(\tB\n" +
	"\x8a\xc81\x06<=1024R\vdescription\x12\xb0\x01\n" +
	"\n" +
	"properties\x18\a \x03(\v2D.yandex.cloud.cloudregistry.v1.CreateRegistryRequest.PropertiesEntryBJ\xf2\xc71![-_.~!*'();/?:@&=+$,%#0-9a-zA-Z]+\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x11\x12\t[a-zA-Z]+\x1a\x041-63R\n" +
	"properties\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a=\n" +
	"\x0fPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"9\n" +
	"\x16CreateRegistryMetadata\x12\x1f\n" +
	"\vregistry_id\x18\x01 \x01(\tR\n" +
	"registryId\"\xad\x05\n" +
	"\x15UpdateRegistryRequest\x12-\n" +
	"\vregistry_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"registryId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x125\n" +
	"\x04name\x18\x03 \x01(\tB!\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12\x95\x01\n" +
	"\x06labels\x18\x04 \x03(\v2@.yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.LabelsEntryB;\xf2\xc71\v[-_0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x18\x12\x10[a-z][-_0-9a-z]*\x1a\x041-63R\x06labels\x12,\n" +
	"\vdescription\x18\x05 \x01(\tB\n" +
	"\x8a\xc81\x06<=1024R\vdescription\x12\xb0\x01\n" +
	"\n" +
	"properties\x18\x06 \x03(\v2D.yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.PropertiesEntryBJ\xf2\xc71![-_.~!*'();/?:@&=+$,%#0-9a-zA-Z]+\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x11\x12\t[a-zA-Z]+\x1a\x041-63R\n" +
	"properties\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a=\n" +
	"\x0fPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"9\n" +
	"\x16UpdateRegistryMetadata\x12\x1f\n" +
	"\vregistry_id\x18\x01 \x01(\tR\n" +
	"registryId\"F\n" +
	"\x15DeleteRegistryRequest\x12-\n" +
	"\vregistry_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"registryId\"9\n" +
	"\x16DeleteRegistryMetadata\x12\x1f\n" +
	"\vregistry_id\x18\x01 \x01(\tR\n" +
	"registryId\"\x9c\x01\n" +
	"\x17SetIpPermissionsRequest\x12-\n" +
	"\vregistry_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"registryId\x12R\n" +
	"\x0eip_permissions\x18\x02 \x03(\v2+.yandex.cloud.cloudregistry.v1.IpPermissionR\ripPermissions\"\xaf\x01\n" +
	"\x1aUpdateIpPermissionsRequest\x12-\n" +
	"\vregistry_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"registryId\x12b\n" +
	"\x14ip_permission_deltas\x18\x02 \x03(\v20.yandex.cloud.cloudregistry.v1.IpPermissionDeltaR\x12ipPermissionDeltas\"I\n" +
	"\x18ListIpPermissionsRequest\x12-\n" +
	"\vregistry_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"registryId\"j\n" +
	"\x19ListIpPermissionsResponse\x12M\n" +
	"\vpermissions\x18\x01 \x03(\v2+.yandex.cloud.cloudregistry.v1.IpPermissionR\vpermissions\";\n" +
	"\x18SetIpPermissionsMetadata\x12\x1f\n" +
	"\vregistry_id\x18\x01 \x01(\tR\n" +
	"registryId\">\n" +
	"\x1bUpdateIpPermissionsMetadata\x12\x1f\n" +
	"\vregistry_id\x18\x01 \x01(\tR\n" +
	"registryId\"\xa8\x01\n" +
	"\x14ListArtifactsRequest\x12)\n" +
	"\vregistry_id\x18\x01 \x01(\tB\b\x8a\xc81\x04<=50R\n" +
	"registryId\x12\x12\n" +
	"\x04path\x18\x02 \x01(\tR\x04path\x12'\n" +
	"\tpage_size\x18\x03 \x01(\x03B\n" +
	"\xfa\xc71\x060-1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x04 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\"\x86\x01\n" +
	"\x15ListArtifactsResponse\x12E\n" +
	"\tartifacts\x18\x01 \x03(\v2'.yandex.cloud.cloudregistry.v1.ArtifactR\tartifacts\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken2\x8b\x15\n" +
	"\x0fRegistryService\x12\x96\x01\n" +
	"\x03Get\x121.yandex.cloud.cloudregistry.v1.GetRegistryRequest\x1a'.yandex.cloud.cloudregistry.v1.Registry\"3\x82\xd3\xe4\x93\x02-\x12+/cloud-registry/v1/registries/{registry_id}\x12\x9a\x01\n" +
	"\x04List\x124.yandex.cloud.cloudregistry.v1.ListRegistriesRequest\x1a5.yandex.cloud.cloudregistry.v1.ListRegistriesResponse\"%\x82\xd3\xe4\x93\x02\x1f\x12\x1d/cloud-registry/v1/registries\x12\xb1\x01\n" +
	"\x06Create\x124.yandex.cloud.cloudregistry.v1.CreateRegistryRequest\x1a!.yandex.cloud.operation.Operation\"N\xb2\xd2*\"\n" +
	"\x16CreateRegistryMetadata\x12\bRegistry\x82\xd3\xe4\x93\x02\":\x01*\"\x1d/cloud-registry/v1/registries\x12\xbf\x01\n" +
	"\x06Update\x124.yandex.cloud.cloudregistry.v1.UpdateRegistryRequest\x1a!.yandex.cloud.operation.Operation\"\\\xb2\xd2*\"\n" +
	"\x16UpdateRegistryMetadata\x12\bRegistry\x82\xd3\xe4\x93\x020:\x01*2+/cloud-registry/v1/registries/{registry_id}\x12\xc9\x01\n" +
	"\x06Delete\x124.yandex.cloud.cloudregistry.v1.DeleteRegistryRequest\x1a!.yandex.cloud.operation.Operation\"f\xb2\xd2*/\n" +
	"\x16DeleteRegistryMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02-*+/cloud-registry/v1/registries/{registry_id}\x12\xda\x01\n" +
	"\vForceDelete\x124.yandex.cloud.cloudregistry.v1.DeleteRegistryRequest\x1a!.yandex.cloud.operation.Operation\"r\xb2\xd2*/\n" +
	"\x16DeleteRegistryMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x029\"7/cloud-registry/v1/registries/{registry_id}:forceDelete\x12\xbd\x01\n" +
	"\x12ListAccessBindings\x12..yandex.cloud.access.ListAccessBindingsRequest\x1a/.yandex.cloud.access.ListAccessBindingsResponse\"F\x82\xd3\xe4\x93\x02@\x12>/cloud-registry/v1/registries/{resource_id}:listAccessBindings\x12\xed\x01\n" +
	"\x11SetAccessBindings\x12-.yandex.cloud.access.SetAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x85\x01\xb2\xd2*9\n" +
	" access.SetAccessBindingsMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02B:\x01*\"=/cloud-registry/v1/registries/{resource_id}:setAccessBindings\x12\xf9\x01\n" +
	"\x14UpdateAccessBindings\x120.yandex.cloud.access.UpdateAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x8b\x01\xb2\xd2*<\n" +
	"#access.UpdateAccessBindingsMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02E:\x01*\"@/cloud-registry/v1/registries/{resource_id}:updateAccessBindings\x12\xcd\x01\n" +
	"\x11ListIpPermissions\x127.yandex.cloud.cloudregistry.v1.ListIpPermissionsRequest\x1a8.yandex.cloud.cloudregistry.v1.ListIpPermissionsResponse\"E\x82\xd3\xe4\x93\x02?\x12=/cloud-registry/v1/registries/{registry_id}:listIpPermissions\x12\xeb\x01\n" +
	"\x10SetIpPermissions\x126.yandex.cloud.cloudregistry.v1.SetIpPermissionsRequest\x1a!.yandex.cloud.operation.Operation\"|\xb2\xd2*1\n" +
	"\x18SetIpPermissionsMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02A:\x01*\"</cloud-registry/v1/registries/{registry_id}:setIpPermissions\x12\xf8\x01\n" +
	"\x13UpdateIpPermissions\x129.yandex.cloud.cloudregistry.v1.UpdateIpPermissionsRequest\x1a!.yandex.cloud.operation.Operation\"\x82\x01\xb2\xd2*4\n" +
	"\x1bUpdateIpPermissionsMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02D:\x01*\"?/cloud-registry/v1/registries/{registry_id}:updateIpPermissions\x12\xbd\x01\n" +
	"\rListArtifacts\x123.yandex.cloud.cloudregistry.v1.ListArtifactsRequest\x1a4.yandex.cloud.cloudregistry.v1.ListArtifactsResponse\"A\x82\xd3\xe4\x93\x02;\x129/cloud-registry/v1/registries/{registry_id}:listArtifactsBt\n" +
	"!yandex.cloud.api.cloudregistry.v1ZOgithub.com/yandex-cloud/go-genproto/yandex/cloud/cloudregistry/v1;cloudregistryb\x06proto3"

var (
	file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescData []byte
)

func file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDesc), len(file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDesc)))
	})
	return file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDescData
}

var file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_yandex_cloud_cloudregistry_v1_registry_service_proto_goTypes = []any{
	(*GetRegistryRequest)(nil),                 // 0: yandex.cloud.cloudregistry.v1.GetRegistryRequest
	(*ListRegistriesRequest)(nil),              // 1: yandex.cloud.cloudregistry.v1.ListRegistriesRequest
	(*ListRegistriesResponse)(nil),             // 2: yandex.cloud.cloudregistry.v1.ListRegistriesResponse
	(*CreateRegistryRequest)(nil),              // 3: yandex.cloud.cloudregistry.v1.CreateRegistryRequest
	(*CreateRegistryMetadata)(nil),             // 4: yandex.cloud.cloudregistry.v1.CreateRegistryMetadata
	(*UpdateRegistryRequest)(nil),              // 5: yandex.cloud.cloudregistry.v1.UpdateRegistryRequest
	(*UpdateRegistryMetadata)(nil),             // 6: yandex.cloud.cloudregistry.v1.UpdateRegistryMetadata
	(*DeleteRegistryRequest)(nil),              // 7: yandex.cloud.cloudregistry.v1.DeleteRegistryRequest
	(*DeleteRegistryMetadata)(nil),             // 8: yandex.cloud.cloudregistry.v1.DeleteRegistryMetadata
	(*SetIpPermissionsRequest)(nil),            // 9: yandex.cloud.cloudregistry.v1.SetIpPermissionsRequest
	(*UpdateIpPermissionsRequest)(nil),         // 10: yandex.cloud.cloudregistry.v1.UpdateIpPermissionsRequest
	(*ListIpPermissionsRequest)(nil),           // 11: yandex.cloud.cloudregistry.v1.ListIpPermissionsRequest
	(*ListIpPermissionsResponse)(nil),          // 12: yandex.cloud.cloudregistry.v1.ListIpPermissionsResponse
	(*SetIpPermissionsMetadata)(nil),           // 13: yandex.cloud.cloudregistry.v1.SetIpPermissionsMetadata
	(*UpdateIpPermissionsMetadata)(nil),        // 14: yandex.cloud.cloudregistry.v1.UpdateIpPermissionsMetadata
	(*ListArtifactsRequest)(nil),               // 15: yandex.cloud.cloudregistry.v1.ListArtifactsRequest
	(*ListArtifactsResponse)(nil),              // 16: yandex.cloud.cloudregistry.v1.ListArtifactsResponse
	nil,                                        // 17: yandex.cloud.cloudregistry.v1.CreateRegistryRequest.LabelsEntry
	nil,                                        // 18: yandex.cloud.cloudregistry.v1.CreateRegistryRequest.PropertiesEntry
	nil,                                        // 19: yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.LabelsEntry
	nil,                                        // 20: yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.PropertiesEntry
	(*Registry)(nil),                           // 21: yandex.cloud.cloudregistry.v1.Registry
	(Registry_Kind)(0),                         // 22: yandex.cloud.cloudregistry.v1.Registry.Kind
	(Registry_Type)(0),                         // 23: yandex.cloud.cloudregistry.v1.Registry.Type
	(*fieldmaskpb.FieldMask)(nil),              // 24: google.protobuf.FieldMask
	(*IpPermission)(nil),                       // 25: yandex.cloud.cloudregistry.v1.IpPermission
	(*IpPermissionDelta)(nil),                  // 26: yandex.cloud.cloudregistry.v1.IpPermissionDelta
	(*Artifact)(nil),                           // 27: yandex.cloud.cloudregistry.v1.Artifact
	(*access.ListAccessBindingsRequest)(nil),   // 28: yandex.cloud.access.ListAccessBindingsRequest
	(*access.SetAccessBindingsRequest)(nil),    // 29: yandex.cloud.access.SetAccessBindingsRequest
	(*access.UpdateAccessBindingsRequest)(nil), // 30: yandex.cloud.access.UpdateAccessBindingsRequest
	(*operation.Operation)(nil),                // 31: yandex.cloud.operation.Operation
	(*access.ListAccessBindingsResponse)(nil),  // 32: yandex.cloud.access.ListAccessBindingsResponse
}
var file_yandex_cloud_cloudregistry_v1_registry_service_proto_depIdxs = []int32{
	21, // 0: yandex.cloud.cloudregistry.v1.ListRegistriesResponse.registries:type_name -> yandex.cloud.cloudregistry.v1.Registry
	17, // 1: yandex.cloud.cloudregistry.v1.CreateRegistryRequest.labels:type_name -> yandex.cloud.cloudregistry.v1.CreateRegistryRequest.LabelsEntry
	22, // 2: yandex.cloud.cloudregistry.v1.CreateRegistryRequest.kind:type_name -> yandex.cloud.cloudregistry.v1.Registry.Kind
	23, // 3: yandex.cloud.cloudregistry.v1.CreateRegistryRequest.type:type_name -> yandex.cloud.cloudregistry.v1.Registry.Type
	18, // 4: yandex.cloud.cloudregistry.v1.CreateRegistryRequest.properties:type_name -> yandex.cloud.cloudregistry.v1.CreateRegistryRequest.PropertiesEntry
	24, // 5: yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 6: yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.labels:type_name -> yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.LabelsEntry
	20, // 7: yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.properties:type_name -> yandex.cloud.cloudregistry.v1.UpdateRegistryRequest.PropertiesEntry
	25, // 8: yandex.cloud.cloudregistry.v1.SetIpPermissionsRequest.ip_permissions:type_name -> yandex.cloud.cloudregistry.v1.IpPermission
	26, // 9: yandex.cloud.cloudregistry.v1.UpdateIpPermissionsRequest.ip_permission_deltas:type_name -> yandex.cloud.cloudregistry.v1.IpPermissionDelta
	25, // 10: yandex.cloud.cloudregistry.v1.ListIpPermissionsResponse.permissions:type_name -> yandex.cloud.cloudregistry.v1.IpPermission
	27, // 11: yandex.cloud.cloudregistry.v1.ListArtifactsResponse.artifacts:type_name -> yandex.cloud.cloudregistry.v1.Artifact
	0,  // 12: yandex.cloud.cloudregistry.v1.RegistryService.Get:input_type -> yandex.cloud.cloudregistry.v1.GetRegistryRequest
	1,  // 13: yandex.cloud.cloudregistry.v1.RegistryService.List:input_type -> yandex.cloud.cloudregistry.v1.ListRegistriesRequest
	3,  // 14: yandex.cloud.cloudregistry.v1.RegistryService.Create:input_type -> yandex.cloud.cloudregistry.v1.CreateRegistryRequest
	5,  // 15: yandex.cloud.cloudregistry.v1.RegistryService.Update:input_type -> yandex.cloud.cloudregistry.v1.UpdateRegistryRequest
	7,  // 16: yandex.cloud.cloudregistry.v1.RegistryService.Delete:input_type -> yandex.cloud.cloudregistry.v1.DeleteRegistryRequest
	7,  // 17: yandex.cloud.cloudregistry.v1.RegistryService.ForceDelete:input_type -> yandex.cloud.cloudregistry.v1.DeleteRegistryRequest
	28, // 18: yandex.cloud.cloudregistry.v1.RegistryService.ListAccessBindings:input_type -> yandex.cloud.access.ListAccessBindingsRequest
	29, // 19: yandex.cloud.cloudregistry.v1.RegistryService.SetAccessBindings:input_type -> yandex.cloud.access.SetAccessBindingsRequest
	30, // 20: yandex.cloud.cloudregistry.v1.RegistryService.UpdateAccessBindings:input_type -> yandex.cloud.access.UpdateAccessBindingsRequest
	11, // 21: yandex.cloud.cloudregistry.v1.RegistryService.ListIpPermissions:input_type -> yandex.cloud.cloudregistry.v1.ListIpPermissionsRequest
	9,  // 22: yandex.cloud.cloudregistry.v1.RegistryService.SetIpPermissions:input_type -> yandex.cloud.cloudregistry.v1.SetIpPermissionsRequest
	10, // 23: yandex.cloud.cloudregistry.v1.RegistryService.UpdateIpPermissions:input_type -> yandex.cloud.cloudregistry.v1.UpdateIpPermissionsRequest
	15, // 24: yandex.cloud.cloudregistry.v1.RegistryService.ListArtifacts:input_type -> yandex.cloud.cloudregistry.v1.ListArtifactsRequest
	21, // 25: yandex.cloud.cloudregistry.v1.RegistryService.Get:output_type -> yandex.cloud.cloudregistry.v1.Registry
	2,  // 26: yandex.cloud.cloudregistry.v1.RegistryService.List:output_type -> yandex.cloud.cloudregistry.v1.ListRegistriesResponse
	31, // 27: yandex.cloud.cloudregistry.v1.RegistryService.Create:output_type -> yandex.cloud.operation.Operation
	31, // 28: yandex.cloud.cloudregistry.v1.RegistryService.Update:output_type -> yandex.cloud.operation.Operation
	31, // 29: yandex.cloud.cloudregistry.v1.RegistryService.Delete:output_type -> yandex.cloud.operation.Operation
	31, // 30: yandex.cloud.cloudregistry.v1.RegistryService.ForceDelete:output_type -> yandex.cloud.operation.Operation
	32, // 31: yandex.cloud.cloudregistry.v1.RegistryService.ListAccessBindings:output_type -> yandex.cloud.access.ListAccessBindingsResponse
	31, // 32: yandex.cloud.cloudregistry.v1.RegistryService.SetAccessBindings:output_type -> yandex.cloud.operation.Operation
	31, // 33: yandex.cloud.cloudregistry.v1.RegistryService.UpdateAccessBindings:output_type -> yandex.cloud.operation.Operation
	12, // 34: yandex.cloud.cloudregistry.v1.RegistryService.ListIpPermissions:output_type -> yandex.cloud.cloudregistry.v1.ListIpPermissionsResponse
	31, // 35: yandex.cloud.cloudregistry.v1.RegistryService.SetIpPermissions:output_type -> yandex.cloud.operation.Operation
	31, // 36: yandex.cloud.cloudregistry.v1.RegistryService.UpdateIpPermissions:output_type -> yandex.cloud.operation.Operation
	16, // 37: yandex.cloud.cloudregistry.v1.RegistryService.ListArtifacts:output_type -> yandex.cloud.cloudregistry.v1.ListArtifactsResponse
	25, // [25:38] is the sub-list for method output_type
	12, // [12:25] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_yandex_cloud_cloudregistry_v1_registry_service_proto_init() }
func file_yandex_cloud_cloudregistry_v1_registry_service_proto_init() {
	if File_yandex_cloud_cloudregistry_v1_registry_service_proto != nil {
		return
	}
	file_yandex_cloud_cloudregistry_v1_registry_proto_init()
	file_yandex_cloud_cloudregistry_v1_ip_permission_proto_init()
	file_yandex_cloud_cloudregistry_v1_artifact_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDesc), len(file_yandex_cloud_cloudregistry_v1_registry_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_cloudregistry_v1_registry_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_cloudregistry_v1_registry_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_cloudregistry_v1_registry_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_cloudregistry_v1_registry_service_proto = out.File
	file_yandex_cloud_cloudregistry_v1_registry_service_proto_goTypes = nil
	file_yandex_cloud_cloudregistry_v1_registry_service_proto_depIdxs = nil
}
