// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/datatransfer/v1/transfer_service.proto

package datatransfer

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CreateTransferRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the source endpoint.
	SourceId string `protobuf:"bytes,1,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// Identifier of the target endpoint.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Description of the transfer.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the folder to create the transfer in.
	//
	// To get the folder ID, make a
	// [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string       `protobuf:"bytes,4,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	Runtime  *Runtime     `protobuf:"bytes,5,opt,name=runtime,proto3" json:"runtime,omitempty"`
	Type     TransferType `protobuf:"varint,6,opt,name=type,proto3,enum=yandex.cloud.datatransfer.v1.TransferType" json:"type,omitempty"`
	// The transfer name. Must be unique within the folder.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	// Transfer labels as `key:value` pairs.
	//
	// For details about the concept, see [documentation]({{ api-url-prefix
	// }}/resource-manager/concepts/labels).
	Labels             map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Transformation     *Transformation   `protobuf:"bytes,10,opt,name=transformation,proto3" json:"transformation,omitempty"`
	DataObjects        *DataObjects      `protobuf:"bytes,12,opt,name=data_objects,json=dataObjects,proto3" json:"data_objects,omitempty"`
	ReplicationRuntime *Runtime          `protobuf:"bytes,16,opt,name=replication_runtime,json=replicationRuntime,proto3" json:"replication_runtime,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *CreateTransferRequest) Reset() {
	*x = CreateTransferRequest{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTransferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTransferRequest) ProtoMessage() {}

func (x *CreateTransferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTransferRequest.ProtoReflect.Descriptor instead.
func (*CreateTransferRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateTransferRequest) GetSourceId() string {
	if x != nil {
		return x.SourceId
	}
	return ""
}

func (x *CreateTransferRequest) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *CreateTransferRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateTransferRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateTransferRequest) GetRuntime() *Runtime {
	if x != nil {
		return x.Runtime
	}
	return nil
}

func (x *CreateTransferRequest) GetType() TransferType {
	if x != nil {
		return x.Type
	}
	return TransferType_TRANSFER_TYPE_UNSPECIFIED
}

func (x *CreateTransferRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateTransferRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateTransferRequest) GetTransformation() *Transformation {
	if x != nil {
		return x.Transformation
	}
	return nil
}

func (x *CreateTransferRequest) GetDataObjects() *DataObjects {
	if x != nil {
		return x.DataObjects
	}
	return nil
}

func (x *CreateTransferRequest) GetReplicationRuntime() *Runtime {
	if x != nil {
		return x.ReplicationRuntime
	}
	return nil
}

type CreateTransferMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TransferId    string                 `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateTransferMetadata) Reset() {
	*x = CreateTransferMetadata{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTransferMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTransferMetadata) ProtoMessage() {}

func (x *CreateTransferMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTransferMetadata.ProtoReflect.Descriptor instead.
func (*CreateTransferMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateTransferMetadata) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

type UpdateTransferRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the transfer to be updated.
	TransferId string `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	// The new description for the transfer.
	Description string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	Runtime     *Runtime `protobuf:"bytes,3,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// The new transfer name. Must be unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Field mask specifying transfer fields to be updated. Semantics for this field is
	// described here:
	// <https://pkg.go.dev/google.golang.org/protobuf/types/known/fieldmaskpb#FieldMask>
	// The only exception: if the repeated field is specified in the mask, then
	// the new value replaces the old one instead of being appended to the old one.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Transfer labels as `key:value` pairs.
	//
	// For details about the concept, see [documentation]({{ api-url-prefix
	// }}/resource-manager/concepts/labels).
	Labels             map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Transformation     *Transformation   `protobuf:"bytes,8,opt,name=transformation,proto3" json:"transformation,omitempty"`
	DataObjects        *DataObjects      `protobuf:"bytes,10,opt,name=data_objects,json=dataObjects,proto3" json:"data_objects,omitempty"`
	ReplicationRuntime *Runtime          `protobuf:"bytes,12,opt,name=replication_runtime,json=replicationRuntime,proto3" json:"replication_runtime,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *UpdateTransferRequest) Reset() {
	*x = UpdateTransferRequest{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTransferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTransferRequest) ProtoMessage() {}

func (x *UpdateTransferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTransferRequest.ProtoReflect.Descriptor instead.
func (*UpdateTransferRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateTransferRequest) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

func (x *UpdateTransferRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateTransferRequest) GetRuntime() *Runtime {
	if x != nil {
		return x.Runtime
	}
	return nil
}

func (x *UpdateTransferRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateTransferRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTransferRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *UpdateTransferRequest) GetTransformation() *Transformation {
	if x != nil {
		return x.Transformation
	}
	return nil
}

func (x *UpdateTransferRequest) GetDataObjects() *DataObjects {
	if x != nil {
		return x.DataObjects
	}
	return nil
}

func (x *UpdateTransferRequest) GetReplicationRuntime() *Runtime {
	if x != nil {
		return x.ReplicationRuntime
	}
	return nil
}

type UpdateTransferMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TransferId    string                 `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateTransferMetadata) Reset() {
	*x = UpdateTransferMetadata{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTransferMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTransferMetadata) ProtoMessage() {}

func (x *UpdateTransferMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTransferMetadata.ProtoReflect.Descriptor instead.
func (*UpdateTransferMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateTransferMetadata) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

type DeleteTransferRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the transfer to be deleted.
	TransferId    string `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteTransferRequest) Reset() {
	*x = DeleteTransferRequest{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTransferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTransferRequest) ProtoMessage() {}

func (x *DeleteTransferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTransferRequest.ProtoReflect.Descriptor instead.
func (*DeleteTransferRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteTransferRequest) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

type DeleteTransferMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TransferId    string                 `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteTransferMetadata) Reset() {
	*x = DeleteTransferMetadata{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTransferMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTransferMetadata) ProtoMessage() {}

func (x *DeleteTransferMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTransferMetadata.ProtoReflect.Descriptor instead.
func (*DeleteTransferMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteTransferMetadata) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

type ListTransfersRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the folder containing the transfers to be listed.
	//
	// To get the folder ID, make a
	// [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of transfers to be sent in the response message. If the
	// folder contains more transfers than `page_size`, `next_page_token` will be
	// included
	// in the response message. Include it into the subsequent `ListTransfersRequest`
	// to
	// fetch the next page. Defaults to `100` if not specified. The maximum allowed
	// value
	// for this field is `1000`.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Opaque value identifying the transfers page to be fetched. Should be empty in
	// the first `ListTransfersRequest`. Subsequent requests should have this field
	// filled
	// with the `next_page_token` from the previous `ListTransfersResponse`.
	PageToken     string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTransfersRequest) Reset() {
	*x = ListTransfersRequest{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTransfersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransfersRequest) ProtoMessage() {}

func (x *ListTransfersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransfersRequest.ProtoReflect.Descriptor instead.
func (*ListTransfersRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListTransfersRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListTransfersRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTransfersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListTransfersResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The list of transfers. If there are more transfers in the folder, then
	// `next_page_token` is a non-empty string to be included into the subsequent
	// `ListTransfersRequest` to fetch the next transfers page.
	Transfers []*Transfer `protobuf:"bytes,1,rep,name=transfers,proto3" json:"transfers,omitempty"`
	// Opaque value identifying the next transfers page. This field is empty if there
	// are no more transfers in the folder. Otherwise it is non-empty and should be
	// included in the subsequent `ListTransfersRequest` to fetch the next transfers
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTransfersResponse) Reset() {
	*x = ListTransfersResponse{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTransfersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransfersResponse) ProtoMessage() {}

func (x *ListTransfersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransfersResponse.ProtoReflect.Descriptor instead.
func (*ListTransfersResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListTransfersResponse) GetTransfers() []*Transfer {
	if x != nil {
		return x.Transfers
	}
	return nil
}

func (x *ListTransfersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type GetTransferRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the transfer to be returned.
	//
	// To get the list of all available transfers, make a [List] request.
	TransferId    string `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetTransferRequest) Reset() {
	*x = GetTransferRequest{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTransferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTransferRequest) ProtoMessage() {}

func (x *GetTransferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTransferRequest.ProtoReflect.Descriptor instead.
func (*GetTransferRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetTransferRequest) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

type DeactivateTransferRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the transfer to be deactivated.
	//
	// To get the list of all available transfers, make a [List] request.
	TransferId    string `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeactivateTransferRequest) Reset() {
	*x = DeactivateTransferRequest{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeactivateTransferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeactivateTransferRequest) ProtoMessage() {}

func (x *DeactivateTransferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeactivateTransferRequest.ProtoReflect.Descriptor instead.
func (*DeactivateTransferRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{9}
}

func (x *DeactivateTransferRequest) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

type DeactivateTransferMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TransferId    string                 `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeactivateTransferMetadata) Reset() {
	*x = DeactivateTransferMetadata{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeactivateTransferMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeactivateTransferMetadata) ProtoMessage() {}

func (x *DeactivateTransferMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeactivateTransferMetadata.ProtoReflect.Descriptor instead.
func (*DeactivateTransferMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{10}
}

func (x *DeactivateTransferMetadata) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

type ActivateTransferRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the transfer to be activated.
	//
	// To get the list of all available transfers, make a [List] request.
	TransferId    string `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ActivateTransferRequest) Reset() {
	*x = ActivateTransferRequest{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ActivateTransferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateTransferRequest) ProtoMessage() {}

func (x *ActivateTransferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateTransferRequest.ProtoReflect.Descriptor instead.
func (*ActivateTransferRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{11}
}

func (x *ActivateTransferRequest) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

type ActivateTransferMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TransferId    string                 `protobuf:"bytes,1,opt,name=transfer_id,json=transferId,proto3" json:"transfer_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ActivateTransferMetadata) Reset() {
	*x = ActivateTransferMetadata{}
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ActivateTransferMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateTransferMetadata) ProtoMessage() {}

func (x *ActivateTransferMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateTransferMetadata.ProtoReflect.Descriptor instead.
func (*ActivateTransferMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP(), []int{12}
}

func (x *ActivateTransferMetadata) GetTransferId() string {
	if x != nil {
		return x.TransferId
	}
	return ""
}

var File_yandex_cloud_datatransfer_v1_transfer_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDesc = "" +
	"\n" +
	"3yandex/cloud/datatransfer/v1/transfer_service.proto\x12\x1cyandex.cloud.datatransfer.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a+yandex/cloud/datatransfer/v1/transfer.proto\x1a yandex/cloud/api/operation.proto\x1a&yandex/cloud/operation/operation.proto\"\xc7\x05\n" +
	"\x15CreateTransferRequest\x12\x1b\n" +
	"\tsource_id\x18\x01 \x01(\tR\bsourceId\x12\x1b\n" +
	"\ttarget_id\x18\x02 \x01(\tR\btargetId\x12 \n" +
	"\vdescription\x18\x03 \x01(\tR\vdescription\x12\x1b\n" +
	"\tfolder_id\x18\x04 \x01(\tR\bfolderId\x12?\n" +
	"\aruntime\x18\x05 \x01(\v2%.yandex.cloud.datatransfer.v1.RuntimeR\aruntime\x12>\n" +
	"\x04type\x18\x06 \x01(\x0e2*.yandex.cloud.datatransfer.v1.TransferTypeR\x04type\x12\x12\n" +
	"\x04name\x18\a \x01(\tR\x04name\x12W\n" +
	"\x06labels\x18\b \x03(\v2?.yandex.cloud.datatransfer.v1.CreateTransferRequest.LabelsEntryR\x06labels\x12T\n" +
	"\x0etransformation\x18\n" +
	" \x01(\v2,.yandex.cloud.datatransfer.v1.TransformationR\x0etransformation\x12L\n" +
	"\fdata_objects\x18\f \x01(\v2).yandex.cloud.datatransfer.v1.DataObjectsR\vdataObjects\x12V\n" +
	"\x13replication_runtime\x18\x10 \x01(\v2%.yandex.cloud.datatransfer.v1.RuntimeR\x12replicationRuntime\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01J\x04\b\t\x10\n" +
	"J\x04\b\v\x10\fJ\x04\b\r\x10\x10\"9\n" +
	"\x16CreateTransferMetadata\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\"\x8e\x05\n" +
	"\x15UpdateTransferRequest\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12?\n" +
	"\aruntime\x18\x03 \x01(\v2%.yandex.cloud.datatransfer.v1.RuntimeR\aruntime\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12;\n" +
	"\vupdate_mask\x18\x05 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x12W\n" +
	"\x06labels\x18\x06 \x03(\v2?.yandex.cloud.datatransfer.v1.UpdateTransferRequest.LabelsEntryR\x06labels\x12T\n" +
	"\x0etransformation\x18\b \x01(\v2,.yandex.cloud.datatransfer.v1.TransformationR\x0etransformation\x12L\n" +
	"\fdata_objects\x18\n" +
	" \x01(\v2).yandex.cloud.datatransfer.v1.DataObjectsR\vdataObjects\x12V\n" +
	"\x13replication_runtime\x18\f \x01(\v2%.yandex.cloud.datatransfer.v1.RuntimeR\x12replicationRuntime\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01J\x04\b\a\x10\bJ\x04\b\t\x10\n" +
	"J\x04\b\v\x10\f\"9\n" +
	"\x16UpdateTransferMetadata\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\"8\n" +
	"\x15DeleteTransferRequest\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\"9\n" +
	"\x16DeleteTransferMetadata\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\"u\n" +
	"\x14ListTransfersRequest\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x12\x1b\n" +
	"\tpage_size\x18\x03 \x01(\x03R\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x04 \x01(\tR\tpageTokenJ\x04\b\x01\x10\x02\"\x85\x01\n" +
	"\x15ListTransfersResponse\x12D\n" +
	"\ttransfers\x18\x01 \x03(\v2&.yandex.cloud.datatransfer.v1.TransferR\ttransfers\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"5\n" +
	"\x12GetTransferRequest\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\"<\n" +
	"\x19DeactivateTransferRequest\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\"=\n" +
	"\x1aDeactivateTransferMetadata\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\":\n" +
	"\x17ActivateTransferRequest\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId\";\n" +
	"\x18ActivateTransferMetadata\x12\x1f\n" +
	"\vtransfer_id\x18\x01 \x01(\tR\n" +
	"transferId2\xdd\t\n" +
	"\x0fTransferService\x12\x9f\x01\n" +
	"\x06Create\x123.yandex.cloud.datatransfer.v1.CreateTransferRequest\x1a!.yandex.cloud.operation.Operation\"=\xb2\xd2*\"\n" +
	"\x16CreateTransferMetadata\x12\bTransfer\x82\xd3\xe4\x93\x02\x11:\x01*\"\f/v1/transfer\x12\xad\x01\n" +
	"\x06Update\x123.yandex.cloud.datatransfer.v1.UpdateTransferRequest\x1a!.yandex.cloud.operation.Operation\"K\xb2\xd2*\"\n" +
	"\x16UpdateTransferMetadata\x12\bTransfer\x82\xd3\xe4\x93\x02\x1f:\x01*2\x1a/v1/transfer/{transfer_id}\x12\xb7\x01\n" +
	"\x06Delete\x123.yandex.cloud.datatransfer.v1.DeleteTransferRequest\x1a!.yandex.cloud.operation.Operation\"U\xb2\xd2*/\n" +
	"\x16DeleteTransferMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02\x1c*\x1a/v1/transfer/{transfer_id}\x12\x97\x01\n" +
	"\x04List\x122.yandex.cloud.datatransfer.v1.ListTransfersRequest\x1a3.yandex.cloud.datatransfer.v1.ListTransfersResponse\"&\x82\xd3\xe4\x93\x02 \x12\x1e/v1/transfers/list/{folder_id}\x12\x83\x01\n" +
	"\x03Get\x120.yandex.cloud.datatransfer.v1.GetTransferRequest\x1a&.yandex.cloud.datatransfer.v1.Transfer\"\"\x82\xd3\xe4\x93\x02\x1c\x12\x1a/v1/transfer/{transfer_id}\x12\xd1\x01\n" +
	"\n" +
	"Deactivate\x127.yandex.cloud.datatransfer.v1.DeactivateTransferRequest\x1a!.yandex.cloud.operation.Operation\"g\xb2\xd2*3\n" +
	"\x1aDeactivateTransferMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02*:\x01*\"%/v1/transfer/{transfer_id}:deactivate\x12\xc9\x01\n" +
	"\bActivate\x125.yandex.cloud.datatransfer.v1.ActivateTransferRequest\x1a!.yandex.cloud.operation.Operation\"c\xb2\xd2*1\n" +
	"\x18ActivateTransferMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02(:\x01*\"#/v1/transfer/{transfer_id}:activateBq\n" +
	" yandex.cloud.api.datatransfer.v1ZMgithub.com/yandex-cloud/go-genproto/yandex/cloud/datatransfer/v1;datatransferb\x06proto3"

var (
	file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescData []byte
)

func file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDesc), len(file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDesc)))
	})
	return file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDescData
}

var file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_yandex_cloud_datatransfer_v1_transfer_service_proto_goTypes = []any{
	(*CreateTransferRequest)(nil),      // 0: yandex.cloud.datatransfer.v1.CreateTransferRequest
	(*CreateTransferMetadata)(nil),     // 1: yandex.cloud.datatransfer.v1.CreateTransferMetadata
	(*UpdateTransferRequest)(nil),      // 2: yandex.cloud.datatransfer.v1.UpdateTransferRequest
	(*UpdateTransferMetadata)(nil),     // 3: yandex.cloud.datatransfer.v1.UpdateTransferMetadata
	(*DeleteTransferRequest)(nil),      // 4: yandex.cloud.datatransfer.v1.DeleteTransferRequest
	(*DeleteTransferMetadata)(nil),     // 5: yandex.cloud.datatransfer.v1.DeleteTransferMetadata
	(*ListTransfersRequest)(nil),       // 6: yandex.cloud.datatransfer.v1.ListTransfersRequest
	(*ListTransfersResponse)(nil),      // 7: yandex.cloud.datatransfer.v1.ListTransfersResponse
	(*GetTransferRequest)(nil),         // 8: yandex.cloud.datatransfer.v1.GetTransferRequest
	(*DeactivateTransferRequest)(nil),  // 9: yandex.cloud.datatransfer.v1.DeactivateTransferRequest
	(*DeactivateTransferMetadata)(nil), // 10: yandex.cloud.datatransfer.v1.DeactivateTransferMetadata
	(*ActivateTransferRequest)(nil),    // 11: yandex.cloud.datatransfer.v1.ActivateTransferRequest
	(*ActivateTransferMetadata)(nil),   // 12: yandex.cloud.datatransfer.v1.ActivateTransferMetadata
	nil,                                // 13: yandex.cloud.datatransfer.v1.CreateTransferRequest.LabelsEntry
	nil,                                // 14: yandex.cloud.datatransfer.v1.UpdateTransferRequest.LabelsEntry
	(*Runtime)(nil),                    // 15: yandex.cloud.datatransfer.v1.Runtime
	(TransferType)(0),                  // 16: yandex.cloud.datatransfer.v1.TransferType
	(*Transformation)(nil),             // 17: yandex.cloud.datatransfer.v1.Transformation
	(*DataObjects)(nil),                // 18: yandex.cloud.datatransfer.v1.DataObjects
	(*fieldmaskpb.FieldMask)(nil),      // 19: google.protobuf.FieldMask
	(*Transfer)(nil),                   // 20: yandex.cloud.datatransfer.v1.Transfer
	(*operation.Operation)(nil),        // 21: yandex.cloud.operation.Operation
}
var file_yandex_cloud_datatransfer_v1_transfer_service_proto_depIdxs = []int32{
	15, // 0: yandex.cloud.datatransfer.v1.CreateTransferRequest.runtime:type_name -> yandex.cloud.datatransfer.v1.Runtime
	16, // 1: yandex.cloud.datatransfer.v1.CreateTransferRequest.type:type_name -> yandex.cloud.datatransfer.v1.TransferType
	13, // 2: yandex.cloud.datatransfer.v1.CreateTransferRequest.labels:type_name -> yandex.cloud.datatransfer.v1.CreateTransferRequest.LabelsEntry
	17, // 3: yandex.cloud.datatransfer.v1.CreateTransferRequest.transformation:type_name -> yandex.cloud.datatransfer.v1.Transformation
	18, // 4: yandex.cloud.datatransfer.v1.CreateTransferRequest.data_objects:type_name -> yandex.cloud.datatransfer.v1.DataObjects
	15, // 5: yandex.cloud.datatransfer.v1.CreateTransferRequest.replication_runtime:type_name -> yandex.cloud.datatransfer.v1.Runtime
	15, // 6: yandex.cloud.datatransfer.v1.UpdateTransferRequest.runtime:type_name -> yandex.cloud.datatransfer.v1.Runtime
	19, // 7: yandex.cloud.datatransfer.v1.UpdateTransferRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 8: yandex.cloud.datatransfer.v1.UpdateTransferRequest.labels:type_name -> yandex.cloud.datatransfer.v1.UpdateTransferRequest.LabelsEntry
	17, // 9: yandex.cloud.datatransfer.v1.UpdateTransferRequest.transformation:type_name -> yandex.cloud.datatransfer.v1.Transformation
	18, // 10: yandex.cloud.datatransfer.v1.UpdateTransferRequest.data_objects:type_name -> yandex.cloud.datatransfer.v1.DataObjects
	15, // 11: yandex.cloud.datatransfer.v1.UpdateTransferRequest.replication_runtime:type_name -> yandex.cloud.datatransfer.v1.Runtime
	20, // 12: yandex.cloud.datatransfer.v1.ListTransfersResponse.transfers:type_name -> yandex.cloud.datatransfer.v1.Transfer
	0,  // 13: yandex.cloud.datatransfer.v1.TransferService.Create:input_type -> yandex.cloud.datatransfer.v1.CreateTransferRequest
	2,  // 14: yandex.cloud.datatransfer.v1.TransferService.Update:input_type -> yandex.cloud.datatransfer.v1.UpdateTransferRequest
	4,  // 15: yandex.cloud.datatransfer.v1.TransferService.Delete:input_type -> yandex.cloud.datatransfer.v1.DeleteTransferRequest
	6,  // 16: yandex.cloud.datatransfer.v1.TransferService.List:input_type -> yandex.cloud.datatransfer.v1.ListTransfersRequest
	8,  // 17: yandex.cloud.datatransfer.v1.TransferService.Get:input_type -> yandex.cloud.datatransfer.v1.GetTransferRequest
	9,  // 18: yandex.cloud.datatransfer.v1.TransferService.Deactivate:input_type -> yandex.cloud.datatransfer.v1.DeactivateTransferRequest
	11, // 19: yandex.cloud.datatransfer.v1.TransferService.Activate:input_type -> yandex.cloud.datatransfer.v1.ActivateTransferRequest
	21, // 20: yandex.cloud.datatransfer.v1.TransferService.Create:output_type -> yandex.cloud.operation.Operation
	21, // 21: yandex.cloud.datatransfer.v1.TransferService.Update:output_type -> yandex.cloud.operation.Operation
	21, // 22: yandex.cloud.datatransfer.v1.TransferService.Delete:output_type -> yandex.cloud.operation.Operation
	7,  // 23: yandex.cloud.datatransfer.v1.TransferService.List:output_type -> yandex.cloud.datatransfer.v1.ListTransfersResponse
	20, // 24: yandex.cloud.datatransfer.v1.TransferService.Get:output_type -> yandex.cloud.datatransfer.v1.Transfer
	21, // 25: yandex.cloud.datatransfer.v1.TransferService.Deactivate:output_type -> yandex.cloud.operation.Operation
	21, // 26: yandex.cloud.datatransfer.v1.TransferService.Activate:output_type -> yandex.cloud.operation.Operation
	20, // [20:27] is the sub-list for method output_type
	13, // [13:20] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_yandex_cloud_datatransfer_v1_transfer_service_proto_init() }
func file_yandex_cloud_datatransfer_v1_transfer_service_proto_init() {
	if File_yandex_cloud_datatransfer_v1_transfer_service_proto != nil {
		return
	}
	file_yandex_cloud_datatransfer_v1_transfer_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDesc), len(file_yandex_cloud_datatransfer_v1_transfer_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_datatransfer_v1_transfer_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_datatransfer_v1_transfer_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_datatransfer_v1_transfer_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_datatransfer_v1_transfer_service_proto = out.File
	file_yandex_cloud_datatransfer_v1_transfer_service_proto_goTypes = nil
	file_yandex_cloud_datatransfer_v1_transfer_service_proto_depIdxs = nil
}
