// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/spark/v1/cluster.proto

package spark

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Health int32

const (
	// Cluster is in unknown state (we have no data).
	Health_HEALTH_UNKNOWN Health = 0
	// Cluster is alive and well.
	Health_ALIVE Health = 1
	// Cluster is inoperable (it cannot perform any of its essential functions).
	Health_DEAD Health = 2
	// Cluster is partially alive (it can perform some of its essential functions).
	Health_DEGRADED Health = 3
)

// Enum value maps for Health.
var (
	Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Health) Enum() *Health {
	p := new(Health)
	*p = x
	return p
}

func (x Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_spark_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_spark_v1_cluster_proto_enumTypes[0]
}

func (x Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Health.Descriptor instead.
func (Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{0}
}

type Cluster_Status int32

const (
	// Cluster status is unknown
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 3
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster is stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "UPDATING",
		4: "ERROR",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"UPDATING":       3,
		"ERROR":          4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_spark_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_spark_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

// Spark cluster.
type Cluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique ID of the Spark cluster.
	// This ID is assigned by Cloud in the process of creating a Spark cluster.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Spark cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The time when the Spark cluster was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Spark cluster.
	// The name is unique within the folder. 1-64 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Spark cluster. 0-256 characters long.
	Description string            `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	Labels      map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Configuration of the Spark cluster.
	Config *ClusterConfig `protobuf:"bytes,7,opt,name=config,proto3" json:"config,omitempty"`
	// Cluster status.
	Status  Cluster_Status `protobuf:"varint,8,opt,name=status,proto3,enum=yandex.cloud.spark.v1.Cluster_Status" json:"status,omitempty"`
	Network *NetworkConfig `protobuf:"bytes,9,opt,name=network,proto3" json:"network,omitempty"`
	// Deletion Protection inhibits deletion of the cluster
	DeletionProtection bool `protobuf:"varint,10,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Service account that will be used to access a YC resources
	ServiceAccountId string `protobuf:"bytes,11,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Cloud logging configuration.
	Logging *LoggingConfig `protobuf:"bytes,12,opt,name=logging,proto3" json:"logging,omitempty"`
	// Aggregated cluster health.
	Health Health `protobuf:"varint,13,opt,name=health,proto3,enum=yandex.cloud.spark.v1.Health" json:"health,omitempty"`
	// UI URLs
	Links []*UILink `protobuf:"bytes,14,rep,name=links,proto3" json:"links,omitempty"`
	// Window of maintenance operations.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,15,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Maintenance operation planned at nearest maintenance_window.
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,16,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetNetwork() *NetworkConfig {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *Cluster) GetLogging() *LoggingConfig {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *Cluster) GetHealth() Health {
	if x != nil {
		return x.Health
	}
	return Health_HEALTH_UNKNOWN
}

func (x *Cluster) GetLinks() []*UILink {
	if x != nil {
		return x.Links
	}
	return nil
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

type ClusterConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ResourcePools *ResourcePools         `protobuf:"bytes,1,opt,name=resource_pools,json=resourcePools,proto3" json:"resource_pools,omitempty"`
	// Configuration for HistoryServer
	HistoryServer *HistoryServerConfig `protobuf:"bytes,2,opt,name=history_server,json=historyServer,proto3" json:"history_server,omitempty"`
	// Container custom environment dependencies
	Dependencies *Dependencies `protobuf:"bytes,3,opt,name=dependencies,proto3" json:"dependencies,omitempty"`
	// Metastore Cluster
	Metastore *Metastore `protobuf:"bytes,4,opt,name=metastore,proto3" json:"metastore,omitempty"`
	// Spark version. Format: "Major.Minor"
	SparkVersion  string `protobuf:"bytes,5,opt,name=spark_version,json=sparkVersion,proto3" json:"spark_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *ClusterConfig) GetResourcePools() *ResourcePools {
	if x != nil {
		return x.ResourcePools
	}
	return nil
}

func (x *ClusterConfig) GetHistoryServer() *HistoryServerConfig {
	if x != nil {
		return x.HistoryServer
	}
	return nil
}

func (x *ClusterConfig) GetDependencies() *Dependencies {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *ClusterConfig) GetMetastore() *Metastore {
	if x != nil {
		return x.Metastore
	}
	return nil
}

func (x *ClusterConfig) GetSparkVersion() string {
	if x != nil {
		return x.SparkVersion
	}
	return ""
}

type UpdateClusterConfigSpec struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ResourcePools *ResourcePools         `protobuf:"bytes,1,opt,name=resource_pools,json=resourcePools,proto3" json:"resource_pools,omitempty"`
	// Configuration for HistoryServer
	HistoryServer *HistoryServerConfig `protobuf:"bytes,2,opt,name=history_server,json=historyServer,proto3" json:"history_server,omitempty"`
	// Container custom environment dependencies
	Dependencies *Dependencies `protobuf:"bytes,3,opt,name=dependencies,proto3" json:"dependencies,omitempty"`
	// Metastore Cluster
	Metastore *Metastore `protobuf:"bytes,4,opt,name=metastore,proto3" json:"metastore,omitempty"`
	// Spark version. Format: "Major.Minor"
	SparkVersion  string `protobuf:"bytes,5,opt,name=spark_version,json=sparkVersion,proto3" json:"spark_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateClusterConfigSpec) Reset() {
	*x = UpdateClusterConfigSpec{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateClusterConfigSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClusterConfigSpec) ProtoMessage() {}

func (x *UpdateClusterConfigSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClusterConfigSpec.ProtoReflect.Descriptor instead.
func (*UpdateClusterConfigSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateClusterConfigSpec) GetResourcePools() *ResourcePools {
	if x != nil {
		return x.ResourcePools
	}
	return nil
}

func (x *UpdateClusterConfigSpec) GetHistoryServer() *HistoryServerConfig {
	if x != nil {
		return x.HistoryServer
	}
	return nil
}

func (x *UpdateClusterConfigSpec) GetDependencies() *Dependencies {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *UpdateClusterConfigSpec) GetMetastore() *Metastore {
	if x != nil {
		return x.Metastore
	}
	return nil
}

func (x *UpdateClusterConfigSpec) GetSparkVersion() string {
	if x != nil {
		return x.SparkVersion
	}
	return ""
}

type HistoryServerConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Enabled       bool                   `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HistoryServerConfig) Reset() {
	*x = HistoryServerConfig{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HistoryServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HistoryServerConfig) ProtoMessage() {}

func (x *HistoryServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HistoryServerConfig.ProtoReflect.Descriptor instead.
func (*HistoryServerConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *HistoryServerConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

type NetworkConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IDs of VPC network subnets where instances of the cluster are attached.
	SubnetIds []string `protobuf:"bytes,1,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// User security groups
	SecurityGroupIds []string `protobuf:"bytes,2,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *NetworkConfig) GetSubnetIds() []string {
	if x != nil {
		return x.SubnetIds
	}
	return nil
}

func (x *NetworkConfig) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

type UpdateNetworkConfigSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// User security groups.
	SecurityGroupIds []string `protobuf:"bytes,1,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *UpdateNetworkConfigSpec) Reset() {
	*x = UpdateNetworkConfigSpec{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateNetworkConfigSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNetworkConfigSpec) ProtoMessage() {}

func (x *UpdateNetworkConfigSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNetworkConfigSpec.ProtoReflect.Descriptor instead.
func (*UpdateNetworkConfigSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateNetworkConfigSpec) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

type ResourcePools struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Driver        *ResourcePool          `protobuf:"bytes,1,opt,name=driver,proto3" json:"driver,omitempty"`
	Executor      *ResourcePool          `protobuf:"bytes,2,opt,name=executor,proto3" json:"executor,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourcePools) Reset() {
	*x = ResourcePools{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourcePools) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePools) ProtoMessage() {}

func (x *ResourcePools) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePools.ProtoReflect.Descriptor instead.
func (*ResourcePools) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *ResourcePools) GetDriver() *ResourcePool {
	if x != nil {
		return x.Driver
	}
	return nil
}

func (x *ResourcePools) GetExecutor() *ResourcePool {
	if x != nil {
		return x.Executor
	}
	return nil
}

type ResourcePool struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the preset for computational resources allocated to a instance (e.g., CPU, memory, etc.).
	ResourcePresetId string       `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	ScalePolicy      *ScalePolicy `protobuf:"bytes,2,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ResourcePool) Reset() {
	*x = ResourcePool{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourcePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePool) ProtoMessage() {}

func (x *ResourcePool) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePool.ProtoReflect.Descriptor instead.
func (*ResourcePool) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *ResourcePool) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *ResourcePool) GetScalePolicy() *ScalePolicy {
	if x != nil {
		return x.ScalePolicy
	}
	return nil
}

type ScalePolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to ScaleType:
	//
	//	*ScalePolicy_FixedScale_
	//	*ScalePolicy_AutoScale_
	ScaleType     isScalePolicy_ScaleType `protobuf_oneof:"scale_type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ScalePolicy) Reset() {
	*x = ScalePolicy{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScalePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScalePolicy) ProtoMessage() {}

func (x *ScalePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScalePolicy.ProtoReflect.Descriptor instead.
func (*ScalePolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *ScalePolicy) GetScaleType() isScalePolicy_ScaleType {
	if x != nil {
		return x.ScaleType
	}
	return nil
}

func (x *ScalePolicy) GetFixedScale() *ScalePolicy_FixedScale {
	if x != nil {
		if x, ok := x.ScaleType.(*ScalePolicy_FixedScale_); ok {
			return x.FixedScale
		}
	}
	return nil
}

func (x *ScalePolicy) GetAutoScale() *ScalePolicy_AutoScale {
	if x != nil {
		if x, ok := x.ScaleType.(*ScalePolicy_AutoScale_); ok {
			return x.AutoScale
		}
	}
	return nil
}

type isScalePolicy_ScaleType interface {
	isScalePolicy_ScaleType()
}

type ScalePolicy_FixedScale_ struct {
	FixedScale *ScalePolicy_FixedScale `protobuf:"bytes,1,opt,name=fixed_scale,json=fixedScale,proto3,oneof"`
}

type ScalePolicy_AutoScale_ struct {
	AutoScale *ScalePolicy_AutoScale `protobuf:"bytes,2,opt,name=auto_scale,json=autoScale,proto3,oneof"`
}

func (*ScalePolicy_FixedScale_) isScalePolicy_ScaleType() {}

func (*ScalePolicy_AutoScale_) isScalePolicy_ScaleType() {}

type Dependencies struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PipPackages   []string               `protobuf:"bytes,1,rep,name=pip_packages,json=pipPackages,proto3" json:"pip_packages,omitempty"`
	DebPackages   []string               `protobuf:"bytes,2,rep,name=deb_packages,json=debPackages,proto3" json:"deb_packages,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Dependencies) Reset() {
	*x = Dependencies{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Dependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dependencies) ProtoMessage() {}

func (x *Dependencies) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dependencies.ProtoReflect.Descriptor instead.
func (*Dependencies) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *Dependencies) GetPipPackages() []string {
	if x != nil {
		return x.PipPackages
	}
	return nil
}

func (x *Dependencies) GetDebPackages() []string {
	if x != nil {
		return x.DebPackages
	}
	return nil
}

type Metastore struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ClusterId     string                 `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Metastore) Reset() {
	*x = Metastore{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metastore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metastore) ProtoMessage() {}

func (x *Metastore) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metastore.ProtoReflect.Descriptor instead.
func (*Metastore) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *Metastore) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

type LoggingConfig struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Enabled bool                   `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Types that are valid to be assigned to Destination:
	//
	//	*LoggingConfig_FolderId
	//	*LoggingConfig_LogGroupId
	Destination   isLoggingConfig_Destination `protobuf_oneof:"destination"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *LoggingConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *LoggingConfig) GetDestination() isLoggingConfig_Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *LoggingConfig) GetFolderId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingConfig_FolderId); ok {
			return x.FolderId
		}
	}
	return ""
}

func (x *LoggingConfig) GetLogGroupId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingConfig_LogGroupId); ok {
			return x.LogGroupId
		}
	}
	return ""
}

type isLoggingConfig_Destination interface {
	isLoggingConfig_Destination()
}

type LoggingConfig_FolderId struct {
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

type LoggingConfig_LogGroupId struct {
	LogGroupId string `protobuf:"bytes,3,opt,name=log_group_id,json=logGroupId,proto3,oneof"`
}

func (*LoggingConfig_FolderId) isLoggingConfig_Destination() {}

func (*LoggingConfig_LogGroupId) isLoggingConfig_Destination() {}

type UILink struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Url           string                 `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UILink) Reset() {
	*x = UILink{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UILink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UILink) ProtoMessage() {}

func (x *UILink) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UILink.ProtoReflect.Descriptor instead.
func (*UILink) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *UILink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UILink) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type ScalePolicy_FixedScale struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Size          int64                  `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ScalePolicy_FixedScale) Reset() {
	*x = ScalePolicy_FixedScale{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScalePolicy_FixedScale) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScalePolicy_FixedScale) ProtoMessage() {}

func (x *ScalePolicy_FixedScale) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScalePolicy_FixedScale.ProtoReflect.Descriptor instead.
func (*ScalePolicy_FixedScale) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{8, 0}
}

func (x *ScalePolicy_FixedScale) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

type ScalePolicy_AutoScale struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MinSize       int64                  `protobuf:"varint,1,opt,name=min_size,json=minSize,proto3" json:"min_size,omitempty"`
	MaxSize       int64                  `protobuf:"varint,2,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ScalePolicy_AutoScale) Reset() {
	*x = ScalePolicy_AutoScale{}
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScalePolicy_AutoScale) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScalePolicy_AutoScale) ProtoMessage() {}

func (x *ScalePolicy_AutoScale) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_spark_v1_cluster_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScalePolicy_AutoScale.ProtoReflect.Descriptor instead.
func (*ScalePolicy_AutoScale) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP(), []int{8, 1}
}

func (x *ScalePolicy_AutoScale) GetMinSize() int64 {
	if x != nil {
		return x.MinSize
	}
	return 0
}

func (x *ScalePolicy_AutoScale) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

var File_yandex_cloud_spark_v1_cluster_proto protoreflect.FileDescriptor

const file_yandex_cloud_spark_v1_cluster_proto_rawDesc = "" +
	"\n" +
	"#yandex/cloud/spark/v1/cluster.proto\x12\x15yandex.cloud.spark.v1\x1a'yandex/cloud/spark/v1/maintenance.proto\x1a\x1dyandex/cloud/validation.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xb4\b\n" +
	"\aCluster\x12\x1c\n" +
	"\x02id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12B\n" +
	"\x06labels\x18\x06 \x03(\v2*.yandex.cloud.spark.v1.Cluster.LabelsEntryR\x06labels\x12<\n" +
	"\x06config\x18\a \x01(\v2$.yandex.cloud.spark.v1.ClusterConfigR\x06config\x12=\n" +
	"\x06status\x18\b \x01(\x0e2%.yandex.cloud.spark.v1.Cluster.StatusR\x06status\x12>\n" +
	"\anetwork\x18\t \x01(\v2$.yandex.cloud.spark.v1.NetworkConfigR\anetwork\x12/\n" +
	"\x13deletion_protection\x18\n" +
	" \x01(\bR\x12deletionProtection\x126\n" +
	"\x12service_account_id\x18\v \x01(\tB\b\x8a\xc81\x04<=50R\x10serviceAccountId\x12>\n" +
	"\alogging\x18\f \x01(\v2$.yandex.cloud.spark.v1.LoggingConfigR\alogging\x125\n" +
	"\x06health\x18\r \x01(\x0e2\x1d.yandex.cloud.spark.v1.HealthR\x06health\x123\n" +
	"\x05links\x18\x0e \x03(\v2\x1d.yandex.cloud.spark.v1.UILinkR\x05links\x12W\n" +
	"\x12maintenance_window\x18\x0f \x01(\v2(.yandex.cloud.spark.v1.MaintenanceWindowR\x11maintenanceWindow\x12X\n" +
	"\x11planned_operation\x18\x10 \x01(\v2+.yandex.cloud.spark.v1.MaintenanceOperationR\x10plannedOperation\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"y\n" +
	"\x06Status\x12\x12\n" +
	"\x0eSTATUS_UNKNOWN\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aRUNNING\x10\x02\x12\f\n" +
	"\bUPDATING\x10\x03\x12\t\n" +
	"\x05ERROR\x10\x04\x12\f\n" +
	"\bSTOPPING\x10\x05\x12\v\n" +
	"\aSTOPPED\x10\x06\x12\f\n" +
	"\bSTARTING\x10\a\"\xe3\x02\n" +
	"\rClusterConfig\x12Q\n" +
	"\x0eresource_pools\x18\x01 \x01(\v2$.yandex.cloud.spark.v1.ResourcePoolsB\x04\xe8\xc71\x01R\rresourcePools\x12Q\n" +
	"\x0ehistory_server\x18\x02 \x01(\v2*.yandex.cloud.spark.v1.HistoryServerConfigR\rhistoryServer\x12G\n" +
	"\fdependencies\x18\x03 \x01(\v2#.yandex.cloud.spark.v1.DependenciesR\fdependencies\x12>\n" +
	"\tmetastore\x18\x04 \x01(\v2 .yandex.cloud.spark.v1.MetastoreR\tmetastore\x12#\n" +
	"\rspark_version\x18\x05 \x01(\tR\fsparkVersion\"\xe7\x02\n" +
	"\x17UpdateClusterConfigSpec\x12K\n" +
	"\x0eresource_pools\x18\x01 \x01(\v2$.yandex.cloud.spark.v1.ResourcePoolsR\rresourcePools\x12Q\n" +
	"\x0ehistory_server\x18\x02 \x01(\v2*.yandex.cloud.spark.v1.HistoryServerConfigR\rhistoryServer\x12G\n" +
	"\fdependencies\x18\x03 \x01(\v2#.yandex.cloud.spark.v1.DependenciesR\fdependencies\x12>\n" +
	"\tmetastore\x18\x04 \x01(\v2 .yandex.cloud.spark.v1.MetastoreR\tmetastore\x12#\n" +
	"\rspark_version\x18\x05 \x01(\tR\fsparkVersion\"/\n" +
	"\x13HistoryServerConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\"\\\n" +
	"\rNetworkConfig\x12\x1d\n" +
	"\n" +
	"subnet_ids\x18\x01 \x03(\tR\tsubnetIds\x12,\n" +
	"\x12security_group_ids\x18\x02 \x03(\tR\x10securityGroupIds\"G\n" +
	"\x17UpdateNetworkConfigSpec\x12,\n" +
	"\x12security_group_ids\x18\x01 \x03(\tR\x10securityGroupIds\"\x99\x01\n" +
	"\rResourcePools\x12A\n" +
	"\x06driver\x18\x01 \x01(\v2#.yandex.cloud.spark.v1.ResourcePoolB\x04\xe8\xc71\x01R\x06driver\x12E\n" +
	"\bexecutor\x18\x02 \x01(\v2#.yandex.cloud.spark.v1.ResourcePoolB\x04\xe8\xc71\x01R\bexecutor\"\x97\x01\n" +
	"\fResourcePool\x12:\n" +
	"\x12resource_preset_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x10resourcePresetId\x12K\n" +
	"\fscale_policy\x18\x02 \x01(\v2\".yandex.cloud.spark.v1.ScalePolicyB\x04\xe8\xc71\x01R\vscalePolicy\"\xc8\x02\n" +
	"\vScalePolicy\x12P\n" +
	"\vfixed_scale\x18\x01 \x01(\v2-.yandex.cloud.spark.v1.ScalePolicy.FixedScaleH\x00R\n" +
	"fixedScale\x12M\n" +
	"\n" +
	"auto_scale\x18\x02 \x01(\v2,.yandex.cloud.spark.v1.ScalePolicy.AutoScaleH\x00R\tautoScale\x1a+\n" +
	"\n" +
	"FixedScale\x12\x1d\n" +
	"\x04size\x18\x01 \x01(\x03B\t\xfa\xc71\x051-100R\x04size\x1aW\n" +
	"\tAutoScale\x12$\n" +
	"\bmin_size\x18\x01 \x01(\x03B\t\xfa\xc71\x050-100R\aminSize\x12$\n" +
	"\bmax_size\x18\x02 \x01(\x03B\t\xfa\xc71\x051-100R\amaxSizeB\x12\n" +
	"\n" +
	"scale_type\x12\x04\xc0\xc11\x01\"T\n" +
	"\fDependencies\x12!\n" +
	"\fpip_packages\x18\x01 \x03(\tR\vpipPackages\x12!\n" +
	"\fdeb_packages\x18\x02 \x03(\tR\vdebPackages\"4\n" +
	"\tMetastore\x12'\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\b\x8a\xc81\x04<=50R\tclusterId\"\xc5\x01\n" +
	"\rLoggingConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12B\n" +
	"\tfolder_id\x18\x02 \x01(\tB#\xf2\xc71\x1f([a-zA-Z][-a-zA-Z0-9_.]{0,63})?H\x00R\bfolderId\x12G\n" +
	"\flog_group_id\x18\x03 \x01(\tB#\xf2\xc71\x1f([a-zA-Z][-a-zA-Z0-9_.]{0,63})?H\x00R\n" +
	"logGroupIdB\r\n" +
	"\vdestination\".\n" +
	"\x06UILink\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x10\n" +
	"\x03url\x18\x02 \x01(\tR\x03url*?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03B\\\n" +
	"\x19yandex.cloud.api.spark.v1Z?github.com/yandex-cloud/go-genproto/yandex/cloud/spark/v1;sparkb\x06proto3"

var (
	file_yandex_cloud_spark_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_spark_v1_cluster_proto_rawDescData []byte
)

func file_yandex_cloud_spark_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_spark_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_spark_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_spark_v1_cluster_proto_rawDesc), len(file_yandex_cloud_spark_v1_cluster_proto_rawDesc)))
	})
	return file_yandex_cloud_spark_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_spark_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_yandex_cloud_spark_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_yandex_cloud_spark_v1_cluster_proto_goTypes = []any{
	(Health)(0),                     // 0: yandex.cloud.spark.v1.Health
	(Cluster_Status)(0),             // 1: yandex.cloud.spark.v1.Cluster.Status
	(*Cluster)(nil),                 // 2: yandex.cloud.spark.v1.Cluster
	(*ClusterConfig)(nil),           // 3: yandex.cloud.spark.v1.ClusterConfig
	(*UpdateClusterConfigSpec)(nil), // 4: yandex.cloud.spark.v1.UpdateClusterConfigSpec
	(*HistoryServerConfig)(nil),     // 5: yandex.cloud.spark.v1.HistoryServerConfig
	(*NetworkConfig)(nil),           // 6: yandex.cloud.spark.v1.NetworkConfig
	(*UpdateNetworkConfigSpec)(nil), // 7: yandex.cloud.spark.v1.UpdateNetworkConfigSpec
	(*ResourcePools)(nil),           // 8: yandex.cloud.spark.v1.ResourcePools
	(*ResourcePool)(nil),            // 9: yandex.cloud.spark.v1.ResourcePool
	(*ScalePolicy)(nil),             // 10: yandex.cloud.spark.v1.ScalePolicy
	(*Dependencies)(nil),            // 11: yandex.cloud.spark.v1.Dependencies
	(*Metastore)(nil),               // 12: yandex.cloud.spark.v1.Metastore
	(*LoggingConfig)(nil),           // 13: yandex.cloud.spark.v1.LoggingConfig
	(*UILink)(nil),                  // 14: yandex.cloud.spark.v1.UILink
	nil,                             // 15: yandex.cloud.spark.v1.Cluster.LabelsEntry
	(*ScalePolicy_FixedScale)(nil),  // 16: yandex.cloud.spark.v1.ScalePolicy.FixedScale
	(*ScalePolicy_AutoScale)(nil),   // 17: yandex.cloud.spark.v1.ScalePolicy.AutoScale
	(*timestamppb.Timestamp)(nil),   // 18: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),       // 19: yandex.cloud.spark.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),    // 20: yandex.cloud.spark.v1.MaintenanceOperation
}
var file_yandex_cloud_spark_v1_cluster_proto_depIdxs = []int32{
	18, // 0: yandex.cloud.spark.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	15, // 1: yandex.cloud.spark.v1.Cluster.labels:type_name -> yandex.cloud.spark.v1.Cluster.LabelsEntry
	3,  // 2: yandex.cloud.spark.v1.Cluster.config:type_name -> yandex.cloud.spark.v1.ClusterConfig
	1,  // 3: yandex.cloud.spark.v1.Cluster.status:type_name -> yandex.cloud.spark.v1.Cluster.Status
	6,  // 4: yandex.cloud.spark.v1.Cluster.network:type_name -> yandex.cloud.spark.v1.NetworkConfig
	13, // 5: yandex.cloud.spark.v1.Cluster.logging:type_name -> yandex.cloud.spark.v1.LoggingConfig
	0,  // 6: yandex.cloud.spark.v1.Cluster.health:type_name -> yandex.cloud.spark.v1.Health
	14, // 7: yandex.cloud.spark.v1.Cluster.links:type_name -> yandex.cloud.spark.v1.UILink
	19, // 8: yandex.cloud.spark.v1.Cluster.maintenance_window:type_name -> yandex.cloud.spark.v1.MaintenanceWindow
	20, // 9: yandex.cloud.spark.v1.Cluster.planned_operation:type_name -> yandex.cloud.spark.v1.MaintenanceOperation
	8,  // 10: yandex.cloud.spark.v1.ClusterConfig.resource_pools:type_name -> yandex.cloud.spark.v1.ResourcePools
	5,  // 11: yandex.cloud.spark.v1.ClusterConfig.history_server:type_name -> yandex.cloud.spark.v1.HistoryServerConfig
	11, // 12: yandex.cloud.spark.v1.ClusterConfig.dependencies:type_name -> yandex.cloud.spark.v1.Dependencies
	12, // 13: yandex.cloud.spark.v1.ClusterConfig.metastore:type_name -> yandex.cloud.spark.v1.Metastore
	8,  // 14: yandex.cloud.spark.v1.UpdateClusterConfigSpec.resource_pools:type_name -> yandex.cloud.spark.v1.ResourcePools
	5,  // 15: yandex.cloud.spark.v1.UpdateClusterConfigSpec.history_server:type_name -> yandex.cloud.spark.v1.HistoryServerConfig
	11, // 16: yandex.cloud.spark.v1.UpdateClusterConfigSpec.dependencies:type_name -> yandex.cloud.spark.v1.Dependencies
	12, // 17: yandex.cloud.spark.v1.UpdateClusterConfigSpec.metastore:type_name -> yandex.cloud.spark.v1.Metastore
	9,  // 18: yandex.cloud.spark.v1.ResourcePools.driver:type_name -> yandex.cloud.spark.v1.ResourcePool
	9,  // 19: yandex.cloud.spark.v1.ResourcePools.executor:type_name -> yandex.cloud.spark.v1.ResourcePool
	10, // 20: yandex.cloud.spark.v1.ResourcePool.scale_policy:type_name -> yandex.cloud.spark.v1.ScalePolicy
	16, // 21: yandex.cloud.spark.v1.ScalePolicy.fixed_scale:type_name -> yandex.cloud.spark.v1.ScalePolicy.FixedScale
	17, // 22: yandex.cloud.spark.v1.ScalePolicy.auto_scale:type_name -> yandex.cloud.spark.v1.ScalePolicy.AutoScale
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_yandex_cloud_spark_v1_cluster_proto_init() }
func file_yandex_cloud_spark_v1_cluster_proto_init() {
	if File_yandex_cloud_spark_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_spark_v1_maintenance_proto_init()
	file_yandex_cloud_spark_v1_cluster_proto_msgTypes[8].OneofWrappers = []any{
		(*ScalePolicy_FixedScale_)(nil),
		(*ScalePolicy_AutoScale_)(nil),
	}
	file_yandex_cloud_spark_v1_cluster_proto_msgTypes[11].OneofWrappers = []any{
		(*LoggingConfig_FolderId)(nil),
		(*LoggingConfig_LogGroupId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_spark_v1_cluster_proto_rawDesc), len(file_yandex_cloud_spark_v1_cluster_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_spark_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_spark_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_spark_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_spark_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_spark_v1_cluster_proto = out.File
	file_yandex_cloud_spark_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_spark_v1_cluster_proto_depIdxs = nil
}
