// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/video/v1/subtitle_service.proto

package video

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	SubtitleService_Get_FullMethodName               = "/yandex.cloud.video.v1.SubtitleService/Get"
	SubtitleService_List_FullMethodName              = "/yandex.cloud.video.v1.SubtitleService/List"
	SubtitleService_Create_FullMethodName            = "/yandex.cloud.video.v1.SubtitleService/Create"
	SubtitleService_GenerateUploadURL_FullMethodName = "/yandex.cloud.video.v1.SubtitleService/GenerateUploadURL"
	SubtitleService_Delete_FullMethodName            = "/yandex.cloud.video.v1.SubtitleService/Delete"
)

// SubtitleServiceClient is the client API for SubtitleService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Subtitle management service.
// Provides methods for creating, retrieving, updating, and deleting subtitles,
// which provide text translations or transcriptions of video content in various languages.
type SubtitleServiceClient interface {
	// Retrieves detailed information about a specific subtitle by its ID.
	// Returns all subtitle metadata and related information.
	Get(ctx context.Context, in *GetSubtitleRequest, opts ...grpc.CallOption) (*Subtitle, error)
	// Lists all subtitles associated with a specific video with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(ctx context.Context, in *ListSubtitlesRequest, opts ...grpc.CallOption) (*ListSubtitlesResponse, error)
	// Creates a new subtitle record for a specific video.
	// This method only creates the metadata record; the actual subtitle file must be uploaded
	// using the URL obtained from the GenerateUploadURL method.
	Create(ctx context.Context, in *CreateSubtitleRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Generates a URL for uploading a subtitle file to an existing subtitle record.
	// This URL can be used to upload the actual subtitle file using an HTTP PUT request.
	// The URL is pre-signed and has a limited validity period.
	GenerateUploadURL(ctx context.Context, in *GenerateSubtitleUploadURLRequest, opts ...grpc.CallOption) (*GenerateSubtitleUploadURLResponse, error)
	// Deletes a specific subtitle by its ID.
	// This removes both the metadata record and the associated subtitle file.
	Delete(ctx context.Context, in *DeleteSubtitleRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type subtitleServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSubtitleServiceClient(cc grpc.ClientConnInterface) SubtitleServiceClient {
	return &subtitleServiceClient{cc}
}

func (c *subtitleServiceClient) Get(ctx context.Context, in *GetSubtitleRequest, opts ...grpc.CallOption) (*Subtitle, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Subtitle)
	err := c.cc.Invoke(ctx, SubtitleService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subtitleServiceClient) List(ctx context.Context, in *ListSubtitlesRequest, opts ...grpc.CallOption) (*ListSubtitlesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListSubtitlesResponse)
	err := c.cc.Invoke(ctx, SubtitleService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subtitleServiceClient) Create(ctx context.Context, in *CreateSubtitleRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubtitleService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subtitleServiceClient) GenerateUploadURL(ctx context.Context, in *GenerateSubtitleUploadURLRequest, opts ...grpc.CallOption) (*GenerateSubtitleUploadURLResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GenerateSubtitleUploadURLResponse)
	err := c.cc.Invoke(ctx, SubtitleService_GenerateUploadURL_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subtitleServiceClient) Delete(ctx context.Context, in *DeleteSubtitleRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubtitleService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SubtitleServiceServer is the server API for SubtitleService service.
// All implementations should embed UnimplementedSubtitleServiceServer
// for forward compatibility.
//
// Subtitle management service.
// Provides methods for creating, retrieving, updating, and deleting subtitles,
// which provide text translations or transcriptions of video content in various languages.
type SubtitleServiceServer interface {
	// Retrieves detailed information about a specific subtitle by its ID.
	// Returns all subtitle metadata and related information.
	Get(context.Context, *GetSubtitleRequest) (*Subtitle, error)
	// Lists all subtitles associated with a specific video with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(context.Context, *ListSubtitlesRequest) (*ListSubtitlesResponse, error)
	// Creates a new subtitle record for a specific video.
	// This method only creates the metadata record; the actual subtitle file must be uploaded
	// using the URL obtained from the GenerateUploadURL method.
	Create(context.Context, *CreateSubtitleRequest) (*operation.Operation, error)
	// Generates a URL for uploading a subtitle file to an existing subtitle record.
	// This URL can be used to upload the actual subtitle file using an HTTP PUT request.
	// The URL is pre-signed and has a limited validity period.
	GenerateUploadURL(context.Context, *GenerateSubtitleUploadURLRequest) (*GenerateSubtitleUploadURLResponse, error)
	// Deletes a specific subtitle by its ID.
	// This removes both the metadata record and the associated subtitle file.
	Delete(context.Context, *DeleteSubtitleRequest) (*operation.Operation, error)
}

// UnimplementedSubtitleServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedSubtitleServiceServer struct{}

func (UnimplementedSubtitleServiceServer) Get(context.Context, *GetSubtitleRequest) (*Subtitle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedSubtitleServiceServer) List(context.Context, *ListSubtitlesRequest) (*ListSubtitlesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedSubtitleServiceServer) Create(context.Context, *CreateSubtitleRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedSubtitleServiceServer) GenerateUploadURL(context.Context, *GenerateSubtitleUploadURLRequest) (*GenerateSubtitleUploadURLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateUploadURL not implemented")
}
func (UnimplementedSubtitleServiceServer) Delete(context.Context, *DeleteSubtitleRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedSubtitleServiceServer) testEmbeddedByValue() {}

// UnsafeSubtitleServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SubtitleServiceServer will
// result in compilation errors.
type UnsafeSubtitleServiceServer interface {
	mustEmbedUnimplementedSubtitleServiceServer()
}

func RegisterSubtitleServiceServer(s grpc.ServiceRegistrar, srv SubtitleServiceServer) {
	// If the following call pancis, it indicates UnimplementedSubtitleServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&SubtitleService_ServiceDesc, srv)
}

func _SubtitleService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubtitleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubtitleServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubtitleService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubtitleServiceServer).Get(ctx, req.(*GetSubtitleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubtitleService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubtitlesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubtitleServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubtitleService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubtitleServiceServer).List(ctx, req.(*ListSubtitlesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubtitleService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubtitleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubtitleServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubtitleService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubtitleServiceServer).Create(ctx, req.(*CreateSubtitleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubtitleService_GenerateUploadURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateSubtitleUploadURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubtitleServiceServer).GenerateUploadURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubtitleService_GenerateUploadURL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubtitleServiceServer).GenerateUploadURL(ctx, req.(*GenerateSubtitleUploadURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubtitleService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubtitleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubtitleServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubtitleService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubtitleServiceServer).Delete(ctx, req.(*DeleteSubtitleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SubtitleService_ServiceDesc is the grpc.ServiceDesc for SubtitleService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SubtitleService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.video.v1.SubtitleService",
	HandlerType: (*SubtitleServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _SubtitleService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SubtitleService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _SubtitleService_Create_Handler,
		},
		{
			MethodName: "GenerateUploadURL",
			Handler:    _SubtitleService_GenerateUploadURL_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SubtitleService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/video/v1/subtitle_service.proto",
}
