// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/trino/v1/cluster.proto

package trino

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	v1 "github.com/yandex-cloud/go-genproto/yandex/cloud/logging/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Health int32

const (
	Health_HEALTH_UNKNOWN Health = 0 // Object is in unknown state (we have no data)
	Health_ALIVE          Health = 1 // Object is alive and well (all hosts are alive)
	Health_DEAD           Health = 2 // Object is inoperable (it cannot perform any of its essential functions)
	Health_DEGRADED       Health = 3 // Object is partially alive (it can perform some of its essential functions)
)

// Enum value maps for Health.
var (
	Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Health) Enum() *Health {
	p := new(Health)
	*p = x
	return p
}

func (x Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_trino_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_trino_v1_cluster_proto_enumTypes[0]
}

func (x Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Health.Descriptor instead.
func (Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{0}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 4
	// Cluster is stopped.
	Cluster_STOPPED Cluster_Status = 5
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 6
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "STOPPING",
		5: "STOPPED",
		6: "STARTING",
		7: "UPDATING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"STOPPING":       4,
		"STOPPED":        5,
		"STARTING":       6,
		"UPDATING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_trino_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_trino_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type RetryPolicyConfig_RetryPolicy int32

const (
	RetryPolicyConfig_RETRY_POLICY_UNSPECIFIED RetryPolicyConfig_RetryPolicy = 0
	RetryPolicyConfig_QUERY                    RetryPolicyConfig_RetryPolicy = 1
	RetryPolicyConfig_TASK                     RetryPolicyConfig_RetryPolicy = 2
)

// Enum value maps for RetryPolicyConfig_RetryPolicy.
var (
	RetryPolicyConfig_RetryPolicy_name = map[int32]string{
		0: "RETRY_POLICY_UNSPECIFIED",
		1: "QUERY",
		2: "TASK",
	}
	RetryPolicyConfig_RetryPolicy_value = map[string]int32{
		"RETRY_POLICY_UNSPECIFIED": 0,
		"QUERY":                    1,
		"TASK":                     2,
	}
)

func (x RetryPolicyConfig_RetryPolicy) Enum() *RetryPolicyConfig_RetryPolicy {
	p := new(RetryPolicyConfig_RetryPolicy)
	*p = x
	return p
}

func (x RetryPolicyConfig_RetryPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RetryPolicyConfig_RetryPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_trino_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (RetryPolicyConfig_RetryPolicy) Type() protoreflect.EnumType {
	return &file_yandex_cloud_trino_v1_cluster_proto_enumTypes[2]
}

func (x RetryPolicyConfig_RetryPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RetryPolicyConfig_RetryPolicy.Descriptor instead.
func (RetryPolicyConfig_RetryPolicy) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{7, 0}
}

// Trino cluster.
type Cluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique ID of the Trino cluster.
	// This ID is assigned by Cloud in the process of creating a Trino cluster.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Trino cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The time when the Trino cluster was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Trino cluster.
	// The name is unique within the folder. 1-64 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Trino cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs. Maximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Monitoring systems relevant to the Trino cluster.
	Monitoring []*Monitoring `protobuf:"bytes,7,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the Trino cluster.
	Trino *TrinoConfig `protobuf:"bytes,8,opt,name=trino,proto3" json:"trino,omitempty"`
	// Aggregated cluster health.
	Health Health `protobuf:"varint,9,opt,name=health,proto3,enum=yandex.cloud.trino.v1.Health" json:"health,omitempty"`
	// Cluster status.
	Status Cluster_Status `protobuf:"varint,10,opt,name=status,proto3,enum=yandex.cloud.trino.v1.Cluster_Status" json:"status,omitempty"`
	// Network related configuration options.
	Network *NetworkConfig `protobuf:"bytes,11,opt,name=network,proto3" json:"network,omitempty"`
	// Deletion Protection inhibits deletion of the cluster.
	DeletionProtection bool `protobuf:"varint,12,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Service account used to access Cloud resources.
	ServiceAccountId string `protobuf:"bytes,13,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Cloud logging configuration.
	Logging *LoggingConfig `protobuf:"bytes,14,opt,name=logging,proto3" json:"logging,omitempty"`
	// Address of Trino Coordinator.
	CoordinatorUrl string `protobuf:"bytes,15,opt,name=coordinator_url,json=coordinatorUrl,proto3" json:"coordinator_url,omitempty"`
	// Window of maintenance operations.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,16,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Maintenance operation planned at nearest maintenance_window.
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,17,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetTrino() *TrinoConfig {
	if x != nil {
		return x.Trino
	}
	return nil
}

func (x *Cluster) GetHealth() Health {
	if x != nil {
		return x.Health
	}
	return Health_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetNetwork() *NetworkConfig {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *Cluster) GetLogging() *LoggingConfig {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *Cluster) GetCoordinatorUrl() string {
	if x != nil {
		return x.CoordinatorUrl
	}
	return ""
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

// Monitoring system.
type Monitoring struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system.
	Link          string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type LoggingConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Logs generated by the Trino components are delivered to Cloud Logging.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Destination of log records.
	//
	// Types that are valid to be assigned to Destination:
	//
	//	*LoggingConfig_FolderId
	//	*LoggingConfig_LogGroupId
	Destination isLoggingConfig_Destination `protobuf_oneof:"destination"`
	// Minimum log entry level.
	//
	// See [LogLevel.Level] for details.
	MinLevel      v1.LogLevel_Level `protobuf:"varint,4,opt,name=min_level,json=minLevel,proto3,enum=yandex.cloud.logging.v1.LogLevel_Level" json:"min_level,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *LoggingConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *LoggingConfig) GetDestination() isLoggingConfig_Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *LoggingConfig) GetFolderId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingConfig_FolderId); ok {
			return x.FolderId
		}
	}
	return ""
}

func (x *LoggingConfig) GetLogGroupId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingConfig_LogGroupId); ok {
			return x.LogGroupId
		}
	}
	return ""
}

func (x *LoggingConfig) GetMinLevel() v1.LogLevel_Level {
	if x != nil {
		return x.MinLevel
	}
	return v1.LogLevel_Level(0)
}

type isLoggingConfig_Destination interface {
	isLoggingConfig_Destination()
}

type LoggingConfig_FolderId struct {
	// Logs should be written to default log group for specified folder.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

type LoggingConfig_LogGroupId struct {
	// Logs should be written to log group resolved by ID.
	LogGroupId string `protobuf:"bytes,3,opt,name=log_group_id,json=logGroupId,proto3,oneof"`
}

func (*LoggingConfig_FolderId) isLoggingConfig_Destination() {}

func (*LoggingConfig_LogGroupId) isLoggingConfig_Destination() {}

type NetworkConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IDs of VPC network subnets where instances of the cluster are attached.
	SubnetIds []string `protobuf:"bytes,1,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// User security groups.
	SecurityGroupIds []string `protobuf:"bytes,2,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *NetworkConfig) GetSubnetIds() []string {
	if x != nil {
		return x.SubnetIds
	}
	return nil
}

func (x *NetworkConfig) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

type TrinoConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for the coordinator, specifying computational resources and other settings.
	CoordinatorConfig *CoordinatorConfig `protobuf:"bytes,1,opt,name=coordinator_config,json=coordinatorConfig,proto3" json:"coordinator_config,omitempty"`
	// Configuration for worker nodes, including scaling policy and computational resources.
	WorkerConfig *WorkerConfig `protobuf:"bytes,2,opt,name=worker_config,json=workerConfig,proto3" json:"worker_config,omitempty"`
	// Version of Trino.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration for retry policy, specifying the spooling storage destination and other settings.
	RetryPolicy *RetryPolicyConfig `protobuf:"bytes,4,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
	// Configuration for access control, specifying the fine-grained rules of accesses.
	AccessControl *AccessControlConfig `protobuf:"bytes,5,opt,name=access_control,json=accessControl,proto3" json:"access_control,omitempty"`
	// Configuration for resource management, specifying the resource groups and other settings.
	ResourceManagement *ResourceManagementConfig `protobuf:"bytes,6,opt,name=resource_management,json=resourceManagement,proto3" json:"resource_management,omitempty"`
	// Configuration for TLS.
	Tls           *TLSConfig `protobuf:"bytes,7,opt,name=tls,proto3" json:"tls,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrinoConfig) Reset() {
	*x = TrinoConfig{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrinoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrinoConfig) ProtoMessage() {}

func (x *TrinoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrinoConfig.ProtoReflect.Descriptor instead.
func (*TrinoConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *TrinoConfig) GetCoordinatorConfig() *CoordinatorConfig {
	if x != nil {
		return x.CoordinatorConfig
	}
	return nil
}

func (x *TrinoConfig) GetWorkerConfig() *WorkerConfig {
	if x != nil {
		return x.WorkerConfig
	}
	return nil
}

func (x *TrinoConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *TrinoConfig) GetRetryPolicy() *RetryPolicyConfig {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

func (x *TrinoConfig) GetAccessControl() *AccessControlConfig {
	if x != nil {
		return x.AccessControl
	}
	return nil
}

func (x *TrinoConfig) GetResourceManagement() *ResourceManagementConfig {
	if x != nil {
		return x.ResourceManagement
	}
	return nil
}

func (x *TrinoConfig) GetTls() *TLSConfig {
	if x != nil {
		return x.Tls
	}
	return nil
}

type CoordinatorConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for computational resources assigned to the coordinator instance.
	Resources     *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CoordinatorConfig) Reset() {
	*x = CoordinatorConfig{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CoordinatorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CoordinatorConfig) ProtoMessage() {}

func (x *CoordinatorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CoordinatorConfig.ProtoReflect.Descriptor instead.
func (*CoordinatorConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *CoordinatorConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type WorkerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for computational resources for worker instances.
	Resources *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// Configuration for scaling policy for worker instances.
	ScalePolicy   *WorkerConfig_WorkerScalePolicy `protobuf:"bytes,2,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkerConfig) Reset() {
	*x = WorkerConfig{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerConfig) ProtoMessage() {}

func (x *WorkerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerConfig.ProtoReflect.Descriptor instead.
func (*WorkerConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *WorkerConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *WorkerConfig) GetScalePolicy() *WorkerConfig_WorkerScalePolicy {
	if x != nil {
		return x.ScalePolicy
	}
	return nil
}

type RetryPolicyConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Retry policy level.
	Policy RetryPolicyConfig_RetryPolicy `protobuf:"varint,1,opt,name=policy,proto3,enum=yandex.cloud.trino.v1.RetryPolicyConfig_RetryPolicy" json:"policy,omitempty"`
	// Configuration for exchange manager.
	ExchangeManager *ExchangeManagerConfig `protobuf:"bytes,2,opt,name=exchange_manager,json=exchangeManager,proto3" json:"exchange_manager,omitempty"`
	// Additional properties.
	AdditionalProperties map[string]string `protobuf:"bytes,3,rep,name=additional_properties,json=additionalProperties,proto3" json:"additional_properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *RetryPolicyConfig) Reset() {
	*x = RetryPolicyConfig{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetryPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryPolicyConfig) ProtoMessage() {}

func (x *RetryPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryPolicyConfig.ProtoReflect.Descriptor instead.
func (*RetryPolicyConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *RetryPolicyConfig) GetPolicy() RetryPolicyConfig_RetryPolicy {
	if x != nil {
		return x.Policy
	}
	return RetryPolicyConfig_RETRY_POLICY_UNSPECIFIED
}

func (x *RetryPolicyConfig) GetExchangeManager() *ExchangeManagerConfig {
	if x != nil {
		return x.ExchangeManager
	}
	return nil
}

func (x *RetryPolicyConfig) GetAdditionalProperties() map[string]string {
	if x != nil {
		return x.AdditionalProperties
	}
	return nil
}

type TLSConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Trusted CA-certificates. Each element should contain single self-signed CA-certificate or
	// chain of CA-certificates where first certificate is the leaf and last certificate is the self-signed root.
	TrustedCertificates []string `protobuf:"bytes,1,rep,name=trusted_certificates,json=trustedCertificates,proto3" json:"trusted_certificates,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *TLSConfig) Reset() {
	*x = TLSConfig{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLSConfig) ProtoMessage() {}

func (x *TLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLSConfig.ProtoReflect.Descriptor instead.
func (*TLSConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *TLSConfig) GetTrustedCertificates() []string {
	if x != nil {
		return x.TrustedCertificates
	}
	return nil
}

type ExchangeManagerStorage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Type:
	//
	//	*ExchangeManagerStorage_ServiceS3_
	Type          isExchangeManagerStorage_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExchangeManagerStorage) Reset() {
	*x = ExchangeManagerStorage{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExchangeManagerStorage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeManagerStorage) ProtoMessage() {}

func (x *ExchangeManagerStorage) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeManagerStorage.ProtoReflect.Descriptor instead.
func (*ExchangeManagerStorage) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *ExchangeManagerStorage) GetType() isExchangeManagerStorage_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ExchangeManagerStorage) GetServiceS3() *ExchangeManagerStorage_ServiceS3 {
	if x != nil {
		if x, ok := x.Type.(*ExchangeManagerStorage_ServiceS3_); ok {
			return x.ServiceS3
		}
	}
	return nil
}

type isExchangeManagerStorage_Type interface {
	isExchangeManagerStorage_Type()
}

type ExchangeManagerStorage_ServiceS3_ struct {
	// Use service side s3 bucket for exchange manager.
	ServiceS3 *ExchangeManagerStorage_ServiceS3 `protobuf:"bytes,1,opt,name=service_s3,json=serviceS3,proto3,oneof"`
}

func (*ExchangeManagerStorage_ServiceS3_) isExchangeManagerStorage_Type() {}

type ExchangeManagerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Additional properties.
	AdditionalProperties map[string]string       `protobuf:"bytes,1,rep,name=additional_properties,json=additionalProperties,proto3" json:"additional_properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Storage              *ExchangeManagerStorage `protobuf:"bytes,2,opt,name=storage,proto3" json:"storage,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ExchangeManagerConfig) Reset() {
	*x = ExchangeManagerConfig{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExchangeManagerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeManagerConfig) ProtoMessage() {}

func (x *ExchangeManagerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeManagerConfig.ProtoReflect.Descriptor instead.
func (*ExchangeManagerConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *ExchangeManagerConfig) GetAdditionalProperties() map[string]string {
	if x != nil {
		return x.AdditionalProperties
	}
	return nil
}

func (x *ExchangeManagerConfig) GetStorage() *ExchangeManagerStorage {
	if x != nil {
		return x.Storage
	}
	return nil
}

type Resources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the preset for computational resources allocated to a instance (e.g., CPU, memory, etc.).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Resources) Reset() {
	*x = Resources{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

type FixedScalePolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the number of worker instances.
	Count         int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FixedScalePolicy) Reset() {
	*x = FixedScalePolicy{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FixedScalePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FixedScalePolicy) ProtoMessage() {}

func (x *FixedScalePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FixedScalePolicy.ProtoReflect.Descriptor instead.
func (*FixedScalePolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *FixedScalePolicy) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

type AutoScalePolicy struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MinCount      int64                  `protobuf:"varint,1,opt,name=min_count,json=minCount,proto3" json:"min_count,omitempty"`
	MaxCount      int64                  `protobuf:"varint,2,opt,name=max_count,json=maxCount,proto3" json:"max_count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutoScalePolicy) Reset() {
	*x = AutoScalePolicy{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoScalePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoScalePolicy) ProtoMessage() {}

func (x *AutoScalePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoScalePolicy.ProtoReflect.Descriptor instead.
func (*AutoScalePolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *AutoScalePolicy) GetMinCount() int64 {
	if x != nil {
		return x.MinCount
	}
	return 0
}

func (x *AutoScalePolicy) GetMaxCount() int64 {
	if x != nil {
		return x.MaxCount
	}
	return 0
}

type WorkerConfig_WorkerScalePolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Defines the scaling type for worker instances.
	// Only one type of scaling can be specified at a time.
	//
	// Types that are valid to be assigned to ScaleType:
	//
	//	*WorkerConfig_WorkerScalePolicy_FixedScale
	//	*WorkerConfig_WorkerScalePolicy_AutoScale
	ScaleType     isWorkerConfig_WorkerScalePolicy_ScaleType `protobuf_oneof:"scale_type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkerConfig_WorkerScalePolicy) Reset() {
	*x = WorkerConfig_WorkerScalePolicy{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerConfig_WorkerScalePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerConfig_WorkerScalePolicy) ProtoMessage() {}

func (x *WorkerConfig_WorkerScalePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerConfig_WorkerScalePolicy.ProtoReflect.Descriptor instead.
func (*WorkerConfig_WorkerScalePolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

func (x *WorkerConfig_WorkerScalePolicy) GetScaleType() isWorkerConfig_WorkerScalePolicy_ScaleType {
	if x != nil {
		return x.ScaleType
	}
	return nil
}

func (x *WorkerConfig_WorkerScalePolicy) GetFixedScale() *FixedScalePolicy {
	if x != nil {
		if x, ok := x.ScaleType.(*WorkerConfig_WorkerScalePolicy_FixedScale); ok {
			return x.FixedScale
		}
	}
	return nil
}

func (x *WorkerConfig_WorkerScalePolicy) GetAutoScale() *AutoScalePolicy {
	if x != nil {
		if x, ok := x.ScaleType.(*WorkerConfig_WorkerScalePolicy_AutoScale); ok {
			return x.AutoScale
		}
	}
	return nil
}

type isWorkerConfig_WorkerScalePolicy_ScaleType interface {
	isWorkerConfig_WorkerScalePolicy_ScaleType()
}

type WorkerConfig_WorkerScalePolicy_FixedScale struct {
	// A fixed scaling policy that specifies a fixed number of worker instances.
	FixedScale *FixedScalePolicy `protobuf:"bytes,1,opt,name=fixed_scale,json=fixedScale,proto3,oneof"`
}

type WorkerConfig_WorkerScalePolicy_AutoScale struct {
	// A scaling policy that dynamically adjusts the number of worker instances
	// based on the cluster's workload. The system automatically increases or
	// decreases the number of instances within the defined range.
	AutoScale *AutoScalePolicy `protobuf:"bytes,2,opt,name=auto_scale,json=autoScale,proto3,oneof"`
}

func (*WorkerConfig_WorkerScalePolicy_FixedScale) isWorkerConfig_WorkerScalePolicy_ScaleType() {}

func (*WorkerConfig_WorkerScalePolicy_AutoScale) isWorkerConfig_WorkerScalePolicy_ScaleType() {}

type ExchangeManagerStorage_ServiceS3 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExchangeManagerStorage_ServiceS3) Reset() {
	*x = ExchangeManagerStorage_ServiceS3{}
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExchangeManagerStorage_ServiceS3) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeManagerStorage_ServiceS3) ProtoMessage() {}

func (x *ExchangeManagerStorage_ServiceS3) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_trino_v1_cluster_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeManagerStorage_ServiceS3.ProtoReflect.Descriptor instead.
func (*ExchangeManagerStorage_ServiceS3) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP(), []int{9, 0}
}

var File_yandex_cloud_trino_v1_cluster_proto protoreflect.FileDescriptor

const file_yandex_cloud_trino_v1_cluster_proto_rawDesc = "" +
	"\n" +
	"#yandex/cloud/trino/v1/cluster.proto\x12\x15yandex.cloud.trino.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a'yandex/cloud/logging/v1/log_entry.proto\x1a*yandex/cloud/trino/v1/access_control.proto\x1a'yandex/cloud/trino/v1/maintenance.proto\x1a/yandex/cloud/trino/v1/resource_management.proto\x1a\x1dyandex/cloud/validation.proto\"\xd9\b\n" +
	"\aCluster\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12B\n" +
	"\x06labels\x18\x06 \x03(\v2*.yandex.cloud.trino.v1.Cluster.LabelsEntryR\x06labels\x12A\n" +
	"\n" +
	"monitoring\x18\a \x03(\v2!.yandex.cloud.trino.v1.MonitoringR\n" +
	"monitoring\x128\n" +
	"\x05trino\x18\b \x01(\v2\".yandex.cloud.trino.v1.TrinoConfigR\x05trino\x125\n" +
	"\x06health\x18\t \x01(\x0e2\x1d.yandex.cloud.trino.v1.HealthR\x06health\x12=\n" +
	"\x06status\x18\n" +
	" \x01(\x0e2%.yandex.cloud.trino.v1.Cluster.StatusR\x06status\x12>\n" +
	"\anetwork\x18\v \x01(\v2$.yandex.cloud.trino.v1.NetworkConfigR\anetwork\x12/\n" +
	"\x13deletion_protection\x18\f \x01(\bR\x12deletionProtection\x126\n" +
	"\x12service_account_id\x18\r \x01(\tB\b\x8a\xc81\x04<=50R\x10serviceAccountId\x12>\n" +
	"\alogging\x18\x0e \x01(\v2$.yandex.cloud.trino.v1.LoggingConfigR\alogging\x12'\n" +
	"\x0fcoordinator_url\x18\x0f \x01(\tR\x0ecoordinatorUrl\x12W\n" +
	"\x12maintenance_window\x18\x10 \x01(\v2(.yandex.cloud.trino.v1.MaintenanceWindowR\x11maintenanceWindow\x12X\n" +
	"\x11planned_operation\x18\x11 \x01(\v2+.yandex.cloud.trino.v1.MaintenanceOperationR\x10plannedOperation\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"y\n" +
	"\x06Status\x12\x12\n" +
	"\x0eSTATUS_UNKNOWN\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aRUNNING\x10\x02\x12\t\n" +
	"\x05ERROR\x10\x03\x12\f\n" +
	"\bSTOPPING\x10\x04\x12\v\n" +
	"\aSTOPPED\x10\x05\x12\f\n" +
	"\bSTARTING\x10\x06\x12\f\n" +
	"\bUPDATING\x10\a\"V\n" +
	"\n" +
	"Monitoring\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12\x12\n" +
	"\x04link\x18\x03 \x01(\tR\x04link\"\x8b\x02\n" +
	"\rLoggingConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12B\n" +
	"\tfolder_id\x18\x02 \x01(\tB#\xf2\xc71\x1f([a-zA-Z][-a-zA-Z0-9_.]{0,63})?H\x00R\bfolderId\x12G\n" +
	"\flog_group_id\x18\x03 \x01(\tB#\xf2\xc71\x1f([a-zA-Z][-a-zA-Z0-9_.]{0,63})?H\x00R\n" +
	"logGroupId\x12D\n" +
	"\tmin_level\x18\x04 \x01(\x0e2'.yandex.cloud.logging.v1.LogLevel.LevelR\bminLevelB\r\n" +
	"\vdestination\"\\\n" +
	"\rNetworkConfig\x12\x1d\n" +
	"\n" +
	"subnet_ids\x18\x01 \x03(\tR\tsubnetIds\x12,\n" +
	"\x12security_group_ids\x18\x02 \x03(\tR\x10securityGroupIds\"\x8c\x04\n" +
	"\vTrinoConfig\x12]\n" +
	"\x12coordinator_config\x18\x01 \x01(\v2(.yandex.cloud.trino.v1.CoordinatorConfigB\x04\xe8\xc71\x01R\x11coordinatorConfig\x12N\n" +
	"\rworker_config\x18\x02 \x01(\v2#.yandex.cloud.trino.v1.WorkerConfigB\x04\xe8\xc71\x01R\fworkerConfig\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12K\n" +
	"\fretry_policy\x18\x04 \x01(\v2(.yandex.cloud.trino.v1.RetryPolicyConfigR\vretryPolicy\x12Q\n" +
	"\x0eaccess_control\x18\x05 \x01(\v2*.yandex.cloud.trino.v1.AccessControlConfigR\raccessControl\x12`\n" +
	"\x13resource_management\x18\x06 \x01(\v2/.yandex.cloud.trino.v1.ResourceManagementConfigR\x12resourceManagement\x122\n" +
	"\x03tls\x18\a \x01(\v2 .yandex.cloud.trino.v1.TLSConfigR\x03tls\"Y\n" +
	"\x11CoordinatorConfig\x12D\n" +
	"\tresources\x18\x01 \x01(\v2 .yandex.cloud.trino.v1.ResourcesB\x04\xe8\xc71\x01R\tresources\"\xf3\x02\n" +
	"\fWorkerConfig\x12D\n" +
	"\tresources\x18\x01 \x01(\v2 .yandex.cloud.trino.v1.ResourcesB\x04\xe8\xc71\x01R\tresources\x12^\n" +
	"\fscale_policy\x18\x02 \x01(\v25.yandex.cloud.trino.v1.WorkerConfig.WorkerScalePolicyB\x04\xe8\xc71\x01R\vscalePolicy\x1a\xbc\x01\n" +
	"\x11WorkerScalePolicy\x12J\n" +
	"\vfixed_scale\x18\x01 \x01(\v2'.yandex.cloud.trino.v1.FixedScalePolicyH\x00R\n" +
	"fixedScale\x12G\n" +
	"\n" +
	"auto_scale\x18\x02 \x01(\v2&.yandex.cloud.trino.v1.AutoScalePolicyH\x00R\tautoScaleB\x12\n" +
	"\n" +
	"scale_type\x12\x04\xc0\xc11\x01\"\x8a\x04\n" +
	"\x11RetryPolicyConfig\x12L\n" +
	"\x06policy\x18\x01 \x01(\x0e24.yandex.cloud.trino.v1.RetryPolicyConfig.RetryPolicyR\x06policy\x12W\n" +
	"\x10exchange_manager\x18\x02 \x01(\v2,.yandex.cloud.trino.v1.ExchangeManagerConfigR\x0fexchangeManager\x12\xc2\x01\n" +
	"\x15additional_properties\x18\x03 \x03(\v2B.yandex.cloud.trino.v1.RetryPolicyConfig.AdditionalPropertiesEntryBI\xf2\xc71\x15[-_0-9a-zA-Z.,:\\/_ ]*\x82\xc81\x05<=256\x8a\xc81\x05<=128\xb2\xc81\x1a\x12\x11[a-z][-_0-9a-z.]*\x1a\x051-128R\x14additionalProperties\x1aG\n" +
	"\x19AdditionalPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"@\n" +
	"\vRetryPolicy\x12\x1c\n" +
	"\x18RETRY_POLICY_UNSPECIFIED\x10\x00\x12\t\n" +
	"\x05QUERY\x10\x01\x12\b\n" +
	"\x04TASK\x10\x02\"U\n" +
	"\tTLSConfig\x12H\n" +
	"\x14trusted_certificates\x18\x01 \x03(\tB\x15\x82\xc81\x03<=8\x8a\xc81\x06<=8192\x90\xc81\x01R\x13trustedCertificates\"\x8d\x01\n" +
	"\x16ExchangeManagerStorage\x12X\n" +
	"\n" +
	"service_s3\x18\x01 \x01(\v27.yandex.cloud.trino.v1.ExchangeManagerStorage.ServiceS3H\x00R\tserviceS3\x1a\v\n" +
	"\tServiceS3B\f\n" +
	"\x04type\x12\x04\xc0\xc11\x01\"\xf2\x02\n" +
	"\x15ExchangeManagerConfig\x12\xc6\x01\n" +
	"\x15additional_properties\x18\x01 \x03(\v2F.yandex.cloud.trino.v1.ExchangeManagerConfig.AdditionalPropertiesEntryBI\xf2\xc71\x15[-_0-9a-zA-Z.,:\\/_ ]*\x82\xc81\x05<=256\x8a\xc81\x05<=128\xb2\xc81\x1a\x12\x11[a-z][-_0-9a-z.]*\x1a\x051-128R\x14additionalProperties\x12G\n" +
	"\astorage\x18\x02 \x01(\v2-.yandex.cloud.trino.v1.ExchangeManagerStorageR\astorage\x1aG\n" +
	"\x19AdditionalPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"G\n" +
	"\tResources\x12:\n" +
	"\x12resource_preset_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x10resourcePresetId\"3\n" +
	"\x10FixedScalePolicy\x12\x1f\n" +
	"\x05count\x18\x01 \x01(\x03B\t\xfa\xc71\x051-512R\x05count\"a\n" +
	"\x0fAutoScalePolicy\x12&\n" +
	"\tmin_count\x18\x01 \x01(\x03B\t\xfa\xc71\x050-512R\bminCount\x12&\n" +
	"\tmax_count\x18\x02 \x01(\x03B\t\xfa\xc71\x051-512R\bmaxCount*?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03B\\\n" +
	"\x19yandex.cloud.api.trino.v1Z?github.com/yandex-cloud/go-genproto/yandex/cloud/trino/v1;trinob\x06proto3"

var (
	file_yandex_cloud_trino_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_trino_v1_cluster_proto_rawDescData []byte
)

func file_yandex_cloud_trino_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_trino_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_trino_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_trino_v1_cluster_proto_rawDesc), len(file_yandex_cloud_trino_v1_cluster_proto_rawDesc)))
	})
	return file_yandex_cloud_trino_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_trino_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_yandex_cloud_trino_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_yandex_cloud_trino_v1_cluster_proto_goTypes = []any{
	(Health)(0),                              // 0: yandex.cloud.trino.v1.Health
	(Cluster_Status)(0),                      // 1: yandex.cloud.trino.v1.Cluster.Status
	(RetryPolicyConfig_RetryPolicy)(0),       // 2: yandex.cloud.trino.v1.RetryPolicyConfig.RetryPolicy
	(*Cluster)(nil),                          // 3: yandex.cloud.trino.v1.Cluster
	(*Monitoring)(nil),                       // 4: yandex.cloud.trino.v1.Monitoring
	(*LoggingConfig)(nil),                    // 5: yandex.cloud.trino.v1.LoggingConfig
	(*NetworkConfig)(nil),                    // 6: yandex.cloud.trino.v1.NetworkConfig
	(*TrinoConfig)(nil),                      // 7: yandex.cloud.trino.v1.TrinoConfig
	(*CoordinatorConfig)(nil),                // 8: yandex.cloud.trino.v1.CoordinatorConfig
	(*WorkerConfig)(nil),                     // 9: yandex.cloud.trino.v1.WorkerConfig
	(*RetryPolicyConfig)(nil),                // 10: yandex.cloud.trino.v1.RetryPolicyConfig
	(*TLSConfig)(nil),                        // 11: yandex.cloud.trino.v1.TLSConfig
	(*ExchangeManagerStorage)(nil),           // 12: yandex.cloud.trino.v1.ExchangeManagerStorage
	(*ExchangeManagerConfig)(nil),            // 13: yandex.cloud.trino.v1.ExchangeManagerConfig
	(*Resources)(nil),                        // 14: yandex.cloud.trino.v1.Resources
	(*FixedScalePolicy)(nil),                 // 15: yandex.cloud.trino.v1.FixedScalePolicy
	(*AutoScalePolicy)(nil),                  // 16: yandex.cloud.trino.v1.AutoScalePolicy
	nil,                                      // 17: yandex.cloud.trino.v1.Cluster.LabelsEntry
	(*WorkerConfig_WorkerScalePolicy)(nil),   // 18: yandex.cloud.trino.v1.WorkerConfig.WorkerScalePolicy
	nil,                                      // 19: yandex.cloud.trino.v1.RetryPolicyConfig.AdditionalPropertiesEntry
	(*ExchangeManagerStorage_ServiceS3)(nil), // 20: yandex.cloud.trino.v1.ExchangeManagerStorage.ServiceS3
	nil,                                      // 21: yandex.cloud.trino.v1.ExchangeManagerConfig.AdditionalPropertiesEntry
	(*timestamppb.Timestamp)(nil),            // 22: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),                // 23: yandex.cloud.trino.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),             // 24: yandex.cloud.trino.v1.MaintenanceOperation
	(v1.LogLevel_Level)(0),                   // 25: yandex.cloud.logging.v1.LogLevel.Level
	(*AccessControlConfig)(nil),              // 26: yandex.cloud.trino.v1.AccessControlConfig
	(*ResourceManagementConfig)(nil),         // 27: yandex.cloud.trino.v1.ResourceManagementConfig
}
var file_yandex_cloud_trino_v1_cluster_proto_depIdxs = []int32{
	22, // 0: yandex.cloud.trino.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	17, // 1: yandex.cloud.trino.v1.Cluster.labels:type_name -> yandex.cloud.trino.v1.Cluster.LabelsEntry
	4,  // 2: yandex.cloud.trino.v1.Cluster.monitoring:type_name -> yandex.cloud.trino.v1.Monitoring
	7,  // 3: yandex.cloud.trino.v1.Cluster.trino:type_name -> yandex.cloud.trino.v1.TrinoConfig
	0,  // 4: yandex.cloud.trino.v1.Cluster.health:type_name -> yandex.cloud.trino.v1.Health
	1,  // 5: yandex.cloud.trino.v1.Cluster.status:type_name -> yandex.cloud.trino.v1.Cluster.Status
	6,  // 6: yandex.cloud.trino.v1.Cluster.network:type_name -> yandex.cloud.trino.v1.NetworkConfig
	5,  // 7: yandex.cloud.trino.v1.Cluster.logging:type_name -> yandex.cloud.trino.v1.LoggingConfig
	23, // 8: yandex.cloud.trino.v1.Cluster.maintenance_window:type_name -> yandex.cloud.trino.v1.MaintenanceWindow
	24, // 9: yandex.cloud.trino.v1.Cluster.planned_operation:type_name -> yandex.cloud.trino.v1.MaintenanceOperation
	25, // 10: yandex.cloud.trino.v1.LoggingConfig.min_level:type_name -> yandex.cloud.logging.v1.LogLevel.Level
	8,  // 11: yandex.cloud.trino.v1.TrinoConfig.coordinator_config:type_name -> yandex.cloud.trino.v1.CoordinatorConfig
	9,  // 12: yandex.cloud.trino.v1.TrinoConfig.worker_config:type_name -> yandex.cloud.trino.v1.WorkerConfig
	10, // 13: yandex.cloud.trino.v1.TrinoConfig.retry_policy:type_name -> yandex.cloud.trino.v1.RetryPolicyConfig
	26, // 14: yandex.cloud.trino.v1.TrinoConfig.access_control:type_name -> yandex.cloud.trino.v1.AccessControlConfig
	27, // 15: yandex.cloud.trino.v1.TrinoConfig.resource_management:type_name -> yandex.cloud.trino.v1.ResourceManagementConfig
	11, // 16: yandex.cloud.trino.v1.TrinoConfig.tls:type_name -> yandex.cloud.trino.v1.TLSConfig
	14, // 17: yandex.cloud.trino.v1.CoordinatorConfig.resources:type_name -> yandex.cloud.trino.v1.Resources
	14, // 18: yandex.cloud.trino.v1.WorkerConfig.resources:type_name -> yandex.cloud.trino.v1.Resources
	18, // 19: yandex.cloud.trino.v1.WorkerConfig.scale_policy:type_name -> yandex.cloud.trino.v1.WorkerConfig.WorkerScalePolicy
	2,  // 20: yandex.cloud.trino.v1.RetryPolicyConfig.policy:type_name -> yandex.cloud.trino.v1.RetryPolicyConfig.RetryPolicy
	13, // 21: yandex.cloud.trino.v1.RetryPolicyConfig.exchange_manager:type_name -> yandex.cloud.trino.v1.ExchangeManagerConfig
	19, // 22: yandex.cloud.trino.v1.RetryPolicyConfig.additional_properties:type_name -> yandex.cloud.trino.v1.RetryPolicyConfig.AdditionalPropertiesEntry
	20, // 23: yandex.cloud.trino.v1.ExchangeManagerStorage.service_s3:type_name -> yandex.cloud.trino.v1.ExchangeManagerStorage.ServiceS3
	21, // 24: yandex.cloud.trino.v1.ExchangeManagerConfig.additional_properties:type_name -> yandex.cloud.trino.v1.ExchangeManagerConfig.AdditionalPropertiesEntry
	12, // 25: yandex.cloud.trino.v1.ExchangeManagerConfig.storage:type_name -> yandex.cloud.trino.v1.ExchangeManagerStorage
	15, // 26: yandex.cloud.trino.v1.WorkerConfig.WorkerScalePolicy.fixed_scale:type_name -> yandex.cloud.trino.v1.FixedScalePolicy
	16, // 27: yandex.cloud.trino.v1.WorkerConfig.WorkerScalePolicy.auto_scale:type_name -> yandex.cloud.trino.v1.AutoScalePolicy
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_yandex_cloud_trino_v1_cluster_proto_init() }
func file_yandex_cloud_trino_v1_cluster_proto_init() {
	if File_yandex_cloud_trino_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_trino_v1_access_control_proto_init()
	file_yandex_cloud_trino_v1_maintenance_proto_init()
	file_yandex_cloud_trino_v1_resource_management_proto_init()
	file_yandex_cloud_trino_v1_cluster_proto_msgTypes[2].OneofWrappers = []any{
		(*LoggingConfig_FolderId)(nil),
		(*LoggingConfig_LogGroupId)(nil),
	}
	file_yandex_cloud_trino_v1_cluster_proto_msgTypes[9].OneofWrappers = []any{
		(*ExchangeManagerStorage_ServiceS3_)(nil),
	}
	file_yandex_cloud_trino_v1_cluster_proto_msgTypes[15].OneofWrappers = []any{
		(*WorkerConfig_WorkerScalePolicy_FixedScale)(nil),
		(*WorkerConfig_WorkerScalePolicy_AutoScale)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_trino_v1_cluster_proto_rawDesc), len(file_yandex_cloud_trino_v1_cluster_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_trino_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_trino_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_trino_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_trino_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_trino_v1_cluster_proto = out.File
	file_yandex_cloud_trino_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_trino_v1_cluster_proto_depIdxs = nil
}
