// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package securitylakeiface provides an interface to enable mocking the Amazon Security Lake service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package securitylakeiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/securitylake"
)

// SecurityLakeAPI provides an interface to enable mocking the
// securitylake.SecurityLake service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Security Lake.
//	func myFunc(svc securitylakeiface.SecurityLakeAPI) bool {
//	    // Make svc.CreateAwsLogSource request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := securitylake.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSecurityLakeClient struct {
//	    securitylakeiface.SecurityLakeAPI
//	}
//	func (m *mockSecurityLakeClient) CreateAwsLogSource(input *securitylake.CreateAwsLogSourceInput) (*securitylake.CreateAwsLogSourceOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSecurityLakeClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SecurityLakeAPI interface {
	CreateAwsLogSource(*securitylake.CreateAwsLogSourceInput) (*securitylake.CreateAwsLogSourceOutput, error)
	CreateAwsLogSourceWithContext(aws.Context, *securitylake.CreateAwsLogSourceInput, ...request.Option) (*securitylake.CreateAwsLogSourceOutput, error)
	CreateAwsLogSourceRequest(*securitylake.CreateAwsLogSourceInput) (*request.Request, *securitylake.CreateAwsLogSourceOutput)

	CreateCustomLogSource(*securitylake.CreateCustomLogSourceInput) (*securitylake.CreateCustomLogSourceOutput, error)
	CreateCustomLogSourceWithContext(aws.Context, *securitylake.CreateCustomLogSourceInput, ...request.Option) (*securitylake.CreateCustomLogSourceOutput, error)
	CreateCustomLogSourceRequest(*securitylake.CreateCustomLogSourceInput) (*request.Request, *securitylake.CreateCustomLogSourceOutput)

	CreateDatalake(*securitylake.CreateDatalakeInput) (*securitylake.CreateDatalakeOutput, error)
	CreateDatalakeWithContext(aws.Context, *securitylake.CreateDatalakeInput, ...request.Option) (*securitylake.CreateDatalakeOutput, error)
	CreateDatalakeRequest(*securitylake.CreateDatalakeInput) (*request.Request, *securitylake.CreateDatalakeOutput)

	CreateDatalakeAutoEnable(*securitylake.CreateDatalakeAutoEnableInput) (*securitylake.CreateDatalakeAutoEnableOutput, error)
	CreateDatalakeAutoEnableWithContext(aws.Context, *securitylake.CreateDatalakeAutoEnableInput, ...request.Option) (*securitylake.CreateDatalakeAutoEnableOutput, error)
	CreateDatalakeAutoEnableRequest(*securitylake.CreateDatalakeAutoEnableInput) (*request.Request, *securitylake.CreateDatalakeAutoEnableOutput)

	CreateDatalakeDelegatedAdmin(*securitylake.CreateDatalakeDelegatedAdminInput) (*securitylake.CreateDatalakeDelegatedAdminOutput, error)
	CreateDatalakeDelegatedAdminWithContext(aws.Context, *securitylake.CreateDatalakeDelegatedAdminInput, ...request.Option) (*securitylake.CreateDatalakeDelegatedAdminOutput, error)
	CreateDatalakeDelegatedAdminRequest(*securitylake.CreateDatalakeDelegatedAdminInput) (*request.Request, *securitylake.CreateDatalakeDelegatedAdminOutput)

	CreateDatalakeExceptionsSubscription(*securitylake.CreateDatalakeExceptionsSubscriptionInput) (*securitylake.CreateDatalakeExceptionsSubscriptionOutput, error)
	CreateDatalakeExceptionsSubscriptionWithContext(aws.Context, *securitylake.CreateDatalakeExceptionsSubscriptionInput, ...request.Option) (*securitylake.CreateDatalakeExceptionsSubscriptionOutput, error)
	CreateDatalakeExceptionsSubscriptionRequest(*securitylake.CreateDatalakeExceptionsSubscriptionInput) (*request.Request, *securitylake.CreateDatalakeExceptionsSubscriptionOutput)

	CreateSubscriber(*securitylake.CreateSubscriberInput) (*securitylake.CreateSubscriberOutput, error)
	CreateSubscriberWithContext(aws.Context, *securitylake.CreateSubscriberInput, ...request.Option) (*securitylake.CreateSubscriberOutput, error)
	CreateSubscriberRequest(*securitylake.CreateSubscriberInput) (*request.Request, *securitylake.CreateSubscriberOutput)

	CreateSubscriptionNotificationConfiguration(*securitylake.CreateSubscriptionNotificationConfigurationInput) (*securitylake.CreateSubscriptionNotificationConfigurationOutput, error)
	CreateSubscriptionNotificationConfigurationWithContext(aws.Context, *securitylake.CreateSubscriptionNotificationConfigurationInput, ...request.Option) (*securitylake.CreateSubscriptionNotificationConfigurationOutput, error)
	CreateSubscriptionNotificationConfigurationRequest(*securitylake.CreateSubscriptionNotificationConfigurationInput) (*request.Request, *securitylake.CreateSubscriptionNotificationConfigurationOutput)

	DeleteAwsLogSource(*securitylake.DeleteAwsLogSourceInput) (*securitylake.DeleteAwsLogSourceOutput, error)
	DeleteAwsLogSourceWithContext(aws.Context, *securitylake.DeleteAwsLogSourceInput, ...request.Option) (*securitylake.DeleteAwsLogSourceOutput, error)
	DeleteAwsLogSourceRequest(*securitylake.DeleteAwsLogSourceInput) (*request.Request, *securitylake.DeleteAwsLogSourceOutput)

	DeleteCustomLogSource(*securitylake.DeleteCustomLogSourceInput) (*securitylake.DeleteCustomLogSourceOutput, error)
	DeleteCustomLogSourceWithContext(aws.Context, *securitylake.DeleteCustomLogSourceInput, ...request.Option) (*securitylake.DeleteCustomLogSourceOutput, error)
	DeleteCustomLogSourceRequest(*securitylake.DeleteCustomLogSourceInput) (*request.Request, *securitylake.DeleteCustomLogSourceOutput)

	DeleteDatalake(*securitylake.DeleteDatalakeInput) (*securitylake.DeleteDatalakeOutput, error)
	DeleteDatalakeWithContext(aws.Context, *securitylake.DeleteDatalakeInput, ...request.Option) (*securitylake.DeleteDatalakeOutput, error)
	DeleteDatalakeRequest(*securitylake.DeleteDatalakeInput) (*request.Request, *securitylake.DeleteDatalakeOutput)

	DeleteDatalakeAutoEnable(*securitylake.DeleteDatalakeAutoEnableInput) (*securitylake.DeleteDatalakeAutoEnableOutput, error)
	DeleteDatalakeAutoEnableWithContext(aws.Context, *securitylake.DeleteDatalakeAutoEnableInput, ...request.Option) (*securitylake.DeleteDatalakeAutoEnableOutput, error)
	DeleteDatalakeAutoEnableRequest(*securitylake.DeleteDatalakeAutoEnableInput) (*request.Request, *securitylake.DeleteDatalakeAutoEnableOutput)

	DeleteDatalakeDelegatedAdmin(*securitylake.DeleteDatalakeDelegatedAdminInput) (*securitylake.DeleteDatalakeDelegatedAdminOutput, error)
	DeleteDatalakeDelegatedAdminWithContext(aws.Context, *securitylake.DeleteDatalakeDelegatedAdminInput, ...request.Option) (*securitylake.DeleteDatalakeDelegatedAdminOutput, error)
	DeleteDatalakeDelegatedAdminRequest(*securitylake.DeleteDatalakeDelegatedAdminInput) (*request.Request, *securitylake.DeleteDatalakeDelegatedAdminOutput)

	DeleteDatalakeExceptionsSubscription(*securitylake.DeleteDatalakeExceptionsSubscriptionInput) (*securitylake.DeleteDatalakeExceptionsSubscriptionOutput, error)
	DeleteDatalakeExceptionsSubscriptionWithContext(aws.Context, *securitylake.DeleteDatalakeExceptionsSubscriptionInput, ...request.Option) (*securitylake.DeleteDatalakeExceptionsSubscriptionOutput, error)
	DeleteDatalakeExceptionsSubscriptionRequest(*securitylake.DeleteDatalakeExceptionsSubscriptionInput) (*request.Request, *securitylake.DeleteDatalakeExceptionsSubscriptionOutput)

	DeleteSubscriber(*securitylake.DeleteSubscriberInput) (*securitylake.DeleteSubscriberOutput, error)
	DeleteSubscriberWithContext(aws.Context, *securitylake.DeleteSubscriberInput, ...request.Option) (*securitylake.DeleteSubscriberOutput, error)
	DeleteSubscriberRequest(*securitylake.DeleteSubscriberInput) (*request.Request, *securitylake.DeleteSubscriberOutput)

	DeleteSubscriptionNotificationConfiguration(*securitylake.DeleteSubscriptionNotificationConfigurationInput) (*securitylake.DeleteSubscriptionNotificationConfigurationOutput, error)
	DeleteSubscriptionNotificationConfigurationWithContext(aws.Context, *securitylake.DeleteSubscriptionNotificationConfigurationInput, ...request.Option) (*securitylake.DeleteSubscriptionNotificationConfigurationOutput, error)
	DeleteSubscriptionNotificationConfigurationRequest(*securitylake.DeleteSubscriptionNotificationConfigurationInput) (*request.Request, *securitylake.DeleteSubscriptionNotificationConfigurationOutput)

	GetDatalake(*securitylake.GetDatalakeInput) (*securitylake.GetDatalakeOutput, error)
	GetDatalakeWithContext(aws.Context, *securitylake.GetDatalakeInput, ...request.Option) (*securitylake.GetDatalakeOutput, error)
	GetDatalakeRequest(*securitylake.GetDatalakeInput) (*request.Request, *securitylake.GetDatalakeOutput)

	GetDatalakeAutoEnable(*securitylake.GetDatalakeAutoEnableInput) (*securitylake.GetDatalakeAutoEnableOutput, error)
	GetDatalakeAutoEnableWithContext(aws.Context, *securitylake.GetDatalakeAutoEnableInput, ...request.Option) (*securitylake.GetDatalakeAutoEnableOutput, error)
	GetDatalakeAutoEnableRequest(*securitylake.GetDatalakeAutoEnableInput) (*request.Request, *securitylake.GetDatalakeAutoEnableOutput)

	GetDatalakeExceptionsExpiry(*securitylake.GetDatalakeExceptionsExpiryInput) (*securitylake.GetDatalakeExceptionsExpiryOutput, error)
	GetDatalakeExceptionsExpiryWithContext(aws.Context, *securitylake.GetDatalakeExceptionsExpiryInput, ...request.Option) (*securitylake.GetDatalakeExceptionsExpiryOutput, error)
	GetDatalakeExceptionsExpiryRequest(*securitylake.GetDatalakeExceptionsExpiryInput) (*request.Request, *securitylake.GetDatalakeExceptionsExpiryOutput)

	GetDatalakeExceptionsSubscription(*securitylake.GetDatalakeExceptionsSubscriptionInput) (*securitylake.GetDatalakeExceptionsSubscriptionOutput, error)
	GetDatalakeExceptionsSubscriptionWithContext(aws.Context, *securitylake.GetDatalakeExceptionsSubscriptionInput, ...request.Option) (*securitylake.GetDatalakeExceptionsSubscriptionOutput, error)
	GetDatalakeExceptionsSubscriptionRequest(*securitylake.GetDatalakeExceptionsSubscriptionInput) (*request.Request, *securitylake.GetDatalakeExceptionsSubscriptionOutput)

	GetDatalakeStatus(*securitylake.GetDatalakeStatusInput) (*securitylake.GetDatalakeStatusOutput, error)
	GetDatalakeStatusWithContext(aws.Context, *securitylake.GetDatalakeStatusInput, ...request.Option) (*securitylake.GetDatalakeStatusOutput, error)
	GetDatalakeStatusRequest(*securitylake.GetDatalakeStatusInput) (*request.Request, *securitylake.GetDatalakeStatusOutput)

	GetDatalakeStatusPages(*securitylake.GetDatalakeStatusInput, func(*securitylake.GetDatalakeStatusOutput, bool) bool) error
	GetDatalakeStatusPagesWithContext(aws.Context, *securitylake.GetDatalakeStatusInput, func(*securitylake.GetDatalakeStatusOutput, bool) bool, ...request.Option) error

	GetSubscriber(*securitylake.GetSubscriberInput) (*securitylake.GetSubscriberOutput, error)
	GetSubscriberWithContext(aws.Context, *securitylake.GetSubscriberInput, ...request.Option) (*securitylake.GetSubscriberOutput, error)
	GetSubscriberRequest(*securitylake.GetSubscriberInput) (*request.Request, *securitylake.GetSubscriberOutput)

	ListDatalakeExceptions(*securitylake.ListDatalakeExceptionsInput) (*securitylake.ListDatalakeExceptionsOutput, error)
	ListDatalakeExceptionsWithContext(aws.Context, *securitylake.ListDatalakeExceptionsInput, ...request.Option) (*securitylake.ListDatalakeExceptionsOutput, error)
	ListDatalakeExceptionsRequest(*securitylake.ListDatalakeExceptionsInput) (*request.Request, *securitylake.ListDatalakeExceptionsOutput)

	ListDatalakeExceptionsPages(*securitylake.ListDatalakeExceptionsInput, func(*securitylake.ListDatalakeExceptionsOutput, bool) bool) error
	ListDatalakeExceptionsPagesWithContext(aws.Context, *securitylake.ListDatalakeExceptionsInput, func(*securitylake.ListDatalakeExceptionsOutput, bool) bool, ...request.Option) error

	ListLogSources(*securitylake.ListLogSourcesInput) (*securitylake.ListLogSourcesOutput, error)
	ListLogSourcesWithContext(aws.Context, *securitylake.ListLogSourcesInput, ...request.Option) (*securitylake.ListLogSourcesOutput, error)
	ListLogSourcesRequest(*securitylake.ListLogSourcesInput) (*request.Request, *securitylake.ListLogSourcesOutput)

	ListLogSourcesPages(*securitylake.ListLogSourcesInput, func(*securitylake.ListLogSourcesOutput, bool) bool) error
	ListLogSourcesPagesWithContext(aws.Context, *securitylake.ListLogSourcesInput, func(*securitylake.ListLogSourcesOutput, bool) bool, ...request.Option) error

	ListSubscribers(*securitylake.ListSubscribersInput) (*securitylake.ListSubscribersOutput, error)
	ListSubscribersWithContext(aws.Context, *securitylake.ListSubscribersInput, ...request.Option) (*securitylake.ListSubscribersOutput, error)
	ListSubscribersRequest(*securitylake.ListSubscribersInput) (*request.Request, *securitylake.ListSubscribersOutput)

	ListSubscribersPages(*securitylake.ListSubscribersInput, func(*securitylake.ListSubscribersOutput, bool) bool) error
	ListSubscribersPagesWithContext(aws.Context, *securitylake.ListSubscribersInput, func(*securitylake.ListSubscribersOutput, bool) bool, ...request.Option) error

	UpdateDatalake(*securitylake.UpdateDatalakeInput) (*securitylake.UpdateDatalakeOutput, error)
	UpdateDatalakeWithContext(aws.Context, *securitylake.UpdateDatalakeInput, ...request.Option) (*securitylake.UpdateDatalakeOutput, error)
	UpdateDatalakeRequest(*securitylake.UpdateDatalakeInput) (*request.Request, *securitylake.UpdateDatalakeOutput)

	UpdateDatalakeExceptionsExpiry(*securitylake.UpdateDatalakeExceptionsExpiryInput) (*securitylake.UpdateDatalakeExceptionsExpiryOutput, error)
	UpdateDatalakeExceptionsExpiryWithContext(aws.Context, *securitylake.UpdateDatalakeExceptionsExpiryInput, ...request.Option) (*securitylake.UpdateDatalakeExceptionsExpiryOutput, error)
	UpdateDatalakeExceptionsExpiryRequest(*securitylake.UpdateDatalakeExceptionsExpiryInput) (*request.Request, *securitylake.UpdateDatalakeExceptionsExpiryOutput)

	UpdateDatalakeExceptionsSubscription(*securitylake.UpdateDatalakeExceptionsSubscriptionInput) (*securitylake.UpdateDatalakeExceptionsSubscriptionOutput, error)
	UpdateDatalakeExceptionsSubscriptionWithContext(aws.Context, *securitylake.UpdateDatalakeExceptionsSubscriptionInput, ...request.Option) (*securitylake.UpdateDatalakeExceptionsSubscriptionOutput, error)
	UpdateDatalakeExceptionsSubscriptionRequest(*securitylake.UpdateDatalakeExceptionsSubscriptionInput) (*request.Request, *securitylake.UpdateDatalakeExceptionsSubscriptionOutput)

	UpdateSubscriber(*securitylake.UpdateSubscriberInput) (*securitylake.UpdateSubscriberOutput, error)
	UpdateSubscriberWithContext(aws.Context, *securitylake.UpdateSubscriberInput, ...request.Option) (*securitylake.UpdateSubscriberOutput, error)
	UpdateSubscriberRequest(*securitylake.UpdateSubscriberInput) (*request.Request, *securitylake.UpdateSubscriberOutput)

	UpdateSubscriptionNotificationConfiguration(*securitylake.UpdateSubscriptionNotificationConfigurationInput) (*securitylake.UpdateSubscriptionNotificationConfigurationOutput, error)
	UpdateSubscriptionNotificationConfigurationWithContext(aws.Context, *securitylake.UpdateSubscriptionNotificationConfigurationInput, ...request.Option) (*securitylake.UpdateSubscriptionNotificationConfigurationOutput, error)
	UpdateSubscriptionNotificationConfigurationRequest(*securitylake.UpdateSubscriptionNotificationConfigurationInput) (*request.Request, *securitylake.UpdateSubscriptionNotificationConfigurationOutput)
}

var _ SecurityLakeAPI = (*securitylake.SecurityLake)(nil)
