//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AlertDefinitionsServer is a fake server for instances of the armauthorization.AlertDefinitionsClient type.
type AlertDefinitionsServer struct {
	// Get is the fake for method AlertDefinitionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, alertDefinitionID string, options *armauthorization.AlertDefinitionsClientGetOptions) (resp azfake.Responder[armauthorization.AlertDefinitionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListForScopePager is the fake for method AlertDefinitionsClient.NewListForScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForScopePager func(scope string, options *armauthorization.AlertDefinitionsClientListForScopeOptions) (resp azfake.PagerResponder[armauthorization.AlertDefinitionsClientListForScopeResponse])
}

// NewAlertDefinitionsServerTransport creates a new instance of AlertDefinitionsServerTransport with the provided implementation.
// The returned AlertDefinitionsServerTransport instance is connected to an instance of armauthorization.AlertDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAlertDefinitionsServerTransport(srv *AlertDefinitionsServer) *AlertDefinitionsServerTransport {
	return &AlertDefinitionsServerTransport{
		srv:                  srv,
		newListForScopePager: newTracker[azfake.PagerResponder[armauthorization.AlertDefinitionsClientListForScopeResponse]](),
	}
}

// AlertDefinitionsServerTransport connects instances of armauthorization.AlertDefinitionsClient to instances of AlertDefinitionsServer.
// Don't use this type directly, use NewAlertDefinitionsServerTransport instead.
type AlertDefinitionsServerTransport struct {
	srv                  *AlertDefinitionsServer
	newListForScopePager *tracker[azfake.PagerResponder[armauthorization.AlertDefinitionsClientListForScopeResponse]]
}

// Do implements the policy.Transporter interface for AlertDefinitionsServerTransport.
func (a *AlertDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AlertDefinitionsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AlertDefinitionsClient.NewListForScopePager":
		resp, err = a.dispatchNewListForScopePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AlertDefinitionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlertDefinitions/(?P<alertDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertDefinitionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), scopeParam, alertDefinitionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AlertDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertDefinitionsServerTransport) dispatchNewListForScopePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForScopePager not implemented")}
	}
	newListForScopePager := a.newListForScopePager.get(req)
	if newListForScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlertDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListForScopePager(scopeParam, nil)
		newListForScopePager = &resp
		a.newListForScopePager.add(req, newListForScopePager)
		server.PagerResponderInjectNextLinks(newListForScopePager, req, func(page *armauthorization.AlertDefinitionsClientListForScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForScopePager) {
		a.newListForScopePager.remove(req)
	}
	return resp, nil
}
