//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"regexp"
)

// AccessReviewDefaultSettingsServer is a fake server for instances of the armauthorization.AccessReviewDefaultSettingsClient type.
type AccessReviewDefaultSettingsServer struct {
	// Get is the fake for method AccessReviewDefaultSettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, options *armauthorization.AccessReviewDefaultSettingsClientGetOptions) (resp azfake.Responder[armauthorization.AccessReviewDefaultSettingsClientGetResponse], errResp azfake.ErrorResponder)

	// Put is the fake for method AccessReviewDefaultSettingsClient.Put
	// HTTP status codes to indicate success: http.StatusOK
	Put func(ctx context.Context, properties armauthorization.AccessReviewScheduleSettings, options *armauthorization.AccessReviewDefaultSettingsClientPutOptions) (resp azfake.Responder[armauthorization.AccessReviewDefaultSettingsClientPutResponse], errResp azfake.ErrorResponder)
}

// NewAccessReviewDefaultSettingsServerTransport creates a new instance of AccessReviewDefaultSettingsServerTransport with the provided implementation.
// The returned AccessReviewDefaultSettingsServerTransport instance is connected to an instance of armauthorization.AccessReviewDefaultSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccessReviewDefaultSettingsServerTransport(srv *AccessReviewDefaultSettingsServer) *AccessReviewDefaultSettingsServerTransport {
	return &AccessReviewDefaultSettingsServerTransport{srv: srv}
}

// AccessReviewDefaultSettingsServerTransport connects instances of armauthorization.AccessReviewDefaultSettingsClient to instances of AccessReviewDefaultSettingsServer.
// Don't use this type directly, use NewAccessReviewDefaultSettingsServerTransport instead.
type AccessReviewDefaultSettingsServerTransport struct {
	srv *AccessReviewDefaultSettingsServer
}

// Do implements the policy.Transporter interface for AccessReviewDefaultSettingsServerTransport.
func (a *AccessReviewDefaultSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AccessReviewDefaultSettingsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AccessReviewDefaultSettingsClient.Put":
		resp, err = a.dispatchPut(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AccessReviewDefaultSettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := a.srv.Get(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessReviewDefaultSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessReviewDefaultSettingsServerTransport) dispatchPut(req *http.Request) (*http.Response, error) {
	if a.srv.Put == nil {
		return nil, &nonRetriableError{errors.New("fake for method Put not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armauthorization.AccessReviewScheduleSettings](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Put(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessReviewDefaultSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
