//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AlertsServer is a fake server for instances of the armauthorization.AlertsClient type.
type AlertsServer struct {
	// Get is the fake for method AlertsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, alertID string, options *armauthorization.AlertsClientGetOptions) (resp azfake.Responder[armauthorization.AlertsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListForScopePager is the fake for method AlertsClient.NewListForScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForScopePager func(scope string, options *armauthorization.AlertsClientListForScopeOptions) (resp azfake.PagerResponder[armauthorization.AlertsClientListForScopeResponse])

	// BeginRefresh is the fake for method AlertsClient.BeginRefresh
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginRefresh func(ctx context.Context, scope string, alertID string, options *armauthorization.AlertsClientBeginRefreshOptions) (resp azfake.PollerResponder[armauthorization.AlertsClientRefreshResponse], errResp azfake.ErrorResponder)

	// BeginRefreshAll is the fake for method AlertsClient.BeginRefreshAll
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginRefreshAll func(ctx context.Context, scope string, options *armauthorization.AlertsClientBeginRefreshAllOptions) (resp azfake.PollerResponder[armauthorization.AlertsClientRefreshAllResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method AlertsClient.Update
	// HTTP status codes to indicate success: http.StatusNoContent
	Update func(ctx context.Context, scope string, alertID string, parameters armauthorization.Alert, options *armauthorization.AlertsClientUpdateOptions) (resp azfake.Responder[armauthorization.AlertsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewAlertsServerTransport creates a new instance of AlertsServerTransport with the provided implementation.
// The returned AlertsServerTransport instance is connected to an instance of armauthorization.AlertsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAlertsServerTransport(srv *AlertsServer) *AlertsServerTransport {
	return &AlertsServerTransport{
		srv:                  srv,
		newListForScopePager: newTracker[azfake.PagerResponder[armauthorization.AlertsClientListForScopeResponse]](),
		beginRefresh:         newTracker[azfake.PollerResponder[armauthorization.AlertsClientRefreshResponse]](),
		beginRefreshAll:      newTracker[azfake.PollerResponder[armauthorization.AlertsClientRefreshAllResponse]](),
	}
}

// AlertsServerTransport connects instances of armauthorization.AlertsClient to instances of AlertsServer.
// Don't use this type directly, use NewAlertsServerTransport instead.
type AlertsServerTransport struct {
	srv                  *AlertsServer
	newListForScopePager *tracker[azfake.PagerResponder[armauthorization.AlertsClientListForScopeResponse]]
	beginRefresh         *tracker[azfake.PollerResponder[armauthorization.AlertsClientRefreshResponse]]
	beginRefreshAll      *tracker[azfake.PollerResponder[armauthorization.AlertsClientRefreshAllResponse]]
}

// Do implements the policy.Transporter interface for AlertsServerTransport.
func (a *AlertsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AlertsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AlertsClient.NewListForScopePager":
		resp, err = a.dispatchNewListForScopePager(req)
	case "AlertsClient.BeginRefresh":
		resp, err = a.dispatchBeginRefresh(req)
	case "AlertsClient.BeginRefreshAll":
		resp, err = a.dispatchBeginRefreshAll(req)
	case "AlertsClient.Update":
		resp, err = a.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AlertsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlerts/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), scopeParam, alertIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Alert, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchNewListForScopePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForScopePager not implemented")}
	}
	newListForScopePager := a.newListForScopePager.get(req)
	if newListForScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlerts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListForScopePager(scopeParam, nil)
		newListForScopePager = &resp
		a.newListForScopePager.add(req, newListForScopePager)
		server.PagerResponderInjectNextLinks(newListForScopePager, req, func(page *armauthorization.AlertsClientListForScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForScopePager) {
		a.newListForScopePager.remove(req)
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchBeginRefresh(req *http.Request) (*http.Response, error) {
	if a.srv.BeginRefresh == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRefresh not implemented")}
	}
	beginRefresh := a.beginRefresh.get(req)
	if beginRefresh == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlerts/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/refresh`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginRefresh(req.Context(), scopeParam, alertIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRefresh = &respr
		a.beginRefresh.add(req, beginRefresh)
	}

	resp, err := server.PollerResponderNext(beginRefresh, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		a.beginRefresh.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRefresh) {
		a.beginRefresh.remove(req)
	}

	return resp, nil
}

func (a *AlertsServerTransport) dispatchBeginRefreshAll(req *http.Request) (*http.Response, error) {
	if a.srv.BeginRefreshAll == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRefreshAll not implemented")}
	}
	beginRefreshAll := a.beginRefreshAll.get(req)
	if beginRefreshAll == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlerts/refresh`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginRefreshAll(req.Context(), scopeParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRefreshAll = &respr
		a.beginRefreshAll.add(req, beginRefreshAll)
	}

	resp, err := server.PollerResponderNext(beginRefreshAll, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		a.beginRefreshAll.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRefreshAll) {
		a.beginRefreshAll.remove(req)
	}

	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlerts/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armauthorization.Alert](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Update(req.Context(), scopeParam, alertIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
