//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// ScopeAccessReviewInstanceServer is a fake server for instances of the armauthorization.ScopeAccessReviewInstanceClient type.
type ScopeAccessReviewInstanceServer struct {
	// ApplyDecisions is the fake for method ScopeAccessReviewInstanceClient.ApplyDecisions
	// HTTP status codes to indicate success: http.StatusNoContent
	ApplyDecisions func(ctx context.Context, scope string, scheduleDefinitionID string, id string, options *armauthorization.ScopeAccessReviewInstanceClientApplyDecisionsOptions) (resp azfake.Responder[armauthorization.ScopeAccessReviewInstanceClientApplyDecisionsResponse], errResp azfake.ErrorResponder)

	// RecordAllDecisions is the fake for method ScopeAccessReviewInstanceClient.RecordAllDecisions
	// HTTP status codes to indicate success: http.StatusNoContent
	RecordAllDecisions func(ctx context.Context, scope string, scheduleDefinitionID string, id string, properties armauthorization.RecordAllDecisionsProperties, options *armauthorization.ScopeAccessReviewInstanceClientRecordAllDecisionsOptions) (resp azfake.Responder[armauthorization.ScopeAccessReviewInstanceClientRecordAllDecisionsResponse], errResp azfake.ErrorResponder)

	// ResetDecisions is the fake for method ScopeAccessReviewInstanceClient.ResetDecisions
	// HTTP status codes to indicate success: http.StatusNoContent
	ResetDecisions func(ctx context.Context, scope string, scheduleDefinitionID string, id string, options *armauthorization.ScopeAccessReviewInstanceClientResetDecisionsOptions) (resp azfake.Responder[armauthorization.ScopeAccessReviewInstanceClientResetDecisionsResponse], errResp azfake.ErrorResponder)

	// SendReminders is the fake for method ScopeAccessReviewInstanceClient.SendReminders
	// HTTP status codes to indicate success: http.StatusNoContent
	SendReminders func(ctx context.Context, scope string, scheduleDefinitionID string, id string, options *armauthorization.ScopeAccessReviewInstanceClientSendRemindersOptions) (resp azfake.Responder[armauthorization.ScopeAccessReviewInstanceClientSendRemindersResponse], errResp azfake.ErrorResponder)

	// Stop is the fake for method ScopeAccessReviewInstanceClient.Stop
	// HTTP status codes to indicate success: http.StatusNoContent
	Stop func(ctx context.Context, scope string, scheduleDefinitionID string, id string, options *armauthorization.ScopeAccessReviewInstanceClientStopOptions) (resp azfake.Responder[armauthorization.ScopeAccessReviewInstanceClientStopResponse], errResp azfake.ErrorResponder)
}

// NewScopeAccessReviewInstanceServerTransport creates a new instance of ScopeAccessReviewInstanceServerTransport with the provided implementation.
// The returned ScopeAccessReviewInstanceServerTransport instance is connected to an instance of armauthorization.ScopeAccessReviewInstanceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScopeAccessReviewInstanceServerTransport(srv *ScopeAccessReviewInstanceServer) *ScopeAccessReviewInstanceServerTransport {
	return &ScopeAccessReviewInstanceServerTransport{srv: srv}
}

// ScopeAccessReviewInstanceServerTransport connects instances of armauthorization.ScopeAccessReviewInstanceClient to instances of ScopeAccessReviewInstanceServer.
// Don't use this type directly, use NewScopeAccessReviewInstanceServerTransport instead.
type ScopeAccessReviewInstanceServerTransport struct {
	srv *ScopeAccessReviewInstanceServer
}

// Do implements the policy.Transporter interface for ScopeAccessReviewInstanceServerTransport.
func (s *ScopeAccessReviewInstanceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScopeAccessReviewInstanceClient.ApplyDecisions":
		resp, err = s.dispatchApplyDecisions(req)
	case "ScopeAccessReviewInstanceClient.RecordAllDecisions":
		resp, err = s.dispatchRecordAllDecisions(req)
	case "ScopeAccessReviewInstanceClient.ResetDecisions":
		resp, err = s.dispatchResetDecisions(req)
	case "ScopeAccessReviewInstanceClient.SendReminders":
		resp, err = s.dispatchSendReminders(req)
	case "ScopeAccessReviewInstanceClient.Stop":
		resp, err = s.dispatchStop(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScopeAccessReviewInstanceServerTransport) dispatchApplyDecisions(req *http.Request) (*http.Response, error) {
	if s.srv.ApplyDecisions == nil {
		return nil, &nonRetriableError{errors.New("fake for method ApplyDecisions not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applyDecisions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ApplyDecisions(req.Context(), scopeParam, scheduleDefinitionIDParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScopeAccessReviewInstanceServerTransport) dispatchRecordAllDecisions(req *http.Request) (*http.Response, error) {
	if s.srv.RecordAllDecisions == nil {
		return nil, &nonRetriableError{errors.New("fake for method RecordAllDecisions not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recordAllDecisions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armauthorization.RecordAllDecisionsProperties](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.RecordAllDecisions(req.Context(), scopeParam, scheduleDefinitionIDParam, idParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScopeAccessReviewInstanceServerTransport) dispatchResetDecisions(req *http.Request) (*http.Response, error) {
	if s.srv.ResetDecisions == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResetDecisions not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetDecisions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ResetDecisions(req.Context(), scopeParam, scheduleDefinitionIDParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScopeAccessReviewInstanceServerTransport) dispatchSendReminders(req *http.Request) (*http.Response, error) {
	if s.srv.SendReminders == nil {
		return nil, &nonRetriableError{errors.New("fake for method SendReminders not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sendReminders`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.SendReminders(req.Context(), scopeParam, scheduleDefinitionIDParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScopeAccessReviewInstanceServerTransport) dispatchStop(req *http.Request) (*http.Response, error) {
	if s.srv.Stop == nil {
		return nil, &nonRetriableError{errors.New("fake for method Stop not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Stop(req.Context(), scopeParam, scheduleDefinitionIDParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
