//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armauthorization

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ScopeAccessReviewHistoryDefinitionInstancesClient contains the methods for the ScopeAccessReviewHistoryDefinitionInstances group.
// Don't use this type directly, use NewScopeAccessReviewHistoryDefinitionInstancesClient() instead.
type ScopeAccessReviewHistoryDefinitionInstancesClient struct {
	internal *arm.Client
}

// NewScopeAccessReviewHistoryDefinitionInstancesClient creates a new instance of ScopeAccessReviewHistoryDefinitionInstancesClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewScopeAccessReviewHistoryDefinitionInstancesClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ScopeAccessReviewHistoryDefinitionInstancesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ScopeAccessReviewHistoryDefinitionInstancesClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Get access review history definition instances by definition Id
//
// Generated from API version 2021-12-01-preview
//   - scope - The scope of the resource.
//   - historyDefinitionID - The id of the access review history definition.
//   - options - ScopeAccessReviewHistoryDefinitionInstancesClientListOptions contains the optional parameters for the ScopeAccessReviewHistoryDefinitionInstancesClient.NewListPager
//     method.
func (client *ScopeAccessReviewHistoryDefinitionInstancesClient) NewListPager(scope string, historyDefinitionID string, options *ScopeAccessReviewHistoryDefinitionInstancesClientListOptions) *runtime.Pager[ScopeAccessReviewHistoryDefinitionInstancesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ScopeAccessReviewHistoryDefinitionInstancesClientListResponse]{
		More: func(page ScopeAccessReviewHistoryDefinitionInstancesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ScopeAccessReviewHistoryDefinitionInstancesClientListResponse) (ScopeAccessReviewHistoryDefinitionInstancesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ScopeAccessReviewHistoryDefinitionInstancesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, scope, historyDefinitionID, options)
			}, nil)
			if err != nil {
				return ScopeAccessReviewHistoryDefinitionInstancesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ScopeAccessReviewHistoryDefinitionInstancesClient) listCreateRequest(ctx context.Context, scope string, historyDefinitionID string, options *ScopeAccessReviewHistoryDefinitionInstancesClientListOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/accessReviewHistoryDefinitions/{historyDefinitionId}/instances"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if historyDefinitionID == "" {
		return nil, errors.New("parameter historyDefinitionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{historyDefinitionId}", url.PathEscape(historyDefinitionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ScopeAccessReviewHistoryDefinitionInstancesClient) listHandleResponse(resp *http.Response) (ScopeAccessReviewHistoryDefinitionInstancesClientListResponse, error) {
	result := ScopeAccessReviewHistoryDefinitionInstancesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccessReviewHistoryDefinitionInstanceListResult); err != nil {
		return ScopeAccessReviewHistoryDefinitionInstancesClientListResponse{}, err
	}
	return result, nil
}
