// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/beyondcorp/clientconnectorservices/v1/client_connector_services_service.proto

package clientconnectorservicespb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ClientConnectorServicesService_ListClientConnectorServices_FullMethodName  = "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/ListClientConnectorServices"
	ClientConnectorServicesService_GetClientConnectorService_FullMethodName    = "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/GetClientConnectorService"
	ClientConnectorServicesService_CreateClientConnectorService_FullMethodName = "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/CreateClientConnectorService"
	ClientConnectorServicesService_UpdateClientConnectorService_FullMethodName = "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/UpdateClientConnectorService"
	ClientConnectorServicesService_DeleteClientConnectorService_FullMethodName = "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/DeleteClientConnectorService"
)

// ClientConnectorServicesServiceClient is the client API for ClientConnectorServicesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ClientConnectorServicesServiceClient interface {
	// Lists ClientConnectorServices in a given project and location.
	ListClientConnectorServices(ctx context.Context, in *ListClientConnectorServicesRequest, opts ...grpc.CallOption) (*ListClientConnectorServicesResponse, error)
	// Gets details of a single ClientConnectorService.
	GetClientConnectorService(ctx context.Context, in *GetClientConnectorServiceRequest, opts ...grpc.CallOption) (*ClientConnectorService, error)
	// Creates a new ClientConnectorService in a given project and location.
	CreateClientConnectorService(ctx context.Context, in *CreateClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ClientConnectorService.
	UpdateClientConnectorService(ctx context.Context, in *UpdateClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ClientConnectorService.
	DeleteClientConnectorService(ctx context.Context, in *DeleteClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type clientConnectorServicesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClientConnectorServicesServiceClient(cc grpc.ClientConnInterface) ClientConnectorServicesServiceClient {
	return &clientConnectorServicesServiceClient{cc}
}

func (c *clientConnectorServicesServiceClient) ListClientConnectorServices(ctx context.Context, in *ListClientConnectorServicesRequest, opts ...grpc.CallOption) (*ListClientConnectorServicesResponse, error) {
	out := new(ListClientConnectorServicesResponse)
	err := c.cc.Invoke(ctx, ClientConnectorServicesService_ListClientConnectorServices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientConnectorServicesServiceClient) GetClientConnectorService(ctx context.Context, in *GetClientConnectorServiceRequest, opts ...grpc.CallOption) (*ClientConnectorService, error) {
	out := new(ClientConnectorService)
	err := c.cc.Invoke(ctx, ClientConnectorServicesService_GetClientConnectorService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientConnectorServicesServiceClient) CreateClientConnectorService(ctx context.Context, in *CreateClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClientConnectorServicesService_CreateClientConnectorService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientConnectorServicesServiceClient) UpdateClientConnectorService(ctx context.Context, in *UpdateClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClientConnectorServicesService_UpdateClientConnectorService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientConnectorServicesServiceClient) DeleteClientConnectorService(ctx context.Context, in *DeleteClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClientConnectorServicesService_DeleteClientConnectorService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClientConnectorServicesServiceServer is the server API for ClientConnectorServicesService service.
// All implementations should embed UnimplementedClientConnectorServicesServiceServer
// for forward compatibility
type ClientConnectorServicesServiceServer interface {
	// Lists ClientConnectorServices in a given project and location.
	ListClientConnectorServices(context.Context, *ListClientConnectorServicesRequest) (*ListClientConnectorServicesResponse, error)
	// Gets details of a single ClientConnectorService.
	GetClientConnectorService(context.Context, *GetClientConnectorServiceRequest) (*ClientConnectorService, error)
	// Creates a new ClientConnectorService in a given project and location.
	CreateClientConnectorService(context.Context, *CreateClientConnectorServiceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ClientConnectorService.
	UpdateClientConnectorService(context.Context, *UpdateClientConnectorServiceRequest) (*longrunningpb.Operation, error)
	// Deletes a single ClientConnectorService.
	DeleteClientConnectorService(context.Context, *DeleteClientConnectorServiceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedClientConnectorServicesServiceServer should be embedded to have forward compatible implementations.
type UnimplementedClientConnectorServicesServiceServer struct {
}

func (UnimplementedClientConnectorServicesServiceServer) ListClientConnectorServices(context.Context, *ListClientConnectorServicesRequest) (*ListClientConnectorServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClientConnectorServices not implemented")
}
func (UnimplementedClientConnectorServicesServiceServer) GetClientConnectorService(context.Context, *GetClientConnectorServiceRequest) (*ClientConnectorService, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClientConnectorService not implemented")
}
func (UnimplementedClientConnectorServicesServiceServer) CreateClientConnectorService(context.Context, *CreateClientConnectorServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateClientConnectorService not implemented")
}
func (UnimplementedClientConnectorServicesServiceServer) UpdateClientConnectorService(context.Context, *UpdateClientConnectorServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateClientConnectorService not implemented")
}
func (UnimplementedClientConnectorServicesServiceServer) DeleteClientConnectorService(context.Context, *DeleteClientConnectorServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteClientConnectorService not implemented")
}

// UnsafeClientConnectorServicesServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ClientConnectorServicesServiceServer will
// result in compilation errors.
type UnsafeClientConnectorServicesServiceServer interface {
	mustEmbedUnimplementedClientConnectorServicesServiceServer()
}

func RegisterClientConnectorServicesServiceServer(s grpc.ServiceRegistrar, srv ClientConnectorServicesServiceServer) {
	s.RegisterService(&ClientConnectorServicesService_ServiceDesc, srv)
}

func _ClientConnectorServicesService_ListClientConnectorServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClientConnectorServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).ListClientConnectorServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientConnectorServicesService_ListClientConnectorServices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).ListClientConnectorServices(ctx, req.(*ListClientConnectorServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientConnectorServicesService_GetClientConnectorService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClientConnectorServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).GetClientConnectorService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientConnectorServicesService_GetClientConnectorService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).GetClientConnectorService(ctx, req.(*GetClientConnectorServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientConnectorServicesService_CreateClientConnectorService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientConnectorServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).CreateClientConnectorService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientConnectorServicesService_CreateClientConnectorService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).CreateClientConnectorService(ctx, req.(*CreateClientConnectorServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientConnectorServicesService_UpdateClientConnectorService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClientConnectorServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).UpdateClientConnectorService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientConnectorServicesService_UpdateClientConnectorService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).UpdateClientConnectorService(ctx, req.(*UpdateClientConnectorServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientConnectorServicesService_DeleteClientConnectorService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClientConnectorServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).DeleteClientConnectorService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientConnectorServicesService_DeleteClientConnectorService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).DeleteClientConnectorService(ctx, req.(*DeleteClientConnectorServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ClientConnectorServicesService_ServiceDesc is the grpc.ServiceDesc for ClientConnectorServicesService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ClientConnectorServicesService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService",
	HandlerType: (*ClientConnectorServicesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClientConnectorServices",
			Handler:    _ClientConnectorServicesService_ListClientConnectorServices_Handler,
		},
		{
			MethodName: "GetClientConnectorService",
			Handler:    _ClientConnectorServicesService_GetClientConnectorService_Handler,
		},
		{
			MethodName: "CreateClientConnectorService",
			Handler:    _ClientConnectorServicesService_CreateClientConnectorService_Handler,
		},
		{
			MethodName: "UpdateClientConnectorService",
			Handler:    _ClientConnectorServicesService_UpdateClientConnectorService_Handler,
		},
		{
			MethodName: "DeleteClientConnectorService",
			Handler:    _ClientConnectorServicesService_DeleteClientConnectorService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/beyondcorp/clientconnectorservices/v1/client_connector_services_service.proto",
}
