// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

package datatransferpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataTransferService_GetDataSource_FullMethodName           = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetDataSource"
	DataTransferService_ListDataSources_FullMethodName         = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListDataSources"
	DataTransferService_CreateTransferConfig_FullMethodName    = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CreateTransferConfig"
	DataTransferService_UpdateTransferConfig_FullMethodName    = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/UpdateTransferConfig"
	DataTransferService_DeleteTransferConfig_FullMethodName    = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferConfig"
	DataTransferService_GetTransferConfig_FullMethodName       = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferConfig"
	DataTransferService_ListTransferConfigs_FullMethodName     = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferConfigs"
	DataTransferService_ScheduleTransferRuns_FullMethodName    = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ScheduleTransferRuns"
	DataTransferService_StartManualTransferRuns_FullMethodName = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/StartManualTransferRuns"
	DataTransferService_GetTransferRun_FullMethodName          = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferRun"
	DataTransferService_DeleteTransferRun_FullMethodName       = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferRun"
	DataTransferService_ListTransferRuns_FullMethodName        = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferRuns"
	DataTransferService_ListTransferLogs_FullMethodName        = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferLogs"
	DataTransferService_CheckValidCreds_FullMethodName         = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CheckValidCreds"
	DataTransferService_EnrollDataSources_FullMethodName       = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/EnrollDataSources"
	DataTransferService_UnenrollDataSources_FullMethodName     = "/google.cloud.bigquery.datatransfer.v1.DataTransferService/UnenrollDataSources"
)

// DataTransferServiceClient is the client API for DataTransferService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataTransferServiceClient interface {
	// Retrieves a supported data source and returns its settings.
	GetDataSource(ctx context.Context, in *GetDataSourceRequest, opts ...grpc.CallOption) (*DataSource, error)
	// Lists supported data sources and returns their settings.
	ListDataSources(ctx context.Context, in *ListDataSourcesRequest, opts ...grpc.CallOption) (*ListDataSourcesResponse, error)
	// Creates a new data transfer configuration.
	CreateTransferConfig(ctx context.Context, in *CreateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Updates a data transfer configuration.
	// All fields must be set, even if they are not updated.
	UpdateTransferConfig(ctx context.Context, in *UpdateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Deletes a data transfer configuration, including any associated transfer
	// runs and logs.
	DeleteTransferConfig(ctx context.Context, in *DeleteTransferConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns information about a data transfer config.
	GetTransferConfig(ctx context.Context, in *GetTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Returns information about all transfer configs owned by a project in the
	// specified location.
	ListTransferConfigs(ctx context.Context, in *ListTransferConfigsRequest, opts ...grpc.CallOption) (*ListTransferConfigsResponse, error)
	// Deprecated: Do not use.
	// Creates transfer runs for a time range [start_time, end_time].
	// For each date - or whatever granularity the data source supports - in the
	// range, one transfer run is created.
	// Note that runs are created per UTC time in the time range.
	// DEPRECATED: use StartManualTransferRuns instead.
	ScheduleTransferRuns(ctx context.Context, in *ScheduleTransferRunsRequest, opts ...grpc.CallOption) (*ScheduleTransferRunsResponse, error)
	// Start manual transfer runs to be executed now with schedule_time equal to
	// current time. The transfer runs can be created for a time range where the
	// run_time is between start_time (inclusive) and end_time (exclusive), or for
	// a specific run_time.
	StartManualTransferRuns(ctx context.Context, in *StartManualTransferRunsRequest, opts ...grpc.CallOption) (*StartManualTransferRunsResponse, error)
	// Returns information about the particular transfer run.
	GetTransferRun(ctx context.Context, in *GetTransferRunRequest, opts ...grpc.CallOption) (*TransferRun, error)
	// Deletes the specified transfer run.
	DeleteTransferRun(ctx context.Context, in *DeleteTransferRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns information about running and completed transfer runs.
	ListTransferRuns(ctx context.Context, in *ListTransferRunsRequest, opts ...grpc.CallOption) (*ListTransferRunsResponse, error)
	// Returns log messages for the transfer run.
	ListTransferLogs(ctx context.Context, in *ListTransferLogsRequest, opts ...grpc.CallOption) (*ListTransferLogsResponse, error)
	// Returns true if valid credentials exist for the given data source and
	// requesting user.
	CheckValidCreds(ctx context.Context, in *CheckValidCredsRequest, opts ...grpc.CallOption) (*CheckValidCredsResponse, error)
	// Enroll data sources in a user project. This allows users to create transfer
	// configurations for these data sources. They will also appear in the
	// ListDataSources RPC and as such, will appear in the
	// [BigQuery UI](https://console.cloud.google.com/bigquery), and the documents
	// can be found in the public guide for
	// [BigQuery Web UI](https://cloud.google.com/bigquery/bigquery-web-ui) and
	// [Data Transfer
	// Service](https://cloud.google.com/bigquery/docs/working-with-transfers).
	EnrollDataSources(ctx context.Context, in *EnrollDataSourcesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Unenroll data sources in a user project. This allows users to remove
	// transfer configurations for these data sources. They will no longer appear
	// in the ListDataSources RPC and will also no longer appear in the [BigQuery
	// UI](https://console.cloud.google.com/bigquery). Data transfers
	// configurations of unenrolled data sources will not be scheduled.
	UnenrollDataSources(ctx context.Context, in *UnenrollDataSourcesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type dataTransferServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataTransferServiceClient(cc grpc.ClientConnInterface) DataTransferServiceClient {
	return &dataTransferServiceClient{cc}
}

func (c *dataTransferServiceClient) GetDataSource(ctx context.Context, in *GetDataSourceRequest, opts ...grpc.CallOption) (*DataSource, error) {
	out := new(DataSource)
	err := c.cc.Invoke(ctx, DataTransferService_GetDataSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListDataSources(ctx context.Context, in *ListDataSourcesRequest, opts ...grpc.CallOption) (*ListDataSourcesResponse, error) {
	out := new(ListDataSourcesResponse)
	err := c.cc.Invoke(ctx, DataTransferService_ListDataSources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CreateTransferConfig(ctx context.Context, in *CreateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, DataTransferService_CreateTransferConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) UpdateTransferConfig(ctx context.Context, in *UpdateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, DataTransferService_UpdateTransferConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteTransferConfig(ctx context.Context, in *DeleteTransferConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataTransferService_DeleteTransferConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetTransferConfig(ctx context.Context, in *GetTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, DataTransferService_GetTransferConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferConfigs(ctx context.Context, in *ListTransferConfigsRequest, opts ...grpc.CallOption) (*ListTransferConfigsResponse, error) {
	out := new(ListTransferConfigsResponse)
	err := c.cc.Invoke(ctx, DataTransferService_ListTransferConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTransferServiceClient) ScheduleTransferRuns(ctx context.Context, in *ScheduleTransferRunsRequest, opts ...grpc.CallOption) (*ScheduleTransferRunsResponse, error) {
	out := new(ScheduleTransferRunsResponse)
	err := c.cc.Invoke(ctx, DataTransferService_ScheduleTransferRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) StartManualTransferRuns(ctx context.Context, in *StartManualTransferRunsRequest, opts ...grpc.CallOption) (*StartManualTransferRunsResponse, error) {
	out := new(StartManualTransferRunsResponse)
	err := c.cc.Invoke(ctx, DataTransferService_StartManualTransferRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetTransferRun(ctx context.Context, in *GetTransferRunRequest, opts ...grpc.CallOption) (*TransferRun, error) {
	out := new(TransferRun)
	err := c.cc.Invoke(ctx, DataTransferService_GetTransferRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteTransferRun(ctx context.Context, in *DeleteTransferRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataTransferService_DeleteTransferRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferRuns(ctx context.Context, in *ListTransferRunsRequest, opts ...grpc.CallOption) (*ListTransferRunsResponse, error) {
	out := new(ListTransferRunsResponse)
	err := c.cc.Invoke(ctx, DataTransferService_ListTransferRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferLogs(ctx context.Context, in *ListTransferLogsRequest, opts ...grpc.CallOption) (*ListTransferLogsResponse, error) {
	out := new(ListTransferLogsResponse)
	err := c.cc.Invoke(ctx, DataTransferService_ListTransferLogs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CheckValidCreds(ctx context.Context, in *CheckValidCredsRequest, opts ...grpc.CallOption) (*CheckValidCredsResponse, error) {
	out := new(CheckValidCredsResponse)
	err := c.cc.Invoke(ctx, DataTransferService_CheckValidCreds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) EnrollDataSources(ctx context.Context, in *EnrollDataSourcesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataTransferService_EnrollDataSources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) UnenrollDataSources(ctx context.Context, in *UnenrollDataSourcesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataTransferService_UnenrollDataSources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataTransferServiceServer is the server API for DataTransferService service.
// All implementations should embed UnimplementedDataTransferServiceServer
// for forward compatibility
type DataTransferServiceServer interface {
	// Retrieves a supported data source and returns its settings.
	GetDataSource(context.Context, *GetDataSourceRequest) (*DataSource, error)
	// Lists supported data sources and returns their settings.
	ListDataSources(context.Context, *ListDataSourcesRequest) (*ListDataSourcesResponse, error)
	// Creates a new data transfer configuration.
	CreateTransferConfig(context.Context, *CreateTransferConfigRequest) (*TransferConfig, error)
	// Updates a data transfer configuration.
	// All fields must be set, even if they are not updated.
	UpdateTransferConfig(context.Context, *UpdateTransferConfigRequest) (*TransferConfig, error)
	// Deletes a data transfer configuration, including any associated transfer
	// runs and logs.
	DeleteTransferConfig(context.Context, *DeleteTransferConfigRequest) (*emptypb.Empty, error)
	// Returns information about a data transfer config.
	GetTransferConfig(context.Context, *GetTransferConfigRequest) (*TransferConfig, error)
	// Returns information about all transfer configs owned by a project in the
	// specified location.
	ListTransferConfigs(context.Context, *ListTransferConfigsRequest) (*ListTransferConfigsResponse, error)
	// Deprecated: Do not use.
	// Creates transfer runs for a time range [start_time, end_time].
	// For each date - or whatever granularity the data source supports - in the
	// range, one transfer run is created.
	// Note that runs are created per UTC time in the time range.
	// DEPRECATED: use StartManualTransferRuns instead.
	ScheduleTransferRuns(context.Context, *ScheduleTransferRunsRequest) (*ScheduleTransferRunsResponse, error)
	// Start manual transfer runs to be executed now with schedule_time equal to
	// current time. The transfer runs can be created for a time range where the
	// run_time is between start_time (inclusive) and end_time (exclusive), or for
	// a specific run_time.
	StartManualTransferRuns(context.Context, *StartManualTransferRunsRequest) (*StartManualTransferRunsResponse, error)
	// Returns information about the particular transfer run.
	GetTransferRun(context.Context, *GetTransferRunRequest) (*TransferRun, error)
	// Deletes the specified transfer run.
	DeleteTransferRun(context.Context, *DeleteTransferRunRequest) (*emptypb.Empty, error)
	// Returns information about running and completed transfer runs.
	ListTransferRuns(context.Context, *ListTransferRunsRequest) (*ListTransferRunsResponse, error)
	// Returns log messages for the transfer run.
	ListTransferLogs(context.Context, *ListTransferLogsRequest) (*ListTransferLogsResponse, error)
	// Returns true if valid credentials exist for the given data source and
	// requesting user.
	CheckValidCreds(context.Context, *CheckValidCredsRequest) (*CheckValidCredsResponse, error)
	// Enroll data sources in a user project. This allows users to create transfer
	// configurations for these data sources. They will also appear in the
	// ListDataSources RPC and as such, will appear in the
	// [BigQuery UI](https://console.cloud.google.com/bigquery), and the documents
	// can be found in the public guide for
	// [BigQuery Web UI](https://cloud.google.com/bigquery/bigquery-web-ui) and
	// [Data Transfer
	// Service](https://cloud.google.com/bigquery/docs/working-with-transfers).
	EnrollDataSources(context.Context, *EnrollDataSourcesRequest) (*emptypb.Empty, error)
	// Unenroll data sources in a user project. This allows users to remove
	// transfer configurations for these data sources. They will no longer appear
	// in the ListDataSources RPC and will also no longer appear in the [BigQuery
	// UI](https://console.cloud.google.com/bigquery). Data transfers
	// configurations of unenrolled data sources will not be scheduled.
	UnenrollDataSources(context.Context, *UnenrollDataSourcesRequest) (*emptypb.Empty, error)
}

// UnimplementedDataTransferServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDataTransferServiceServer struct {
}

func (UnimplementedDataTransferServiceServer) GetDataSource(context.Context, *GetDataSourceRequest) (*DataSource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataSource not implemented")
}
func (UnimplementedDataTransferServiceServer) ListDataSources(context.Context, *ListDataSourcesRequest) (*ListDataSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataSources not implemented")
}
func (UnimplementedDataTransferServiceServer) CreateTransferConfig(context.Context, *CreateTransferConfigRequest) (*TransferConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTransferConfig not implemented")
}
func (UnimplementedDataTransferServiceServer) UpdateTransferConfig(context.Context, *UpdateTransferConfigRequest) (*TransferConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTransferConfig not implemented")
}
func (UnimplementedDataTransferServiceServer) DeleteTransferConfig(context.Context, *DeleteTransferConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTransferConfig not implemented")
}
func (UnimplementedDataTransferServiceServer) GetTransferConfig(context.Context, *GetTransferConfigRequest) (*TransferConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransferConfig not implemented")
}
func (UnimplementedDataTransferServiceServer) ListTransferConfigs(context.Context, *ListTransferConfigsRequest) (*ListTransferConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferConfigs not implemented")
}
func (UnimplementedDataTransferServiceServer) ScheduleTransferRuns(context.Context, *ScheduleTransferRunsRequest) (*ScheduleTransferRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScheduleTransferRuns not implemented")
}
func (UnimplementedDataTransferServiceServer) StartManualTransferRuns(context.Context, *StartManualTransferRunsRequest) (*StartManualTransferRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartManualTransferRuns not implemented")
}
func (UnimplementedDataTransferServiceServer) GetTransferRun(context.Context, *GetTransferRunRequest) (*TransferRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransferRun not implemented")
}
func (UnimplementedDataTransferServiceServer) DeleteTransferRun(context.Context, *DeleteTransferRunRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTransferRun not implemented")
}
func (UnimplementedDataTransferServiceServer) ListTransferRuns(context.Context, *ListTransferRunsRequest) (*ListTransferRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferRuns not implemented")
}
func (UnimplementedDataTransferServiceServer) ListTransferLogs(context.Context, *ListTransferLogsRequest) (*ListTransferLogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferLogs not implemented")
}
func (UnimplementedDataTransferServiceServer) CheckValidCreds(context.Context, *CheckValidCredsRequest) (*CheckValidCredsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckValidCreds not implemented")
}
func (UnimplementedDataTransferServiceServer) EnrollDataSources(context.Context, *EnrollDataSourcesRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnrollDataSources not implemented")
}
func (UnimplementedDataTransferServiceServer) UnenrollDataSources(context.Context, *UnenrollDataSourcesRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnenrollDataSources not implemented")
}

// UnsafeDataTransferServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataTransferServiceServer will
// result in compilation errors.
type UnsafeDataTransferServiceServer interface {
	mustEmbedUnimplementedDataTransferServiceServer()
}

func RegisterDataTransferServiceServer(s grpc.ServiceRegistrar, srv DataTransferServiceServer) {
	s.RegisterService(&DataTransferService_ServiceDesc, srv)
}

func _DataTransferService_GetDataSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetDataSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_GetDataSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetDataSource(ctx, req.(*GetDataSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListDataSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListDataSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_ListDataSources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListDataSources(ctx, req.(*ListDataSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CreateTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CreateTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_CreateTransferConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CreateTransferConfig(ctx, req.(*CreateTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_UpdateTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).UpdateTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_UpdateTransferConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).UpdateTransferConfig(ctx, req.(*UpdateTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_DeleteTransferConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteTransferConfig(ctx, req.(*DeleteTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_GetTransferConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetTransferConfig(ctx, req.(*GetTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_ListTransferConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferConfigs(ctx, req.(*ListTransferConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ScheduleTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScheduleTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ScheduleTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_ScheduleTransferRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ScheduleTransferRuns(ctx, req.(*ScheduleTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_StartManualTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartManualTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).StartManualTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_StartManualTransferRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).StartManualTransferRuns(ctx, req.(*StartManualTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetTransferRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetTransferRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_GetTransferRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetTransferRun(ctx, req.(*GetTransferRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteTransferRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteTransferRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_DeleteTransferRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteTransferRun(ctx, req.(*DeleteTransferRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_ListTransferRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferRuns(ctx, req.(*ListTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_ListTransferLogs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferLogs(ctx, req.(*ListTransferLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CheckValidCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckValidCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CheckValidCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_CheckValidCreds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CheckValidCreds(ctx, req.(*CheckValidCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_EnrollDataSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnrollDataSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).EnrollDataSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_EnrollDataSources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).EnrollDataSources(ctx, req.(*EnrollDataSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_UnenrollDataSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnenrollDataSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).UnenrollDataSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_UnenrollDataSources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).UnenrollDataSources(ctx, req.(*UnenrollDataSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataTransferService_ServiceDesc is the grpc.ServiceDesc for DataTransferService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataTransferService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.datatransfer.v1.DataTransferService",
	HandlerType: (*DataTransferServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDataSource",
			Handler:    _DataTransferService_GetDataSource_Handler,
		},
		{
			MethodName: "ListDataSources",
			Handler:    _DataTransferService_ListDataSources_Handler,
		},
		{
			MethodName: "CreateTransferConfig",
			Handler:    _DataTransferService_CreateTransferConfig_Handler,
		},
		{
			MethodName: "UpdateTransferConfig",
			Handler:    _DataTransferService_UpdateTransferConfig_Handler,
		},
		{
			MethodName: "DeleteTransferConfig",
			Handler:    _DataTransferService_DeleteTransferConfig_Handler,
		},
		{
			MethodName: "GetTransferConfig",
			Handler:    _DataTransferService_GetTransferConfig_Handler,
		},
		{
			MethodName: "ListTransferConfigs",
			Handler:    _DataTransferService_ListTransferConfigs_Handler,
		},
		{
			MethodName: "ScheduleTransferRuns",
			Handler:    _DataTransferService_ScheduleTransferRuns_Handler,
		},
		{
			MethodName: "StartManualTransferRuns",
			Handler:    _DataTransferService_StartManualTransferRuns_Handler,
		},
		{
			MethodName: "GetTransferRun",
			Handler:    _DataTransferService_GetTransferRun_Handler,
		},
		{
			MethodName: "DeleteTransferRun",
			Handler:    _DataTransferService_DeleteTransferRun_Handler,
		},
		{
			MethodName: "ListTransferRuns",
			Handler:    _DataTransferService_ListTransferRuns_Handler,
		},
		{
			MethodName: "ListTransferLogs",
			Handler:    _DataTransferService_ListTransferLogs_Handler,
		},
		{
			MethodName: "CheckValidCreds",
			Handler:    _DataTransferService_CheckValidCreds_Handler,
		},
		{
			MethodName: "EnrollDataSources",
			Handler:    _DataTransferService_EnrollDataSources_Handler,
		},
		{
			MethodName: "UnenrollDataSources",
			Handler:    _DataTransferService_UnenrollDataSources_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/datatransfer/v1/datatransfer.proto",
}
