// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Big Data Service API
//
// REST API for Oracle Big Data Service. Use this API to build, deploy, and manage fully elastic Big Data Service clusters. Build on Hadoop, Spark and Data Science distributions, which can be fully integrated with existing enterprise data in Oracle Database and Oracle applications.
//

package bds

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CreateIdentityConfigurationDetails Details for creating the identity configuration.
type CreateIdentityConfigurationDetails struct {

	// Base-64 encoded password for the cluster admin user.
	ClusterAdminPassword *string `mandatory:"true" json:"clusterAdminPassword"`

	// Display name of the identity configuration, required for creating identity configuration.
	DisplayName *string `mandatory:"true" json:"displayName"`

	// Identity domain OCID to use for identity config, required for creating identity configuration
	IdentityDomainId *string `mandatory:"true" json:"identityDomainId"`

	// Identity domain confidential application ID for the identity config, required for creating identity configuration
	ConfidentialApplicationId *string `mandatory:"true" json:"confidentialApplicationId"`

	UpstConfigurationDetails *UpstConfigurationDetails `mandatory:"false" json:"upstConfigurationDetails"`

	IamUserSyncConfigurationDetails *IamUserSyncConfigurationDetails `mandatory:"false" json:"iamUserSyncConfigurationDetails"`
}

func (m CreateIdentityConfigurationDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CreateIdentityConfigurationDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
