// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetAccessControlStatusReader is a Reader for the GetAccessControlStatus structure.
type GetAccessControlStatusReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAccessControlStatusReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAccessControlStatusOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetAccessControlStatusForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetAccessControlStatusNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAccessControlStatusInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /access-control/status] getAccessControlStatus", response, response.Code())
	}
}

// NewGetAccessControlStatusOK creates a GetAccessControlStatusOK with default headers values
func NewGetAccessControlStatusOK() *GetAccessControlStatusOK {
	return &GetAccessControlStatusOK{}
}

/*
GetAccessControlStatusOK describes a response with status code 200, with default header values.

(empty)
*/
type GetAccessControlStatusOK struct {
	Payload models.Status
}

// IsSuccess returns true when this get access control status Ok response has a 2xx status code
func (o *GetAccessControlStatusOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get access control status Ok response has a 3xx status code
func (o *GetAccessControlStatusOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get access control status Ok response has a 4xx status code
func (o *GetAccessControlStatusOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get access control status Ok response has a 5xx status code
func (o *GetAccessControlStatusOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get access control status Ok response a status code equal to that given
func (o *GetAccessControlStatusOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get access control status Ok response
func (o *GetAccessControlStatusOK) Code() int {
	return 200
}

func (o *GetAccessControlStatusOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/status][%d] getAccessControlStatusOk %s", 200, payload)
}

func (o *GetAccessControlStatusOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/status][%d] getAccessControlStatusOk %s", 200, payload)
}

func (o *GetAccessControlStatusOK) GetPayload() models.Status {
	return o.Payload
}

func (o *GetAccessControlStatusOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAccessControlStatusForbidden creates a GetAccessControlStatusForbidden with default headers values
func NewGetAccessControlStatusForbidden() *GetAccessControlStatusForbidden {
	return &GetAccessControlStatusForbidden{}
}

/*
GetAccessControlStatusForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetAccessControlStatusForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get access control status forbidden response has a 2xx status code
func (o *GetAccessControlStatusForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get access control status forbidden response has a 3xx status code
func (o *GetAccessControlStatusForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get access control status forbidden response has a 4xx status code
func (o *GetAccessControlStatusForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get access control status forbidden response has a 5xx status code
func (o *GetAccessControlStatusForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get access control status forbidden response a status code equal to that given
func (o *GetAccessControlStatusForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get access control status forbidden response
func (o *GetAccessControlStatusForbidden) Code() int {
	return 403
}

func (o *GetAccessControlStatusForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/status][%d] getAccessControlStatusForbidden %s", 403, payload)
}

func (o *GetAccessControlStatusForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/status][%d] getAccessControlStatusForbidden %s", 403, payload)
}

func (o *GetAccessControlStatusForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAccessControlStatusForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAccessControlStatusNotFound creates a GetAccessControlStatusNotFound with default headers values
func NewGetAccessControlStatusNotFound() *GetAccessControlStatusNotFound {
	return &GetAccessControlStatusNotFound{}
}

/*
GetAccessControlStatusNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetAccessControlStatusNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get access control status not found response has a 2xx status code
func (o *GetAccessControlStatusNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get access control status not found response has a 3xx status code
func (o *GetAccessControlStatusNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get access control status not found response has a 4xx status code
func (o *GetAccessControlStatusNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get access control status not found response has a 5xx status code
func (o *GetAccessControlStatusNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get access control status not found response a status code equal to that given
func (o *GetAccessControlStatusNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get access control status not found response
func (o *GetAccessControlStatusNotFound) Code() int {
	return 404
}

func (o *GetAccessControlStatusNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/status][%d] getAccessControlStatusNotFound %s", 404, payload)
}

func (o *GetAccessControlStatusNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/status][%d] getAccessControlStatusNotFound %s", 404, payload)
}

func (o *GetAccessControlStatusNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAccessControlStatusNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAccessControlStatusInternalServerError creates a GetAccessControlStatusInternalServerError with default headers values
func NewGetAccessControlStatusInternalServerError() *GetAccessControlStatusInternalServerError {
	return &GetAccessControlStatusInternalServerError{}
}

/*
GetAccessControlStatusInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetAccessControlStatusInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get access control status internal server error response has a 2xx status code
func (o *GetAccessControlStatusInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get access control status internal server error response has a 3xx status code
func (o *GetAccessControlStatusInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get access control status internal server error response has a 4xx status code
func (o *GetAccessControlStatusInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get access control status internal server error response has a 5xx status code
func (o *GetAccessControlStatusInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get access control status internal server error response a status code equal to that given
func (o *GetAccessControlStatusInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get access control status internal server error response
func (o *GetAccessControlStatusInternalServerError) Code() int {
	return 500
}

func (o *GetAccessControlStatusInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/status][%d] getAccessControlStatusInternalServerError %s", 500, payload)
}

func (o *GetAccessControlStatusInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/status][%d] getAccessControlStatusInternalServerError %s", 500, payload)
}

func (o *GetAccessControlStatusInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAccessControlStatusInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
