// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetResourcePermissionsParams creates a new GetResourcePermissionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetResourcePermissionsParams() *GetResourcePermissionsParams {
	return &GetResourcePermissionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetResourcePermissionsParamsWithTimeout creates a new GetResourcePermissionsParams object
// with the ability to set a timeout on a request.
func NewGetResourcePermissionsParamsWithTimeout(timeout time.Duration) *GetResourcePermissionsParams {
	return &GetResourcePermissionsParams{
		timeout: timeout,
	}
}

// NewGetResourcePermissionsParamsWithContext creates a new GetResourcePermissionsParams object
// with the ability to set a context for a request.
func NewGetResourcePermissionsParamsWithContext(ctx context.Context) *GetResourcePermissionsParams {
	return &GetResourcePermissionsParams{
		Context: ctx,
	}
}

// NewGetResourcePermissionsParamsWithHTTPClient creates a new GetResourcePermissionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetResourcePermissionsParamsWithHTTPClient(client *http.Client) *GetResourcePermissionsParams {
	return &GetResourcePermissionsParams{
		HTTPClient: client,
	}
}

/*
GetResourcePermissionsParams contains all the parameters to send to the API endpoint

	for the get resource permissions operation.

	Typically these are written to a http.Request.
*/
type GetResourcePermissionsParams struct {

	// Resource.
	Resource string

	// ResourceID.
	ResourceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get resource permissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetResourcePermissionsParams) WithDefaults() *GetResourcePermissionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get resource permissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetResourcePermissionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get resource permissions params
func (o *GetResourcePermissionsParams) WithTimeout(timeout time.Duration) *GetResourcePermissionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get resource permissions params
func (o *GetResourcePermissionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get resource permissions params
func (o *GetResourcePermissionsParams) WithContext(ctx context.Context) *GetResourcePermissionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get resource permissions params
func (o *GetResourcePermissionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get resource permissions params
func (o *GetResourcePermissionsParams) WithHTTPClient(client *http.Client) *GetResourcePermissionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get resource permissions params
func (o *GetResourcePermissionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithResource adds the resource to the get resource permissions params
func (o *GetResourcePermissionsParams) WithResource(resource string) *GetResourcePermissionsParams {
	o.SetResource(resource)
	return o
}

// SetResource adds the resource to the get resource permissions params
func (o *GetResourcePermissionsParams) SetResource(resource string) {
	o.Resource = resource
}

// WithResourceID adds the resourceID to the get resource permissions params
func (o *GetResourcePermissionsParams) WithResourceID(resourceID string) *GetResourcePermissionsParams {
	o.SetResourceID(resourceID)
	return o
}

// SetResourceID adds the resourceId to the get resource permissions params
func (o *GetResourcePermissionsParams) SetResourceID(resourceID string) {
	o.ResourceID = resourceID
}

// WriteToRequest writes these params to a swagger request
func (o *GetResourcePermissionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param resource
	if err := r.SetPathParam("resource", o.Resource); err != nil {
		return err
	}

	// path param resourceID
	if err := r.SetPathParam("resourceID", o.ResourceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
