// Code generated by go-swagger; DO NOT EDIT.

package admin_ldap

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetLDAPStatusReader is a Reader for the GetLDAPStatus structure.
type GetLDAPStatusReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetLDAPStatusReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLDAPStatusOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetLDAPStatusUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetLDAPStatusForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetLDAPStatusInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /admin/ldap/status] getLDAPStatus", response, response.Code())
	}
}

// NewGetLDAPStatusOK creates a GetLDAPStatusOK with default headers values
func NewGetLDAPStatusOK() *GetLDAPStatusOK {
	return &GetLDAPStatusOK{}
}

/*
GetLDAPStatusOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type GetLDAPStatusOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this get Ldap status Ok response has a 2xx status code
func (o *GetLDAPStatusOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get Ldap status Ok response has a 3xx status code
func (o *GetLDAPStatusOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get Ldap status Ok response has a 4xx status code
func (o *GetLDAPStatusOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get Ldap status Ok response has a 5xx status code
func (o *GetLDAPStatusOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get Ldap status Ok response a status code equal to that given
func (o *GetLDAPStatusOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get Ldap status Ok response
func (o *GetLDAPStatusOK) Code() int {
	return 200
}

func (o *GetLDAPStatusOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/ldap/status][%d] getLdapStatusOk %s", 200, payload)
}

func (o *GetLDAPStatusOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/ldap/status][%d] getLdapStatusOk %s", 200, payload)
}

func (o *GetLDAPStatusOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *GetLDAPStatusOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLDAPStatusUnauthorized creates a GetLDAPStatusUnauthorized with default headers values
func NewGetLDAPStatusUnauthorized() *GetLDAPStatusUnauthorized {
	return &GetLDAPStatusUnauthorized{}
}

/*
GetLDAPStatusUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetLDAPStatusUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get Ldap status unauthorized response has a 2xx status code
func (o *GetLDAPStatusUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get Ldap status unauthorized response has a 3xx status code
func (o *GetLDAPStatusUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get Ldap status unauthorized response has a 4xx status code
func (o *GetLDAPStatusUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get Ldap status unauthorized response has a 5xx status code
func (o *GetLDAPStatusUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get Ldap status unauthorized response a status code equal to that given
func (o *GetLDAPStatusUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get Ldap status unauthorized response
func (o *GetLDAPStatusUnauthorized) Code() int {
	return 401
}

func (o *GetLDAPStatusUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/ldap/status][%d] getLdapStatusUnauthorized %s", 401, payload)
}

func (o *GetLDAPStatusUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/ldap/status][%d] getLdapStatusUnauthorized %s", 401, payload)
}

func (o *GetLDAPStatusUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLDAPStatusUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLDAPStatusForbidden creates a GetLDAPStatusForbidden with default headers values
func NewGetLDAPStatusForbidden() *GetLDAPStatusForbidden {
	return &GetLDAPStatusForbidden{}
}

/*
GetLDAPStatusForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetLDAPStatusForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get Ldap status forbidden response has a 2xx status code
func (o *GetLDAPStatusForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get Ldap status forbidden response has a 3xx status code
func (o *GetLDAPStatusForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get Ldap status forbidden response has a 4xx status code
func (o *GetLDAPStatusForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get Ldap status forbidden response has a 5xx status code
func (o *GetLDAPStatusForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get Ldap status forbidden response a status code equal to that given
func (o *GetLDAPStatusForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get Ldap status forbidden response
func (o *GetLDAPStatusForbidden) Code() int {
	return 403
}

func (o *GetLDAPStatusForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/ldap/status][%d] getLdapStatusForbidden %s", 403, payload)
}

func (o *GetLDAPStatusForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/ldap/status][%d] getLdapStatusForbidden %s", 403, payload)
}

func (o *GetLDAPStatusForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLDAPStatusForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLDAPStatusInternalServerError creates a GetLDAPStatusInternalServerError with default headers values
func NewGetLDAPStatusInternalServerError() *GetLDAPStatusInternalServerError {
	return &GetLDAPStatusInternalServerError{}
}

/*
GetLDAPStatusInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetLDAPStatusInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get Ldap status internal server error response has a 2xx status code
func (o *GetLDAPStatusInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get Ldap status internal server error response has a 3xx status code
func (o *GetLDAPStatusInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get Ldap status internal server error response has a 4xx status code
func (o *GetLDAPStatusInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get Ldap status internal server error response has a 5xx status code
func (o *GetLDAPStatusInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get Ldap status internal server error response a status code equal to that given
func (o *GetLDAPStatusInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get Ldap status internal server error response
func (o *GetLDAPStatusInternalServerError) Code() int {
	return 500
}

func (o *GetLDAPStatusInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/ldap/status][%d] getLdapStatusInternalServerError %s", 500, payload)
}

func (o *GetLDAPStatusInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/ldap/status][%d] getLdapStatusInternalServerError %s", 500, payload)
}

func (o *GetLDAPStatusInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLDAPStatusInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
