// Code generated by go-swagger; DO NOT EDIT.

package enterprise

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// EnableDataSourceCacheReader is a Reader for the EnableDataSourceCache structure.
type EnableDataSourceCacheReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EnableDataSourceCacheReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEnableDataSourceCacheOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewEnableDataSourceCacheInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /datasources/{dataSourceUID}/cache/enable] enableDataSourceCache", response, response.Code())
	}
}

// NewEnableDataSourceCacheOK creates a EnableDataSourceCacheOK with default headers values
func NewEnableDataSourceCacheOK() *EnableDataSourceCacheOK {
	return &EnableDataSourceCacheOK{}
}

/*
EnableDataSourceCacheOK describes a response with status code 200, with default header values.

CacheConfigResponse
*/
type EnableDataSourceCacheOK struct {
	Payload *models.CacheConfigResponse
}

// IsSuccess returns true when this enable data source cache Ok response has a 2xx status code
func (o *EnableDataSourceCacheOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this enable data source cache Ok response has a 3xx status code
func (o *EnableDataSourceCacheOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this enable data source cache Ok response has a 4xx status code
func (o *EnableDataSourceCacheOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this enable data source cache Ok response has a 5xx status code
func (o *EnableDataSourceCacheOK) IsServerError() bool {
	return false
}

// IsCode returns true when this enable data source cache Ok response a status code equal to that given
func (o *EnableDataSourceCacheOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the enable data source cache Ok response
func (o *EnableDataSourceCacheOK) Code() int {
	return 200
}

func (o *EnableDataSourceCacheOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/enable][%d] enableDataSourceCacheOk %s", 200, payload)
}

func (o *EnableDataSourceCacheOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/enable][%d] enableDataSourceCacheOk %s", 200, payload)
}

func (o *EnableDataSourceCacheOK) GetPayload() *models.CacheConfigResponse {
	return o.Payload
}

func (o *EnableDataSourceCacheOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CacheConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEnableDataSourceCacheInternalServerError creates a EnableDataSourceCacheInternalServerError with default headers values
func NewEnableDataSourceCacheInternalServerError() *EnableDataSourceCacheInternalServerError {
	return &EnableDataSourceCacheInternalServerError{}
}

/*
EnableDataSourceCacheInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type EnableDataSourceCacheInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this enable data source cache internal server error response has a 2xx status code
func (o *EnableDataSourceCacheInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this enable data source cache internal server error response has a 3xx status code
func (o *EnableDataSourceCacheInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this enable data source cache internal server error response has a 4xx status code
func (o *EnableDataSourceCacheInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this enable data source cache internal server error response has a 5xx status code
func (o *EnableDataSourceCacheInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this enable data source cache internal server error response a status code equal to that given
func (o *EnableDataSourceCacheInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the enable data source cache internal server error response
func (o *EnableDataSourceCacheInternalServerError) Code() int {
	return 500
}

func (o *EnableDataSourceCacheInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/enable][%d] enableDataSourceCacheInternalServerError %s", 500, payload)
}

func (o *EnableDataSourceCacheInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/enable][%d] enableDataSourceCacheInternalServerError %s", 500, payload)
}

func (o *EnableDataSourceCacheInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *EnableDataSourceCacheInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
