// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetCloudMigrationTokenReader is a Reader for the GetCloudMigrationToken structure.
type GetCloudMigrationTokenReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCloudMigrationTokenReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCloudMigrationTokenOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetCloudMigrationTokenUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCloudMigrationTokenForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetCloudMigrationTokenNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCloudMigrationTokenInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloudmigration/token] getCloudMigrationToken", response, response.Code())
	}
}

// NewGetCloudMigrationTokenOK creates a GetCloudMigrationTokenOK with default headers values
func NewGetCloudMigrationTokenOK() *GetCloudMigrationTokenOK {
	return &GetCloudMigrationTokenOK{}
}

/*
GetCloudMigrationTokenOK describes a response with status code 200, with default header values.

(empty)
*/
type GetCloudMigrationTokenOK struct {
	Payload *models.GetAccessTokenResponseDTO
}

// IsSuccess returns true when this get cloud migration token Ok response has a 2xx status code
func (o *GetCloudMigrationTokenOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get cloud migration token Ok response has a 3xx status code
func (o *GetCloudMigrationTokenOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get cloud migration token Ok response has a 4xx status code
func (o *GetCloudMigrationTokenOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get cloud migration token Ok response has a 5xx status code
func (o *GetCloudMigrationTokenOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get cloud migration token Ok response a status code equal to that given
func (o *GetCloudMigrationTokenOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get cloud migration token Ok response
func (o *GetCloudMigrationTokenOK) Code() int {
	return 200
}

func (o *GetCloudMigrationTokenOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenOk %s", 200, payload)
}

func (o *GetCloudMigrationTokenOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenOk %s", 200, payload)
}

func (o *GetCloudMigrationTokenOK) GetPayload() *models.GetAccessTokenResponseDTO {
	return o.Payload
}

func (o *GetCloudMigrationTokenOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GetAccessTokenResponseDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCloudMigrationTokenUnauthorized creates a GetCloudMigrationTokenUnauthorized with default headers values
func NewGetCloudMigrationTokenUnauthorized() *GetCloudMigrationTokenUnauthorized {
	return &GetCloudMigrationTokenUnauthorized{}
}

/*
GetCloudMigrationTokenUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetCloudMigrationTokenUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get cloud migration token unauthorized response has a 2xx status code
func (o *GetCloudMigrationTokenUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get cloud migration token unauthorized response has a 3xx status code
func (o *GetCloudMigrationTokenUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get cloud migration token unauthorized response has a 4xx status code
func (o *GetCloudMigrationTokenUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get cloud migration token unauthorized response has a 5xx status code
func (o *GetCloudMigrationTokenUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get cloud migration token unauthorized response a status code equal to that given
func (o *GetCloudMigrationTokenUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get cloud migration token unauthorized response
func (o *GetCloudMigrationTokenUnauthorized) Code() int {
	return 401
}

func (o *GetCloudMigrationTokenUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenUnauthorized %s", 401, payload)
}

func (o *GetCloudMigrationTokenUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenUnauthorized %s", 401, payload)
}

func (o *GetCloudMigrationTokenUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCloudMigrationTokenUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCloudMigrationTokenForbidden creates a GetCloudMigrationTokenForbidden with default headers values
func NewGetCloudMigrationTokenForbidden() *GetCloudMigrationTokenForbidden {
	return &GetCloudMigrationTokenForbidden{}
}

/*
GetCloudMigrationTokenForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetCloudMigrationTokenForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get cloud migration token forbidden response has a 2xx status code
func (o *GetCloudMigrationTokenForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get cloud migration token forbidden response has a 3xx status code
func (o *GetCloudMigrationTokenForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get cloud migration token forbidden response has a 4xx status code
func (o *GetCloudMigrationTokenForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get cloud migration token forbidden response has a 5xx status code
func (o *GetCloudMigrationTokenForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get cloud migration token forbidden response a status code equal to that given
func (o *GetCloudMigrationTokenForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get cloud migration token forbidden response
func (o *GetCloudMigrationTokenForbidden) Code() int {
	return 403
}

func (o *GetCloudMigrationTokenForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenForbidden %s", 403, payload)
}

func (o *GetCloudMigrationTokenForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenForbidden %s", 403, payload)
}

func (o *GetCloudMigrationTokenForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCloudMigrationTokenForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCloudMigrationTokenNotFound creates a GetCloudMigrationTokenNotFound with default headers values
func NewGetCloudMigrationTokenNotFound() *GetCloudMigrationTokenNotFound {
	return &GetCloudMigrationTokenNotFound{}
}

/*
GetCloudMigrationTokenNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetCloudMigrationTokenNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get cloud migration token not found response has a 2xx status code
func (o *GetCloudMigrationTokenNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get cloud migration token not found response has a 3xx status code
func (o *GetCloudMigrationTokenNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get cloud migration token not found response has a 4xx status code
func (o *GetCloudMigrationTokenNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get cloud migration token not found response has a 5xx status code
func (o *GetCloudMigrationTokenNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get cloud migration token not found response a status code equal to that given
func (o *GetCloudMigrationTokenNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get cloud migration token not found response
func (o *GetCloudMigrationTokenNotFound) Code() int {
	return 404
}

func (o *GetCloudMigrationTokenNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenNotFound %s", 404, payload)
}

func (o *GetCloudMigrationTokenNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenNotFound %s", 404, payload)
}

func (o *GetCloudMigrationTokenNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCloudMigrationTokenNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCloudMigrationTokenInternalServerError creates a GetCloudMigrationTokenInternalServerError with default headers values
func NewGetCloudMigrationTokenInternalServerError() *GetCloudMigrationTokenInternalServerError {
	return &GetCloudMigrationTokenInternalServerError{}
}

/*
GetCloudMigrationTokenInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetCloudMigrationTokenInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get cloud migration token internal server error response has a 2xx status code
func (o *GetCloudMigrationTokenInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get cloud migration token internal server error response has a 3xx status code
func (o *GetCloudMigrationTokenInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get cloud migration token internal server error response has a 4xx status code
func (o *GetCloudMigrationTokenInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get cloud migration token internal server error response has a 5xx status code
func (o *GetCloudMigrationTokenInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get cloud migration token internal server error response a status code equal to that given
func (o *GetCloudMigrationTokenInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get cloud migration token internal server error response
func (o *GetCloudMigrationTokenInternalServerError) Code() int {
	return 500
}

func (o *GetCloudMigrationTokenInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenInternalServerError %s", 500, payload)
}

func (o *GetCloudMigrationTokenInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/token][%d] getCloudMigrationTokenInternalServerError %s", 500, payload)
}

func (o *GetCloudMigrationTokenInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCloudMigrationTokenInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
