// Code generated by go-swagger; DO NOT EDIT.

package query_history

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateQueryReader is a Reader for the CreateQuery structure.
type CreateQueryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateQueryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateQueryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateQueryBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCreateQueryUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateQueryInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /query-history] createQuery", response, response.Code())
	}
}

// NewCreateQueryOK creates a CreateQueryOK with default headers values
func NewCreateQueryOK() *CreateQueryOK {
	return &CreateQueryOK{}
}

/*
CreateQueryOK describes a response with status code 200, with default header values.

(empty)
*/
type CreateQueryOK struct {
	Payload *models.QueryHistoryResponse
}

// IsSuccess returns true when this create query Ok response has a 2xx status code
func (o *CreateQueryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create query Ok response has a 3xx status code
func (o *CreateQueryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create query Ok response has a 4xx status code
func (o *CreateQueryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create query Ok response has a 5xx status code
func (o *CreateQueryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create query Ok response a status code equal to that given
func (o *CreateQueryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create query Ok response
func (o *CreateQueryOK) Code() int {
	return 200
}

func (o *CreateQueryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history][%d] createQueryOk %s", 200, payload)
}

func (o *CreateQueryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history][%d] createQueryOk %s", 200, payload)
}

func (o *CreateQueryOK) GetPayload() *models.QueryHistoryResponse {
	return o.Payload
}

func (o *CreateQueryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QueryHistoryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateQueryBadRequest creates a CreateQueryBadRequest with default headers values
func NewCreateQueryBadRequest() *CreateQueryBadRequest {
	return &CreateQueryBadRequest{}
}

/*
CreateQueryBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type CreateQueryBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create query bad request response has a 2xx status code
func (o *CreateQueryBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create query bad request response has a 3xx status code
func (o *CreateQueryBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create query bad request response has a 4xx status code
func (o *CreateQueryBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create query bad request response has a 5xx status code
func (o *CreateQueryBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create query bad request response a status code equal to that given
func (o *CreateQueryBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create query bad request response
func (o *CreateQueryBadRequest) Code() int {
	return 400
}

func (o *CreateQueryBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history][%d] createQueryBadRequest %s", 400, payload)
}

func (o *CreateQueryBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history][%d] createQueryBadRequest %s", 400, payload)
}

func (o *CreateQueryBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateQueryBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateQueryUnauthorized creates a CreateQueryUnauthorized with default headers values
func NewCreateQueryUnauthorized() *CreateQueryUnauthorized {
	return &CreateQueryUnauthorized{}
}

/*
CreateQueryUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateQueryUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create query unauthorized response has a 2xx status code
func (o *CreateQueryUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create query unauthorized response has a 3xx status code
func (o *CreateQueryUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create query unauthorized response has a 4xx status code
func (o *CreateQueryUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create query unauthorized response has a 5xx status code
func (o *CreateQueryUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create query unauthorized response a status code equal to that given
func (o *CreateQueryUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create query unauthorized response
func (o *CreateQueryUnauthorized) Code() int {
	return 401
}

func (o *CreateQueryUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history][%d] createQueryUnauthorized %s", 401, payload)
}

func (o *CreateQueryUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history][%d] createQueryUnauthorized %s", 401, payload)
}

func (o *CreateQueryUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateQueryUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateQueryInternalServerError creates a CreateQueryInternalServerError with default headers values
func NewCreateQueryInternalServerError() *CreateQueryInternalServerError {
	return &CreateQueryInternalServerError{}
}

/*
CreateQueryInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateQueryInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create query internal server error response has a 2xx status code
func (o *CreateQueryInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create query internal server error response has a 3xx status code
func (o *CreateQueryInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create query internal server error response has a 4xx status code
func (o *CreateQueryInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create query internal server error response has a 5xx status code
func (o *CreateQueryInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create query internal server error response a status code equal to that given
func (o *CreateQueryInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create query internal server error response
func (o *CreateQueryInternalServerError) Code() int {
	return 500
}

func (o *CreateQueryInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history][%d] createQueryInternalServerError %s", 500, payload)
}

func (o *CreateQueryInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history][%d] createQueryInternalServerError %s", 500, payload)
}

func (o *CreateQueryInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateQueryInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
