// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteReportReader is a Reader for the DeleteReport structure.
type DeleteReportReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteReportReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteReportOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteReportBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeleteReportUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteReportForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteReportNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteReportInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /reports/{id}] deleteReport", response, response.Code())
	}
}

// NewDeleteReportOK creates a DeleteReportOK with default headers values
func NewDeleteReportOK() *DeleteReportOK {
	return &DeleteReportOK{}
}

/*
DeleteReportOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeleteReportOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete report Ok response has a 2xx status code
func (o *DeleteReportOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete report Ok response has a 3xx status code
func (o *DeleteReportOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete report Ok response has a 4xx status code
func (o *DeleteReportOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete report Ok response has a 5xx status code
func (o *DeleteReportOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete report Ok response a status code equal to that given
func (o *DeleteReportOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete report Ok response
func (o *DeleteReportOK) Code() int {
	return 200
}

func (o *DeleteReportOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportOk %s", 200, payload)
}

func (o *DeleteReportOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportOk %s", 200, payload)
}

func (o *DeleteReportOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeleteReportOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReportBadRequest creates a DeleteReportBadRequest with default headers values
func NewDeleteReportBadRequest() *DeleteReportBadRequest {
	return &DeleteReportBadRequest{}
}

/*
DeleteReportBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type DeleteReportBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete report bad request response has a 2xx status code
func (o *DeleteReportBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete report bad request response has a 3xx status code
func (o *DeleteReportBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete report bad request response has a 4xx status code
func (o *DeleteReportBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete report bad request response has a 5xx status code
func (o *DeleteReportBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete report bad request response a status code equal to that given
func (o *DeleteReportBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete report bad request response
func (o *DeleteReportBadRequest) Code() int {
	return 400
}

func (o *DeleteReportBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportBadRequest %s", 400, payload)
}

func (o *DeleteReportBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportBadRequest %s", 400, payload)
}

func (o *DeleteReportBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteReportBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReportUnauthorized creates a DeleteReportUnauthorized with default headers values
func NewDeleteReportUnauthorized() *DeleteReportUnauthorized {
	return &DeleteReportUnauthorized{}
}

/*
DeleteReportUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteReportUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete report unauthorized response has a 2xx status code
func (o *DeleteReportUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete report unauthorized response has a 3xx status code
func (o *DeleteReportUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete report unauthorized response has a 4xx status code
func (o *DeleteReportUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete report unauthorized response has a 5xx status code
func (o *DeleteReportUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete report unauthorized response a status code equal to that given
func (o *DeleteReportUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete report unauthorized response
func (o *DeleteReportUnauthorized) Code() int {
	return 401
}

func (o *DeleteReportUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportUnauthorized %s", 401, payload)
}

func (o *DeleteReportUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportUnauthorized %s", 401, payload)
}

func (o *DeleteReportUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteReportUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReportForbidden creates a DeleteReportForbidden with default headers values
func NewDeleteReportForbidden() *DeleteReportForbidden {
	return &DeleteReportForbidden{}
}

/*
DeleteReportForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteReportForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete report forbidden response has a 2xx status code
func (o *DeleteReportForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete report forbidden response has a 3xx status code
func (o *DeleteReportForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete report forbidden response has a 4xx status code
func (o *DeleteReportForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete report forbidden response has a 5xx status code
func (o *DeleteReportForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete report forbidden response a status code equal to that given
func (o *DeleteReportForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete report forbidden response
func (o *DeleteReportForbidden) Code() int {
	return 403
}

func (o *DeleteReportForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportForbidden %s", 403, payload)
}

func (o *DeleteReportForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportForbidden %s", 403, payload)
}

func (o *DeleteReportForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteReportForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReportNotFound creates a DeleteReportNotFound with default headers values
func NewDeleteReportNotFound() *DeleteReportNotFound {
	return &DeleteReportNotFound{}
}

/*
DeleteReportNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeleteReportNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete report not found response has a 2xx status code
func (o *DeleteReportNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete report not found response has a 3xx status code
func (o *DeleteReportNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete report not found response has a 4xx status code
func (o *DeleteReportNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete report not found response has a 5xx status code
func (o *DeleteReportNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete report not found response a status code equal to that given
func (o *DeleteReportNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete report not found response
func (o *DeleteReportNotFound) Code() int {
	return 404
}

func (o *DeleteReportNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportNotFound %s", 404, payload)
}

func (o *DeleteReportNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportNotFound %s", 404, payload)
}

func (o *DeleteReportNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteReportNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReportInternalServerError creates a DeleteReportInternalServerError with default headers values
func NewDeleteReportInternalServerError() *DeleteReportInternalServerError {
	return &DeleteReportInternalServerError{}
}

/*
DeleteReportInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteReportInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete report internal server error response has a 2xx status code
func (o *DeleteReportInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete report internal server error response has a 3xx status code
func (o *DeleteReportInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete report internal server error response has a 4xx status code
func (o *DeleteReportInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete report internal server error response has a 5xx status code
func (o *DeleteReportInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete report internal server error response a status code equal to that given
func (o *DeleteReportInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete report internal server error response
func (o *DeleteReportInternalServerError) Code() int {
	return 500
}

func (o *DeleteReportInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportInternalServerError %s", 500, payload)
}

func (o *DeleteReportInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /reports/{id}][%d] deleteReportInternalServerError %s", 500, payload)
}

func (o *DeleteReportInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteReportInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
