// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetReportSettingsReader is a Reader for the GetReportSettings structure.
type GetReportSettingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetReportSettingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetReportSettingsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetReportSettingsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetReportSettingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetReportSettingsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /reports/settings] getReportSettings", response, response.Code())
	}
}

// NewGetReportSettingsOK creates a GetReportSettingsOK with default headers values
func NewGetReportSettingsOK() *GetReportSettingsOK {
	return &GetReportSettingsOK{}
}

/*
GetReportSettingsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetReportSettingsOK struct {
	Payload *models.ReportSettings
}

// IsSuccess returns true when this get report settings Ok response has a 2xx status code
func (o *GetReportSettingsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get report settings Ok response has a 3xx status code
func (o *GetReportSettingsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report settings Ok response has a 4xx status code
func (o *GetReportSettingsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get report settings Ok response has a 5xx status code
func (o *GetReportSettingsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get report settings Ok response a status code equal to that given
func (o *GetReportSettingsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get report settings Ok response
func (o *GetReportSettingsOK) Code() int {
	return 200
}

func (o *GetReportSettingsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/settings][%d] getReportSettingsOk %s", 200, payload)
}

func (o *GetReportSettingsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/settings][%d] getReportSettingsOk %s", 200, payload)
}

func (o *GetReportSettingsOK) GetPayload() *models.ReportSettings {
	return o.Payload
}

func (o *GetReportSettingsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ReportSettings)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportSettingsUnauthorized creates a GetReportSettingsUnauthorized with default headers values
func NewGetReportSettingsUnauthorized() *GetReportSettingsUnauthorized {
	return &GetReportSettingsUnauthorized{}
}

/*
GetReportSettingsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetReportSettingsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get report settings unauthorized response has a 2xx status code
func (o *GetReportSettingsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get report settings unauthorized response has a 3xx status code
func (o *GetReportSettingsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report settings unauthorized response has a 4xx status code
func (o *GetReportSettingsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get report settings unauthorized response has a 5xx status code
func (o *GetReportSettingsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get report settings unauthorized response a status code equal to that given
func (o *GetReportSettingsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get report settings unauthorized response
func (o *GetReportSettingsUnauthorized) Code() int {
	return 401
}

func (o *GetReportSettingsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/settings][%d] getReportSettingsUnauthorized %s", 401, payload)
}

func (o *GetReportSettingsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/settings][%d] getReportSettingsUnauthorized %s", 401, payload)
}

func (o *GetReportSettingsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetReportSettingsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportSettingsForbidden creates a GetReportSettingsForbidden with default headers values
func NewGetReportSettingsForbidden() *GetReportSettingsForbidden {
	return &GetReportSettingsForbidden{}
}

/*
GetReportSettingsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetReportSettingsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get report settings forbidden response has a 2xx status code
func (o *GetReportSettingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get report settings forbidden response has a 3xx status code
func (o *GetReportSettingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report settings forbidden response has a 4xx status code
func (o *GetReportSettingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get report settings forbidden response has a 5xx status code
func (o *GetReportSettingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get report settings forbidden response a status code equal to that given
func (o *GetReportSettingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get report settings forbidden response
func (o *GetReportSettingsForbidden) Code() int {
	return 403
}

func (o *GetReportSettingsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/settings][%d] getReportSettingsForbidden %s", 403, payload)
}

func (o *GetReportSettingsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/settings][%d] getReportSettingsForbidden %s", 403, payload)
}

func (o *GetReportSettingsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetReportSettingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportSettingsInternalServerError creates a GetReportSettingsInternalServerError with default headers values
func NewGetReportSettingsInternalServerError() *GetReportSettingsInternalServerError {
	return &GetReportSettingsInternalServerError{}
}

/*
GetReportSettingsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetReportSettingsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get report settings internal server error response has a 2xx status code
func (o *GetReportSettingsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get report settings internal server error response has a 3xx status code
func (o *GetReportSettingsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report settings internal server error response has a 4xx status code
func (o *GetReportSettingsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get report settings internal server error response has a 5xx status code
func (o *GetReportSettingsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get report settings internal server error response a status code equal to that given
func (o *GetReportSettingsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get report settings internal server error response
func (o *GetReportSettingsInternalServerError) Code() int {
	return 500
}

func (o *GetReportSettingsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/settings][%d] getReportSettingsInternalServerError %s", 500, payload)
}

func (o *GetReportSettingsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/settings][%d] getReportSettingsInternalServerError %s", 500, payload)
}

func (o *GetReportSettingsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetReportSettingsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
