// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetSettingsImageReader is a Reader for the GetSettingsImage structure.
type GetSettingsImageReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSettingsImageReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSettingsImageOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetSettingsImageUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetSettingsImageForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetSettingsImageNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetSettingsImageInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /reports/images/:image] getSettingsImage", response, response.Code())
	}
}

// NewGetSettingsImageOK creates a GetSettingsImageOK with default headers values
func NewGetSettingsImageOK() *GetSettingsImageOK {
	return &GetSettingsImageOK{}
}

/*
GetSettingsImageOK describes a response with status code 200, with default header values.

(empty)
*/
type GetSettingsImageOK struct {
	Payload []uint8
}

// IsSuccess returns true when this get settings image Ok response has a 2xx status code
func (o *GetSettingsImageOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get settings image Ok response has a 3xx status code
func (o *GetSettingsImageOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get settings image Ok response has a 4xx status code
func (o *GetSettingsImageOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get settings image Ok response has a 5xx status code
func (o *GetSettingsImageOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get settings image Ok response a status code equal to that given
func (o *GetSettingsImageOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get settings image Ok response
func (o *GetSettingsImageOK) Code() int {
	return 200
}

func (o *GetSettingsImageOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageOk %s", 200, payload)
}

func (o *GetSettingsImageOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageOk %s", 200, payload)
}

func (o *GetSettingsImageOK) GetPayload() []uint8 {
	return o.Payload
}

func (o *GetSettingsImageOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSettingsImageUnauthorized creates a GetSettingsImageUnauthorized with default headers values
func NewGetSettingsImageUnauthorized() *GetSettingsImageUnauthorized {
	return &GetSettingsImageUnauthorized{}
}

/*
GetSettingsImageUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetSettingsImageUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get settings image unauthorized response has a 2xx status code
func (o *GetSettingsImageUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get settings image unauthorized response has a 3xx status code
func (o *GetSettingsImageUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get settings image unauthorized response has a 4xx status code
func (o *GetSettingsImageUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get settings image unauthorized response has a 5xx status code
func (o *GetSettingsImageUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get settings image unauthorized response a status code equal to that given
func (o *GetSettingsImageUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get settings image unauthorized response
func (o *GetSettingsImageUnauthorized) Code() int {
	return 401
}

func (o *GetSettingsImageUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageUnauthorized %s", 401, payload)
}

func (o *GetSettingsImageUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageUnauthorized %s", 401, payload)
}

func (o *GetSettingsImageUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSettingsImageUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSettingsImageForbidden creates a GetSettingsImageForbidden with default headers values
func NewGetSettingsImageForbidden() *GetSettingsImageForbidden {
	return &GetSettingsImageForbidden{}
}

/*
GetSettingsImageForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetSettingsImageForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get settings image forbidden response has a 2xx status code
func (o *GetSettingsImageForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get settings image forbidden response has a 3xx status code
func (o *GetSettingsImageForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get settings image forbidden response has a 4xx status code
func (o *GetSettingsImageForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get settings image forbidden response has a 5xx status code
func (o *GetSettingsImageForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get settings image forbidden response a status code equal to that given
func (o *GetSettingsImageForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get settings image forbidden response
func (o *GetSettingsImageForbidden) Code() int {
	return 403
}

func (o *GetSettingsImageForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageForbidden %s", 403, payload)
}

func (o *GetSettingsImageForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageForbidden %s", 403, payload)
}

func (o *GetSettingsImageForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSettingsImageForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSettingsImageNotFound creates a GetSettingsImageNotFound with default headers values
func NewGetSettingsImageNotFound() *GetSettingsImageNotFound {
	return &GetSettingsImageNotFound{}
}

/*
GetSettingsImageNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetSettingsImageNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get settings image not found response has a 2xx status code
func (o *GetSettingsImageNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get settings image not found response has a 3xx status code
func (o *GetSettingsImageNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get settings image not found response has a 4xx status code
func (o *GetSettingsImageNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get settings image not found response has a 5xx status code
func (o *GetSettingsImageNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get settings image not found response a status code equal to that given
func (o *GetSettingsImageNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get settings image not found response
func (o *GetSettingsImageNotFound) Code() int {
	return 404
}

func (o *GetSettingsImageNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageNotFound %s", 404, payload)
}

func (o *GetSettingsImageNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageNotFound %s", 404, payload)
}

func (o *GetSettingsImageNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSettingsImageNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSettingsImageInternalServerError creates a GetSettingsImageInternalServerError with default headers values
func NewGetSettingsImageInternalServerError() *GetSettingsImageInternalServerError {
	return &GetSettingsImageInternalServerError{}
}

/*
GetSettingsImageInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetSettingsImageInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get settings image internal server error response has a 2xx status code
func (o *GetSettingsImageInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get settings image internal server error response has a 3xx status code
func (o *GetSettingsImageInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get settings image internal server error response has a 4xx status code
func (o *GetSettingsImageInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get settings image internal server error response has a 5xx status code
func (o *GetSettingsImageInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get settings image internal server error response a status code equal to that given
func (o *GetSettingsImageInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get settings image internal server error response
func (o *GetSettingsImageInternalServerError) Code() int {
	return 500
}

func (o *GetSettingsImageInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageInternalServerError %s", 500, payload)
}

func (o *GetSettingsImageInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/images/:image][%d] getSettingsImageInternalServerError %s", 500, payload)
}

func (o *GetSettingsImageInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSettingsImageInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
